/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponse;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import java.io.IOException;
import java.util.List;

public class Response {
    private final HttpResponse httpResponse;

    Response(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public int getStatusCode() {
        return this.httpResponse.getStatusCode();
    }

    public List<String> getHeader(String headerName) {
        return this.httpResponse.getHeaders().getHeaderStringValues(headerName);
    }

    public long getContentLength() throws NumberFormatException {
        String contentLengthHeader = this.httpResponse.getHeaders().getFirstHeaderStringValue("Content-Length");
        if (contentLengthHeader == null) {
            return -1L;
        }
        try {
            return Long.parseLong(contentLengthHeader);
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    public Blob getBody() throws IOException {
        return Blobs.from(this.httpResponse.getContent());
    }

    public GenericUrl getRequestUrl() {
        return this.httpResponse.getRequest().getUrl();
    }
}

