/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.tools.jib.builder.EntrypointBuilder;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.filesystem.FileOperations;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class DockerContextGenerator {
    private final SourceFilesConfiguration sourceFilesConfiguration;
    @Nullable
    private String baseImage;
    private List<String> jvmFlags = Collections.emptyList();
    private String mainClass = "";
    private List<String> javaArguments = Collections.emptyList();
    private List<String> exposedPorts = Collections.emptyList();

    public DockerContextGenerator(SourceFilesConfiguration sourceFilesConfiguration) {
        this.sourceFilesConfiguration = sourceFilesConfiguration;
    }

    public DockerContextGenerator setBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return this;
    }

    public DockerContextGenerator setJvmFlags(List<String> jvmFlags) {
        this.jvmFlags = jvmFlags;
        return this;
    }

    public DockerContextGenerator setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public DockerContextGenerator setJavaArguments(List<String> javaArguments) {
        this.javaArguments = javaArguments;
        return this;
    }

    public DockerContextGenerator setExposedPorts(List<String> exposedPorts) {
        this.exposedPorts = exposedPorts;
        return this;
    }

    public void generate(Path targetDirectory) throws IOException {
        Preconditions.checkNotNull((Object)this.baseImage);
        try {
            Files.deleteIfExists(targetDirectory);
        }
        catch (DirectoryNotEmptyException ex) {
            MoreFiles.deleteDirectoryContents((Path)targetDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
            Files.delete(targetDirectory);
        }
        Files.createDirectory(targetDirectory, new FileAttribute[0]);
        Path dependenciesDir = targetDirectory.resolve("libs");
        Path resourcesDIr = targetDirectory.resolve("resources");
        Path classesDir = targetDirectory.resolve("classes");
        Files.createDirectory(dependenciesDir, new FileAttribute[0]);
        Files.createDirectory(resourcesDIr, new FileAttribute[0]);
        Files.createDirectory(classesDir, new FileAttribute[0]);
        FileOperations.copy(this.sourceFilesConfiguration.getDependenciesFiles(), dependenciesDir);
        FileOperations.copy(this.sourceFilesConfiguration.getResourcesFiles(), resourcesDIr);
        FileOperations.copy(this.sourceFilesConfiguration.getClassesFiles(), classesDir);
        Files.write(targetDirectory.resolve("Dockerfile"), this.makeDockerfile().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @VisibleForTesting
    String makeDockerfile() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        StringBuilder dockerfile = new StringBuilder();
        dockerfile.append("FROM ").append((String)Preconditions.checkNotNull((Object)this.baseImage)).append("\n\nCOPY libs ").append(this.sourceFilesConfiguration.getDependenciesPathOnImage()).append("\nCOPY resources ").append(this.sourceFilesConfiguration.getResourcesPathOnImage()).append("\nCOPY classes ").append(this.sourceFilesConfiguration.getClassesPathOnImage()).append("\n");
        for (String port : this.exposedPorts) {
            dockerfile.append("\nEXPOSE ").append(port);
        }
        dockerfile.append("\nENTRYPOINT ").append(objectMapper.writeValueAsString(EntrypointBuilder.makeEntrypoint(this.sourceFilesConfiguration, this.jvmFlags, this.mainClass))).append("\nCMD ").append(objectMapper.writeValueAsString(this.javaArguments));
        return dockerfile.toString();
    }
}

