/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CacheStorageFiles;
import com.google.cloud.tools.jib.cache.CacheStorageReader;
import com.google.cloud.tools.jib.cache.CacheStorageWriter;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.LayerEntriesSelector;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.ImageMetadataTemplate;
import com.google.cloud.tools.jib.image.json.ManifestAndConfigTemplate;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Cache {
    private final CacheStorageWriter cacheStorageWriter;
    private final CacheStorageReader cacheStorageReader;

    public static Cache withDirectory(Path cacheDirectory) throws CacheDirectoryCreationException {
        try {
            Files.createDirectories(cacheDirectory, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new CacheDirectoryCreationException(ex);
        }
        return new Cache(new CacheStorageFiles(cacheDirectory));
    }

    private Cache(CacheStorageFiles cacheStorageFiles) {
        this.cacheStorageWriter = new CacheStorageWriter(cacheStorageFiles);
        this.cacheStorageReader = new CacheStorageReader(cacheStorageFiles);
    }

    public void writeMetadata(ImageReference imageReference, ImageMetadataTemplate metadata) throws IOException {
        this.cacheStorageWriter.writeMetadata(imageReference, metadata);
    }

    public void writeMetadata(ImageReference imageReference, BuildableManifestTemplate manifest, ContainerConfigurationTemplate containerConfiguration) throws IOException {
        List<ManifestAndConfigTemplate> singleton = Collections.singletonList(new ManifestAndConfigTemplate(manifest, containerConfiguration));
        this.cacheStorageWriter.writeMetadata(imageReference, new ImageMetadataTemplate(null, singleton));
    }

    public void writeMetadata(ImageReference imageReference, V21ManifestTemplate manifestTemplate) throws IOException {
        List<ManifestAndConfigTemplate> singleton = Collections.singletonList(new ManifestAndConfigTemplate(manifestTemplate, null));
        this.cacheStorageWriter.writeMetadata(imageReference, new ImageMetadataTemplate(null, singleton));
    }

    public CachedLayer writeCompressedLayer(Blob compressedLayerBlob) throws IOException {
        return this.cacheStorageWriter.writeCompressed(compressedLayerBlob);
    }

    public CachedLayer writeUncompressedLayer(Blob uncompressedLayerBlob, ImmutableList<FileEntry> layerEntries) throws IOException {
        return this.cacheStorageWriter.writeUncompressed(uncompressedLayerBlob, LayerEntriesSelector.generateSelector(layerEntries));
    }

    public CachedLayer writeTarLayer(DescriptorDigest diffId, Blob compressedBlob) throws IOException {
        return this.cacheStorageWriter.writeTarLayer(diffId, compressedBlob);
    }

    public void writeLocalConfig(DescriptorDigest imageId, ContainerConfigurationTemplate containerConfiguration) throws IOException {
        this.cacheStorageWriter.writeLocalConfig(imageId, containerConfiguration);
    }

    public Optional<ImageMetadataTemplate> retrieveMetadata(ImageReference imageReference) throws IOException, CacheCorruptedException {
        return this.cacheStorageReader.retrieveMetadata(imageReference);
    }

    public boolean areAllLayersCached(ManifestTemplate manifest) {
        return this.cacheStorageReader.areAllLayersCached(manifest);
    }

    public Optional<CachedLayer> retrieve(ImmutableList<FileEntry> layerEntries) throws IOException, CacheCorruptedException {
        Optional<DescriptorDigest> optionalSelectedLayerDigest = this.cacheStorageReader.select(LayerEntriesSelector.generateSelector(layerEntries));
        if (!optionalSelectedLayerDigest.isPresent()) {
            return Optional.empty();
        }
        return this.cacheStorageReader.retrieve(optionalSelectedLayerDigest.get());
    }

    public Optional<CachedLayer> retrieve(DescriptorDigest layerDigest) throws IOException, CacheCorruptedException {
        return this.cacheStorageReader.retrieve(layerDigest);
    }

    public Optional<CachedLayer> retrieveTarLayer(DescriptorDigest diffId) throws IOException, CacheCorruptedException {
        return this.cacheStorageReader.retrieveTarLayer(diffId);
    }

    public Optional<ContainerConfigurationTemplate> retrieveLocalConfig(DescriptorDigest imageId) throws IOException {
        return this.cacheStorageReader.retrieveLocalConfig(imageId);
    }
}

