/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.api.client.util.Preconditions;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.image.json.ManifestListGenerator;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;

class BuildManifestListOrSingleManifestStep
implements Callable<ManifestTemplate> {
    private static final String DESCRIPTION = "Building a manifest list or a single manifest";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final List<Image> builtImages;

    BuildManifestListOrSingleManifestStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, List<Image> builtImages) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.builtImages = builtImages;
    }

    @Override
    public ManifestTemplate call() throws IOException {
        Preconditions.checkState((!this.builtImages.isEmpty() ? 1 : 0) != 0, (Object)"no images given");
        EventHandlers eventHandlers = this.buildContext.getEventHandlers();
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(eventHandlers, DESCRIPTION);){
            ProgressEventDispatcher ignored2;
            block15: {
                ignored2 = this.progressEventDispatcherFactory.create("building a manifest list or a single manifest", 1L);
                try {
                    if (this.builtImages.size() != 1) break block15;
                    eventHandlers.dispatch(LogEvent.info("Building a single manifest"));
                    ImageToJsonTranslator imageTranslator = new ImageToJsonTranslator(this.builtImages.get(0));
                    BlobDescriptor configDescriptor = Digests.computeDigest(imageTranslator.getContainerConfiguration());
                    BuildableManifestTemplate buildableManifestTemplate = imageTranslator.getManifestTemplate(this.buildContext.getTargetFormat(), configDescriptor);
                    if (ignored2 != null) {
                        ignored2.close();
                    }
                    return buildableManifestTemplate;
                }
                catch (Throwable throwable) {
                    if (ignored2 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            eventHandlers.dispatch(LogEvent.info("Building a manifest list"));
            ManifestTemplate manifestTemplate = new ManifestListGenerator(this.builtImages).getManifestListTemplate(this.buildContext.getTargetFormat());
            if (ignored2 != null) {
                ignored2.close();
            }
            return manifestTemplate;
        }
    }
}

