/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PushBlobStep;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.registry.RegistryClient;
import java.io.IOException;
import java.util.concurrent.Callable;

class PushContainerConfigurationStep
implements Callable<BlobDescriptor> {
    private static final String DESCRIPTION = "Pushing container configuration";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final RegistryClient registryClient;
    private final Image builtImage;

    PushContainerConfigurationStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, RegistryClient registryClient, Image builtImage) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.registryClient = registryClient;
        this.builtImage = builtImage;
    }

    @Override
    public BlobDescriptor call() throws IOException, RegistryException {
        try (ProgressEventDispatcher progressEventDispatcher = this.progressEventDispatcherFactory.create("pushing container configuration", 1L);){
            TimerEventDispatcher ignored = new TimerEventDispatcher(this.buildContext.getEventHandlers(), DESCRIPTION);
            try {
                JsonTemplate containerConfiguration = new ImageToJsonTranslator(this.builtImage).getContainerConfiguration();
                BlobDescriptor blobDescriptor = new PushBlobStep(this.buildContext, progressEventDispatcher.newChildProducer(), this.registryClient, Digests.computeDigest(containerConfiguration), Blobs.from(containerConfiguration), false).call();
                ignored.close();
                return blobDescriptor;
            }
            catch (Throwable throwable) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

