/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.core;

import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.spring.pubsub.core.PubSubOperations;
import com.google.cloud.spring.pubsub.core.publisher.PubSubPublisherTemplate;
import com.google.cloud.spring.pubsub.core.subscriber.PubSubSubscriberTemplate;
import com.google.cloud.spring.pubsub.support.AcknowledgeablePubsubMessage;
import com.google.cloud.spring.pubsub.support.BasicAcknowledgeablePubsubMessage;
import com.google.cloud.spring.pubsub.support.PublisherFactory;
import com.google.cloud.spring.pubsub.support.SubscriberFactory;
import com.google.cloud.spring.pubsub.support.converter.ConvertedAcknowledgeablePubsubMessage;
import com.google.cloud.spring.pubsub.support.converter.ConvertedBasicAcknowledgeablePubsubMessage;
import com.google.cloud.spring.pubsub.support.converter.PubSubMessageConverter;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.springframework.util.Assert;

public class PubSubTemplate
implements PubSubOperations {
    private final PubSubPublisherTemplate pubSubPublisherTemplate;
    private final PubSubSubscriberTemplate pubSubSubscriberTemplate;

    public PubSubTemplate(PublisherFactory publisherFactory, SubscriberFactory subscriberFactory) {
        Assert.notNull((Object)publisherFactory, (String)"The publisherFactory can't be null.");
        Assert.notNull((Object)subscriberFactory, (String)"The subscriberFactory can't be null.");
        this.pubSubPublisherTemplate = new PubSubPublisherTemplate(publisherFactory);
        this.pubSubSubscriberTemplate = new PubSubSubscriberTemplate(subscriberFactory);
    }

    public PubSubTemplate(PubSubPublisherTemplate pubSubPublisherTemplate, PubSubSubscriberTemplate pubSubSubscriberTemplate) {
        Assert.notNull((Object)pubSubPublisherTemplate, (String)"The pubSubPublisherTemplate can't be null.");
        Assert.notNull((Object)pubSubSubscriberTemplate, (String)"The pubSubSubscriberTemplate can't be null.");
        this.pubSubPublisherTemplate = pubSubPublisherTemplate;
        this.pubSubSubscriberTemplate = pubSubSubscriberTemplate;
    }

    public PubSubPublisherTemplate getPubSubPublisherTemplate() {
        return this.pubSubPublisherTemplate;
    }

    public PubSubSubscriberTemplate getPubSubSubscriberTemplate() {
        return this.pubSubSubscriberTemplate;
    }

    public PubSubMessageConverter getMessageConverter() {
        return this.pubSubPublisherTemplate.getMessageConverter();
    }

    public void setMessageConverter(PubSubMessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"A valid Pub/Sub message converter is required.");
        this.pubSubPublisherTemplate.setMessageConverter(messageConverter);
        this.pubSubSubscriberTemplate.setMessageConverter(messageConverter);
    }

    @Override
    public <T> CompletableFuture<String> publish(String topic, T payload, Map<String, String> headers) {
        return this.pubSubPublisherTemplate.publish(topic, payload, headers);
    }

    @Override
    public <T> CompletableFuture<String> publish(String topic, T payload) {
        return this.pubSubPublisherTemplate.publish(topic, payload, null);
    }

    @Override
    public CompletableFuture<String> publish(String topic, PubsubMessage pubsubMessage) {
        return this.pubSubPublisherTemplate.publish(topic, pubsubMessage);
    }

    @Override
    public Subscriber subscribe(String subscription, Consumer<BasicAcknowledgeablePubsubMessage> messageConsumer) {
        return this.pubSubSubscriberTemplate.subscribe(subscription, messageConsumer);
    }

    @Override
    public <T> Subscriber subscribeAndConvert(String subscription, Consumer<ConvertedBasicAcknowledgeablePubsubMessage<T>> messageConsumer, Class<T> payloadType) {
        return this.pubSubSubscriberTemplate.subscribeAndConvert(subscription, messageConsumer, payloadType);
    }

    @Override
    public List<AcknowledgeablePubsubMessage> pull(String subscription, Integer maxMessages, Boolean returnImmediately) {
        return this.pubSubSubscriberTemplate.pull(subscription, maxMessages, returnImmediately);
    }

    @Override
    public CompletableFuture<List<AcknowledgeablePubsubMessage>> pullAsync(String subscription, Integer maxMessages, Boolean returnImmediately) {
        return this.pubSubSubscriberTemplate.pullAsync(subscription, maxMessages, returnImmediately);
    }

    @Override
    public <T> List<ConvertedAcknowledgeablePubsubMessage<T>> pullAndConvert(String subscription, Integer maxMessages, Boolean returnImmediately, Class<T> payloadType) {
        return this.pubSubSubscriberTemplate.pullAndConvert(subscription, maxMessages, returnImmediately, payloadType);
    }

    @Override
    public <T> CompletableFuture<List<ConvertedAcknowledgeablePubsubMessage<T>>> pullAndConvertAsync(String subscription, Integer maxMessages, Boolean returnImmediately, Class<T> payloadType) {
        return this.pubSubSubscriberTemplate.pullAndConvertAsync(subscription, maxMessages, returnImmediately, payloadType);
    }

    @Override
    public List<PubsubMessage> pullAndAck(String subscription, Integer maxMessages, Boolean returnImmediately) {
        return this.pubSubSubscriberTemplate.pullAndAck(subscription, maxMessages, returnImmediately);
    }

    @Override
    public CompletableFuture<List<PubsubMessage>> pullAndAckAsync(String subscription, Integer maxMessages, Boolean returnImmediately) {
        return this.pubSubSubscriberTemplate.pullAndAckAsync(subscription, maxMessages, returnImmediately);
    }

    @Override
    public PubsubMessage pullNext(String subscription) {
        return this.pubSubSubscriberTemplate.pullNext(subscription);
    }

    @Override
    public CompletableFuture<PubsubMessage> pullNextAsync(String subscription) {
        return this.pubSubSubscriberTemplate.pullNextAsync(subscription);
    }

    @Override
    public CompletableFuture<Void> ack(Collection<? extends AcknowledgeablePubsubMessage> acknowledgeablePubsubMessages) {
        return this.pubSubSubscriberTemplate.ack(acknowledgeablePubsubMessages);
    }

    @Override
    public CompletableFuture<Void> nack(Collection<? extends AcknowledgeablePubsubMessage> acknowledgeablePubsubMessages) {
        return this.pubSubSubscriberTemplate.nack(acknowledgeablePubsubMessages);
    }

    @Override
    public CompletableFuture<Void> modifyAckDeadline(Collection<? extends AcknowledgeablePubsubMessage> acknowledgeablePubsubMessages, int ackDeadlineSeconds) {
        return this.pubSubSubscriberTemplate.modifyAckDeadline(acknowledgeablePubsubMessages, ackDeadlineSeconds);
    }

    public PublisherFactory getPublisherFactory() {
        return this.pubSubPublisherTemplate.getPublisherFactory();
    }

    public SubscriberFactory getSubscriberFactory() {
        return this.pubSubSubscriberTemplate.getSubscriberFactory();
    }
}

