/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.core.health;

import com.google.api.core.ApiService;
import com.google.api.gax.core.ExecutorProvider;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.spring.pubsub.core.health.HealthTracker;
import com.google.cloud.spring.pubsub.core.health.HealthTrackerImpl;
import com.google.cloud.spring.pubsub.core.health.HealthTrackerRegistry;
import com.google.cloud.spring.pubsub.support.PubSubSubscriptionUtils;
import com.google.pubsub.v1.ProjectSubscriptionName;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class HealthTrackerRegistryImpl
implements HealthTrackerRegistry {
    private static final Log LOGGER = LogFactory.getLog(HealthTrackerRegistryImpl.class);
    private final String projectId;
    private final MetricServiceClient metricServiceClient;
    private final Integer lagThreshold;
    private final Integer backlogThreshold;
    private final Integer lookUpInterval;
    private final ExecutorProvider executorProvider;
    private final ConcurrentMap<ProjectSubscriptionName, HealthTracker> healthTrackers;

    public HealthTrackerRegistryImpl(String projectId, MetricServiceClient metricServiceClient, Integer lagThreshold, Integer backlogThreshold, Integer lookUpInterval, ExecutorProvider executorProvider) {
        this(projectId, metricServiceClient, lagThreshold, backlogThreshold, lookUpInterval, executorProvider, new ConcurrentHashMap<ProjectSubscriptionName, HealthTracker>());
    }

    public HealthTrackerRegistryImpl(String projectId, MetricServiceClient metricServiceClient, Integer lagThreshold, Integer backlogThreshold, Integer lookUpInterval, ExecutorProvider executorProvider, ConcurrentMap<ProjectSubscriptionName, HealthTracker> healthTrackers) {
        Assert.notNull((Object)metricServiceClient, (String)"MetricServiceClient can't be null");
        this.projectId = projectId;
        this.metricServiceClient = metricServiceClient;
        this.lagThreshold = lagThreshold;
        this.backlogThreshold = backlogThreshold;
        this.lookUpInterval = lookUpInterval;
        this.healthTrackers = healthTrackers;
        this.executorProvider = executorProvider;
    }

    @Override
    public HealthTracker registerTracker(String subscriptionName) {
        ProjectSubscriptionName projectSubscriptionName = PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, this.projectId);
        return this.registerTracker(projectSubscriptionName);
    }

    @Override
    public HealthTracker registerTracker(ProjectSubscriptionName projectSubscriptionName) {
        HealthTrackerImpl healthTracker = new HealthTrackerImpl(projectSubscriptionName, this.metricServiceClient, this.lagThreshold, this.backlogThreshold, this.lookUpInterval);
        this.healthTrackers.put(projectSubscriptionName, healthTracker);
        return healthTracker;
    }

    @Override
    public boolean isTracked(ProjectSubscriptionName projectSubscriptionName) {
        return this.healthTrackers.containsKey(projectSubscriptionName);
    }

    @Override
    public void processedMessage(ProjectSubscriptionName subscription) {
        if (!this.healthTrackers.containsKey(subscription)) {
            LOGGER.warn((Object)("No HealthTracker register for subscription " + subscription.toString()));
            return;
        }
        ((HealthTracker)this.healthTrackers.get(subscription)).processedMessage();
    }

    @Override
    public void addListener(Subscriber subscriber) {
        final ProjectSubscriptionName subscription = ProjectSubscriptionName.parse((String)subscriber.getSubscriptionNameString());
        if (!this.healthTrackers.containsKey(subscription)) {
            LOGGER.warn((Object)("No HealthTracker register for subscription " + subscription.toString() + " ,will not register listener"));
            return;
        }
        ApiService.Listener listener = new ApiService.Listener(){

            public void terminated(ApiService.State from) {
                HealthTrackerRegistryImpl.this.healthTrackers.remove(subscription);
            }
        };
        subscriber.addListener(listener, (Executor)this.executorProvider.getExecutor());
    }

    @Override
    public Collection<HealthTracker> healthTrackers() {
        return this.healthTrackers.values();
    }
}

