/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.support;

import com.google.cloud.spring.pubsub.support.BasicAcknowledgeablePubsubMessage;
import java.util.Optional;
import org.springframework.messaging.Message;

public abstract class GcpPubSubHeaders {
    private static final String PREFIX = "gcp_pubsub_";
    public static final String CLIENT = "googclient_*";
    public static final String TOPIC = "gcp_pubsub_topic";
    public static final String ORIGINAL_MESSAGE = "gcp_pubsub_original_message";
    public static final String ORDERING_KEY = "gcp_pubsub_ordering_key";

    private GcpPubSubHeaders() {
    }

    public static Optional<BasicAcknowledgeablePubsubMessage> getOriginalMessage(Message<?> message) {
        Object originalMessage = message.getHeaders().get((Object)ORIGINAL_MESSAGE);
        if (originalMessage instanceof BasicAcknowledgeablePubsubMessage) {
            return Optional.of((BasicAcknowledgeablePubsubMessage)originalMessage);
        }
        return Optional.empty();
    }
}

