/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.support.converter;

import com.google.cloud.spring.pubsub.support.converter.PubSubMessageConversionException;
import com.google.cloud.spring.pubsub.support.converter.PubSubMessageConverter;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;

public class SimplePubSubMessageConverter
implements PubSubMessageConverter {
    private final Charset charset;

    public SimplePubSubMessageConverter() {
        this(Charset.defaultCharset());
    }

    public SimplePubSubMessageConverter(Charset charset) {
        this.charset = charset;
    }

    @Override
    public PubsubMessage toPubSubMessage(Object payload, Map<String, String> headers) {
        ByteString convertedPayload;
        if (payload instanceof ByteString) {
            convertedPayload = (ByteString)payload;
        } else if (payload instanceof String) {
            convertedPayload = ByteString.copyFrom((byte[])((String)payload).getBytes(this.charset));
        } else if (payload instanceof ByteBuffer) {
            convertedPayload = ByteString.copyFrom((ByteBuffer)((ByteBuffer)payload));
        } else if (payload instanceof byte[]) {
            convertedPayload = ByteString.copyFrom((byte[])((byte[])payload));
        } else {
            throw new PubSubMessageConversionException("Unable to convert payload of type " + payload.getClass().getName() + " to byte[] for sending to Pub/Sub.");
        }
        return this.byteStringToPubSubMessage(convertedPayload, headers);
    }

    @Override
    public <T> T fromPubSubMessage(PubsubMessage message, Class<T> payloadType) {
        Object result;
        byte[] payload = message.getData().toByteArray();
        if (payloadType == ByteString.class) {
            result = message.getData();
        } else if (payloadType == String.class) {
            result = new String(payload, this.charset);
        } else if (payloadType == ByteBuffer.class) {
            result = ByteBuffer.wrap(payload);
        } else if (payloadType == byte[].class) {
            result = payload;
        } else {
            throw new PubSubMessageConversionException("Unable to convert Pub/Sub message to payload of type " + payloadType.getName() + ".");
        }
        return (T)result;
    }
}

