/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.support;

import com.google.cloud.pubsub.v1.PublisherInterface;
import com.google.cloud.spring.pubsub.support.PublisherFactory;
import java.util.concurrent.ConcurrentHashMap;

public class CachingPublisherFactory
implements PublisherFactory {
    private final ConcurrentHashMap<String, PublisherInterface> publishers = new ConcurrentHashMap();
    private PublisherFactory delegate;

    public CachingPublisherFactory(PublisherFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public PublisherInterface createPublisher(String topic) {
        return this.publishers.computeIfAbsent(topic, this.delegate::createPublisher);
    }

    public PublisherFactory getDelegate() {
        return this.delegate;
    }
}

