/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.pubsub;

import brave.Span;
import brave.Tracer;
import brave.messaging.MessagingRequest;
import brave.propagation.TraceContextOrSamplingFlags;
import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubConsumerRequest;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubTracing;
import com.google.pubsub.v1.PubsubMessage;

final class TracingMessageReceiver
implements MessageReceiver {
    private final PubSubTracing pubSubTracing;
    private final MessageReceiver delegate;
    private final String subscriptionName;

    TracingMessageReceiver(MessageReceiver delegate, PubSubTracing pubSubTracing, String subscriptionName) {
        this.pubSubTracing = pubSubTracing;
        this.delegate = delegate;
        this.subscriptionName = subscriptionName;
    }

    public void receiveMessage(PubsubMessage pubsubMessage, AckReplyConsumer ackReplyConsumer) {
        PubsubMessage.Builder messageBuilder = pubsubMessage.toBuilder();
        PubSubConsumerRequest request = new PubSubConsumerRequest(messageBuilder, this.subscriptionName);
        TraceContextOrSamplingFlags extracted = this.pubSubTracing.extractAndClearTraceIdHeaders(this.pubSubTracing.consumerExtractor, request, messageBuilder);
        Span consumerSpan = this.pubSubTracing.nextMessagingSpan(this.pubSubTracing.consumerSampler, (MessagingRequest)request, extracted);
        Span listenerSpan = this.pubSubTracing.tracer.newChild(consumerSpan.context());
        if (!consumerSpan.isNoop()) {
            consumerSpan.name("next-message").kind(Span.Kind.CONSUMER);
            consumerSpan.tag("pubsub.subscription", this.subscriptionName);
            if (this.pubSubTracing.remoteServiceName != null) {
                consumerSpan.remoteServiceName(this.pubSubTracing.remoteServiceName);
            }
            long timestamp = this.pubSubTracing.tracing.clock(consumerSpan.context()).currentTimeMicroseconds();
            consumerSpan.start(timestamp);
            long consumerFinish = timestamp + 1L;
            consumerSpan.finish(consumerFinish);
            listenerSpan.name("on-message").start(consumerFinish);
        }
        Tracer.SpanInScope ws = this.pubSubTracing.tracer.withSpanInScope(listenerSpan);
        Exception error = null;
        try {
            this.delegate.receiveMessage(messageBuilder.build(), ackReplyConsumer);
        }
        catch (Exception t) {
            error = t;
            throw t;
        }
        finally {
            if (error != null) {
                listenerSpan.error((Throwable)error);
            }
            listenerSpan.finish();
            ws.close();
        }
    }
}

