/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.pubsub;

import brave.Tracing;
import brave.messaging.MessagingTracing;
import com.google.cloud.spring.autoconfigure.pubsub.GcpPubSubAutoConfiguration;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubTracing;
import com.google.cloud.spring.autoconfigure.trace.pubsub.TraceHelper;
import com.google.cloud.spring.autoconfigure.trace.pubsub.TracePubSubBeanPostProcessor;
import com.google.cloud.spring.pubsub.core.publisher.PublisherCustomizer;
import com.google.cloud.spring.pubsub.support.PublisherFactory;
import com.google.pubsub.v1.PubsubMessage;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.brave.instrument.messaging.BraveMessagingAutoConfiguration;
import org.springframework.cloud.sleuth.brave.instrument.messaging.ConditionalOnMessagingEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMessagingEnabled
@ConditionalOnBean(value={Tracing.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.trace.pubsub.enabled"}, matchIfMissing=false)
@ConditionalOnClass(value={PublisherFactory.class, MessagingTracing.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class, BraveMessagingAutoConfiguration.class})
@AutoConfigureBefore(value={GcpPubSubAutoConfiguration.class})
class TracePubSubAutoConfiguration {
    TracePubSubAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    static TracePubSubBeanPostProcessor tracePubSubBeanPostProcessor(BeanFactory beanFactory) {
        return new TracePubSubBeanPostProcessor(beanFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    PubSubTracing pubSubTracing(MessagingTracing messagingTracing) {
        return PubSubTracing.newBuilder(messagingTracing).build();
    }

    @Bean
    @Order(value=-2147483648)
    PublisherCustomizer tracePublisherCustomizer(PubSubTracing pubSubTracing) {
        TraceHelper helper = new TraceHelper(pubSubTracing);
        return (publisherBuilder, topic) -> publisherBuilder.setTransform(msg -> helper.instrumentMessage((PubsubMessage)msg, topic));
    }
}

