/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.sql;

import com.google.cloud.spring.autoconfigure.core.GcpProperties;
import com.google.cloud.spring.autoconfigure.sql.GcpCloudSqlProperties;
import com.google.cloud.spring.autoconfigure.sql.SqlCredentialFactory;
import com.google.cloud.spring.core.Credentials;
import java.io.File;
import java.io.IOException;
import org.springframework.core.io.Resource;

final class CredentialsPropertiesSetter {
    CredentialsPropertiesSetter() {
    }

    static void setCredentials(GcpCloudSqlProperties sqlProperties, GcpProperties gcpProperties) {
        Credentials credentials = null;
        credentials = sqlProperties.getCredentials().hasKey() ? sqlProperties.getCredentials() : gcpProperties.getCredentials();
        if (credentials.getEncodedKey() != null) {
            CredentialsPropertiesSetter.setCredentialsEncodedKeyProperty(credentials.getEncodedKey());
        } else if (credentials.getLocation() != null) {
            CredentialsPropertiesSetter.setCredentialsFileProperty(credentials.getLocation());
        }
    }

    private static void setCredentialsEncodedKeyProperty(String encodedKey) {
        System.setProperty("GOOGLE_CLOUD_SQL_ENCODED_KEY", encodedKey);
        System.setProperty("cloudSql.socketFactory.credentialFactory", SqlCredentialFactory.class.getName());
    }

    static void setCredentialsFileProperty(Resource credentialsLocation) throws IllegalArgumentException {
        try {
            File credentialsLocationFile = credentialsLocation.getFile();
            System.setProperty("GOOGLE_CLOUD_SQL_CREDS_LOCATION", credentialsLocationFile.getAbsolutePath());
            System.setProperty("cloudSql.socketFactory.credentialFactory", SqlCredentialFactory.class.getName());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(String.format("Error reading Cloud SQL credentials file: %s. Please verify the specified file path.", credentialsLocation));
        }
    }
}

