/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.datastore.health;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.spring.autoconfigure.datastore.DatastoreProvider;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class DatastoreHealthIndicator
extends AbstractHealthIndicator {
    private final DatastoreProvider datastore;

    public DatastoreHealthIndicator(DatastoreProvider datastore) {
        super("Datastore health check failed");
        Assert.notNull((Object)datastore, (String)"Datastore supplier must not be null");
        this.datastore = datastore;
    }

    protected void doHealthCheck(Health.Builder builder) {
        ((Datastore)this.datastore.get()).run((Query)((KeyQuery.Builder)Query.newKeyQueryBuilder().setKind("__Stat_Total__")).build());
        builder.up();
    }
}

