/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.example.trace;

import com.google.cloud.opentelemetry.trace.TraceConfiguration;
import com.google.cloud.opentelemetry.trace.TraceExporter;
import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;
import java.io.IOException;
import java.time.Duration;

public class TraceExporterExample {
    private TraceExporter traceExporter;
    private Tracer tracer = OpenTelemetry.getTracer((String)"io.opentelemetry.example.TraceExporterExample");

    private void setupTraceExporter() {
        TraceConfiguration configuration = TraceConfiguration.builder().setDeadline(Duration.ofMillis(30000L)).build();
        try {
            this.traceExporter = TraceExporter.createWithConfiguration((TraceConfiguration)configuration);
            OpenTelemetrySdk.getTracerProvider().addSpanProcessor((SpanProcessor)BatchSpanProcessor.newBuilder((SpanExporter)this.traceExporter).build());
        }
        catch (IOException e) {
            System.out.println("Uncaught Exception");
        }
    }

    private void myUseCase() {
        Span span = this.tracer.spanBuilder("Start my use case").startSpan();
        span.addEvent("Event 0");
        this.doWork();
        span.addEvent("Event 1");
        span.end();
    }

    private void doWork() {
        try {
            Thread.sleep((int)(Math.random() * 1000.0) + 1000);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        TraceExporterExample example = new TraceExporterExample();
        example.setupTraceExporter();
        example.myUseCase();
    }
}

