/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workstations.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.workstations.v1.CreateWorkstationClusterRequest;
import com.google.cloud.workstations.v1.CreateWorkstationConfigRequest;
import com.google.cloud.workstations.v1.CreateWorkstationRequest;
import com.google.cloud.workstations.v1.DeleteWorkstationClusterRequest;
import com.google.cloud.workstations.v1.DeleteWorkstationConfigRequest;
import com.google.cloud.workstations.v1.DeleteWorkstationRequest;
import com.google.cloud.workstations.v1.GenerateAccessTokenRequest;
import com.google.cloud.workstations.v1.GenerateAccessTokenResponse;
import com.google.cloud.workstations.v1.GetWorkstationClusterRequest;
import com.google.cloud.workstations.v1.GetWorkstationConfigRequest;
import com.google.cloud.workstations.v1.GetWorkstationRequest;
import com.google.cloud.workstations.v1.ListUsableWorkstationConfigsRequest;
import com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse;
import com.google.cloud.workstations.v1.ListUsableWorkstationsRequest;
import com.google.cloud.workstations.v1.ListUsableWorkstationsResponse;
import com.google.cloud.workstations.v1.ListWorkstationClustersRequest;
import com.google.cloud.workstations.v1.ListWorkstationClustersResponse;
import com.google.cloud.workstations.v1.ListWorkstationConfigsRequest;
import com.google.cloud.workstations.v1.ListWorkstationConfigsResponse;
import com.google.cloud.workstations.v1.ListWorkstationsRequest;
import com.google.cloud.workstations.v1.ListWorkstationsResponse;
import com.google.cloud.workstations.v1.OperationMetadata;
import com.google.cloud.workstations.v1.StartWorkstationRequest;
import com.google.cloud.workstations.v1.StopWorkstationRequest;
import com.google.cloud.workstations.v1.UpdateWorkstationClusterRequest;
import com.google.cloud.workstations.v1.UpdateWorkstationConfigRequest;
import com.google.cloud.workstations.v1.UpdateWorkstationRequest;
import com.google.cloud.workstations.v1.Workstation;
import com.google.cloud.workstations.v1.WorkstationCluster;
import com.google.cloud.workstations.v1.WorkstationConfig;
import com.google.cloud.workstations.v1.WorkstationsClient;
import com.google.cloud.workstations.v1.stub.GrpcWorkstationsStub;
import com.google.cloud.workstations.v1.stub.HttpJsonWorkstationsStub;
import com.google.cloud.workstations.v1.stub.WorkstationsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class WorkstationsStubSettings
extends StubSettings<WorkstationsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetWorkstationClusterRequest, WorkstationCluster> getWorkstationClusterSettings;
    private final PagedCallSettings<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationsClient.ListWorkstationClustersPagedResponse> listWorkstationClustersSettings;
    private final UnaryCallSettings<CreateWorkstationClusterRequest, Operation> createWorkstationClusterSettings;
    private final OperationCallSettings<CreateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> createWorkstationClusterOperationSettings;
    private final UnaryCallSettings<UpdateWorkstationClusterRequest, Operation> updateWorkstationClusterSettings;
    private final OperationCallSettings<UpdateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> updateWorkstationClusterOperationSettings;
    private final UnaryCallSettings<DeleteWorkstationClusterRequest, Operation> deleteWorkstationClusterSettings;
    private final OperationCallSettings<DeleteWorkstationClusterRequest, WorkstationCluster, OperationMetadata> deleteWorkstationClusterOperationSettings;
    private final UnaryCallSettings<GetWorkstationConfigRequest, WorkstationConfig> getWorkstationConfigSettings;
    private final PagedCallSettings<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationsClient.ListWorkstationConfigsPagedResponse> listWorkstationConfigsSettings;
    private final PagedCallSettings<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationsClient.ListUsableWorkstationConfigsPagedResponse> listUsableWorkstationConfigsSettings;
    private final UnaryCallSettings<CreateWorkstationConfigRequest, Operation> createWorkstationConfigSettings;
    private final OperationCallSettings<CreateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> createWorkstationConfigOperationSettings;
    private final UnaryCallSettings<UpdateWorkstationConfigRequest, Operation> updateWorkstationConfigSettings;
    private final OperationCallSettings<UpdateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> updateWorkstationConfigOperationSettings;
    private final UnaryCallSettings<DeleteWorkstationConfigRequest, Operation> deleteWorkstationConfigSettings;
    private final OperationCallSettings<DeleteWorkstationConfigRequest, WorkstationConfig, OperationMetadata> deleteWorkstationConfigOperationSettings;
    private final UnaryCallSettings<GetWorkstationRequest, Workstation> getWorkstationSettings;
    private final PagedCallSettings<ListWorkstationsRequest, ListWorkstationsResponse, WorkstationsClient.ListWorkstationsPagedResponse> listWorkstationsSettings;
    private final PagedCallSettings<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, WorkstationsClient.ListUsableWorkstationsPagedResponse> listUsableWorkstationsSettings;
    private final UnaryCallSettings<CreateWorkstationRequest, Operation> createWorkstationSettings;
    private final OperationCallSettings<CreateWorkstationRequest, Workstation, OperationMetadata> createWorkstationOperationSettings;
    private final UnaryCallSettings<UpdateWorkstationRequest, Operation> updateWorkstationSettings;
    private final OperationCallSettings<UpdateWorkstationRequest, Workstation, OperationMetadata> updateWorkstationOperationSettings;
    private final UnaryCallSettings<DeleteWorkstationRequest, Operation> deleteWorkstationSettings;
    private final OperationCallSettings<DeleteWorkstationRequest, Workstation, OperationMetadata> deleteWorkstationOperationSettings;
    private final UnaryCallSettings<StartWorkstationRequest, Operation> startWorkstationSettings;
    private final OperationCallSettings<StartWorkstationRequest, Workstation, OperationMetadata> startWorkstationOperationSettings;
    private final UnaryCallSettings<StopWorkstationRequest, Operation> stopWorkstationSettings;
    private final OperationCallSettings<StopWorkstationRequest, Workstation, OperationMetadata> stopWorkstationOperationSettings;
    private final UnaryCallSettings<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationCluster> LIST_WORKSTATION_CLUSTERS_PAGE_STR_DESC = new PagedListDescriptor<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationCluster>(){

        public String emptyToken() {
            return "";
        }

        public ListWorkstationClustersRequest injectToken(ListWorkstationClustersRequest payload, String token) {
            return ListWorkstationClustersRequest.newBuilder((ListWorkstationClustersRequest)payload).setPageToken(token).build();
        }

        public ListWorkstationClustersRequest injectPageSize(ListWorkstationClustersRequest payload, int pageSize) {
            return ListWorkstationClustersRequest.newBuilder((ListWorkstationClustersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWorkstationClustersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWorkstationClustersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<WorkstationCluster> extractResources(ListWorkstationClustersResponse payload) {
            return payload.getWorkstationClustersList() == null ? ImmutableList.of() : payload.getWorkstationClustersList();
        }
    };
    private static final PagedListDescriptor<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationConfig> LIST_WORKSTATION_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListWorkstationConfigsRequest injectToken(ListWorkstationConfigsRequest payload, String token) {
            return ListWorkstationConfigsRequest.newBuilder((ListWorkstationConfigsRequest)payload).setPageToken(token).build();
        }

        public ListWorkstationConfigsRequest injectPageSize(ListWorkstationConfigsRequest payload, int pageSize) {
            return ListWorkstationConfigsRequest.newBuilder((ListWorkstationConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWorkstationConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWorkstationConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<WorkstationConfig> extractResources(ListWorkstationConfigsResponse payload) {
            return payload.getWorkstationConfigsList() == null ? ImmutableList.of() : payload.getWorkstationConfigsList();
        }
    };
    private static final PagedListDescriptor<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationConfig> LIST_USABLE_WORKSTATION_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListUsableWorkstationConfigsRequest injectToken(ListUsableWorkstationConfigsRequest payload, String token) {
            return ListUsableWorkstationConfigsRequest.newBuilder((ListUsableWorkstationConfigsRequest)payload).setPageToken(token).build();
        }

        public ListUsableWorkstationConfigsRequest injectPageSize(ListUsableWorkstationConfigsRequest payload, int pageSize) {
            return ListUsableWorkstationConfigsRequest.newBuilder((ListUsableWorkstationConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListUsableWorkstationConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListUsableWorkstationConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<WorkstationConfig> extractResources(ListUsableWorkstationConfigsResponse payload) {
            return payload.getWorkstationConfigsList() == null ? ImmutableList.of() : payload.getWorkstationConfigsList();
        }
    };
    private static final PagedListDescriptor<ListWorkstationsRequest, ListWorkstationsResponse, Workstation> LIST_WORKSTATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListWorkstationsRequest, ListWorkstationsResponse, Workstation>(){

        public String emptyToken() {
            return "";
        }

        public ListWorkstationsRequest injectToken(ListWorkstationsRequest payload, String token) {
            return ListWorkstationsRequest.newBuilder((ListWorkstationsRequest)payload).setPageToken(token).build();
        }

        public ListWorkstationsRequest injectPageSize(ListWorkstationsRequest payload, int pageSize) {
            return ListWorkstationsRequest.newBuilder((ListWorkstationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWorkstationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWorkstationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Workstation> extractResources(ListWorkstationsResponse payload) {
            return payload.getWorkstationsList() == null ? ImmutableList.of() : payload.getWorkstationsList();
        }
    };
    private static final PagedListDescriptor<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, Workstation> LIST_USABLE_WORKSTATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, Workstation>(){

        public String emptyToken() {
            return "";
        }

        public ListUsableWorkstationsRequest injectToken(ListUsableWorkstationsRequest payload, String token) {
            return ListUsableWorkstationsRequest.newBuilder((ListUsableWorkstationsRequest)payload).setPageToken(token).build();
        }

        public ListUsableWorkstationsRequest injectPageSize(ListUsableWorkstationsRequest payload, int pageSize) {
            return ListUsableWorkstationsRequest.newBuilder((ListUsableWorkstationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListUsableWorkstationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListUsableWorkstationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Workstation> extractResources(ListUsableWorkstationsResponse payload) {
            return payload.getWorkstationsList() == null ? ImmutableList.of() : payload.getWorkstationsList();
        }
    };
    private static final PagedListResponseFactory<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationsClient.ListWorkstationClustersPagedResponse> LIST_WORKSTATION_CLUSTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationsClient.ListWorkstationClustersPagedResponse>(){

        public ApiFuture<WorkstationsClient.ListWorkstationClustersPagedResponse> getFuturePagedResponse(UnaryCallable<ListWorkstationClustersRequest, ListWorkstationClustersResponse> callable, ListWorkstationClustersRequest request, ApiCallContext context, ApiFuture<ListWorkstationClustersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WORKSTATION_CLUSTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WorkstationsClient.ListWorkstationClustersPagedResponse.createAsync((PageContext<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationCluster>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationsClient.ListWorkstationConfigsPagedResponse> LIST_WORKSTATION_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationsClient.ListWorkstationConfigsPagedResponse>(){

        public ApiFuture<WorkstationsClient.ListWorkstationConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse> callable, ListWorkstationConfigsRequest request, ApiCallContext context, ApiFuture<ListWorkstationConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WORKSTATION_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WorkstationsClient.ListWorkstationConfigsPagedResponse.createAsync((PageContext<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationConfig>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationsClient.ListUsableWorkstationConfigsPagedResponse> LIST_USABLE_WORKSTATION_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationsClient.ListUsableWorkstationConfigsPagedResponse>(){

        public ApiFuture<WorkstationsClient.ListUsableWorkstationConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse> callable, ListUsableWorkstationConfigsRequest request, ApiCallContext context, ApiFuture<ListUsableWorkstationConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_USABLE_WORKSTATION_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WorkstationsClient.ListUsableWorkstationConfigsPagedResponse.createAsync((PageContext<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationConfig>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListWorkstationsRequest, ListWorkstationsResponse, WorkstationsClient.ListWorkstationsPagedResponse> LIST_WORKSTATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListWorkstationsRequest, ListWorkstationsResponse, WorkstationsClient.ListWorkstationsPagedResponse>(){

        public ApiFuture<WorkstationsClient.ListWorkstationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListWorkstationsRequest, ListWorkstationsResponse> callable, ListWorkstationsRequest request, ApiCallContext context, ApiFuture<ListWorkstationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WORKSTATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WorkstationsClient.ListWorkstationsPagedResponse.createAsync((PageContext<ListWorkstationsRequest, ListWorkstationsResponse, Workstation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, WorkstationsClient.ListUsableWorkstationsPagedResponse> LIST_USABLE_WORKSTATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, WorkstationsClient.ListUsableWorkstationsPagedResponse>(){

        public ApiFuture<WorkstationsClient.ListUsableWorkstationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse> callable, ListUsableWorkstationsRequest request, ApiCallContext context, ApiFuture<ListUsableWorkstationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_USABLE_WORKSTATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WorkstationsClient.ListUsableWorkstationsPagedResponse.createAsync((PageContext<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, Workstation>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetWorkstationClusterRequest, WorkstationCluster> getWorkstationClusterSettings() {
        return this.getWorkstationClusterSettings;
    }

    public PagedCallSettings<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationsClient.ListWorkstationClustersPagedResponse> listWorkstationClustersSettings() {
        return this.listWorkstationClustersSettings;
    }

    public UnaryCallSettings<CreateWorkstationClusterRequest, Operation> createWorkstationClusterSettings() {
        return this.createWorkstationClusterSettings;
    }

    public OperationCallSettings<CreateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> createWorkstationClusterOperationSettings() {
        return this.createWorkstationClusterOperationSettings;
    }

    public UnaryCallSettings<UpdateWorkstationClusterRequest, Operation> updateWorkstationClusterSettings() {
        return this.updateWorkstationClusterSettings;
    }

    public OperationCallSettings<UpdateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> updateWorkstationClusterOperationSettings() {
        return this.updateWorkstationClusterOperationSettings;
    }

    public UnaryCallSettings<DeleteWorkstationClusterRequest, Operation> deleteWorkstationClusterSettings() {
        return this.deleteWorkstationClusterSettings;
    }

    public OperationCallSettings<DeleteWorkstationClusterRequest, WorkstationCluster, OperationMetadata> deleteWorkstationClusterOperationSettings() {
        return this.deleteWorkstationClusterOperationSettings;
    }

    public UnaryCallSettings<GetWorkstationConfigRequest, WorkstationConfig> getWorkstationConfigSettings() {
        return this.getWorkstationConfigSettings;
    }

    public PagedCallSettings<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationsClient.ListWorkstationConfigsPagedResponse> listWorkstationConfigsSettings() {
        return this.listWorkstationConfigsSettings;
    }

    public PagedCallSettings<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationsClient.ListUsableWorkstationConfigsPagedResponse> listUsableWorkstationConfigsSettings() {
        return this.listUsableWorkstationConfigsSettings;
    }

    public UnaryCallSettings<CreateWorkstationConfigRequest, Operation> createWorkstationConfigSettings() {
        return this.createWorkstationConfigSettings;
    }

    public OperationCallSettings<CreateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> createWorkstationConfigOperationSettings() {
        return this.createWorkstationConfigOperationSettings;
    }

    public UnaryCallSettings<UpdateWorkstationConfigRequest, Operation> updateWorkstationConfigSettings() {
        return this.updateWorkstationConfigSettings;
    }

    public OperationCallSettings<UpdateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> updateWorkstationConfigOperationSettings() {
        return this.updateWorkstationConfigOperationSettings;
    }

    public UnaryCallSettings<DeleteWorkstationConfigRequest, Operation> deleteWorkstationConfigSettings() {
        return this.deleteWorkstationConfigSettings;
    }

    public OperationCallSettings<DeleteWorkstationConfigRequest, WorkstationConfig, OperationMetadata> deleteWorkstationConfigOperationSettings() {
        return this.deleteWorkstationConfigOperationSettings;
    }

    public UnaryCallSettings<GetWorkstationRequest, Workstation> getWorkstationSettings() {
        return this.getWorkstationSettings;
    }

    public PagedCallSettings<ListWorkstationsRequest, ListWorkstationsResponse, WorkstationsClient.ListWorkstationsPagedResponse> listWorkstationsSettings() {
        return this.listWorkstationsSettings;
    }

    public PagedCallSettings<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, WorkstationsClient.ListUsableWorkstationsPagedResponse> listUsableWorkstationsSettings() {
        return this.listUsableWorkstationsSettings;
    }

    public UnaryCallSettings<CreateWorkstationRequest, Operation> createWorkstationSettings() {
        return this.createWorkstationSettings;
    }

    public OperationCallSettings<CreateWorkstationRequest, Workstation, OperationMetadata> createWorkstationOperationSettings() {
        return this.createWorkstationOperationSettings;
    }

    public UnaryCallSettings<UpdateWorkstationRequest, Operation> updateWorkstationSettings() {
        return this.updateWorkstationSettings;
    }

    public OperationCallSettings<UpdateWorkstationRequest, Workstation, OperationMetadata> updateWorkstationOperationSettings() {
        return this.updateWorkstationOperationSettings;
    }

    public UnaryCallSettings<DeleteWorkstationRequest, Operation> deleteWorkstationSettings() {
        return this.deleteWorkstationSettings;
    }

    public OperationCallSettings<DeleteWorkstationRequest, Workstation, OperationMetadata> deleteWorkstationOperationSettings() {
        return this.deleteWorkstationOperationSettings;
    }

    public UnaryCallSettings<StartWorkstationRequest, Operation> startWorkstationSettings() {
        return this.startWorkstationSettings;
    }

    public OperationCallSettings<StartWorkstationRequest, Workstation, OperationMetadata> startWorkstationOperationSettings() {
        return this.startWorkstationOperationSettings;
    }

    public UnaryCallSettings<StopWorkstationRequest, Operation> stopWorkstationSettings() {
        return this.stopWorkstationSettings;
    }

    public OperationCallSettings<StopWorkstationRequest, Workstation, OperationMetadata> stopWorkstationOperationSettings() {
        return this.stopWorkstationOperationSettings;
    }

    public UnaryCallSettings<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenSettings() {
        return this.generateAccessTokenSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public WorkstationsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcWorkstationsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonWorkstationsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "workstations.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "workstations.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return WorkstationsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(WorkstationsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(WorkstationsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return WorkstationsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected WorkstationsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getWorkstationClusterSettings = settingsBuilder.getWorkstationClusterSettings().build();
        this.listWorkstationClustersSettings = settingsBuilder.listWorkstationClustersSettings().build();
        this.createWorkstationClusterSettings = settingsBuilder.createWorkstationClusterSettings().build();
        this.createWorkstationClusterOperationSettings = settingsBuilder.createWorkstationClusterOperationSettings().build();
        this.updateWorkstationClusterSettings = settingsBuilder.updateWorkstationClusterSettings().build();
        this.updateWorkstationClusterOperationSettings = settingsBuilder.updateWorkstationClusterOperationSettings().build();
        this.deleteWorkstationClusterSettings = settingsBuilder.deleteWorkstationClusterSettings().build();
        this.deleteWorkstationClusterOperationSettings = settingsBuilder.deleteWorkstationClusterOperationSettings().build();
        this.getWorkstationConfigSettings = settingsBuilder.getWorkstationConfigSettings().build();
        this.listWorkstationConfigsSettings = settingsBuilder.listWorkstationConfigsSettings().build();
        this.listUsableWorkstationConfigsSettings = settingsBuilder.listUsableWorkstationConfigsSettings().build();
        this.createWorkstationConfigSettings = settingsBuilder.createWorkstationConfigSettings().build();
        this.createWorkstationConfigOperationSettings = settingsBuilder.createWorkstationConfigOperationSettings().build();
        this.updateWorkstationConfigSettings = settingsBuilder.updateWorkstationConfigSettings().build();
        this.updateWorkstationConfigOperationSettings = settingsBuilder.updateWorkstationConfigOperationSettings().build();
        this.deleteWorkstationConfigSettings = settingsBuilder.deleteWorkstationConfigSettings().build();
        this.deleteWorkstationConfigOperationSettings = settingsBuilder.deleteWorkstationConfigOperationSettings().build();
        this.getWorkstationSettings = settingsBuilder.getWorkstationSettings().build();
        this.listWorkstationsSettings = settingsBuilder.listWorkstationsSettings().build();
        this.listUsableWorkstationsSettings = settingsBuilder.listUsableWorkstationsSettings().build();
        this.createWorkstationSettings = settingsBuilder.createWorkstationSettings().build();
        this.createWorkstationOperationSettings = settingsBuilder.createWorkstationOperationSettings().build();
        this.updateWorkstationSettings = settingsBuilder.updateWorkstationSettings().build();
        this.updateWorkstationOperationSettings = settingsBuilder.updateWorkstationOperationSettings().build();
        this.deleteWorkstationSettings = settingsBuilder.deleteWorkstationSettings().build();
        this.deleteWorkstationOperationSettings = settingsBuilder.deleteWorkstationOperationSettings().build();
        this.startWorkstationSettings = settingsBuilder.startWorkstationSettings().build();
        this.startWorkstationOperationSettings = settingsBuilder.startWorkstationOperationSettings().build();
        this.stopWorkstationSettings = settingsBuilder.stopWorkstationSettings().build();
        this.stopWorkstationOperationSettings = settingsBuilder.stopWorkstationOperationSettings().build();
        this.generateAccessTokenSettings = settingsBuilder.generateAccessTokenSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<WorkstationsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetWorkstationClusterRequest, WorkstationCluster> getWorkstationClusterSettings;
        private final PagedCallSettings.Builder<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationsClient.ListWorkstationClustersPagedResponse> listWorkstationClustersSettings;
        private final UnaryCallSettings.Builder<CreateWorkstationClusterRequest, Operation> createWorkstationClusterSettings;
        private final OperationCallSettings.Builder<CreateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> createWorkstationClusterOperationSettings;
        private final UnaryCallSettings.Builder<UpdateWorkstationClusterRequest, Operation> updateWorkstationClusterSettings;
        private final OperationCallSettings.Builder<UpdateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> updateWorkstationClusterOperationSettings;
        private final UnaryCallSettings.Builder<DeleteWorkstationClusterRequest, Operation> deleteWorkstationClusterSettings;
        private final OperationCallSettings.Builder<DeleteWorkstationClusterRequest, WorkstationCluster, OperationMetadata> deleteWorkstationClusterOperationSettings;
        private final UnaryCallSettings.Builder<GetWorkstationConfigRequest, WorkstationConfig> getWorkstationConfigSettings;
        private final PagedCallSettings.Builder<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationsClient.ListWorkstationConfigsPagedResponse> listWorkstationConfigsSettings;
        private final PagedCallSettings.Builder<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationsClient.ListUsableWorkstationConfigsPagedResponse> listUsableWorkstationConfigsSettings;
        private final UnaryCallSettings.Builder<CreateWorkstationConfigRequest, Operation> createWorkstationConfigSettings;
        private final OperationCallSettings.Builder<CreateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> createWorkstationConfigOperationSettings;
        private final UnaryCallSettings.Builder<UpdateWorkstationConfigRequest, Operation> updateWorkstationConfigSettings;
        private final OperationCallSettings.Builder<UpdateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> updateWorkstationConfigOperationSettings;
        private final UnaryCallSettings.Builder<DeleteWorkstationConfigRequest, Operation> deleteWorkstationConfigSettings;
        private final OperationCallSettings.Builder<DeleteWorkstationConfigRequest, WorkstationConfig, OperationMetadata> deleteWorkstationConfigOperationSettings;
        private final UnaryCallSettings.Builder<GetWorkstationRequest, Workstation> getWorkstationSettings;
        private final PagedCallSettings.Builder<ListWorkstationsRequest, ListWorkstationsResponse, WorkstationsClient.ListWorkstationsPagedResponse> listWorkstationsSettings;
        private final PagedCallSettings.Builder<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, WorkstationsClient.ListUsableWorkstationsPagedResponse> listUsableWorkstationsSettings;
        private final UnaryCallSettings.Builder<CreateWorkstationRequest, Operation> createWorkstationSettings;
        private final OperationCallSettings.Builder<CreateWorkstationRequest, Workstation, OperationMetadata> createWorkstationOperationSettings;
        private final UnaryCallSettings.Builder<UpdateWorkstationRequest, Operation> updateWorkstationSettings;
        private final OperationCallSettings.Builder<UpdateWorkstationRequest, Workstation, OperationMetadata> updateWorkstationOperationSettings;
        private final UnaryCallSettings.Builder<DeleteWorkstationRequest, Operation> deleteWorkstationSettings;
        private final OperationCallSettings.Builder<DeleteWorkstationRequest, Workstation, OperationMetadata> deleteWorkstationOperationSettings;
        private final UnaryCallSettings.Builder<StartWorkstationRequest, Operation> startWorkstationSettings;
        private final OperationCallSettings.Builder<StartWorkstationRequest, Workstation, OperationMetadata> startWorkstationOperationSettings;
        private final UnaryCallSettings.Builder<StopWorkstationRequest, Operation> stopWorkstationSettings;
        private final OperationCallSettings.Builder<StopWorkstationRequest, Workstation, OperationMetadata> stopWorkstationOperationSettings;
        private final UnaryCallSettings.Builder<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getWorkstationClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listWorkstationClustersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WORKSTATION_CLUSTERS_PAGE_STR_FACT);
            this.createWorkstationClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createWorkstationClusterOperationSettings = OperationCallSettings.newBuilder();
            this.updateWorkstationClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateWorkstationClusterOperationSettings = OperationCallSettings.newBuilder();
            this.deleteWorkstationClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteWorkstationClusterOperationSettings = OperationCallSettings.newBuilder();
            this.getWorkstationConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listWorkstationConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WORKSTATION_CONFIGS_PAGE_STR_FACT);
            this.listUsableWorkstationConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_USABLE_WORKSTATION_CONFIGS_PAGE_STR_FACT);
            this.createWorkstationConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createWorkstationConfigOperationSettings = OperationCallSettings.newBuilder();
            this.updateWorkstationConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateWorkstationConfigOperationSettings = OperationCallSettings.newBuilder();
            this.deleteWorkstationConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteWorkstationConfigOperationSettings = OperationCallSettings.newBuilder();
            this.getWorkstationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listWorkstationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WORKSTATIONS_PAGE_STR_FACT);
            this.listUsableWorkstationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_USABLE_WORKSTATIONS_PAGE_STR_FACT);
            this.createWorkstationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createWorkstationOperationSettings = OperationCallSettings.newBuilder();
            this.updateWorkstationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateWorkstationOperationSettings = OperationCallSettings.newBuilder();
            this.deleteWorkstationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteWorkstationOperationSettings = OperationCallSettings.newBuilder();
            this.startWorkstationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startWorkstationOperationSettings = OperationCallSettings.newBuilder();
            this.stopWorkstationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopWorkstationOperationSettings = OperationCallSettings.newBuilder();
            this.generateAccessTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getWorkstationClusterSettings, this.listWorkstationClustersSettings, this.createWorkstationClusterSettings, this.updateWorkstationClusterSettings, this.deleteWorkstationClusterSettings, this.getWorkstationConfigSettings, this.listWorkstationConfigsSettings, this.listUsableWorkstationConfigsSettings, this.createWorkstationConfigSettings, this.updateWorkstationConfigSettings, this.deleteWorkstationConfigSettings, this.getWorkstationSettings, (Object[])new UnaryCallSettings.Builder[]{this.listWorkstationsSettings, this.listUsableWorkstationsSettings, this.createWorkstationSettings, this.updateWorkstationSettings, this.deleteWorkstationSettings, this.startWorkstationSettings, this.stopWorkstationSettings, this.generateAccessTokenSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(WorkstationsStubSettings settings) {
            super((StubSettings)settings);
            this.getWorkstationClusterSettings = settings.getWorkstationClusterSettings.toBuilder();
            this.listWorkstationClustersSettings = settings.listWorkstationClustersSettings.toBuilder();
            this.createWorkstationClusterSettings = settings.createWorkstationClusterSettings.toBuilder();
            this.createWorkstationClusterOperationSettings = settings.createWorkstationClusterOperationSettings.toBuilder();
            this.updateWorkstationClusterSettings = settings.updateWorkstationClusterSettings.toBuilder();
            this.updateWorkstationClusterOperationSettings = settings.updateWorkstationClusterOperationSettings.toBuilder();
            this.deleteWorkstationClusterSettings = settings.deleteWorkstationClusterSettings.toBuilder();
            this.deleteWorkstationClusterOperationSettings = settings.deleteWorkstationClusterOperationSettings.toBuilder();
            this.getWorkstationConfigSettings = settings.getWorkstationConfigSettings.toBuilder();
            this.listWorkstationConfigsSettings = settings.listWorkstationConfigsSettings.toBuilder();
            this.listUsableWorkstationConfigsSettings = settings.listUsableWorkstationConfigsSettings.toBuilder();
            this.createWorkstationConfigSettings = settings.createWorkstationConfigSettings.toBuilder();
            this.createWorkstationConfigOperationSettings = settings.createWorkstationConfigOperationSettings.toBuilder();
            this.updateWorkstationConfigSettings = settings.updateWorkstationConfigSettings.toBuilder();
            this.updateWorkstationConfigOperationSettings = settings.updateWorkstationConfigOperationSettings.toBuilder();
            this.deleteWorkstationConfigSettings = settings.deleteWorkstationConfigSettings.toBuilder();
            this.deleteWorkstationConfigOperationSettings = settings.deleteWorkstationConfigOperationSettings.toBuilder();
            this.getWorkstationSettings = settings.getWorkstationSettings.toBuilder();
            this.listWorkstationsSettings = settings.listWorkstationsSettings.toBuilder();
            this.listUsableWorkstationsSettings = settings.listUsableWorkstationsSettings.toBuilder();
            this.createWorkstationSettings = settings.createWorkstationSettings.toBuilder();
            this.createWorkstationOperationSettings = settings.createWorkstationOperationSettings.toBuilder();
            this.updateWorkstationSettings = settings.updateWorkstationSettings.toBuilder();
            this.updateWorkstationOperationSettings = settings.updateWorkstationOperationSettings.toBuilder();
            this.deleteWorkstationSettings = settings.deleteWorkstationSettings.toBuilder();
            this.deleteWorkstationOperationSettings = settings.deleteWorkstationOperationSettings.toBuilder();
            this.startWorkstationSettings = settings.startWorkstationSettings.toBuilder();
            this.startWorkstationOperationSettings = settings.startWorkstationOperationSettings.toBuilder();
            this.stopWorkstationSettings = settings.stopWorkstationSettings.toBuilder();
            this.stopWorkstationOperationSettings = settings.stopWorkstationOperationSettings.toBuilder();
            this.generateAccessTokenSettings = settings.generateAccessTokenSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getWorkstationClusterSettings, this.listWorkstationClustersSettings, this.createWorkstationClusterSettings, this.updateWorkstationClusterSettings, this.deleteWorkstationClusterSettings, this.getWorkstationConfigSettings, this.listWorkstationConfigsSettings, this.listUsableWorkstationConfigsSettings, this.createWorkstationConfigSettings, this.updateWorkstationConfigSettings, this.deleteWorkstationConfigSettings, this.getWorkstationSettings, (Object[])new UnaryCallSettings.Builder[]{this.listWorkstationsSettings, this.listUsableWorkstationsSettings, this.createWorkstationSettings, this.updateWorkstationSettings, this.deleteWorkstationSettings, this.startWorkstationSettings, this.stopWorkstationSettings, this.generateAccessTokenSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(WorkstationsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)WorkstationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)WorkstationsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(WorkstationsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(WorkstationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)WorkstationsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)WorkstationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)WorkstationsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(WorkstationsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(WorkstationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getWorkstationClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listWorkstationClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createWorkstationClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateWorkstationClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteWorkstationClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getWorkstationConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listWorkstationConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listUsableWorkstationConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createWorkstationConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateWorkstationConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteWorkstationConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getWorkstationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listWorkstationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listUsableWorkstationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createWorkstationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateWorkstationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteWorkstationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startWorkstationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.stopWorkstationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.generateAccessTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createWorkstationClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(WorkstationCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateWorkstationClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(WorkstationCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteWorkstationClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(WorkstationCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createWorkstationConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(WorkstationConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateWorkstationConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(WorkstationConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteWorkstationConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(WorkstationConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createWorkstationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Workstation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateWorkstationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Workstation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteWorkstationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Workstation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.startWorkstationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Workstation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.stopWorkstationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Workstation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetWorkstationClusterRequest, WorkstationCluster> getWorkstationClusterSettings() {
            return this.getWorkstationClusterSettings;
        }

        public PagedCallSettings.Builder<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationsClient.ListWorkstationClustersPagedResponse> listWorkstationClustersSettings() {
            return this.listWorkstationClustersSettings;
        }

        public UnaryCallSettings.Builder<CreateWorkstationClusterRequest, Operation> createWorkstationClusterSettings() {
            return this.createWorkstationClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> createWorkstationClusterOperationSettings() {
            return this.createWorkstationClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateWorkstationClusterRequest, Operation> updateWorkstationClusterSettings() {
            return this.updateWorkstationClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> updateWorkstationClusterOperationSettings() {
            return this.updateWorkstationClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteWorkstationClusterRequest, Operation> deleteWorkstationClusterSettings() {
            return this.deleteWorkstationClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteWorkstationClusterRequest, WorkstationCluster, OperationMetadata> deleteWorkstationClusterOperationSettings() {
            return this.deleteWorkstationClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<GetWorkstationConfigRequest, WorkstationConfig> getWorkstationConfigSettings() {
            return this.getWorkstationConfigSettings;
        }

        public PagedCallSettings.Builder<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationsClient.ListWorkstationConfigsPagedResponse> listWorkstationConfigsSettings() {
            return this.listWorkstationConfigsSettings;
        }

        public PagedCallSettings.Builder<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationsClient.ListUsableWorkstationConfigsPagedResponse> listUsableWorkstationConfigsSettings() {
            return this.listUsableWorkstationConfigsSettings;
        }

        public UnaryCallSettings.Builder<CreateWorkstationConfigRequest, Operation> createWorkstationConfigSettings() {
            return this.createWorkstationConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> createWorkstationConfigOperationSettings() {
            return this.createWorkstationConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateWorkstationConfigRequest, Operation> updateWorkstationConfigSettings() {
            return this.updateWorkstationConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> updateWorkstationConfigOperationSettings() {
            return this.updateWorkstationConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteWorkstationConfigRequest, Operation> deleteWorkstationConfigSettings() {
            return this.deleteWorkstationConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteWorkstationConfigRequest, WorkstationConfig, OperationMetadata> deleteWorkstationConfigOperationSettings() {
            return this.deleteWorkstationConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<GetWorkstationRequest, Workstation> getWorkstationSettings() {
            return this.getWorkstationSettings;
        }

        public PagedCallSettings.Builder<ListWorkstationsRequest, ListWorkstationsResponse, WorkstationsClient.ListWorkstationsPagedResponse> listWorkstationsSettings() {
            return this.listWorkstationsSettings;
        }

        public PagedCallSettings.Builder<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, WorkstationsClient.ListUsableWorkstationsPagedResponse> listUsableWorkstationsSettings() {
            return this.listUsableWorkstationsSettings;
        }

        public UnaryCallSettings.Builder<CreateWorkstationRequest, Operation> createWorkstationSettings() {
            return this.createWorkstationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateWorkstationRequest, Workstation, OperationMetadata> createWorkstationOperationSettings() {
            return this.createWorkstationOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateWorkstationRequest, Operation> updateWorkstationSettings() {
            return this.updateWorkstationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateWorkstationRequest, Workstation, OperationMetadata> updateWorkstationOperationSettings() {
            return this.updateWorkstationOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteWorkstationRequest, Operation> deleteWorkstationSettings() {
            return this.deleteWorkstationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteWorkstationRequest, Workstation, OperationMetadata> deleteWorkstationOperationSettings() {
            return this.deleteWorkstationOperationSettings;
        }

        public UnaryCallSettings.Builder<StartWorkstationRequest, Operation> startWorkstationSettings() {
            return this.startWorkstationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StartWorkstationRequest, Workstation, OperationMetadata> startWorkstationOperationSettings() {
            return this.startWorkstationOperationSettings;
        }

        public UnaryCallSettings.Builder<StopWorkstationRequest, Operation> stopWorkstationSettings() {
            return this.stopWorkstationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StopWorkstationRequest, Workstation, OperationMetadata> stopWorkstationOperationSettings() {
            return this.stopWorkstationOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenSettings() {
            return this.generateAccessTokenSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public WorkstationsStubSettings build() throws IOException {
            return new WorkstationsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

