/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.events.subscriptions.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.apps.events.subscriptions.v1.CreateSubscriptionMetadata;
import com.google.apps.events.subscriptions.v1.CreateSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.DeleteSubscriptionMetadata;
import com.google.apps.events.subscriptions.v1.DeleteSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.GetSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.ListSubscriptionsRequest;
import com.google.apps.events.subscriptions.v1.ListSubscriptionsResponse;
import com.google.apps.events.subscriptions.v1.ReactivateSubscriptionMetadata;
import com.google.apps.events.subscriptions.v1.ReactivateSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.Subscription;
import com.google.apps.events.subscriptions.v1.SubscriptionName;
import com.google.apps.events.subscriptions.v1.SubscriptionsServiceSettings;
import com.google.apps.events.subscriptions.v1.UpdateSubscriptionMetadata;
import com.google.apps.events.subscriptions.v1.UpdateSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.stub.SubscriptionsServiceStub;
import com.google.apps.events.subscriptions.v1.stub.SubscriptionsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SubscriptionsServiceClient
implements BackgroundResource {
    private final SubscriptionsServiceSettings settings;
    private final SubscriptionsServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final SubscriptionsServiceClient create() throws IOException {
        return SubscriptionsServiceClient.create(SubscriptionsServiceSettings.newBuilder().build());
    }

    public static final SubscriptionsServiceClient create(SubscriptionsServiceSettings settings) throws IOException {
        return new SubscriptionsServiceClient(settings);
    }

    public static final SubscriptionsServiceClient create(SubscriptionsServiceStub stub) {
        return new SubscriptionsServiceClient(stub);
    }

    protected SubscriptionsServiceClient(SubscriptionsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SubscriptionsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SubscriptionsServiceClient(SubscriptionsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SubscriptionsServiceSettings getSettings() {
        return this.settings;
    }

    public SubscriptionsServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Subscription, CreateSubscriptionMetadata> createSubscriptionAsync(Subscription subscription) {
        CreateSubscriptionRequest request = CreateSubscriptionRequest.newBuilder().setSubscription(subscription).build();
        return this.createSubscriptionAsync(request);
    }

    public final OperationFuture<Subscription, CreateSubscriptionMetadata> createSubscriptionAsync(CreateSubscriptionRequest request) {
        return this.createSubscriptionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSubscriptionRequest, Subscription, CreateSubscriptionMetadata> createSubscriptionOperationCallable() {
        return this.stub.createSubscriptionOperationCallable();
    }

    public final UnaryCallable<CreateSubscriptionRequest, Operation> createSubscriptionCallable() {
        return this.stub.createSubscriptionCallable();
    }

    public final OperationFuture<Empty, DeleteSubscriptionMetadata> deleteSubscriptionAsync(SubscriptionName name) {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSubscriptionAsync(request);
    }

    public final OperationFuture<Empty, DeleteSubscriptionMetadata> deleteSubscriptionAsync(String name) {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setName(name).build();
        return this.deleteSubscriptionAsync(request);
    }

    public final OperationFuture<Empty, DeleteSubscriptionMetadata> deleteSubscriptionAsync(DeleteSubscriptionRequest request) {
        return this.deleteSubscriptionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSubscriptionRequest, Empty, DeleteSubscriptionMetadata> deleteSubscriptionOperationCallable() {
        return this.stub.deleteSubscriptionOperationCallable();
    }

    public final UnaryCallable<DeleteSubscriptionRequest, Operation> deleteSubscriptionCallable() {
        return this.stub.deleteSubscriptionCallable();
    }

    public final Subscription getSubscription(SubscriptionName name) {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSubscription(request);
    }

    public final Subscription getSubscription(String name) {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setName(name).build();
        return this.getSubscription(request);
    }

    public final Subscription getSubscription(GetSubscriptionRequest request) {
        return (Subscription)this.getSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable() {
        return this.stub.getSubscriptionCallable();
    }

    public final ListSubscriptionsPagedResponse listSubscriptions(String filter) {
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setFilter(filter).build();
        return this.listSubscriptions(request);
    }

    public final ListSubscriptionsPagedResponse listSubscriptions(ListSubscriptionsRequest request) {
        return (ListSubscriptionsPagedResponse)((Object)this.listSubscriptionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable() {
        return this.stub.listSubscriptionsPagedCallable();
    }

    public final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable() {
        return this.stub.listSubscriptionsCallable();
    }

    public final OperationFuture<Subscription, UpdateSubscriptionMetadata> updateSubscriptionAsync(Subscription subscription, FieldMask updateMask) {
        UpdateSubscriptionRequest request = UpdateSubscriptionRequest.newBuilder().setSubscription(subscription).setUpdateMask(updateMask).build();
        return this.updateSubscriptionAsync(request);
    }

    public final OperationFuture<Subscription, UpdateSubscriptionMetadata> updateSubscriptionAsync(UpdateSubscriptionRequest request) {
        return this.updateSubscriptionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSubscriptionRequest, Subscription, UpdateSubscriptionMetadata> updateSubscriptionOperationCallable() {
        return this.stub.updateSubscriptionOperationCallable();
    }

    public final UnaryCallable<UpdateSubscriptionRequest, Operation> updateSubscriptionCallable() {
        return this.stub.updateSubscriptionCallable();
    }

    public final OperationFuture<Subscription, ReactivateSubscriptionMetadata> reactivateSubscriptionAsync(SubscriptionName name) {
        ReactivateSubscriptionRequest request = ReactivateSubscriptionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.reactivateSubscriptionAsync(request);
    }

    public final OperationFuture<Subscription, ReactivateSubscriptionMetadata> reactivateSubscriptionAsync(String name) {
        ReactivateSubscriptionRequest request = ReactivateSubscriptionRequest.newBuilder().setName(name).build();
        return this.reactivateSubscriptionAsync(request);
    }

    public final OperationFuture<Subscription, ReactivateSubscriptionMetadata> reactivateSubscriptionAsync(ReactivateSubscriptionRequest request) {
        return this.reactivateSubscriptionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ReactivateSubscriptionRequest, Subscription, ReactivateSubscriptionMetadata> reactivateSubscriptionOperationCallable() {
        return this.stub.reactivateSubscriptionOperationCallable();
    }

    public final UnaryCallable<ReactivateSubscriptionRequest, Operation> reactivateSubscriptionCallable() {
        return this.stub.reactivateSubscriptionCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSubscriptionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription, ListSubscriptionsPage, ListSubscriptionsFixedSizeCollection> {
        private ListSubscriptionsFixedSizeCollection(List<ListSubscriptionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSubscriptionsFixedSizeCollection createEmptyCollection() {
            return new ListSubscriptionsFixedSizeCollection(null, 0);
        }

        protected ListSubscriptionsFixedSizeCollection createCollection(List<ListSubscriptionsPage> pages, int collectionSize) {
            return new ListSubscriptionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSubscriptionsPage
    extends AbstractPage<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription, ListSubscriptionsPage> {
        private ListSubscriptionsPage(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ListSubscriptionsResponse response) {
            super(context, (Object)response);
        }

        private static ListSubscriptionsPage createEmptyPage() {
            return new ListSubscriptionsPage(null, null);
        }

        protected ListSubscriptionsPage createPage(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ListSubscriptionsResponse response) {
            return new ListSubscriptionsPage(context, response);
        }

        public ApiFuture<ListSubscriptionsPage> createPageAsync(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSubscriptionsPagedResponse
    extends AbstractPagedListResponse<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription, ListSubscriptionsPage, ListSubscriptionsFixedSizeCollection> {
        public static ApiFuture<ListSubscriptionsPagedResponse> createAsync(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            ApiFuture<ListSubscriptionsPage> futurePage = ListSubscriptionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSubscriptionsPagedResponse((ListSubscriptionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSubscriptionsPagedResponse(ListSubscriptionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSubscriptionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

