/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.events.subscriptions.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.apps.events.subscriptions.v1.CreateSubscriptionMetadata;
import com.google.apps.events.subscriptions.v1.CreateSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.DeleteSubscriptionMetadata;
import com.google.apps.events.subscriptions.v1.DeleteSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.GetSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.ListSubscriptionsRequest;
import com.google.apps.events.subscriptions.v1.ListSubscriptionsResponse;
import com.google.apps.events.subscriptions.v1.ReactivateSubscriptionMetadata;
import com.google.apps.events.subscriptions.v1.ReactivateSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.Subscription;
import com.google.apps.events.subscriptions.v1.SubscriptionsServiceClient;
import com.google.apps.events.subscriptions.v1.UpdateSubscriptionMetadata;
import com.google.apps.events.subscriptions.v1.UpdateSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.stub.HttpJsonSubscriptionsServiceCallableFactory;
import com.google.apps.events.subscriptions.v1.stub.SubscriptionsServiceStub;
import com.google.apps.events.subscriptions.v1.stub.SubscriptionsServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonSubscriptionsServiceStub
extends SubscriptionsServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(Subscription.getDescriptor()).add(UpdateSubscriptionMetadata.getDescriptor()).add(CreateSubscriptionMetadata.getDescriptor()).add(DeleteSubscriptionMetadata.getDescriptor()).add(ReactivateSubscriptionMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateSubscriptionRequest, Operation> createSubscriptionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.apps.events.subscriptions.v1.SubscriptionsService/CreateSubscription").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/subscriptions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("subscription", (Message)request.getSubscription(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteSubscriptionRequest, Operation> deleteSubscriptionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.apps.events.subscriptions.v1.SubscriptionsService/DeleteSubscription").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=subscriptions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetSubscriptionRequest, Subscription> getSubscriptionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.apps.events.subscriptions.v1.SubscriptionsService/GetSubscription").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=subscriptions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Subscription.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.apps.events.subscriptions.v1.SubscriptionsService/ListSubscriptions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/subscriptions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSubscriptionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateSubscriptionRequest, Operation> updateSubscriptionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.apps.events.subscriptions.v1.SubscriptionsService/UpdateSubscription").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{subscription.name=subscriptions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "subscription.name", (Object)request.getSubscription().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("subscription", (Message)request.getSubscription(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ReactivateSubscriptionRequest, Operation> reactivateSubscriptionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.apps.events.subscriptions.v1.SubscriptionsService/ReactivateSubscription").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=subscriptions/*}:reactivate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<CreateSubscriptionRequest, Operation> createSubscriptionCallable;
    private final OperationCallable<CreateSubscriptionRequest, Subscription, CreateSubscriptionMetadata> createSubscriptionOperationCallable;
    private final UnaryCallable<DeleteSubscriptionRequest, Operation> deleteSubscriptionCallable;
    private final OperationCallable<DeleteSubscriptionRequest, Empty, DeleteSubscriptionMetadata> deleteSubscriptionOperationCallable;
    private final UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable;
    private final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable;
    private final UnaryCallable<ListSubscriptionsRequest, SubscriptionsServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable;
    private final UnaryCallable<UpdateSubscriptionRequest, Operation> updateSubscriptionCallable;
    private final OperationCallable<UpdateSubscriptionRequest, Subscription, UpdateSubscriptionMetadata> updateSubscriptionOperationCallable;
    private final UnaryCallable<ReactivateSubscriptionRequest, Operation> reactivateSubscriptionCallable;
    private final OperationCallable<ReactivateSubscriptionRequest, Subscription, ReactivateSubscriptionMetadata> reactivateSubscriptionOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSubscriptionsServiceStub create(SubscriptionsServiceStubSettings settings) throws IOException {
        return new HttpJsonSubscriptionsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSubscriptionsServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSubscriptionsServiceStub(SubscriptionsServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSubscriptionsServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSubscriptionsServiceStub(SubscriptionsServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSubscriptionsServiceStub(SubscriptionsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSubscriptionsServiceCallableFactory());
    }

    protected HttpJsonSubscriptionsServiceStub(SubscriptionsServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=operations/**}").build()).build());
        HttpJsonCallSettings createSubscriptionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSubscriptionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteSubscriptionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteSubscriptionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getSubscriptionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSubscriptionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listSubscriptionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSubscriptionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateSubscriptionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateSubscriptionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("subscription.name", String.valueOf(request.getSubscription().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings reactivateSubscriptionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(reactivateSubscriptionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createSubscriptionCallable = callableFactory.createUnaryCallable(createSubscriptionTransportSettings, settings.createSubscriptionSettings(), clientContext);
        this.createSubscriptionOperationCallable = callableFactory.createOperationCallable(createSubscriptionTransportSettings, settings.createSubscriptionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteSubscriptionCallable = callableFactory.createUnaryCallable(deleteSubscriptionTransportSettings, settings.deleteSubscriptionSettings(), clientContext);
        this.deleteSubscriptionOperationCallable = callableFactory.createOperationCallable(deleteSubscriptionTransportSettings, settings.deleteSubscriptionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getSubscriptionCallable = callableFactory.createUnaryCallable(getSubscriptionTransportSettings, settings.getSubscriptionSettings(), clientContext);
        this.listSubscriptionsCallable = callableFactory.createUnaryCallable(listSubscriptionsTransportSettings, settings.listSubscriptionsSettings(), clientContext);
        this.listSubscriptionsPagedCallable = callableFactory.createPagedCallable(listSubscriptionsTransportSettings, settings.listSubscriptionsSettings(), clientContext);
        this.updateSubscriptionCallable = callableFactory.createUnaryCallable(updateSubscriptionTransportSettings, settings.updateSubscriptionSettings(), clientContext);
        this.updateSubscriptionOperationCallable = callableFactory.createOperationCallable(updateSubscriptionTransportSettings, settings.updateSubscriptionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.reactivateSubscriptionCallable = callableFactory.createUnaryCallable(reactivateSubscriptionTransportSettings, settings.reactivateSubscriptionSettings(), clientContext);
        this.reactivateSubscriptionOperationCallable = callableFactory.createOperationCallable(reactivateSubscriptionTransportSettings, settings.reactivateSubscriptionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createSubscriptionMethodDescriptor);
        methodDescriptors.add(deleteSubscriptionMethodDescriptor);
        methodDescriptors.add(getSubscriptionMethodDescriptor);
        methodDescriptors.add(listSubscriptionsMethodDescriptor);
        methodDescriptors.add(updateSubscriptionMethodDescriptor);
        methodDescriptors.add(reactivateSubscriptionMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateSubscriptionRequest, Operation> createSubscriptionCallable() {
        return this.createSubscriptionCallable;
    }

    @Override
    public OperationCallable<CreateSubscriptionRequest, Subscription, CreateSubscriptionMetadata> createSubscriptionOperationCallable() {
        return this.createSubscriptionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteSubscriptionRequest, Operation> deleteSubscriptionCallable() {
        return this.deleteSubscriptionCallable;
    }

    @Override
    public OperationCallable<DeleteSubscriptionRequest, Empty, DeleteSubscriptionMetadata> deleteSubscriptionOperationCallable() {
        return this.deleteSubscriptionOperationCallable;
    }

    @Override
    public UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable() {
        return this.getSubscriptionCallable;
    }

    @Override
    public UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable() {
        return this.listSubscriptionsCallable;
    }

    @Override
    public UnaryCallable<ListSubscriptionsRequest, SubscriptionsServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable() {
        return this.listSubscriptionsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateSubscriptionRequest, Operation> updateSubscriptionCallable() {
        return this.updateSubscriptionCallable;
    }

    @Override
    public OperationCallable<UpdateSubscriptionRequest, Subscription, UpdateSubscriptionMetadata> updateSubscriptionOperationCallable() {
        return this.updateSubscriptionOperationCallable;
    }

    @Override
    public UnaryCallable<ReactivateSubscriptionRequest, Operation> reactivateSubscriptionCallable() {
        return this.reactivateSubscriptionCallable;
    }

    @Override
    public OperationCallable<ReactivateSubscriptionRequest, Subscription, ReactivateSubscriptionMetadata> reactivateSubscriptionOperationCallable() {
        return this.reactivateSubscriptionOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

