/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workflows.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.workflows.v1beta.CreateWorkflowRequest;
import com.google.cloud.workflows.v1beta.DeleteWorkflowRequest;
import com.google.cloud.workflows.v1beta.GetWorkflowRequest;
import com.google.cloud.workflows.v1beta.ListWorkflowsRequest;
import com.google.cloud.workflows.v1beta.ListWorkflowsResponse;
import com.google.cloud.workflows.v1beta.OperationMetadata;
import com.google.cloud.workflows.v1beta.UpdateWorkflowRequest;
import com.google.cloud.workflows.v1beta.Workflow;
import com.google.cloud.workflows.v1beta.WorkflowsClient;
import com.google.cloud.workflows.v1beta.stub.HttpJsonWorkflowsCallableFactory;
import com.google.cloud.workflows.v1beta.stub.WorkflowsStub;
import com.google.cloud.workflows.v1beta.stub.WorkflowsStubSettings;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonWorkflowsStub
extends WorkflowsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(OperationMetadata.getDescriptor()).add(Workflow.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListWorkflowsRequest, ListWorkflowsResponse> listWorkflowsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workflows.v1beta.Workflows/ListWorkflows").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*}/workflows", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListWorkflowsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetWorkflowRequest, Workflow> getWorkflowMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workflows.v1beta.Workflows/GetWorkflow").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/workflows/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Workflow.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateWorkflowRequest, Operation> createWorkflowMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workflows.v1beta.Workflows/CreateWorkflow").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*}/workflows", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "workflowId", (Object)request.getWorkflowId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("workflow", (Message)request.getWorkflow(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteWorkflowRequest, Operation> deleteWorkflowMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workflows.v1beta.Workflows/DeleteWorkflow").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/workflows/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateWorkflowRequest, Operation> updateWorkflowMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workflows.v1beta.Workflows/UpdateWorkflow").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{workflow.name=projects/*/locations/*/workflows/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "workflow.name", (Object)request.getWorkflow().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("workflow", (Message)request.getWorkflow(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ListWorkflowsRequest, ListWorkflowsResponse> listWorkflowsCallable;
    private final UnaryCallable<ListWorkflowsRequest, WorkflowsClient.ListWorkflowsPagedResponse> listWorkflowsPagedCallable;
    private final UnaryCallable<GetWorkflowRequest, Workflow> getWorkflowCallable;
    private final UnaryCallable<CreateWorkflowRequest, Operation> createWorkflowCallable;
    private final OperationCallable<CreateWorkflowRequest, Workflow, OperationMetadata> createWorkflowOperationCallable;
    private final UnaryCallable<DeleteWorkflowRequest, Operation> deleteWorkflowCallable;
    private final OperationCallable<DeleteWorkflowRequest, Empty, OperationMetadata> deleteWorkflowOperationCallable;
    private final UnaryCallable<UpdateWorkflowRequest, Operation> updateWorkflowCallable;
    private final OperationCallable<UpdateWorkflowRequest, Workflow, OperationMetadata> updateWorkflowOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonWorkflowsStub create(WorkflowsStubSettings settings) throws IOException {
        return new HttpJsonWorkflowsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonWorkflowsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonWorkflowsStub(WorkflowsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonWorkflowsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonWorkflowsStub(WorkflowsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonWorkflowsStub(WorkflowsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonWorkflowsCallableFactory());
    }

    protected HttpJsonWorkflowsStub(WorkflowsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings listWorkflowsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listWorkflowsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getWorkflowTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getWorkflowMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createWorkflowTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createWorkflowMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteWorkflowTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteWorkflowMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateWorkflowTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateWorkflowMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listWorkflowsCallable = callableFactory.createUnaryCallable(listWorkflowsTransportSettings, settings.listWorkflowsSettings(), clientContext);
        this.listWorkflowsPagedCallable = callableFactory.createPagedCallable(listWorkflowsTransportSettings, settings.listWorkflowsSettings(), clientContext);
        this.getWorkflowCallable = callableFactory.createUnaryCallable(getWorkflowTransportSettings, settings.getWorkflowSettings(), clientContext);
        this.createWorkflowCallable = callableFactory.createUnaryCallable(createWorkflowTransportSettings, settings.createWorkflowSettings(), clientContext);
        this.createWorkflowOperationCallable = callableFactory.createOperationCallable(createWorkflowTransportSettings, settings.createWorkflowOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteWorkflowCallable = callableFactory.createUnaryCallable(deleteWorkflowTransportSettings, settings.deleteWorkflowSettings(), clientContext);
        this.deleteWorkflowOperationCallable = callableFactory.createOperationCallable(deleteWorkflowTransportSettings, settings.deleteWorkflowOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateWorkflowCallable = callableFactory.createUnaryCallable(updateWorkflowTransportSettings, settings.updateWorkflowSettings(), clientContext);
        this.updateWorkflowOperationCallable = callableFactory.createOperationCallable(updateWorkflowTransportSettings, settings.updateWorkflowOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listWorkflowsMethodDescriptor);
        methodDescriptors.add(getWorkflowMethodDescriptor);
        methodDescriptors.add(createWorkflowMethodDescriptor);
        methodDescriptors.add(deleteWorkflowMethodDescriptor);
        methodDescriptors.add(updateWorkflowMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListWorkflowsRequest, ListWorkflowsResponse> listWorkflowsCallable() {
        return this.listWorkflowsCallable;
    }

    @Override
    public UnaryCallable<ListWorkflowsRequest, WorkflowsClient.ListWorkflowsPagedResponse> listWorkflowsPagedCallable() {
        return this.listWorkflowsPagedCallable;
    }

    @Override
    public UnaryCallable<GetWorkflowRequest, Workflow> getWorkflowCallable() {
        return this.getWorkflowCallable;
    }

    @Override
    public UnaryCallable<CreateWorkflowRequest, Operation> createWorkflowCallable() {
        return this.createWorkflowCallable;
    }

    @Override
    public OperationCallable<CreateWorkflowRequest, Workflow, OperationMetadata> createWorkflowOperationCallable() {
        return this.createWorkflowOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteWorkflowRequest, Operation> deleteWorkflowCallable() {
        return this.deleteWorkflowCallable;
    }

    @Override
    public OperationCallable<DeleteWorkflowRequest, Empty, OperationMetadata> deleteWorkflowOperationCallable() {
        return this.deleteWorkflowOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateWorkflowRequest, Operation> updateWorkflowCallable() {
        return this.updateWorkflowCallable;
    }

    @Override
    public OperationCallable<UpdateWorkflowRequest, Workflow, OperationMetadata> updateWorkflowOperationCallable() {
        return this.updateWorkflowOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

