/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.websecurityscanner.v1alpha;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.websecurityscanner.v1alpha.CrawledUrl;
import com.google.cloud.websecurityscanner.v1alpha.CreateScanConfigRequest;
import com.google.cloud.websecurityscanner.v1alpha.DeleteScanConfigRequest;
import com.google.cloud.websecurityscanner.v1alpha.Finding;
import com.google.cloud.websecurityscanner.v1alpha.FindingName;
import com.google.cloud.websecurityscanner.v1alpha.GetFindingRequest;
import com.google.cloud.websecurityscanner.v1alpha.GetScanConfigRequest;
import com.google.cloud.websecurityscanner.v1alpha.GetScanRunRequest;
import com.google.cloud.websecurityscanner.v1alpha.ListCrawledUrlsRequest;
import com.google.cloud.websecurityscanner.v1alpha.ListCrawledUrlsResponse;
import com.google.cloud.websecurityscanner.v1alpha.ListFindingTypeStatsRequest;
import com.google.cloud.websecurityscanner.v1alpha.ListFindingTypeStatsResponse;
import com.google.cloud.websecurityscanner.v1alpha.ListFindingsRequest;
import com.google.cloud.websecurityscanner.v1alpha.ListFindingsResponse;
import com.google.cloud.websecurityscanner.v1alpha.ListScanConfigsRequest;
import com.google.cloud.websecurityscanner.v1alpha.ListScanConfigsResponse;
import com.google.cloud.websecurityscanner.v1alpha.ListScanRunsRequest;
import com.google.cloud.websecurityscanner.v1alpha.ListScanRunsResponse;
import com.google.cloud.websecurityscanner.v1alpha.ProjectName;
import com.google.cloud.websecurityscanner.v1alpha.ScanConfig;
import com.google.cloud.websecurityscanner.v1alpha.ScanConfigName;
import com.google.cloud.websecurityscanner.v1alpha.ScanRun;
import com.google.cloud.websecurityscanner.v1alpha.ScanRunName;
import com.google.cloud.websecurityscanner.v1alpha.StartScanRunRequest;
import com.google.cloud.websecurityscanner.v1alpha.StopScanRunRequest;
import com.google.cloud.websecurityscanner.v1alpha.UpdateScanConfigRequest;
import com.google.cloud.websecurityscanner.v1alpha.WebSecurityScannerSettings;
import com.google.cloud.websecurityscanner.v1alpha.stub.WebSecurityScannerStub;
import com.google.cloud.websecurityscanner.v1alpha.stub.WebSecurityScannerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class WebSecurityScannerClient
implements BackgroundResource {
    private final WebSecurityScannerSettings settings;
    private final WebSecurityScannerStub stub;

    public static final WebSecurityScannerClient create() throws IOException {
        return WebSecurityScannerClient.create(WebSecurityScannerSettings.newBuilder().build());
    }

    public static final WebSecurityScannerClient create(WebSecurityScannerSettings settings) throws IOException {
        return new WebSecurityScannerClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final WebSecurityScannerClient create(WebSecurityScannerStub stub) {
        return new WebSecurityScannerClient(stub);
    }

    protected WebSecurityScannerClient(WebSecurityScannerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((WebSecurityScannerStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected WebSecurityScannerClient(WebSecurityScannerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final WebSecurityScannerSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public WebSecurityScannerStub getStub() {
        return this.stub;
    }

    public final void deleteScanConfig(ScanConfigName name) {
        DeleteScanConfigRequest request = DeleteScanConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteScanConfig(request);
    }

    public final void deleteScanConfig(String name) {
        DeleteScanConfigRequest request = DeleteScanConfigRequest.newBuilder().setName(name).build();
        this.deleteScanConfig(request);
    }

    public final void deleteScanConfig(DeleteScanConfigRequest request) {
        this.deleteScanConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteScanConfigRequest, Empty> deleteScanConfigCallable() {
        return this.stub.deleteScanConfigCallable();
    }

    public final ScanConfig createScanConfig(ProjectName parent, ScanConfig scanConfig) {
        CreateScanConfigRequest request = CreateScanConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setScanConfig(scanConfig).build();
        return this.createScanConfig(request);
    }

    public final ScanConfig createScanConfig(String parent, ScanConfig scanConfig) {
        CreateScanConfigRequest request = CreateScanConfigRequest.newBuilder().setParent(parent).setScanConfig(scanConfig).build();
        return this.createScanConfig(request);
    }

    public final ScanConfig createScanConfig(CreateScanConfigRequest request) {
        return (ScanConfig)this.createScanConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateScanConfigRequest, ScanConfig> createScanConfigCallable() {
        return this.stub.createScanConfigCallable();
    }

    public final ScanConfig getScanConfig(ScanConfigName name) {
        GetScanConfigRequest request = GetScanConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getScanConfig(request);
    }

    public final ScanConfig getScanConfig(String name) {
        GetScanConfigRequest request = GetScanConfigRequest.newBuilder().setName(name).build();
        return this.getScanConfig(request);
    }

    public final ScanConfig getScanConfig(GetScanConfigRequest request) {
        return (ScanConfig)this.getScanConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetScanConfigRequest, ScanConfig> getScanConfigCallable() {
        return this.stub.getScanConfigCallable();
    }

    public final ListScanConfigsPagedResponse listScanConfigs(ProjectName parent) {
        ListScanConfigsRequest request = ListScanConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listScanConfigs(request);
    }

    public final ListScanConfigsPagedResponse listScanConfigs(String parent) {
        ListScanConfigsRequest request = ListScanConfigsRequest.newBuilder().setParent(parent).build();
        return this.listScanConfigs(request);
    }

    public final ListScanConfigsPagedResponse listScanConfigs(ListScanConfigsRequest request) {
        return (ListScanConfigsPagedResponse)((Object)this.listScanConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListScanConfigsRequest, ListScanConfigsPagedResponse> listScanConfigsPagedCallable() {
        return this.stub.listScanConfigsPagedCallable();
    }

    public final UnaryCallable<ListScanConfigsRequest, ListScanConfigsResponse> listScanConfigsCallable() {
        return this.stub.listScanConfigsCallable();
    }

    public final ScanConfig updateScanConfig(ScanConfig scanConfig, FieldMask updateMask) {
        UpdateScanConfigRequest request = UpdateScanConfigRequest.newBuilder().setScanConfig(scanConfig).setUpdateMask(updateMask).build();
        return this.updateScanConfig(request);
    }

    public final ScanConfig updateScanConfig(UpdateScanConfigRequest request) {
        return (ScanConfig)this.updateScanConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateScanConfigRequest, ScanConfig> updateScanConfigCallable() {
        return this.stub.updateScanConfigCallable();
    }

    public final ScanRun startScanRun(ScanConfigName name) {
        StartScanRunRequest request = StartScanRunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.startScanRun(request);
    }

    public final ScanRun startScanRun(String name) {
        StartScanRunRequest request = StartScanRunRequest.newBuilder().setName(name).build();
        return this.startScanRun(request);
    }

    public final ScanRun startScanRun(StartScanRunRequest request) {
        return (ScanRun)this.startScanRunCallable().call((Object)request);
    }

    public final UnaryCallable<StartScanRunRequest, ScanRun> startScanRunCallable() {
        return this.stub.startScanRunCallable();
    }

    public final ScanRun getScanRun(ScanRunName name) {
        GetScanRunRequest request = GetScanRunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getScanRun(request);
    }

    public final ScanRun getScanRun(String name) {
        GetScanRunRequest request = GetScanRunRequest.newBuilder().setName(name).build();
        return this.getScanRun(request);
    }

    public final ScanRun getScanRun(GetScanRunRequest request) {
        return (ScanRun)this.getScanRunCallable().call((Object)request);
    }

    public final UnaryCallable<GetScanRunRequest, ScanRun> getScanRunCallable() {
        return this.stub.getScanRunCallable();
    }

    public final ListScanRunsPagedResponse listScanRuns(ScanConfigName parent) {
        ListScanRunsRequest request = ListScanRunsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listScanRuns(request);
    }

    public final ListScanRunsPagedResponse listScanRuns(String parent) {
        ListScanRunsRequest request = ListScanRunsRequest.newBuilder().setParent(parent).build();
        return this.listScanRuns(request);
    }

    public final ListScanRunsPagedResponse listScanRuns(ListScanRunsRequest request) {
        return (ListScanRunsPagedResponse)((Object)this.listScanRunsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListScanRunsRequest, ListScanRunsPagedResponse> listScanRunsPagedCallable() {
        return this.stub.listScanRunsPagedCallable();
    }

    public final UnaryCallable<ListScanRunsRequest, ListScanRunsResponse> listScanRunsCallable() {
        return this.stub.listScanRunsCallable();
    }

    public final ScanRun stopScanRun(ScanRunName name) {
        StopScanRunRequest request = StopScanRunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.stopScanRun(request);
    }

    public final ScanRun stopScanRun(String name) {
        StopScanRunRequest request = StopScanRunRequest.newBuilder().setName(name).build();
        return this.stopScanRun(request);
    }

    public final ScanRun stopScanRun(StopScanRunRequest request) {
        return (ScanRun)this.stopScanRunCallable().call((Object)request);
    }

    public final UnaryCallable<StopScanRunRequest, ScanRun> stopScanRunCallable() {
        return this.stub.stopScanRunCallable();
    }

    public final ListCrawledUrlsPagedResponse listCrawledUrls(ScanRunName parent) {
        ListCrawledUrlsRequest request = ListCrawledUrlsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCrawledUrls(request);
    }

    public final ListCrawledUrlsPagedResponse listCrawledUrls(String parent) {
        ListCrawledUrlsRequest request = ListCrawledUrlsRequest.newBuilder().setParent(parent).build();
        return this.listCrawledUrls(request);
    }

    public final ListCrawledUrlsPagedResponse listCrawledUrls(ListCrawledUrlsRequest request) {
        return (ListCrawledUrlsPagedResponse)((Object)this.listCrawledUrlsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCrawledUrlsRequest, ListCrawledUrlsPagedResponse> listCrawledUrlsPagedCallable() {
        return this.stub.listCrawledUrlsPagedCallable();
    }

    public final UnaryCallable<ListCrawledUrlsRequest, ListCrawledUrlsResponse> listCrawledUrlsCallable() {
        return this.stub.listCrawledUrlsCallable();
    }

    public final Finding getFinding(FindingName name) {
        GetFindingRequest request = GetFindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFinding(request);
    }

    public final Finding getFinding(String name) {
        GetFindingRequest request = GetFindingRequest.newBuilder().setName(name).build();
        return this.getFinding(request);
    }

    public final Finding getFinding(GetFindingRequest request) {
        return (Finding)this.getFindingCallable().call((Object)request);
    }

    public final UnaryCallable<GetFindingRequest, Finding> getFindingCallable() {
        return this.stub.getFindingCallable();
    }

    public final ListFindingsPagedResponse listFindings(ScanRunName parent, String filter) {
        ListFindingsRequest request = ListFindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.listFindings(request);
    }

    public final ListFindingsPagedResponse listFindings(String parent, String filter) {
        ListFindingsRequest request = ListFindingsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listFindings(request);
    }

    public final ListFindingsPagedResponse listFindings(ListFindingsRequest request) {
        return (ListFindingsPagedResponse)((Object)this.listFindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFindingsRequest, ListFindingsPagedResponse> listFindingsPagedCallable() {
        return this.stub.listFindingsPagedCallable();
    }

    public final UnaryCallable<ListFindingsRequest, ListFindingsResponse> listFindingsCallable() {
        return this.stub.listFindingsCallable();
    }

    public final ListFindingTypeStatsResponse listFindingTypeStats(ScanRunName parent) {
        ListFindingTypeStatsRequest request = ListFindingTypeStatsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFindingTypeStats(request);
    }

    public final ListFindingTypeStatsResponse listFindingTypeStats(String parent) {
        ListFindingTypeStatsRequest request = ListFindingTypeStatsRequest.newBuilder().setParent(parent).build();
        return this.listFindingTypeStats(request);
    }

    public final ListFindingTypeStatsResponse listFindingTypeStats(ListFindingTypeStatsRequest request) {
        return (ListFindingTypeStatsResponse)this.listFindingTypeStatsCallable().call((Object)request);
    }

    public final UnaryCallable<ListFindingTypeStatsRequest, ListFindingTypeStatsResponse> listFindingTypeStatsCallable() {
        return this.stub.listFindingTypeStatsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFindingsRequest, ListFindingsResponse, Finding, ListFindingsPage, ListFindingsFixedSizeCollection> {
        private ListFindingsFixedSizeCollection(List<ListFindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFindingsFixedSizeCollection createEmptyCollection() {
            return new ListFindingsFixedSizeCollection(null, 0);
        }

        protected ListFindingsFixedSizeCollection createCollection(List<ListFindingsPage> pages, int collectionSize) {
            return new ListFindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFindingsPage
    extends AbstractPage<ListFindingsRequest, ListFindingsResponse, Finding, ListFindingsPage> {
        private ListFindingsPage(PageContext<ListFindingsRequest, ListFindingsResponse, Finding> context, ListFindingsResponse response) {
            super(context, (Object)response);
        }

        private static ListFindingsPage createEmptyPage() {
            return new ListFindingsPage(null, null);
        }

        protected ListFindingsPage createPage(PageContext<ListFindingsRequest, ListFindingsResponse, Finding> context, ListFindingsResponse response) {
            return new ListFindingsPage(context, response);
        }

        public ApiFuture<ListFindingsPage> createPageAsync(PageContext<ListFindingsRequest, ListFindingsResponse, Finding> context, ApiFuture<ListFindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFindingsPagedResponse
    extends AbstractPagedListResponse<ListFindingsRequest, ListFindingsResponse, Finding, ListFindingsPage, ListFindingsFixedSizeCollection> {
        public static ApiFuture<ListFindingsPagedResponse> createAsync(PageContext<ListFindingsRequest, ListFindingsResponse, Finding> context, ApiFuture<ListFindingsResponse> futureResponse) {
            ApiFuture<ListFindingsPage> futurePage = ListFindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListFindingsPage, ListFindingsPagedResponse>(){

                public ListFindingsPagedResponse apply(ListFindingsPage input) {
                    return new ListFindingsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListFindingsPagedResponse(ListFindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFindingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCrawledUrlsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCrawledUrlsRequest, ListCrawledUrlsResponse, CrawledUrl, ListCrawledUrlsPage, ListCrawledUrlsFixedSizeCollection> {
        private ListCrawledUrlsFixedSizeCollection(List<ListCrawledUrlsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCrawledUrlsFixedSizeCollection createEmptyCollection() {
            return new ListCrawledUrlsFixedSizeCollection(null, 0);
        }

        protected ListCrawledUrlsFixedSizeCollection createCollection(List<ListCrawledUrlsPage> pages, int collectionSize) {
            return new ListCrawledUrlsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCrawledUrlsPage
    extends AbstractPage<ListCrawledUrlsRequest, ListCrawledUrlsResponse, CrawledUrl, ListCrawledUrlsPage> {
        private ListCrawledUrlsPage(PageContext<ListCrawledUrlsRequest, ListCrawledUrlsResponse, CrawledUrl> context, ListCrawledUrlsResponse response) {
            super(context, (Object)response);
        }

        private static ListCrawledUrlsPage createEmptyPage() {
            return new ListCrawledUrlsPage(null, null);
        }

        protected ListCrawledUrlsPage createPage(PageContext<ListCrawledUrlsRequest, ListCrawledUrlsResponse, CrawledUrl> context, ListCrawledUrlsResponse response) {
            return new ListCrawledUrlsPage(context, response);
        }

        public ApiFuture<ListCrawledUrlsPage> createPageAsync(PageContext<ListCrawledUrlsRequest, ListCrawledUrlsResponse, CrawledUrl> context, ApiFuture<ListCrawledUrlsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCrawledUrlsPagedResponse
    extends AbstractPagedListResponse<ListCrawledUrlsRequest, ListCrawledUrlsResponse, CrawledUrl, ListCrawledUrlsPage, ListCrawledUrlsFixedSizeCollection> {
        public static ApiFuture<ListCrawledUrlsPagedResponse> createAsync(PageContext<ListCrawledUrlsRequest, ListCrawledUrlsResponse, CrawledUrl> context, ApiFuture<ListCrawledUrlsResponse> futureResponse) {
            ApiFuture<ListCrawledUrlsPage> futurePage = ListCrawledUrlsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListCrawledUrlsPage, ListCrawledUrlsPagedResponse>(){

                public ListCrawledUrlsPagedResponse apply(ListCrawledUrlsPage input) {
                    return new ListCrawledUrlsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListCrawledUrlsPagedResponse(ListCrawledUrlsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCrawledUrlsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListScanRunsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListScanRunsRequest, ListScanRunsResponse, ScanRun, ListScanRunsPage, ListScanRunsFixedSizeCollection> {
        private ListScanRunsFixedSizeCollection(List<ListScanRunsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListScanRunsFixedSizeCollection createEmptyCollection() {
            return new ListScanRunsFixedSizeCollection(null, 0);
        }

        protected ListScanRunsFixedSizeCollection createCollection(List<ListScanRunsPage> pages, int collectionSize) {
            return new ListScanRunsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListScanRunsPage
    extends AbstractPage<ListScanRunsRequest, ListScanRunsResponse, ScanRun, ListScanRunsPage> {
        private ListScanRunsPage(PageContext<ListScanRunsRequest, ListScanRunsResponse, ScanRun> context, ListScanRunsResponse response) {
            super(context, (Object)response);
        }

        private static ListScanRunsPage createEmptyPage() {
            return new ListScanRunsPage(null, null);
        }

        protected ListScanRunsPage createPage(PageContext<ListScanRunsRequest, ListScanRunsResponse, ScanRun> context, ListScanRunsResponse response) {
            return new ListScanRunsPage(context, response);
        }

        public ApiFuture<ListScanRunsPage> createPageAsync(PageContext<ListScanRunsRequest, ListScanRunsResponse, ScanRun> context, ApiFuture<ListScanRunsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListScanRunsPagedResponse
    extends AbstractPagedListResponse<ListScanRunsRequest, ListScanRunsResponse, ScanRun, ListScanRunsPage, ListScanRunsFixedSizeCollection> {
        public static ApiFuture<ListScanRunsPagedResponse> createAsync(PageContext<ListScanRunsRequest, ListScanRunsResponse, ScanRun> context, ApiFuture<ListScanRunsResponse> futureResponse) {
            ApiFuture<ListScanRunsPage> futurePage = ListScanRunsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListScanRunsPage, ListScanRunsPagedResponse>(){

                public ListScanRunsPagedResponse apply(ListScanRunsPage input) {
                    return new ListScanRunsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListScanRunsPagedResponse(ListScanRunsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListScanRunsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListScanConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig, ListScanConfigsPage, ListScanConfigsFixedSizeCollection> {
        private ListScanConfigsFixedSizeCollection(List<ListScanConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListScanConfigsFixedSizeCollection createEmptyCollection() {
            return new ListScanConfigsFixedSizeCollection(null, 0);
        }

        protected ListScanConfigsFixedSizeCollection createCollection(List<ListScanConfigsPage> pages, int collectionSize) {
            return new ListScanConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListScanConfigsPage
    extends AbstractPage<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig, ListScanConfigsPage> {
        private ListScanConfigsPage(PageContext<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig> context, ListScanConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListScanConfigsPage createEmptyPage() {
            return new ListScanConfigsPage(null, null);
        }

        protected ListScanConfigsPage createPage(PageContext<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig> context, ListScanConfigsResponse response) {
            return new ListScanConfigsPage(context, response);
        }

        public ApiFuture<ListScanConfigsPage> createPageAsync(PageContext<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig> context, ApiFuture<ListScanConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListScanConfigsPagedResponse
    extends AbstractPagedListResponse<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig, ListScanConfigsPage, ListScanConfigsFixedSizeCollection> {
        public static ApiFuture<ListScanConfigsPagedResponse> createAsync(PageContext<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig> context, ApiFuture<ListScanConfigsResponse> futureResponse) {
            ApiFuture<ListScanConfigsPage> futurePage = ListScanConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListScanConfigsPage, ListScanConfigsPagedResponse>(){

                public ListScanConfigsPagedResponse apply(ListScanConfigsPage input) {
                    return new ListScanConfigsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListScanConfigsPagedResponse(ListScanConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListScanConfigsFixedSizeCollection.createEmptyCollection());
        }
    }
}

