/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.webrisk.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.webrisk.v1.stub.GrpcWebRiskServiceCallableFactory;
import com.google.cloud.webrisk.v1.stub.WebRiskServiceStub;
import com.google.cloud.webrisk.v1.stub.WebRiskServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import com.google.webrisk.v1.ComputeThreatListDiffRequest;
import com.google.webrisk.v1.ComputeThreatListDiffResponse;
import com.google.webrisk.v1.CreateSubmissionRequest;
import com.google.webrisk.v1.SearchHashesRequest;
import com.google.webrisk.v1.SearchHashesResponse;
import com.google.webrisk.v1.SearchUrisRequest;
import com.google.webrisk.v1.SearchUrisResponse;
import com.google.webrisk.v1.Submission;
import com.google.webrisk.v1.SubmitUriMetadata;
import com.google.webrisk.v1.SubmitUriRequest;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcWebRiskServiceStub
extends WebRiskServiceStub {
    private static final MethodDescriptor<ComputeThreatListDiffRequest, ComputeThreatListDiffResponse> computeThreatListDiffMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.webrisk.v1.WebRiskService/ComputeThreatListDiff").setRequestMarshaller(ProtoUtils.marshaller((Message)ComputeThreatListDiffRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ComputeThreatListDiffResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SearchUrisRequest, SearchUrisResponse> searchUrisMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.webrisk.v1.WebRiskService/SearchUris").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchUrisRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchUrisResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SearchHashesRequest, SearchHashesResponse> searchHashesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.webrisk.v1.WebRiskService/SearchHashes").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchHashesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchHashesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateSubmissionRequest, Submission> createSubmissionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.webrisk.v1.WebRiskService/CreateSubmission").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSubmissionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Submission.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SubmitUriRequest, Operation> submitUriMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.webrisk.v1.WebRiskService/SubmitUri").setRequestMarshaller(ProtoUtils.marshaller((Message)SubmitUriRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ComputeThreatListDiffRequest, ComputeThreatListDiffResponse> computeThreatListDiffCallable;
    private final UnaryCallable<SearchUrisRequest, SearchUrisResponse> searchUrisCallable;
    private final UnaryCallable<SearchHashesRequest, SearchHashesResponse> searchHashesCallable;
    private final UnaryCallable<CreateSubmissionRequest, Submission> createSubmissionCallable;
    private final UnaryCallable<SubmitUriRequest, Operation> submitUriCallable;
    private final OperationCallable<SubmitUriRequest, Submission, SubmitUriMetadata> submitUriOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcWebRiskServiceStub create(WebRiskServiceStubSettings settings) throws IOException {
        return new GrpcWebRiskServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcWebRiskServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcWebRiskServiceStub(WebRiskServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcWebRiskServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcWebRiskServiceStub(WebRiskServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcWebRiskServiceStub(WebRiskServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcWebRiskServiceCallableFactory());
    }

    protected GrpcWebRiskServiceStub(WebRiskServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings computeThreatListDiffTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(computeThreatListDiffMethodDescriptor).build();
        GrpcCallSettings searchUrisTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchUrisMethodDescriptor).build();
        GrpcCallSettings searchHashesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchHashesMethodDescriptor).build();
        GrpcCallSettings createSubmissionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSubmissionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings submitUriTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(submitUriMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.computeThreatListDiffCallable = callableFactory.createUnaryCallable(computeThreatListDiffTransportSettings, settings.computeThreatListDiffSettings(), clientContext);
        this.searchUrisCallable = callableFactory.createUnaryCallable(searchUrisTransportSettings, settings.searchUrisSettings(), clientContext);
        this.searchHashesCallable = callableFactory.createUnaryCallable(searchHashesTransportSettings, settings.searchHashesSettings(), clientContext);
        this.createSubmissionCallable = callableFactory.createUnaryCallable(createSubmissionTransportSettings, settings.createSubmissionSettings(), clientContext);
        this.submitUriCallable = callableFactory.createUnaryCallable(submitUriTransportSettings, settings.submitUriSettings(), clientContext);
        this.submitUriOperationCallable = callableFactory.createOperationCallable(submitUriTransportSettings, settings.submitUriOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ComputeThreatListDiffRequest, ComputeThreatListDiffResponse> computeThreatListDiffCallable() {
        return this.computeThreatListDiffCallable;
    }

    @Override
    public UnaryCallable<SearchUrisRequest, SearchUrisResponse> searchUrisCallable() {
        return this.searchUrisCallable;
    }

    @Override
    public UnaryCallable<SearchHashesRequest, SearchHashesResponse> searchHashesCallable() {
        return this.searchHashesCallable;
    }

    @Override
    public UnaryCallable<CreateSubmissionRequest, Submission> createSubmissionCallable() {
        return this.createSubmissionCallable;
    }

    @Override
    public UnaryCallable<SubmitUriRequest, Operation> submitUriCallable() {
        return this.submitUriCallable;
    }

    @Override
    public OperationCallable<SubmitUriRequest, Submission, SubmitUriMetadata> submitUriOperationCallable() {
        return this.submitUriOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

