/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.visionai.v1.Channel;
import com.google.cloud.visionai.v1.Cluster;
import com.google.cloud.visionai.v1.ClusterName;
import com.google.cloud.visionai.v1.CreateClusterRequest;
import com.google.cloud.visionai.v1.CreateEventRequest;
import com.google.cloud.visionai.v1.CreateSeriesRequest;
import com.google.cloud.visionai.v1.CreateStreamRequest;
import com.google.cloud.visionai.v1.DeleteClusterRequest;
import com.google.cloud.visionai.v1.DeleteEventRequest;
import com.google.cloud.visionai.v1.DeleteSeriesRequest;
import com.google.cloud.visionai.v1.DeleteStreamRequest;
import com.google.cloud.visionai.v1.Event;
import com.google.cloud.visionai.v1.EventName;
import com.google.cloud.visionai.v1.GenerateStreamHlsTokenRequest;
import com.google.cloud.visionai.v1.GenerateStreamHlsTokenResponse;
import com.google.cloud.visionai.v1.GetClusterRequest;
import com.google.cloud.visionai.v1.GetEventRequest;
import com.google.cloud.visionai.v1.GetSeriesRequest;
import com.google.cloud.visionai.v1.GetStreamRequest;
import com.google.cloud.visionai.v1.GetStreamThumbnailRequest;
import com.google.cloud.visionai.v1.GetStreamThumbnailResponse;
import com.google.cloud.visionai.v1.ListClustersRequest;
import com.google.cloud.visionai.v1.ListClustersResponse;
import com.google.cloud.visionai.v1.ListEventsRequest;
import com.google.cloud.visionai.v1.ListEventsResponse;
import com.google.cloud.visionai.v1.ListSeriesRequest;
import com.google.cloud.visionai.v1.ListSeriesResponse;
import com.google.cloud.visionai.v1.ListStreamsRequest;
import com.google.cloud.visionai.v1.ListStreamsResponse;
import com.google.cloud.visionai.v1.LocationName;
import com.google.cloud.visionai.v1.MaterializeChannelRequest;
import com.google.cloud.visionai.v1.OperationMetadata;
import com.google.cloud.visionai.v1.Series;
import com.google.cloud.visionai.v1.SeriesName;
import com.google.cloud.visionai.v1.Stream;
import com.google.cloud.visionai.v1.StreamName;
import com.google.cloud.visionai.v1.StreamsServiceSettings;
import com.google.cloud.visionai.v1.UpdateClusterRequest;
import com.google.cloud.visionai.v1.UpdateEventRequest;
import com.google.cloud.visionai.v1.UpdateSeriesRequest;
import com.google.cloud.visionai.v1.UpdateStreamRequest;
import com.google.cloud.visionai.v1.stub.StreamsServiceStub;
import com.google.cloud.visionai.v1.stub.StreamsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class StreamsServiceClient
implements BackgroundResource {
    private final StreamsServiceSettings settings;
    private final StreamsServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final StreamsServiceClient create() throws IOException {
        return StreamsServiceClient.create(StreamsServiceSettings.newBuilder().build());
    }

    public static final StreamsServiceClient create(StreamsServiceSettings settings) throws IOException {
        return new StreamsServiceClient(settings);
    }

    public static final StreamsServiceClient create(StreamsServiceStub stub) {
        return new StreamsServiceClient(stub);
    }

    protected StreamsServiceClient(StreamsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((StreamsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected StreamsServiceClient(StreamsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final StreamsServiceSettings getSettings() {
        return this.settings;
    }

    public StreamsServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListClustersPagedResponse listClusters(LocationName parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(String parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(ListClustersRequest request) {
        return (ListClustersPagedResponse)((Object)this.listClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListClustersRequest, ListClustersPagedResponse> listClustersPagedCallable() {
        return this.stub.listClustersPagedCallable();
    }

    public final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.stub.listClustersCallable();
    }

    public final Cluster getCluster(ClusterName name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(String name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(GetClusterRequest request) {
        return (Cluster)this.getClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.stub.getClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(LocationName parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(String parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationCallable() {
        return this.stub.createClusterOperationCallable();
    }

    public final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.stub.createClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> updateClusterAsync(Cluster cluster, FieldMask updateMask) {
        UpdateClusterRequest request = UpdateClusterRequest.newBuilder().setCluster(cluster).setUpdateMask(updateMask).build();
        return this.updateClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> updateClusterAsync(UpdateClusterRequest request) {
        return this.updateClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationCallable() {
        return this.stub.updateClusterOperationCallable();
    }

    public final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.stub.updateClusterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(ClusterName name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(String name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationCallable() {
        return this.stub.deleteClusterOperationCallable();
    }

    public final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.stub.deleteClusterCallable();
    }

    public final ListStreamsPagedResponse listStreams(ClusterName parent) {
        ListStreamsRequest request = ListStreamsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listStreams(request);
    }

    public final ListStreamsPagedResponse listStreams(String parent) {
        ListStreamsRequest request = ListStreamsRequest.newBuilder().setParent(parent).build();
        return this.listStreams(request);
    }

    public final ListStreamsPagedResponse listStreams(ListStreamsRequest request) {
        return (ListStreamsPagedResponse)((Object)this.listStreamsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListStreamsRequest, ListStreamsPagedResponse> listStreamsPagedCallable() {
        return this.stub.listStreamsPagedCallable();
    }

    public final UnaryCallable<ListStreamsRequest, ListStreamsResponse> listStreamsCallable() {
        return this.stub.listStreamsCallable();
    }

    public final Stream getStream(StreamName name) {
        GetStreamRequest request = GetStreamRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getStream(request);
    }

    public final Stream getStream(String name) {
        GetStreamRequest request = GetStreamRequest.newBuilder().setName(name).build();
        return this.getStream(request);
    }

    public final Stream getStream(GetStreamRequest request) {
        return (Stream)this.getStreamCallable().call((Object)request);
    }

    public final UnaryCallable<GetStreamRequest, Stream> getStreamCallable() {
        return this.stub.getStreamCallable();
    }

    public final OperationFuture<Stream, OperationMetadata> createStreamAsync(ClusterName parent, Stream stream, String streamId) {
        CreateStreamRequest request = CreateStreamRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setStream(stream).setStreamId(streamId).build();
        return this.createStreamAsync(request);
    }

    public final OperationFuture<Stream, OperationMetadata> createStreamAsync(String parent, Stream stream, String streamId) {
        CreateStreamRequest request = CreateStreamRequest.newBuilder().setParent(parent).setStream(stream).setStreamId(streamId).build();
        return this.createStreamAsync(request);
    }

    public final OperationFuture<Stream, OperationMetadata> createStreamAsync(CreateStreamRequest request) {
        return this.createStreamOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationCallable() {
        return this.stub.createStreamOperationCallable();
    }

    public final UnaryCallable<CreateStreamRequest, Operation> createStreamCallable() {
        return this.stub.createStreamCallable();
    }

    public final OperationFuture<Stream, OperationMetadata> updateStreamAsync(Stream stream, FieldMask updateMask) {
        UpdateStreamRequest request = UpdateStreamRequest.newBuilder().setStream(stream).setUpdateMask(updateMask).build();
        return this.updateStreamAsync(request);
    }

    public final OperationFuture<Stream, OperationMetadata> updateStreamAsync(UpdateStreamRequest request) {
        return this.updateStreamOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationCallable() {
        return this.stub.updateStreamOperationCallable();
    }

    public final UnaryCallable<UpdateStreamRequest, Operation> updateStreamCallable() {
        return this.stub.updateStreamCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteStreamAsync(StreamName name) {
        DeleteStreamRequest request = DeleteStreamRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteStreamAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteStreamAsync(String name) {
        DeleteStreamRequest request = DeleteStreamRequest.newBuilder().setName(name).build();
        return this.deleteStreamAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteStreamAsync(DeleteStreamRequest request) {
        return this.deleteStreamOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationCallable() {
        return this.stub.deleteStreamOperationCallable();
    }

    public final UnaryCallable<DeleteStreamRequest, Operation> deleteStreamCallable() {
        return this.stub.deleteStreamCallable();
    }

    public final OperationFuture<GetStreamThumbnailResponse, OperationMetadata> getStreamThumbnailAsync(String stream, String gcsObjectName) {
        GetStreamThumbnailRequest request = GetStreamThumbnailRequest.newBuilder().setStream(stream).setGcsObjectName(gcsObjectName).build();
        return this.getStreamThumbnailAsync(request);
    }

    public final OperationFuture<GetStreamThumbnailResponse, OperationMetadata> getStreamThumbnailAsync(GetStreamThumbnailRequest request) {
        return this.getStreamThumbnailOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<GetStreamThumbnailRequest, GetStreamThumbnailResponse, OperationMetadata> getStreamThumbnailOperationCallable() {
        return this.stub.getStreamThumbnailOperationCallable();
    }

    public final UnaryCallable<GetStreamThumbnailRequest, Operation> getStreamThumbnailCallable() {
        return this.stub.getStreamThumbnailCallable();
    }

    public final GenerateStreamHlsTokenResponse generateStreamHlsToken(String stream) {
        GenerateStreamHlsTokenRequest request = GenerateStreamHlsTokenRequest.newBuilder().setStream(stream).build();
        return this.generateStreamHlsToken(request);
    }

    public final GenerateStreamHlsTokenResponse generateStreamHlsToken(GenerateStreamHlsTokenRequest request) {
        return (GenerateStreamHlsTokenResponse)this.generateStreamHlsTokenCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateStreamHlsTokenRequest, GenerateStreamHlsTokenResponse> generateStreamHlsTokenCallable() {
        return this.stub.generateStreamHlsTokenCallable();
    }

    public final ListEventsPagedResponse listEvents(ClusterName parent) {
        ListEventsRequest request = ListEventsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEvents(request);
    }

    public final ListEventsPagedResponse listEvents(String parent) {
        ListEventsRequest request = ListEventsRequest.newBuilder().setParent(parent).build();
        return this.listEvents(request);
    }

    public final ListEventsPagedResponse listEvents(ListEventsRequest request) {
        return (ListEventsPagedResponse)((Object)this.listEventsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEventsRequest, ListEventsPagedResponse> listEventsPagedCallable() {
        return this.stub.listEventsPagedCallable();
    }

    public final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable() {
        return this.stub.listEventsCallable();
    }

    public final Event getEvent(EventName name) {
        GetEventRequest request = GetEventRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEvent(request);
    }

    public final Event getEvent(String name) {
        GetEventRequest request = GetEventRequest.newBuilder().setName(name).build();
        return this.getEvent(request);
    }

    public final Event getEvent(GetEventRequest request) {
        return (Event)this.getEventCallable().call((Object)request);
    }

    public final UnaryCallable<GetEventRequest, Event> getEventCallable() {
        return this.stub.getEventCallable();
    }

    public final OperationFuture<Event, OperationMetadata> createEventAsync(ClusterName parent, Event event, String eventId) {
        CreateEventRequest request = CreateEventRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEvent(event).setEventId(eventId).build();
        return this.createEventAsync(request);
    }

    public final OperationFuture<Event, OperationMetadata> createEventAsync(String parent, Event event, String eventId) {
        CreateEventRequest request = CreateEventRequest.newBuilder().setParent(parent).setEvent(event).setEventId(eventId).build();
        return this.createEventAsync(request);
    }

    public final OperationFuture<Event, OperationMetadata> createEventAsync(CreateEventRequest request) {
        return this.createEventOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEventRequest, Event, OperationMetadata> createEventOperationCallable() {
        return this.stub.createEventOperationCallable();
    }

    public final UnaryCallable<CreateEventRequest, Operation> createEventCallable() {
        return this.stub.createEventCallable();
    }

    public final OperationFuture<Event, OperationMetadata> updateEventAsync(Event event, FieldMask updateMask) {
        UpdateEventRequest request = UpdateEventRequest.newBuilder().setEvent(event).setUpdateMask(updateMask).build();
        return this.updateEventAsync(request);
    }

    public final OperationFuture<Event, OperationMetadata> updateEventAsync(UpdateEventRequest request) {
        return this.updateEventOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateEventRequest, Event, OperationMetadata> updateEventOperationCallable() {
        return this.stub.updateEventOperationCallable();
    }

    public final UnaryCallable<UpdateEventRequest, Operation> updateEventCallable() {
        return this.stub.updateEventCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEventAsync(EventName name) {
        DeleteEventRequest request = DeleteEventRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEventAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEventAsync(String name) {
        DeleteEventRequest request = DeleteEventRequest.newBuilder().setName(name).build();
        return this.deleteEventAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEventAsync(DeleteEventRequest request) {
        return this.deleteEventOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEventRequest, Empty, OperationMetadata> deleteEventOperationCallable() {
        return this.stub.deleteEventOperationCallable();
    }

    public final UnaryCallable<DeleteEventRequest, Operation> deleteEventCallable() {
        return this.stub.deleteEventCallable();
    }

    public final ListSeriesPagedResponse listSeries(ClusterName parent) {
        ListSeriesRequest request = ListSeriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSeries(request);
    }

    public final ListSeriesPagedResponse listSeries(String parent) {
        ListSeriesRequest request = ListSeriesRequest.newBuilder().setParent(parent).build();
        return this.listSeries(request);
    }

    public final ListSeriesPagedResponse listSeries(ListSeriesRequest request) {
        return (ListSeriesPagedResponse)((Object)this.listSeriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSeriesRequest, ListSeriesPagedResponse> listSeriesPagedCallable() {
        return this.stub.listSeriesPagedCallable();
    }

    public final UnaryCallable<ListSeriesRequest, ListSeriesResponse> listSeriesCallable() {
        return this.stub.listSeriesCallable();
    }

    public final Series getSeries(SeriesName name) {
        GetSeriesRequest request = GetSeriesRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSeries(request);
    }

    public final Series getSeries(String name) {
        GetSeriesRequest request = GetSeriesRequest.newBuilder().setName(name).build();
        return this.getSeries(request);
    }

    public final Series getSeries(GetSeriesRequest request) {
        return (Series)this.getSeriesCallable().call((Object)request);
    }

    public final UnaryCallable<GetSeriesRequest, Series> getSeriesCallable() {
        return this.stub.getSeriesCallable();
    }

    public final OperationFuture<Series, OperationMetadata> createSeriesAsync(ClusterName parent, Series series, String seriesId) {
        CreateSeriesRequest request = CreateSeriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSeries(series).setSeriesId(seriesId).build();
        return this.createSeriesAsync(request);
    }

    public final OperationFuture<Series, OperationMetadata> createSeriesAsync(String parent, Series series, String seriesId) {
        CreateSeriesRequest request = CreateSeriesRequest.newBuilder().setParent(parent).setSeries(series).setSeriesId(seriesId).build();
        return this.createSeriesAsync(request);
    }

    public final OperationFuture<Series, OperationMetadata> createSeriesAsync(CreateSeriesRequest request) {
        return this.createSeriesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSeriesRequest, Series, OperationMetadata> createSeriesOperationCallable() {
        return this.stub.createSeriesOperationCallable();
    }

    public final UnaryCallable<CreateSeriesRequest, Operation> createSeriesCallable() {
        return this.stub.createSeriesCallable();
    }

    public final OperationFuture<Series, OperationMetadata> updateSeriesAsync(Series series, FieldMask updateMask) {
        UpdateSeriesRequest request = UpdateSeriesRequest.newBuilder().setSeries(series).setUpdateMask(updateMask).build();
        return this.updateSeriesAsync(request);
    }

    public final OperationFuture<Series, OperationMetadata> updateSeriesAsync(UpdateSeriesRequest request) {
        return this.updateSeriesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSeriesRequest, Series, OperationMetadata> updateSeriesOperationCallable() {
        return this.stub.updateSeriesOperationCallable();
    }

    public final UnaryCallable<UpdateSeriesRequest, Operation> updateSeriesCallable() {
        return this.stub.updateSeriesCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSeriesAsync(SeriesName name) {
        DeleteSeriesRequest request = DeleteSeriesRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSeriesAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSeriesAsync(String name) {
        DeleteSeriesRequest request = DeleteSeriesRequest.newBuilder().setName(name).build();
        return this.deleteSeriesAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSeriesAsync(DeleteSeriesRequest request) {
        return this.deleteSeriesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSeriesRequest, Empty, OperationMetadata> deleteSeriesOperationCallable() {
        return this.stub.deleteSeriesOperationCallable();
    }

    public final UnaryCallable<DeleteSeriesRequest, Operation> deleteSeriesCallable() {
        return this.stub.deleteSeriesCallable();
    }

    public final OperationFuture<Channel, OperationMetadata> materializeChannelAsync(ClusterName parent, Channel channel, String channelId) {
        MaterializeChannelRequest request = MaterializeChannelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setChannel(channel).setChannelId(channelId).build();
        return this.materializeChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> materializeChannelAsync(String parent, Channel channel, String channelId) {
        MaterializeChannelRequest request = MaterializeChannelRequest.newBuilder().setParent(parent).setChannel(channel).setChannelId(channelId).build();
        return this.materializeChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> materializeChannelAsync(MaterializeChannelRequest request) {
        return this.materializeChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<MaterializeChannelRequest, Channel, OperationMetadata> materializeChannelOperationCallable() {
        return this.stub.materializeChannelOperationCallable();
    }

    public final UnaryCallable<MaterializeChannelRequest, Operation> materializeChannelCallable() {
        return this.stub.materializeChannelCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSeriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSeriesRequest, ListSeriesResponse, Series, ListSeriesPage, ListSeriesFixedSizeCollection> {
        private ListSeriesFixedSizeCollection(List<ListSeriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSeriesFixedSizeCollection createEmptyCollection() {
            return new ListSeriesFixedSizeCollection(null, 0);
        }

        protected ListSeriesFixedSizeCollection createCollection(List<ListSeriesPage> pages, int collectionSize) {
            return new ListSeriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSeriesPage
    extends AbstractPage<ListSeriesRequest, ListSeriesResponse, Series, ListSeriesPage> {
        private ListSeriesPage(PageContext<ListSeriesRequest, ListSeriesResponse, Series> context, ListSeriesResponse response) {
            super(context, (Object)response);
        }

        private static ListSeriesPage createEmptyPage() {
            return new ListSeriesPage(null, null);
        }

        protected ListSeriesPage createPage(PageContext<ListSeriesRequest, ListSeriesResponse, Series> context, ListSeriesResponse response) {
            return new ListSeriesPage(context, response);
        }

        public ApiFuture<ListSeriesPage> createPageAsync(PageContext<ListSeriesRequest, ListSeriesResponse, Series> context, ApiFuture<ListSeriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSeriesPagedResponse
    extends AbstractPagedListResponse<ListSeriesRequest, ListSeriesResponse, Series, ListSeriesPage, ListSeriesFixedSizeCollection> {
        public static ApiFuture<ListSeriesPagedResponse> createAsync(PageContext<ListSeriesRequest, ListSeriesResponse, Series> context, ApiFuture<ListSeriesResponse> futureResponse) {
            ApiFuture<ListSeriesPage> futurePage = ListSeriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSeriesPagedResponse((ListSeriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSeriesPagedResponse(ListSeriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSeriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEventsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEventsRequest, ListEventsResponse, Event, ListEventsPage, ListEventsFixedSizeCollection> {
        private ListEventsFixedSizeCollection(List<ListEventsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEventsFixedSizeCollection createEmptyCollection() {
            return new ListEventsFixedSizeCollection(null, 0);
        }

        protected ListEventsFixedSizeCollection createCollection(List<ListEventsPage> pages, int collectionSize) {
            return new ListEventsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEventsPage
    extends AbstractPage<ListEventsRequest, ListEventsResponse, Event, ListEventsPage> {
        private ListEventsPage(PageContext<ListEventsRequest, ListEventsResponse, Event> context, ListEventsResponse response) {
            super(context, (Object)response);
        }

        private static ListEventsPage createEmptyPage() {
            return new ListEventsPage(null, null);
        }

        protected ListEventsPage createPage(PageContext<ListEventsRequest, ListEventsResponse, Event> context, ListEventsResponse response) {
            return new ListEventsPage(context, response);
        }

        public ApiFuture<ListEventsPage> createPageAsync(PageContext<ListEventsRequest, ListEventsResponse, Event> context, ApiFuture<ListEventsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEventsPagedResponse
    extends AbstractPagedListResponse<ListEventsRequest, ListEventsResponse, Event, ListEventsPage, ListEventsFixedSizeCollection> {
        public static ApiFuture<ListEventsPagedResponse> createAsync(PageContext<ListEventsRequest, ListEventsResponse, Event> context, ApiFuture<ListEventsResponse> futureResponse) {
            ApiFuture<ListEventsPage> futurePage = ListEventsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEventsPagedResponse((ListEventsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEventsPagedResponse(ListEventsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEventsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListStreamsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListStreamsRequest, ListStreamsResponse, Stream, ListStreamsPage, ListStreamsFixedSizeCollection> {
        private ListStreamsFixedSizeCollection(List<ListStreamsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListStreamsFixedSizeCollection createEmptyCollection() {
            return new ListStreamsFixedSizeCollection(null, 0);
        }

        protected ListStreamsFixedSizeCollection createCollection(List<ListStreamsPage> pages, int collectionSize) {
            return new ListStreamsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListStreamsPage
    extends AbstractPage<ListStreamsRequest, ListStreamsResponse, Stream, ListStreamsPage> {
        private ListStreamsPage(PageContext<ListStreamsRequest, ListStreamsResponse, Stream> context, ListStreamsResponse response) {
            super(context, (Object)response);
        }

        private static ListStreamsPage createEmptyPage() {
            return new ListStreamsPage(null, null);
        }

        protected ListStreamsPage createPage(PageContext<ListStreamsRequest, ListStreamsResponse, Stream> context, ListStreamsResponse response) {
            return new ListStreamsPage(context, response);
        }

        public ApiFuture<ListStreamsPage> createPageAsync(PageContext<ListStreamsRequest, ListStreamsResponse, Stream> context, ApiFuture<ListStreamsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListStreamsPagedResponse
    extends AbstractPagedListResponse<ListStreamsRequest, ListStreamsResponse, Stream, ListStreamsPage, ListStreamsFixedSizeCollection> {
        public static ApiFuture<ListStreamsPagedResponse> createAsync(PageContext<ListStreamsRequest, ListStreamsResponse, Stream> context, ApiFuture<ListStreamsResponse> futureResponse) {
            ApiFuture<ListStreamsPage> futurePage = ListStreamsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListStreamsPagedResponse((ListStreamsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListStreamsPagedResponse(ListStreamsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListStreamsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        private ListClustersFixedSizeCollection(List<ListClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListClustersFixedSizeCollection createEmptyCollection() {
            return new ListClustersFixedSizeCollection(null, 0);
        }

        protected ListClustersFixedSizeCollection createCollection(List<ListClustersPage> pages, int collectionSize) {
            return new ListClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListClustersPage
    extends AbstractPage<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage> {
        private ListClustersPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListClustersPage createEmptyPage() {
            return new ListClustersPage(null, null);
        }

        protected ListClustersPage createPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            return new ListClustersPage(context, response);
        }

        public ApiFuture<ListClustersPage> createPageAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListClustersPagedResponse
    extends AbstractPagedListResponse<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        public static ApiFuture<ListClustersPagedResponse> createAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            ApiFuture<ListClustersPage> futurePage = ListClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListClustersPagedResponse((ListClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListClustersPagedResponse(ListClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

