/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.visionai.v1.Analysis;
import com.google.cloud.visionai.v1.AnalysisName;
import com.google.cloud.visionai.v1.BatchRunProcessRequest;
import com.google.cloud.visionai.v1.BatchRunProcessResponse;
import com.google.cloud.visionai.v1.ClusterName;
import com.google.cloud.visionai.v1.CreateAnalysisRequest;
import com.google.cloud.visionai.v1.CreateOperatorRequest;
import com.google.cloud.visionai.v1.CreateProcessRequest;
import com.google.cloud.visionai.v1.DeleteAnalysisRequest;
import com.google.cloud.visionai.v1.DeleteOperatorRequest;
import com.google.cloud.visionai.v1.DeleteProcessRequest;
import com.google.cloud.visionai.v1.GetAnalysisRequest;
import com.google.cloud.visionai.v1.GetOperatorRequest;
import com.google.cloud.visionai.v1.GetProcessRequest;
import com.google.cloud.visionai.v1.ListAnalysesRequest;
import com.google.cloud.visionai.v1.ListAnalysesResponse;
import com.google.cloud.visionai.v1.ListOperatorsRequest;
import com.google.cloud.visionai.v1.ListOperatorsResponse;
import com.google.cloud.visionai.v1.ListProcessesRequest;
import com.google.cloud.visionai.v1.ListProcessesResponse;
import com.google.cloud.visionai.v1.ListPublicOperatorsRequest;
import com.google.cloud.visionai.v1.ListPublicOperatorsResponse;
import com.google.cloud.visionai.v1.LiveVideoAnalyticsSettings;
import com.google.cloud.visionai.v1.LocationName;
import com.google.cloud.visionai.v1.OperationMetadata;
import com.google.cloud.visionai.v1.Operator;
import com.google.cloud.visionai.v1.OperatorName;
import com.google.cloud.visionai.v1.OperatorQuery;
import com.google.cloud.visionai.v1.Process;
import com.google.cloud.visionai.v1.ProcessName;
import com.google.cloud.visionai.v1.ResolveOperatorInfoRequest;
import com.google.cloud.visionai.v1.ResolveOperatorInfoResponse;
import com.google.cloud.visionai.v1.UpdateAnalysisRequest;
import com.google.cloud.visionai.v1.UpdateOperatorRequest;
import com.google.cloud.visionai.v1.UpdateProcessRequest;
import com.google.cloud.visionai.v1.stub.LiveVideoAnalyticsStub;
import com.google.cloud.visionai.v1.stub.LiveVideoAnalyticsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class LiveVideoAnalyticsClient
implements BackgroundResource {
    private final LiveVideoAnalyticsSettings settings;
    private final LiveVideoAnalyticsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final LiveVideoAnalyticsClient create() throws IOException {
        return LiveVideoAnalyticsClient.create(LiveVideoAnalyticsSettings.newBuilder().build());
    }

    public static final LiveVideoAnalyticsClient create(LiveVideoAnalyticsSettings settings) throws IOException {
        return new LiveVideoAnalyticsClient(settings);
    }

    public static final LiveVideoAnalyticsClient create(LiveVideoAnalyticsStub stub) {
        return new LiveVideoAnalyticsClient(stub);
    }

    protected LiveVideoAnalyticsClient(LiveVideoAnalyticsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LiveVideoAnalyticsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected LiveVideoAnalyticsClient(LiveVideoAnalyticsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final LiveVideoAnalyticsSettings getSettings() {
        return this.settings;
    }

    public LiveVideoAnalyticsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListPublicOperatorsPagedResponse listPublicOperators(LocationName parent) {
        ListPublicOperatorsRequest request = ListPublicOperatorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPublicOperators(request);
    }

    public final ListPublicOperatorsPagedResponse listPublicOperators(String parent) {
        ListPublicOperatorsRequest request = ListPublicOperatorsRequest.newBuilder().setParent(parent).build();
        return this.listPublicOperators(request);
    }

    public final ListPublicOperatorsPagedResponse listPublicOperators(ListPublicOperatorsRequest request) {
        return (ListPublicOperatorsPagedResponse)((Object)this.listPublicOperatorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPublicOperatorsRequest, ListPublicOperatorsPagedResponse> listPublicOperatorsPagedCallable() {
        return this.stub.listPublicOperatorsPagedCallable();
    }

    public final UnaryCallable<ListPublicOperatorsRequest, ListPublicOperatorsResponse> listPublicOperatorsCallable() {
        return this.stub.listPublicOperatorsCallable();
    }

    public final ResolveOperatorInfoResponse resolveOperatorInfo(LocationName parent, List<OperatorQuery> queries) {
        ResolveOperatorInfoRequest request = ResolveOperatorInfoRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllQueries(queries).build();
        return this.resolveOperatorInfo(request);
    }

    public final ResolveOperatorInfoResponse resolveOperatorInfo(String parent, List<OperatorQuery> queries) {
        ResolveOperatorInfoRequest request = ResolveOperatorInfoRequest.newBuilder().setParent(parent).addAllQueries(queries).build();
        return this.resolveOperatorInfo(request);
    }

    public final ResolveOperatorInfoResponse resolveOperatorInfo(ResolveOperatorInfoRequest request) {
        return (ResolveOperatorInfoResponse)this.resolveOperatorInfoCallable().call((Object)request);
    }

    public final UnaryCallable<ResolveOperatorInfoRequest, ResolveOperatorInfoResponse> resolveOperatorInfoCallable() {
        return this.stub.resolveOperatorInfoCallable();
    }

    public final ListOperatorsPagedResponse listOperators(LocationName parent) {
        ListOperatorsRequest request = ListOperatorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listOperators(request);
    }

    public final ListOperatorsPagedResponse listOperators(String parent) {
        ListOperatorsRequest request = ListOperatorsRequest.newBuilder().setParent(parent).build();
        return this.listOperators(request);
    }

    public final ListOperatorsPagedResponse listOperators(ListOperatorsRequest request) {
        return (ListOperatorsPagedResponse)((Object)this.listOperatorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOperatorsRequest, ListOperatorsPagedResponse> listOperatorsPagedCallable() {
        return this.stub.listOperatorsPagedCallable();
    }

    public final UnaryCallable<ListOperatorsRequest, ListOperatorsResponse> listOperatorsCallable() {
        return this.stub.listOperatorsCallable();
    }

    public final Operator getOperator(OperatorName name) {
        GetOperatorRequest request = GetOperatorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOperator(request);
    }

    public final Operator getOperator(String name) {
        GetOperatorRequest request = GetOperatorRequest.newBuilder().setName(name).build();
        return this.getOperator(request);
    }

    public final Operator getOperator(GetOperatorRequest request) {
        return (Operator)this.getOperatorCallable().call((Object)request);
    }

    public final UnaryCallable<GetOperatorRequest, Operator> getOperatorCallable() {
        return this.stub.getOperatorCallable();
    }

    public final OperationFuture<Operator, OperationMetadata> createOperatorAsync(LocationName parent, Operator operator, String operatorId) {
        CreateOperatorRequest request = CreateOperatorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setOperator(operator).setOperatorId(operatorId).build();
        return this.createOperatorAsync(request);
    }

    public final OperationFuture<Operator, OperationMetadata> createOperatorAsync(String parent, Operator operator, String operatorId) {
        CreateOperatorRequest request = CreateOperatorRequest.newBuilder().setParent(parent).setOperator(operator).setOperatorId(operatorId).build();
        return this.createOperatorAsync(request);
    }

    public final OperationFuture<Operator, OperationMetadata> createOperatorAsync(CreateOperatorRequest request) {
        return this.createOperatorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateOperatorRequest, Operator, OperationMetadata> createOperatorOperationCallable() {
        return this.stub.createOperatorOperationCallable();
    }

    public final UnaryCallable<CreateOperatorRequest, Operation> createOperatorCallable() {
        return this.stub.createOperatorCallable();
    }

    public final OperationFuture<Operator, OperationMetadata> updateOperatorAsync(Operator operator, FieldMask updateMask) {
        UpdateOperatorRequest request = UpdateOperatorRequest.newBuilder().setOperator(operator).setUpdateMask(updateMask).build();
        return this.updateOperatorAsync(request);
    }

    public final OperationFuture<Operator, OperationMetadata> updateOperatorAsync(UpdateOperatorRequest request) {
        return this.updateOperatorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateOperatorRequest, Operator, OperationMetadata> updateOperatorOperationCallable() {
        return this.stub.updateOperatorOperationCallable();
    }

    public final UnaryCallable<UpdateOperatorRequest, Operation> updateOperatorCallable() {
        return this.stub.updateOperatorCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOperatorAsync(OperatorName name) {
        DeleteOperatorRequest request = DeleteOperatorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteOperatorAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOperatorAsync(String name) {
        DeleteOperatorRequest request = DeleteOperatorRequest.newBuilder().setName(name).build();
        return this.deleteOperatorAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOperatorAsync(DeleteOperatorRequest request) {
        return this.deleteOperatorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteOperatorRequest, Empty, OperationMetadata> deleteOperatorOperationCallable() {
        return this.stub.deleteOperatorOperationCallable();
    }

    public final UnaryCallable<DeleteOperatorRequest, Operation> deleteOperatorCallable() {
        return this.stub.deleteOperatorCallable();
    }

    public final ListAnalysesPagedResponse listAnalyses(ClusterName parent) {
        ListAnalysesRequest request = ListAnalysesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAnalyses(request);
    }

    public final ListAnalysesPagedResponse listAnalyses(String parent) {
        ListAnalysesRequest request = ListAnalysesRequest.newBuilder().setParent(parent).build();
        return this.listAnalyses(request);
    }

    public final ListAnalysesPagedResponse listAnalyses(ListAnalysesRequest request) {
        return (ListAnalysesPagedResponse)((Object)this.listAnalysesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAnalysesRequest, ListAnalysesPagedResponse> listAnalysesPagedCallable() {
        return this.stub.listAnalysesPagedCallable();
    }

    public final UnaryCallable<ListAnalysesRequest, ListAnalysesResponse> listAnalysesCallable() {
        return this.stub.listAnalysesCallable();
    }

    public final Analysis getAnalysis(AnalysisName name) {
        GetAnalysisRequest request = GetAnalysisRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAnalysis(request);
    }

    public final Analysis getAnalysis(String name) {
        GetAnalysisRequest request = GetAnalysisRequest.newBuilder().setName(name).build();
        return this.getAnalysis(request);
    }

    public final Analysis getAnalysis(GetAnalysisRequest request) {
        return (Analysis)this.getAnalysisCallable().call((Object)request);
    }

    public final UnaryCallable<GetAnalysisRequest, Analysis> getAnalysisCallable() {
        return this.stub.getAnalysisCallable();
    }

    public final OperationFuture<Analysis, OperationMetadata> createAnalysisAsync(ClusterName parent, Analysis analysis, String analysisId) {
        CreateAnalysisRequest request = CreateAnalysisRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAnalysis(analysis).setAnalysisId(analysisId).build();
        return this.createAnalysisAsync(request);
    }

    public final OperationFuture<Analysis, OperationMetadata> createAnalysisAsync(String parent, Analysis analysis, String analysisId) {
        CreateAnalysisRequest request = CreateAnalysisRequest.newBuilder().setParent(parent).setAnalysis(analysis).setAnalysisId(analysisId).build();
        return this.createAnalysisAsync(request);
    }

    public final OperationFuture<Analysis, OperationMetadata> createAnalysisAsync(CreateAnalysisRequest request) {
        return this.createAnalysisOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAnalysisRequest, Analysis, OperationMetadata> createAnalysisOperationCallable() {
        return this.stub.createAnalysisOperationCallable();
    }

    public final UnaryCallable<CreateAnalysisRequest, Operation> createAnalysisCallable() {
        return this.stub.createAnalysisCallable();
    }

    public final OperationFuture<Analysis, OperationMetadata> updateAnalysisAsync(Analysis analysis, FieldMask updateMask) {
        UpdateAnalysisRequest request = UpdateAnalysisRequest.newBuilder().setAnalysis(analysis).setUpdateMask(updateMask).build();
        return this.updateAnalysisAsync(request);
    }

    public final OperationFuture<Analysis, OperationMetadata> updateAnalysisAsync(UpdateAnalysisRequest request) {
        return this.updateAnalysisOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAnalysisRequest, Analysis, OperationMetadata> updateAnalysisOperationCallable() {
        return this.stub.updateAnalysisOperationCallable();
    }

    public final UnaryCallable<UpdateAnalysisRequest, Operation> updateAnalysisCallable() {
        return this.stub.updateAnalysisCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAnalysisAsync(AnalysisName name) {
        DeleteAnalysisRequest request = DeleteAnalysisRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAnalysisAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAnalysisAsync(String name) {
        DeleteAnalysisRequest request = DeleteAnalysisRequest.newBuilder().setName(name).build();
        return this.deleteAnalysisAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAnalysisAsync(DeleteAnalysisRequest request) {
        return this.deleteAnalysisOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAnalysisRequest, Empty, OperationMetadata> deleteAnalysisOperationCallable() {
        return this.stub.deleteAnalysisOperationCallable();
    }

    public final UnaryCallable<DeleteAnalysisRequest, Operation> deleteAnalysisCallable() {
        return this.stub.deleteAnalysisCallable();
    }

    public final ListProcessesPagedResponse listProcesses(ClusterName parent) {
        ListProcessesRequest request = ListProcessesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProcesses(request);
    }

    public final ListProcessesPagedResponse listProcesses(String parent) {
        ListProcessesRequest request = ListProcessesRequest.newBuilder().setParent(parent).build();
        return this.listProcesses(request);
    }

    public final ListProcessesPagedResponse listProcesses(ListProcessesRequest request) {
        return (ListProcessesPagedResponse)((Object)this.listProcessesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProcessesRequest, ListProcessesPagedResponse> listProcessesPagedCallable() {
        return this.stub.listProcessesPagedCallable();
    }

    public final UnaryCallable<ListProcessesRequest, ListProcessesResponse> listProcessesCallable() {
        return this.stub.listProcessesCallable();
    }

    public final Process getProcess(ProcessName name) {
        GetProcessRequest request = GetProcessRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProcess(request);
    }

    public final Process getProcess(String name) {
        GetProcessRequest request = GetProcessRequest.newBuilder().setName(name).build();
        return this.getProcess(request);
    }

    public final Process getProcess(GetProcessRequest request) {
        return (Process)this.getProcessCallable().call((Object)request);
    }

    public final UnaryCallable<GetProcessRequest, Process> getProcessCallable() {
        return this.stub.getProcessCallable();
    }

    public final OperationFuture<Process, OperationMetadata> createProcessAsync(ClusterName parent, Process process, String processId) {
        CreateProcessRequest request = CreateProcessRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProcess(process).setProcessId(processId).build();
        return this.createProcessAsync(request);
    }

    public final OperationFuture<Process, OperationMetadata> createProcessAsync(String parent, Process process, String processId) {
        CreateProcessRequest request = CreateProcessRequest.newBuilder().setParent(parent).setProcess(process).setProcessId(processId).build();
        return this.createProcessAsync(request);
    }

    public final OperationFuture<Process, OperationMetadata> createProcessAsync(CreateProcessRequest request) {
        return this.createProcessOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateProcessRequest, Process, OperationMetadata> createProcessOperationCallable() {
        return this.stub.createProcessOperationCallable();
    }

    public final UnaryCallable<CreateProcessRequest, Operation> createProcessCallable() {
        return this.stub.createProcessCallable();
    }

    public final OperationFuture<Process, OperationMetadata> updateProcessAsync(Process process, FieldMask updateMask) {
        UpdateProcessRequest request = UpdateProcessRequest.newBuilder().setProcess(process).setUpdateMask(updateMask).build();
        return this.updateProcessAsync(request);
    }

    public final OperationFuture<Process, OperationMetadata> updateProcessAsync(UpdateProcessRequest request) {
        return this.updateProcessOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateProcessRequest, Process, OperationMetadata> updateProcessOperationCallable() {
        return this.stub.updateProcessOperationCallable();
    }

    public final UnaryCallable<UpdateProcessRequest, Operation> updateProcessCallable() {
        return this.stub.updateProcessCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteProcessAsync(ProcessName name) {
        DeleteProcessRequest request = DeleteProcessRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteProcessAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteProcessAsync(String name) {
        DeleteProcessRequest request = DeleteProcessRequest.newBuilder().setName(name).build();
        return this.deleteProcessAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteProcessAsync(DeleteProcessRequest request) {
        return this.deleteProcessOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteProcessRequest, Empty, OperationMetadata> deleteProcessOperationCallable() {
        return this.stub.deleteProcessOperationCallable();
    }

    public final UnaryCallable<DeleteProcessRequest, Operation> deleteProcessCallable() {
        return this.stub.deleteProcessCallable();
    }

    public final OperationFuture<BatchRunProcessResponse, OperationMetadata> batchRunProcessAsync(ClusterName parent, List<CreateProcessRequest> requests) {
        BatchRunProcessRequest request = BatchRunProcessRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchRunProcessAsync(request);
    }

    public final OperationFuture<BatchRunProcessResponse, OperationMetadata> batchRunProcessAsync(String parent, List<CreateProcessRequest> requests) {
        BatchRunProcessRequest request = BatchRunProcessRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchRunProcessAsync(request);
    }

    public final OperationFuture<BatchRunProcessResponse, OperationMetadata> batchRunProcessAsync(BatchRunProcessRequest request) {
        return this.batchRunProcessOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchRunProcessRequest, BatchRunProcessResponse, OperationMetadata> batchRunProcessOperationCallable() {
        return this.stub.batchRunProcessOperationCallable();
    }

    public final UnaryCallable<BatchRunProcessRequest, Operation> batchRunProcessCallable() {
        return this.stub.batchRunProcessCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListProcessesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProcessesRequest, ListProcessesResponse, Process, ListProcessesPage, ListProcessesFixedSizeCollection> {
        private ListProcessesFixedSizeCollection(List<ListProcessesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProcessesFixedSizeCollection createEmptyCollection() {
            return new ListProcessesFixedSizeCollection(null, 0);
        }

        protected ListProcessesFixedSizeCollection createCollection(List<ListProcessesPage> pages, int collectionSize) {
            return new ListProcessesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProcessesPage
    extends AbstractPage<ListProcessesRequest, ListProcessesResponse, Process, ListProcessesPage> {
        private ListProcessesPage(PageContext<ListProcessesRequest, ListProcessesResponse, Process> context, ListProcessesResponse response) {
            super(context, (Object)response);
        }

        private static ListProcessesPage createEmptyPage() {
            return new ListProcessesPage(null, null);
        }

        protected ListProcessesPage createPage(PageContext<ListProcessesRequest, ListProcessesResponse, Process> context, ListProcessesResponse response) {
            return new ListProcessesPage(context, response);
        }

        public ApiFuture<ListProcessesPage> createPageAsync(PageContext<ListProcessesRequest, ListProcessesResponse, Process> context, ApiFuture<ListProcessesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProcessesPagedResponse
    extends AbstractPagedListResponse<ListProcessesRequest, ListProcessesResponse, Process, ListProcessesPage, ListProcessesFixedSizeCollection> {
        public static ApiFuture<ListProcessesPagedResponse> createAsync(PageContext<ListProcessesRequest, ListProcessesResponse, Process> context, ApiFuture<ListProcessesResponse> futureResponse) {
            ApiFuture<ListProcessesPage> futurePage = ListProcessesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProcessesPagedResponse((ListProcessesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProcessesPagedResponse(ListProcessesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProcessesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAnalysesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAnalysesRequest, ListAnalysesResponse, Analysis, ListAnalysesPage, ListAnalysesFixedSizeCollection> {
        private ListAnalysesFixedSizeCollection(List<ListAnalysesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAnalysesFixedSizeCollection createEmptyCollection() {
            return new ListAnalysesFixedSizeCollection(null, 0);
        }

        protected ListAnalysesFixedSizeCollection createCollection(List<ListAnalysesPage> pages, int collectionSize) {
            return new ListAnalysesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAnalysesPage
    extends AbstractPage<ListAnalysesRequest, ListAnalysesResponse, Analysis, ListAnalysesPage> {
        private ListAnalysesPage(PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis> context, ListAnalysesResponse response) {
            super(context, (Object)response);
        }

        private static ListAnalysesPage createEmptyPage() {
            return new ListAnalysesPage(null, null);
        }

        protected ListAnalysesPage createPage(PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis> context, ListAnalysesResponse response) {
            return new ListAnalysesPage(context, response);
        }

        public ApiFuture<ListAnalysesPage> createPageAsync(PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis> context, ApiFuture<ListAnalysesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAnalysesPagedResponse
    extends AbstractPagedListResponse<ListAnalysesRequest, ListAnalysesResponse, Analysis, ListAnalysesPage, ListAnalysesFixedSizeCollection> {
        public static ApiFuture<ListAnalysesPagedResponse> createAsync(PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis> context, ApiFuture<ListAnalysesResponse> futureResponse) {
            ApiFuture<ListAnalysesPage> futurePage = ListAnalysesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAnalysesPagedResponse((ListAnalysesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAnalysesPagedResponse(ListAnalysesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAnalysesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOperatorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOperatorsRequest, ListOperatorsResponse, Operator, ListOperatorsPage, ListOperatorsFixedSizeCollection> {
        private ListOperatorsFixedSizeCollection(List<ListOperatorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOperatorsFixedSizeCollection createEmptyCollection() {
            return new ListOperatorsFixedSizeCollection(null, 0);
        }

        protected ListOperatorsFixedSizeCollection createCollection(List<ListOperatorsPage> pages, int collectionSize) {
            return new ListOperatorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOperatorsPage
    extends AbstractPage<ListOperatorsRequest, ListOperatorsResponse, Operator, ListOperatorsPage> {
        private ListOperatorsPage(PageContext<ListOperatorsRequest, ListOperatorsResponse, Operator> context, ListOperatorsResponse response) {
            super(context, (Object)response);
        }

        private static ListOperatorsPage createEmptyPage() {
            return new ListOperatorsPage(null, null);
        }

        protected ListOperatorsPage createPage(PageContext<ListOperatorsRequest, ListOperatorsResponse, Operator> context, ListOperatorsResponse response) {
            return new ListOperatorsPage(context, response);
        }

        public ApiFuture<ListOperatorsPage> createPageAsync(PageContext<ListOperatorsRequest, ListOperatorsResponse, Operator> context, ApiFuture<ListOperatorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOperatorsPagedResponse
    extends AbstractPagedListResponse<ListOperatorsRequest, ListOperatorsResponse, Operator, ListOperatorsPage, ListOperatorsFixedSizeCollection> {
        public static ApiFuture<ListOperatorsPagedResponse> createAsync(PageContext<ListOperatorsRequest, ListOperatorsResponse, Operator> context, ApiFuture<ListOperatorsResponse> futureResponse) {
            ApiFuture<ListOperatorsPage> futurePage = ListOperatorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOperatorsPagedResponse((ListOperatorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOperatorsPagedResponse(ListOperatorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOperatorsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPublicOperatorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPublicOperatorsRequest, ListPublicOperatorsResponse, Operator, ListPublicOperatorsPage, ListPublicOperatorsFixedSizeCollection> {
        private ListPublicOperatorsFixedSizeCollection(List<ListPublicOperatorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPublicOperatorsFixedSizeCollection createEmptyCollection() {
            return new ListPublicOperatorsFixedSizeCollection(null, 0);
        }

        protected ListPublicOperatorsFixedSizeCollection createCollection(List<ListPublicOperatorsPage> pages, int collectionSize) {
            return new ListPublicOperatorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPublicOperatorsPage
    extends AbstractPage<ListPublicOperatorsRequest, ListPublicOperatorsResponse, Operator, ListPublicOperatorsPage> {
        private ListPublicOperatorsPage(PageContext<ListPublicOperatorsRequest, ListPublicOperatorsResponse, Operator> context, ListPublicOperatorsResponse response) {
            super(context, (Object)response);
        }

        private static ListPublicOperatorsPage createEmptyPage() {
            return new ListPublicOperatorsPage(null, null);
        }

        protected ListPublicOperatorsPage createPage(PageContext<ListPublicOperatorsRequest, ListPublicOperatorsResponse, Operator> context, ListPublicOperatorsResponse response) {
            return new ListPublicOperatorsPage(context, response);
        }

        public ApiFuture<ListPublicOperatorsPage> createPageAsync(PageContext<ListPublicOperatorsRequest, ListPublicOperatorsResponse, Operator> context, ApiFuture<ListPublicOperatorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPublicOperatorsPagedResponse
    extends AbstractPagedListResponse<ListPublicOperatorsRequest, ListPublicOperatorsResponse, Operator, ListPublicOperatorsPage, ListPublicOperatorsFixedSizeCollection> {
        public static ApiFuture<ListPublicOperatorsPagedResponse> createAsync(PageContext<ListPublicOperatorsRequest, ListPublicOperatorsResponse, Operator> context, ApiFuture<ListPublicOperatorsResponse> futureResponse) {
            ApiFuture<ListPublicOperatorsPage> futurePage = ListPublicOperatorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPublicOperatorsPagedResponse((ListPublicOperatorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPublicOperatorsPagedResponse(ListPublicOperatorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPublicOperatorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

