/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1p3beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.vision.v1p3beta1.AddProductToProductSetRequest;
import com.google.cloud.vision.v1p3beta1.BatchOperationMetadata;
import com.google.cloud.vision.v1p3beta1.CreateProductRequest;
import com.google.cloud.vision.v1p3beta1.CreateProductSetRequest;
import com.google.cloud.vision.v1p3beta1.CreateReferenceImageRequest;
import com.google.cloud.vision.v1p3beta1.DeleteProductRequest;
import com.google.cloud.vision.v1p3beta1.DeleteProductSetRequest;
import com.google.cloud.vision.v1p3beta1.DeleteReferenceImageRequest;
import com.google.cloud.vision.v1p3beta1.GetProductRequest;
import com.google.cloud.vision.v1p3beta1.GetProductSetRequest;
import com.google.cloud.vision.v1p3beta1.GetReferenceImageRequest;
import com.google.cloud.vision.v1p3beta1.ImportProductSetsInputConfig;
import com.google.cloud.vision.v1p3beta1.ImportProductSetsRequest;
import com.google.cloud.vision.v1p3beta1.ImportProductSetsResponse;
import com.google.cloud.vision.v1p3beta1.ListProductSetsRequest;
import com.google.cloud.vision.v1p3beta1.ListProductSetsResponse;
import com.google.cloud.vision.v1p3beta1.ListProductsInProductSetRequest;
import com.google.cloud.vision.v1p3beta1.ListProductsInProductSetResponse;
import com.google.cloud.vision.v1p3beta1.ListProductsRequest;
import com.google.cloud.vision.v1p3beta1.ListProductsResponse;
import com.google.cloud.vision.v1p3beta1.ListReferenceImagesRequest;
import com.google.cloud.vision.v1p3beta1.ListReferenceImagesResponse;
import com.google.cloud.vision.v1p3beta1.LocationName;
import com.google.cloud.vision.v1p3beta1.Product;
import com.google.cloud.vision.v1p3beta1.ProductName;
import com.google.cloud.vision.v1p3beta1.ProductSearchSettings;
import com.google.cloud.vision.v1p3beta1.ProductSet;
import com.google.cloud.vision.v1p3beta1.ProductSetName;
import com.google.cloud.vision.v1p3beta1.ReferenceImage;
import com.google.cloud.vision.v1p3beta1.ReferenceImageName;
import com.google.cloud.vision.v1p3beta1.RemoveProductFromProductSetRequest;
import com.google.cloud.vision.v1p3beta1.UpdateProductRequest;
import com.google.cloud.vision.v1p3beta1.UpdateProductSetRequest;
import com.google.cloud.vision.v1p3beta1.stub.ProductSearchStub;
import com.google.cloud.vision.v1p3beta1.stub.ProductSearchStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ProductSearchClient
implements BackgroundResource {
    private final ProductSearchSettings settings;
    private final ProductSearchStub stub;
    private final OperationsClient operationsClient;

    public static final ProductSearchClient create() throws IOException {
        return ProductSearchClient.create(ProductSearchSettings.newBuilder().build());
    }

    public static final ProductSearchClient create(ProductSearchSettings settings) throws IOException {
        return new ProductSearchClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ProductSearchClient create(ProductSearchStub stub) {
        return new ProductSearchClient(stub);
    }

    protected ProductSearchClient(ProductSearchSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProductSearchStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ProductSearchClient(ProductSearchStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ProductSearchSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProductSearchStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ProductSet createProductSet(LocationName parent, ProductSet productSet, String productSetId) {
        CreateProductSetRequest request = CreateProductSetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProductSet(productSet).setProductSetId(productSetId).build();
        return this.createProductSet(request);
    }

    public final ProductSet createProductSet(String parent, ProductSet productSet, String productSetId) {
        CreateProductSetRequest request = CreateProductSetRequest.newBuilder().setParent(parent).setProductSet(productSet).setProductSetId(productSetId).build();
        return this.createProductSet(request);
    }

    public final ProductSet createProductSet(CreateProductSetRequest request) {
        return (ProductSet)this.createProductSetCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProductSetRequest, ProductSet> createProductSetCallable() {
        return this.stub.createProductSetCallable();
    }

    public final ListProductSetsPagedResponse listProductSets(LocationName parent) {
        ListProductSetsRequest request = ListProductSetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProductSets(request);
    }

    public final ListProductSetsPagedResponse listProductSets(String parent) {
        ListProductSetsRequest request = ListProductSetsRequest.newBuilder().setParent(parent).build();
        return this.listProductSets(request);
    }

    public final ListProductSetsPagedResponse listProductSets(ListProductSetsRequest request) {
        return (ListProductSetsPagedResponse)((Object)this.listProductSetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProductSetsRequest, ListProductSetsPagedResponse> listProductSetsPagedCallable() {
        return this.stub.listProductSetsPagedCallable();
    }

    public final UnaryCallable<ListProductSetsRequest, ListProductSetsResponse> listProductSetsCallable() {
        return this.stub.listProductSetsCallable();
    }

    public final ProductSet getProductSet(ProductSetName name) {
        GetProductSetRequest request = GetProductSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProductSet(request);
    }

    public final ProductSet getProductSet(String name) {
        GetProductSetRequest request = GetProductSetRequest.newBuilder().setName(name).build();
        return this.getProductSet(request);
    }

    public final ProductSet getProductSet(GetProductSetRequest request) {
        return (ProductSet)this.getProductSetCallable().call((Object)request);
    }

    public final UnaryCallable<GetProductSetRequest, ProductSet> getProductSetCallable() {
        return this.stub.getProductSetCallable();
    }

    public final ProductSet updateProductSet(ProductSet productSet, FieldMask updateMask) {
        UpdateProductSetRequest request = UpdateProductSetRequest.newBuilder().setProductSet(productSet).setUpdateMask(updateMask).build();
        return this.updateProductSet(request);
    }

    public final ProductSet updateProductSet(UpdateProductSetRequest request) {
        return (ProductSet)this.updateProductSetCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProductSetRequest, ProductSet> updateProductSetCallable() {
        return this.stub.updateProductSetCallable();
    }

    public final void deleteProductSet(ProductSetName name) {
        DeleteProductSetRequest request = DeleteProductSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteProductSet(request);
    }

    public final void deleteProductSet(String name) {
        DeleteProductSetRequest request = DeleteProductSetRequest.newBuilder().setName(name).build();
        this.deleteProductSet(request);
    }

    public final void deleteProductSet(DeleteProductSetRequest request) {
        this.deleteProductSetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteProductSetRequest, Empty> deleteProductSetCallable() {
        return this.stub.deleteProductSetCallable();
    }

    public final Product createProduct(LocationName parent, Product product, String productId) {
        CreateProductRequest request = CreateProductRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProduct(product).setProductId(productId).build();
        return this.createProduct(request);
    }

    public final Product createProduct(String parent, Product product, String productId) {
        CreateProductRequest request = CreateProductRequest.newBuilder().setParent(parent).setProduct(product).setProductId(productId).build();
        return this.createProduct(request);
    }

    public final Product createProduct(CreateProductRequest request) {
        return (Product)this.createProductCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProductRequest, Product> createProductCallable() {
        return this.stub.createProductCallable();
    }

    public final ListProductsPagedResponse listProducts(LocationName parent) {
        ListProductsRequest request = ListProductsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProducts(request);
    }

    public final ListProductsPagedResponse listProducts(String parent) {
        ListProductsRequest request = ListProductsRequest.newBuilder().setParent(parent).build();
        return this.listProducts(request);
    }

    public final ListProductsPagedResponse listProducts(ListProductsRequest request) {
        return (ListProductsPagedResponse)((Object)this.listProductsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProductsRequest, ListProductsPagedResponse> listProductsPagedCallable() {
        return this.stub.listProductsPagedCallable();
    }

    public final UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable() {
        return this.stub.listProductsCallable();
    }

    public final Product getProduct(ProductName name) {
        GetProductRequest request = GetProductRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProduct(request);
    }

    public final Product getProduct(String name) {
        GetProductRequest request = GetProductRequest.newBuilder().setName(name).build();
        return this.getProduct(request);
    }

    public final Product getProduct(GetProductRequest request) {
        return (Product)this.getProductCallable().call((Object)request);
    }

    public final UnaryCallable<GetProductRequest, Product> getProductCallable() {
        return this.stub.getProductCallable();
    }

    public final Product updateProduct(Product product, FieldMask updateMask) {
        UpdateProductRequest request = UpdateProductRequest.newBuilder().setProduct(product).setUpdateMask(updateMask).build();
        return this.updateProduct(request);
    }

    public final Product updateProduct(UpdateProductRequest request) {
        return (Product)this.updateProductCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProductRequest, Product> updateProductCallable() {
        return this.stub.updateProductCallable();
    }

    public final void deleteProduct(ProductName name) {
        DeleteProductRequest request = DeleteProductRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteProduct(request);
    }

    public final void deleteProduct(String name) {
        DeleteProductRequest request = DeleteProductRequest.newBuilder().setName(name).build();
        this.deleteProduct(request);
    }

    public final void deleteProduct(DeleteProductRequest request) {
        this.deleteProductCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteProductRequest, Empty> deleteProductCallable() {
        return this.stub.deleteProductCallable();
    }

    public final ReferenceImage createReferenceImage(ProductName parent, ReferenceImage referenceImage, String referenceImageId) {
        CreateReferenceImageRequest request = CreateReferenceImageRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReferenceImage(referenceImage).setReferenceImageId(referenceImageId).build();
        return this.createReferenceImage(request);
    }

    public final ReferenceImage createReferenceImage(String parent, ReferenceImage referenceImage, String referenceImageId) {
        CreateReferenceImageRequest request = CreateReferenceImageRequest.newBuilder().setParent(parent).setReferenceImage(referenceImage).setReferenceImageId(referenceImageId).build();
        return this.createReferenceImage(request);
    }

    public final ReferenceImage createReferenceImage(CreateReferenceImageRequest request) {
        return (ReferenceImage)this.createReferenceImageCallable().call((Object)request);
    }

    public final UnaryCallable<CreateReferenceImageRequest, ReferenceImage> createReferenceImageCallable() {
        return this.stub.createReferenceImageCallable();
    }

    public final void deleteReferenceImage(ReferenceImageName name) {
        DeleteReferenceImageRequest request = DeleteReferenceImageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteReferenceImage(request);
    }

    public final void deleteReferenceImage(String name) {
        DeleteReferenceImageRequest request = DeleteReferenceImageRequest.newBuilder().setName(name).build();
        this.deleteReferenceImage(request);
    }

    public final void deleteReferenceImage(DeleteReferenceImageRequest request) {
        this.deleteReferenceImageCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteReferenceImageRequest, Empty> deleteReferenceImageCallable() {
        return this.stub.deleteReferenceImageCallable();
    }

    public final ListReferenceImagesPagedResponse listReferenceImages(ProductName parent) {
        ListReferenceImagesRequest request = ListReferenceImagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReferenceImages(request);
    }

    public final ListReferenceImagesPagedResponse listReferenceImages(String parent) {
        ListReferenceImagesRequest request = ListReferenceImagesRequest.newBuilder().setParent(parent).build();
        return this.listReferenceImages(request);
    }

    public final ListReferenceImagesPagedResponse listReferenceImages(ListReferenceImagesRequest request) {
        return (ListReferenceImagesPagedResponse)((Object)this.listReferenceImagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReferenceImagesRequest, ListReferenceImagesPagedResponse> listReferenceImagesPagedCallable() {
        return this.stub.listReferenceImagesPagedCallable();
    }

    public final UnaryCallable<ListReferenceImagesRequest, ListReferenceImagesResponse> listReferenceImagesCallable() {
        return this.stub.listReferenceImagesCallable();
    }

    public final ReferenceImage getReferenceImage(ReferenceImageName name) {
        GetReferenceImageRequest request = GetReferenceImageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReferenceImage(request);
    }

    public final ReferenceImage getReferenceImage(String name) {
        GetReferenceImageRequest request = GetReferenceImageRequest.newBuilder().setName(name).build();
        return this.getReferenceImage(request);
    }

    public final ReferenceImage getReferenceImage(GetReferenceImageRequest request) {
        return (ReferenceImage)this.getReferenceImageCallable().call((Object)request);
    }

    public final UnaryCallable<GetReferenceImageRequest, ReferenceImage> getReferenceImageCallable() {
        return this.stub.getReferenceImageCallable();
    }

    public final void addProductToProductSet(ProductSetName name, ProductName product) {
        AddProductToProductSetRequest request = AddProductToProductSetRequest.newBuilder().setName(name == null ? null : name.toString()).setProduct(product == null ? null : product.toString()).build();
        this.addProductToProductSet(request);
    }

    public final void addProductToProductSet(ProductSetName name, String product) {
        AddProductToProductSetRequest request = AddProductToProductSetRequest.newBuilder().setName(name == null ? null : name.toString()).setProduct(product).build();
        this.addProductToProductSet(request);
    }

    public final void addProductToProductSet(String name, ProductName product) {
        AddProductToProductSetRequest request = AddProductToProductSetRequest.newBuilder().setName(name).setProduct(product == null ? null : product.toString()).build();
        this.addProductToProductSet(request);
    }

    public final void addProductToProductSet(String name, String product) {
        AddProductToProductSetRequest request = AddProductToProductSetRequest.newBuilder().setName(name).setProduct(product).build();
        this.addProductToProductSet(request);
    }

    public final void addProductToProductSet(AddProductToProductSetRequest request) {
        this.addProductToProductSetCallable().call((Object)request);
    }

    public final UnaryCallable<AddProductToProductSetRequest, Empty> addProductToProductSetCallable() {
        return this.stub.addProductToProductSetCallable();
    }

    public final void removeProductFromProductSet(ProductSetName name, ProductName product) {
        RemoveProductFromProductSetRequest request = RemoveProductFromProductSetRequest.newBuilder().setName(name == null ? null : name.toString()).setProduct(product == null ? null : product.toString()).build();
        this.removeProductFromProductSet(request);
    }

    public final void removeProductFromProductSet(ProductSetName name, String product) {
        RemoveProductFromProductSetRequest request = RemoveProductFromProductSetRequest.newBuilder().setName(name == null ? null : name.toString()).setProduct(product).build();
        this.removeProductFromProductSet(request);
    }

    public final void removeProductFromProductSet(String name, ProductName product) {
        RemoveProductFromProductSetRequest request = RemoveProductFromProductSetRequest.newBuilder().setName(name).setProduct(product == null ? null : product.toString()).build();
        this.removeProductFromProductSet(request);
    }

    public final void removeProductFromProductSet(String name, String product) {
        RemoveProductFromProductSetRequest request = RemoveProductFromProductSetRequest.newBuilder().setName(name).setProduct(product).build();
        this.removeProductFromProductSet(request);
    }

    public final void removeProductFromProductSet(RemoveProductFromProductSetRequest request) {
        this.removeProductFromProductSetCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveProductFromProductSetRequest, Empty> removeProductFromProductSetCallable() {
        return this.stub.removeProductFromProductSetCallable();
    }

    public final ListProductsInProductSetPagedResponse listProductsInProductSet(ProductSetName name) {
        ListProductsInProductSetRequest request = ListProductsInProductSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listProductsInProductSet(request);
    }

    public final ListProductsInProductSetPagedResponse listProductsInProductSet(String name) {
        ListProductsInProductSetRequest request = ListProductsInProductSetRequest.newBuilder().setName(name).build();
        return this.listProductsInProductSet(request);
    }

    public final ListProductsInProductSetPagedResponse listProductsInProductSet(ListProductsInProductSetRequest request) {
        return (ListProductsInProductSetPagedResponse)((Object)this.listProductsInProductSetPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProductsInProductSetRequest, ListProductsInProductSetPagedResponse> listProductsInProductSetPagedCallable() {
        return this.stub.listProductsInProductSetPagedCallable();
    }

    public final UnaryCallable<ListProductsInProductSetRequest, ListProductsInProductSetResponse> listProductsInProductSetCallable() {
        return this.stub.listProductsInProductSetCallable();
    }

    public final OperationFuture<ImportProductSetsResponse, BatchOperationMetadata> importProductSetsAsync(LocationName parent, ImportProductSetsInputConfig inputConfig) {
        ImportProductSetsRequest request = ImportProductSetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInputConfig(inputConfig).build();
        return this.importProductSetsAsync(request);
    }

    public final OperationFuture<ImportProductSetsResponse, BatchOperationMetadata> importProductSetsAsync(String parent, ImportProductSetsInputConfig inputConfig) {
        ImportProductSetsRequest request = ImportProductSetsRequest.newBuilder().setParent(parent).setInputConfig(inputConfig).build();
        return this.importProductSetsAsync(request);
    }

    public final OperationFuture<ImportProductSetsResponse, BatchOperationMetadata> importProductSetsAsync(ImportProductSetsRequest request) {
        return this.importProductSetsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportProductSetsRequest, ImportProductSetsResponse, BatchOperationMetadata> importProductSetsOperationCallable() {
        return this.stub.importProductSetsOperationCallable();
    }

    public final UnaryCallable<ImportProductSetsRequest, Operation> importProductSetsCallable() {
        return this.stub.importProductSetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListProductsInProductSetFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product, ListProductsInProductSetPage, ListProductsInProductSetFixedSizeCollection> {
        private ListProductsInProductSetFixedSizeCollection(List<ListProductsInProductSetPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProductsInProductSetFixedSizeCollection createEmptyCollection() {
            return new ListProductsInProductSetFixedSizeCollection(null, 0);
        }

        protected ListProductsInProductSetFixedSizeCollection createCollection(List<ListProductsInProductSetPage> pages, int collectionSize) {
            return new ListProductsInProductSetFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProductsInProductSetPage
    extends AbstractPage<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product, ListProductsInProductSetPage> {
        private ListProductsInProductSetPage(PageContext<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product> context, ListProductsInProductSetResponse response) {
            super(context, (Object)response);
        }

        private static ListProductsInProductSetPage createEmptyPage() {
            return new ListProductsInProductSetPage(null, null);
        }

        protected ListProductsInProductSetPage createPage(PageContext<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product> context, ListProductsInProductSetResponse response) {
            return new ListProductsInProductSetPage(context, response);
        }

        public ApiFuture<ListProductsInProductSetPage> createPageAsync(PageContext<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product> context, ApiFuture<ListProductsInProductSetResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProductsInProductSetPagedResponse
    extends AbstractPagedListResponse<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product, ListProductsInProductSetPage, ListProductsInProductSetFixedSizeCollection> {
        public static ApiFuture<ListProductsInProductSetPagedResponse> createAsync(PageContext<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product> context, ApiFuture<ListProductsInProductSetResponse> futureResponse) {
            ApiFuture<ListProductsInProductSetPage> futurePage = ListProductsInProductSetPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListProductsInProductSetPage, ListProductsInProductSetPagedResponse>(){

                public ListProductsInProductSetPagedResponse apply(ListProductsInProductSetPage input) {
                    return new ListProductsInProductSetPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListProductsInProductSetPagedResponse(ListProductsInProductSetPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProductsInProductSetFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReferenceImagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage, ListReferenceImagesPage, ListReferenceImagesFixedSizeCollection> {
        private ListReferenceImagesFixedSizeCollection(List<ListReferenceImagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReferenceImagesFixedSizeCollection createEmptyCollection() {
            return new ListReferenceImagesFixedSizeCollection(null, 0);
        }

        protected ListReferenceImagesFixedSizeCollection createCollection(List<ListReferenceImagesPage> pages, int collectionSize) {
            return new ListReferenceImagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReferenceImagesPage
    extends AbstractPage<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage, ListReferenceImagesPage> {
        private ListReferenceImagesPage(PageContext<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage> context, ListReferenceImagesResponse response) {
            super(context, (Object)response);
        }

        private static ListReferenceImagesPage createEmptyPage() {
            return new ListReferenceImagesPage(null, null);
        }

        protected ListReferenceImagesPage createPage(PageContext<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage> context, ListReferenceImagesResponse response) {
            return new ListReferenceImagesPage(context, response);
        }

        public ApiFuture<ListReferenceImagesPage> createPageAsync(PageContext<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage> context, ApiFuture<ListReferenceImagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReferenceImagesPagedResponse
    extends AbstractPagedListResponse<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage, ListReferenceImagesPage, ListReferenceImagesFixedSizeCollection> {
        public static ApiFuture<ListReferenceImagesPagedResponse> createAsync(PageContext<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage> context, ApiFuture<ListReferenceImagesResponse> futureResponse) {
            ApiFuture<ListReferenceImagesPage> futurePage = ListReferenceImagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListReferenceImagesPage, ListReferenceImagesPagedResponse>(){

                public ListReferenceImagesPagedResponse apply(ListReferenceImagesPage input) {
                    return new ListReferenceImagesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListReferenceImagesPagedResponse(ListReferenceImagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReferenceImagesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProductsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProductsRequest, ListProductsResponse, Product, ListProductsPage, ListProductsFixedSizeCollection> {
        private ListProductsFixedSizeCollection(List<ListProductsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProductsFixedSizeCollection createEmptyCollection() {
            return new ListProductsFixedSizeCollection(null, 0);
        }

        protected ListProductsFixedSizeCollection createCollection(List<ListProductsPage> pages, int collectionSize) {
            return new ListProductsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProductsPage
    extends AbstractPage<ListProductsRequest, ListProductsResponse, Product, ListProductsPage> {
        private ListProductsPage(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ListProductsResponse response) {
            super(context, (Object)response);
        }

        private static ListProductsPage createEmptyPage() {
            return new ListProductsPage(null, null);
        }

        protected ListProductsPage createPage(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ListProductsResponse response) {
            return new ListProductsPage(context, response);
        }

        public ApiFuture<ListProductsPage> createPageAsync(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ApiFuture<ListProductsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProductsPagedResponse
    extends AbstractPagedListResponse<ListProductsRequest, ListProductsResponse, Product, ListProductsPage, ListProductsFixedSizeCollection> {
        public static ApiFuture<ListProductsPagedResponse> createAsync(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ApiFuture<ListProductsResponse> futureResponse) {
            ApiFuture<ListProductsPage> futurePage = ListProductsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListProductsPage, ListProductsPagedResponse>(){

                public ListProductsPagedResponse apply(ListProductsPage input) {
                    return new ListProductsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListProductsPagedResponse(ListProductsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProductsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProductSetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProductSetsRequest, ListProductSetsResponse, ProductSet, ListProductSetsPage, ListProductSetsFixedSizeCollection> {
        private ListProductSetsFixedSizeCollection(List<ListProductSetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProductSetsFixedSizeCollection createEmptyCollection() {
            return new ListProductSetsFixedSizeCollection(null, 0);
        }

        protected ListProductSetsFixedSizeCollection createCollection(List<ListProductSetsPage> pages, int collectionSize) {
            return new ListProductSetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProductSetsPage
    extends AbstractPage<ListProductSetsRequest, ListProductSetsResponse, ProductSet, ListProductSetsPage> {
        private ListProductSetsPage(PageContext<ListProductSetsRequest, ListProductSetsResponse, ProductSet> context, ListProductSetsResponse response) {
            super(context, (Object)response);
        }

        private static ListProductSetsPage createEmptyPage() {
            return new ListProductSetsPage(null, null);
        }

        protected ListProductSetsPage createPage(PageContext<ListProductSetsRequest, ListProductSetsResponse, ProductSet> context, ListProductSetsResponse response) {
            return new ListProductSetsPage(context, response);
        }

        public ApiFuture<ListProductSetsPage> createPageAsync(PageContext<ListProductSetsRequest, ListProductSetsResponse, ProductSet> context, ApiFuture<ListProductSetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProductSetsPagedResponse
    extends AbstractPagedListResponse<ListProductSetsRequest, ListProductSetsResponse, ProductSet, ListProductSetsPage, ListProductSetsFixedSizeCollection> {
        public static ApiFuture<ListProductSetsPagedResponse> createAsync(PageContext<ListProductSetsRequest, ListProductSetsResponse, ProductSet> context, ApiFuture<ListProductSetsResponse> futureResponse) {
            ApiFuture<ListProductSetsPage> futurePage = ListProductSetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListProductSetsPage, ListProductSetsPagedResponse>(){

                public ListProductSetsPagedResponse apply(ListProductSetsPage input) {
                    return new ListProductSetsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListProductSetsPagedResponse(ListProductSetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProductSetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

