/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.spi.v1;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.vision.spi.v1.ImageAnnotatorSettings;
import com.google.cloud.vision.v1.AnnotateImageRequest;
import com.google.cloud.vision.v1.BatchAnnotateImagesRequest;
import com.google.cloud.vision.v1.BatchAnnotateImagesResponse;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class ImageAnnotatorApi
implements AutoCloseable {
    private final ImageAnnotatorSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<BatchAnnotateImagesRequest, BatchAnnotateImagesResponse> batchAnnotateImagesCallable;

    public static final ImageAnnotatorApi create() throws IOException {
        return ImageAnnotatorApi.create(ImageAnnotatorSettings.defaultBuilder().build());
    }

    public static final ImageAnnotatorApi create(ImageAnnotatorSettings settings) throws IOException {
        return new ImageAnnotatorApi(settings);
    }

    protected ImageAnnotatorApi(ImageAnnotatorSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.batchAnnotateImagesCallable = UnaryCallable.create(settings.batchAnnotateImagesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ImageAnnotatorApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ImageAnnotatorApi.this.executor.shutdown();
                }
            });
        }
    }

    public final ImageAnnotatorSettings getSettings() {
        return this.settings;
    }

    public final BatchAnnotateImagesResponse batchAnnotateImages(List<AnnotateImageRequest> requests) {
        BatchAnnotateImagesRequest request = BatchAnnotateImagesRequest.newBuilder().addAllRequests(requests).build();
        return this.batchAnnotateImages(request);
    }

    private final BatchAnnotateImagesResponse batchAnnotateImages(BatchAnnotateImagesRequest request) {
        return (BatchAnnotateImagesResponse)this.batchAnnotateImagesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchAnnotateImagesRequest, BatchAnnotateImagesResponse> batchAnnotateImagesCallable() {
        return this.batchAnnotateImagesCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

