/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.transcoder.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.video.transcoder.v1.CreateJobRequest;
import com.google.cloud.video.transcoder.v1.CreateJobTemplateRequest;
import com.google.cloud.video.transcoder.v1.DeleteJobRequest;
import com.google.cloud.video.transcoder.v1.DeleteJobTemplateRequest;
import com.google.cloud.video.transcoder.v1.GetJobRequest;
import com.google.cloud.video.transcoder.v1.GetJobTemplateRequest;
import com.google.cloud.video.transcoder.v1.Job;
import com.google.cloud.video.transcoder.v1.JobTemplate;
import com.google.cloud.video.transcoder.v1.ListJobTemplatesRequest;
import com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse;
import com.google.cloud.video.transcoder.v1.ListJobsRequest;
import com.google.cloud.video.transcoder.v1.ListJobsResponse;
import com.google.cloud.video.transcoder.v1.TranscoderServiceClient;
import com.google.cloud.video.transcoder.v1.stub.HttpJsonTranscoderServiceCallableFactory;
import com.google.cloud.video.transcoder.v1.stub.TranscoderServiceStub;
import com.google.cloud.video.transcoder.v1.stub.TranscoderServiceStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonTranscoderServiceStub
extends TranscoderServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateJobRequest, Job> createJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/CreateJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("job", (Message)request.getJob())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/ListJobs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListJobsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/GetJob").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteJobRequest, Empty> deleteJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/DeleteJob").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateJobTemplateRequest, JobTemplate> createJobTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/CreateJobTemplate").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/jobTemplates", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "jobTemplateId", (Object)request.getJobTemplateId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("jobTemplate", (Message)request.getJobTemplate())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)JobTemplate.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListJobTemplatesRequest, ListJobTemplatesResponse> listJobTemplatesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/ListJobTemplates").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/jobTemplates", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListJobTemplatesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetJobTemplateRequest, JobTemplate> getJobTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/GetJobTemplate").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/jobTemplates/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)JobTemplate.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteJobTemplateRequest, Empty> deleteJobTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/DeleteJobTemplate").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/jobTemplates/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateJobRequest, Job> createJobCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, TranscoderServiceClient.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable;
    private final UnaryCallable<CreateJobTemplateRequest, JobTemplate> createJobTemplateCallable;
    private final UnaryCallable<ListJobTemplatesRequest, ListJobTemplatesResponse> listJobTemplatesCallable;
    private final UnaryCallable<ListJobTemplatesRequest, TranscoderServiceClient.ListJobTemplatesPagedResponse> listJobTemplatesPagedCallable;
    private final UnaryCallable<GetJobTemplateRequest, JobTemplate> getJobTemplateCallable;
    private final UnaryCallable<DeleteJobTemplateRequest, Empty> deleteJobTemplateCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTranscoderServiceStub create(TranscoderServiceStubSettings settings) throws IOException {
        return new HttpJsonTranscoderServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTranscoderServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTranscoderServiceStub(TranscoderServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonTranscoderServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTranscoderServiceStub(TranscoderServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTranscoderServiceStub(TranscoderServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTranscoderServiceCallableFactory());
    }

    protected HttpJsonTranscoderServiceStub(TranscoderServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createJobTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createJobTemplateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listJobTemplatesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listJobTemplatesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getJobTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getJobTemplateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteJobTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteJobTemplateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createJobCallable = callableFactory.createUnaryCallable(createJobTransportSettings, settings.createJobSettings(), clientContext);
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.deleteJobCallable = callableFactory.createUnaryCallable(deleteJobTransportSettings, settings.deleteJobSettings(), clientContext);
        this.createJobTemplateCallable = callableFactory.createUnaryCallable(createJobTemplateTransportSettings, settings.createJobTemplateSettings(), clientContext);
        this.listJobTemplatesCallable = callableFactory.createUnaryCallable(listJobTemplatesTransportSettings, settings.listJobTemplatesSettings(), clientContext);
        this.listJobTemplatesPagedCallable = callableFactory.createPagedCallable(listJobTemplatesTransportSettings, settings.listJobTemplatesSettings(), clientContext);
        this.getJobTemplateCallable = callableFactory.createUnaryCallable(getJobTemplateTransportSettings, settings.getJobTemplateSettings(), clientContext);
        this.deleteJobTemplateCallable = callableFactory.createUnaryCallable(deleteJobTemplateTransportSettings, settings.deleteJobTemplateSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createJobMethodDescriptor);
        methodDescriptors.add(listJobsMethodDescriptor);
        methodDescriptors.add(getJobMethodDescriptor);
        methodDescriptors.add(deleteJobMethodDescriptor);
        methodDescriptors.add(createJobTemplateMethodDescriptor);
        methodDescriptors.add(listJobTemplatesMethodDescriptor);
        methodDescriptors.add(getJobTemplateMethodDescriptor);
        methodDescriptors.add(deleteJobTemplateMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.createJobCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, TranscoderServiceClient.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.deleteJobCallable;
    }

    @Override
    public UnaryCallable<CreateJobTemplateRequest, JobTemplate> createJobTemplateCallable() {
        return this.createJobTemplateCallable;
    }

    @Override
    public UnaryCallable<ListJobTemplatesRequest, ListJobTemplatesResponse> listJobTemplatesCallable() {
        return this.listJobTemplatesCallable;
    }

    @Override
    public UnaryCallable<ListJobTemplatesRequest, TranscoderServiceClient.ListJobTemplatesPagedResponse> listJobTemplatesPagedCallable() {
        return this.listJobTemplatesPagedCallable;
    }

    @Override
    public UnaryCallable<GetJobTemplateRequest, JobTemplate> getJobTemplateCallable() {
        return this.getJobTemplateCallable;
    }

    @Override
    public UnaryCallable<DeleteJobTemplateRequest, Empty> deleteJobTemplateCallable() {
        return this.deleteJobTemplateCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

