/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vectorsearch.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vectorsearch.v1beta.Collection;
import com.google.cloud.vectorsearch.v1beta.CreateCollectionRequest;
import com.google.cloud.vectorsearch.v1beta.CreateIndexRequest;
import com.google.cloud.vectorsearch.v1beta.DeleteCollectionRequest;
import com.google.cloud.vectorsearch.v1beta.DeleteIndexRequest;
import com.google.cloud.vectorsearch.v1beta.GetCollectionRequest;
import com.google.cloud.vectorsearch.v1beta.GetIndexRequest;
import com.google.cloud.vectorsearch.v1beta.ImportDataObjectsMetadata;
import com.google.cloud.vectorsearch.v1beta.ImportDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.ImportDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.Index;
import com.google.cloud.vectorsearch.v1beta.ListCollectionsRequest;
import com.google.cloud.vectorsearch.v1beta.ListCollectionsResponse;
import com.google.cloud.vectorsearch.v1beta.ListIndexesRequest;
import com.google.cloud.vectorsearch.v1beta.ListIndexesResponse;
import com.google.cloud.vectorsearch.v1beta.OperationMetadata;
import com.google.cloud.vectorsearch.v1beta.UpdateCollectionRequest;
import com.google.cloud.vectorsearch.v1beta.VectorSearchServiceClient;
import com.google.cloud.vectorsearch.v1beta.stub.GrpcVectorSearchServiceStub;
import com.google.cloud.vectorsearch.v1beta.stub.HttpJsonVectorSearchServiceStub;
import com.google.cloud.vectorsearch.v1beta.stub.VectorSearchServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Set;

@BetaApi
public class VectorSearchServiceStubSettings
extends StubSettings<VectorSearchServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListCollectionsRequest, ListCollectionsResponse, VectorSearchServiceClient.ListCollectionsPagedResponse> listCollectionsSettings;
    private final UnaryCallSettings<GetCollectionRequest, Collection> getCollectionSettings;
    private final UnaryCallSettings<CreateCollectionRequest, Operation> createCollectionSettings;
    private final OperationCallSettings<CreateCollectionRequest, Collection, OperationMetadata> createCollectionOperationSettings;
    private final UnaryCallSettings<UpdateCollectionRequest, Operation> updateCollectionSettings;
    private final OperationCallSettings<UpdateCollectionRequest, Collection, OperationMetadata> updateCollectionOperationSettings;
    private final UnaryCallSettings<DeleteCollectionRequest, Operation> deleteCollectionSettings;
    private final OperationCallSettings<DeleteCollectionRequest, Empty, OperationMetadata> deleteCollectionOperationSettings;
    private final PagedCallSettings<ListIndexesRequest, ListIndexesResponse, VectorSearchServiceClient.ListIndexesPagedResponse> listIndexesSettings;
    private final UnaryCallSettings<GetIndexRequest, Index> getIndexSettings;
    private final UnaryCallSettings<CreateIndexRequest, Operation> createIndexSettings;
    private final OperationCallSettings<CreateIndexRequest, Index, OperationMetadata> createIndexOperationSettings;
    private final UnaryCallSettings<DeleteIndexRequest, Operation> deleteIndexSettings;
    private final OperationCallSettings<DeleteIndexRequest, Empty, OperationMetadata> deleteIndexOperationSettings;
    private final UnaryCallSettings<ImportDataObjectsRequest, Operation> importDataObjectsSettings;
    private final OperationCallSettings<ImportDataObjectsRequest, ImportDataObjectsResponse, ImportDataObjectsMetadata> importDataObjectsOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, VectorSearchServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListCollectionsRequest, ListCollectionsResponse, Collection> LIST_COLLECTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListCollectionsRequest, ListCollectionsResponse, Collection>(){

        public String emptyToken() {
            return "";
        }

        public ListCollectionsRequest injectToken(ListCollectionsRequest payload, String token) {
            return ListCollectionsRequest.newBuilder((ListCollectionsRequest)payload).setPageToken(token).build();
        }

        public ListCollectionsRequest injectPageSize(ListCollectionsRequest payload, int pageSize) {
            return ListCollectionsRequest.newBuilder((ListCollectionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCollectionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCollectionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Collection> extractResources(ListCollectionsResponse payload) {
            return payload.getCollectionsList();
        }
    };
    private static final PagedListDescriptor<ListIndexesRequest, ListIndexesResponse, Index> LIST_INDEXES_PAGE_STR_DESC = new PagedListDescriptor<ListIndexesRequest, ListIndexesResponse, Index>(){

        public String emptyToken() {
            return "";
        }

        public ListIndexesRequest injectToken(ListIndexesRequest payload, String token) {
            return ListIndexesRequest.newBuilder((ListIndexesRequest)payload).setPageToken(token).build();
        }

        public ListIndexesRequest injectPageSize(ListIndexesRequest payload, int pageSize) {
            return ListIndexesRequest.newBuilder((ListIndexesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListIndexesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListIndexesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Index> extractResources(ListIndexesResponse payload) {
            return payload.getIndexesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListCollectionsRequest, ListCollectionsResponse, VectorSearchServiceClient.ListCollectionsPagedResponse> LIST_COLLECTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListCollectionsRequest, ListCollectionsResponse, VectorSearchServiceClient.ListCollectionsPagedResponse>(){

        public ApiFuture<VectorSearchServiceClient.ListCollectionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCollectionsRequest, ListCollectionsResponse> callable, ListCollectionsRequest request, ApiCallContext context, ApiFuture<ListCollectionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_COLLECTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VectorSearchServiceClient.ListCollectionsPagedResponse.createAsync((PageContext<ListCollectionsRequest, ListCollectionsResponse, Collection>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListIndexesRequest, ListIndexesResponse, VectorSearchServiceClient.ListIndexesPagedResponse> LIST_INDEXES_PAGE_STR_FACT = new PagedListResponseFactory<ListIndexesRequest, ListIndexesResponse, VectorSearchServiceClient.ListIndexesPagedResponse>(){

        public ApiFuture<VectorSearchServiceClient.ListIndexesPagedResponse> getFuturePagedResponse(UnaryCallable<ListIndexesRequest, ListIndexesResponse> callable, ListIndexesRequest request, ApiCallContext context, ApiFuture<ListIndexesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INDEXES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VectorSearchServiceClient.ListIndexesPagedResponse.createAsync((PageContext<ListIndexesRequest, ListIndexesResponse, Index>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, VectorSearchServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, VectorSearchServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<VectorSearchServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VectorSearchServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListCollectionsRequest, ListCollectionsResponse, VectorSearchServiceClient.ListCollectionsPagedResponse> listCollectionsSettings() {
        return this.listCollectionsSettings;
    }

    public UnaryCallSettings<GetCollectionRequest, Collection> getCollectionSettings() {
        return this.getCollectionSettings;
    }

    public UnaryCallSettings<CreateCollectionRequest, Operation> createCollectionSettings() {
        return this.createCollectionSettings;
    }

    public OperationCallSettings<CreateCollectionRequest, Collection, OperationMetadata> createCollectionOperationSettings() {
        return this.createCollectionOperationSettings;
    }

    public UnaryCallSettings<UpdateCollectionRequest, Operation> updateCollectionSettings() {
        return this.updateCollectionSettings;
    }

    public OperationCallSettings<UpdateCollectionRequest, Collection, OperationMetadata> updateCollectionOperationSettings() {
        return this.updateCollectionOperationSettings;
    }

    public UnaryCallSettings<DeleteCollectionRequest, Operation> deleteCollectionSettings() {
        return this.deleteCollectionSettings;
    }

    public OperationCallSettings<DeleteCollectionRequest, Empty, OperationMetadata> deleteCollectionOperationSettings() {
        return this.deleteCollectionOperationSettings;
    }

    public PagedCallSettings<ListIndexesRequest, ListIndexesResponse, VectorSearchServiceClient.ListIndexesPagedResponse> listIndexesSettings() {
        return this.listIndexesSettings;
    }

    public UnaryCallSettings<GetIndexRequest, Index> getIndexSettings() {
        return this.getIndexSettings;
    }

    public UnaryCallSettings<CreateIndexRequest, Operation> createIndexSettings() {
        return this.createIndexSettings;
    }

    public OperationCallSettings<CreateIndexRequest, Index, OperationMetadata> createIndexOperationSettings() {
        return this.createIndexOperationSettings;
    }

    public UnaryCallSettings<DeleteIndexRequest, Operation> deleteIndexSettings() {
        return this.deleteIndexSettings;
    }

    public OperationCallSettings<DeleteIndexRequest, Empty, OperationMetadata> deleteIndexOperationSettings() {
        return this.deleteIndexOperationSettings;
    }

    public UnaryCallSettings<ImportDataObjectsRequest, Operation> importDataObjectsSettings() {
        return this.importDataObjectsSettings;
    }

    public OperationCallSettings<ImportDataObjectsRequest, ImportDataObjectsResponse, ImportDataObjectsMetadata> importDataObjectsOperationSettings() {
        return this.importDataObjectsOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, VectorSearchServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public VectorSearchServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcVectorSearchServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonVectorSearchServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "vectorsearch";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "vectorsearch.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "vectorsearch.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return VectorSearchServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(VectorSearchServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(VectorSearchServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return VectorSearchServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected VectorSearchServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listCollectionsSettings = settingsBuilder.listCollectionsSettings().build();
        this.getCollectionSettings = settingsBuilder.getCollectionSettings().build();
        this.createCollectionSettings = settingsBuilder.createCollectionSettings().build();
        this.createCollectionOperationSettings = settingsBuilder.createCollectionOperationSettings().build();
        this.updateCollectionSettings = settingsBuilder.updateCollectionSettings().build();
        this.updateCollectionOperationSettings = settingsBuilder.updateCollectionOperationSettings().build();
        this.deleteCollectionSettings = settingsBuilder.deleteCollectionSettings().build();
        this.deleteCollectionOperationSettings = settingsBuilder.deleteCollectionOperationSettings().build();
        this.listIndexesSettings = settingsBuilder.listIndexesSettings().build();
        this.getIndexSettings = settingsBuilder.getIndexSettings().build();
        this.createIndexSettings = settingsBuilder.createIndexSettings().build();
        this.createIndexOperationSettings = settingsBuilder.createIndexOperationSettings().build();
        this.deleteIndexSettings = settingsBuilder.deleteIndexSettings().build();
        this.deleteIndexOperationSettings = settingsBuilder.deleteIndexOperationSettings().build();
        this.importDataObjectsSettings = settingsBuilder.importDataObjectsSettings().build();
        this.importDataObjectsOperationSettings = settingsBuilder.importDataObjectsOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<VectorSearchServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListCollectionsRequest, ListCollectionsResponse, VectorSearchServiceClient.ListCollectionsPagedResponse> listCollectionsSettings;
        private final UnaryCallSettings.Builder<GetCollectionRequest, Collection> getCollectionSettings;
        private final UnaryCallSettings.Builder<CreateCollectionRequest, Operation> createCollectionSettings;
        private final OperationCallSettings.Builder<CreateCollectionRequest, Collection, OperationMetadata> createCollectionOperationSettings;
        private final UnaryCallSettings.Builder<UpdateCollectionRequest, Operation> updateCollectionSettings;
        private final OperationCallSettings.Builder<UpdateCollectionRequest, Collection, OperationMetadata> updateCollectionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteCollectionRequest, Operation> deleteCollectionSettings;
        private final OperationCallSettings.Builder<DeleteCollectionRequest, Empty, OperationMetadata> deleteCollectionOperationSettings;
        private final PagedCallSettings.Builder<ListIndexesRequest, ListIndexesResponse, VectorSearchServiceClient.ListIndexesPagedResponse> listIndexesSettings;
        private final UnaryCallSettings.Builder<GetIndexRequest, Index> getIndexSettings;
        private final UnaryCallSettings.Builder<CreateIndexRequest, Operation> createIndexSettings;
        private final OperationCallSettings.Builder<CreateIndexRequest, Index, OperationMetadata> createIndexOperationSettings;
        private final UnaryCallSettings.Builder<DeleteIndexRequest, Operation> deleteIndexSettings;
        private final OperationCallSettings.Builder<DeleteIndexRequest, Empty, OperationMetadata> deleteIndexOperationSettings;
        private final UnaryCallSettings.Builder<ImportDataObjectsRequest, Operation> importDataObjectsSettings;
        private final OperationCallSettings.Builder<ImportDataObjectsRequest, ImportDataObjectsResponse, ImportDataObjectsMetadata> importDataObjectsOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, VectorSearchServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listCollectionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_COLLECTIONS_PAGE_STR_FACT);
            this.getCollectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCollectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCollectionOperationSettings = OperationCallSettings.newBuilder();
            this.updateCollectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCollectionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteCollectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCollectionOperationSettings = OperationCallSettings.newBuilder();
            this.listIndexesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INDEXES_PAGE_STR_FACT);
            this.getIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createIndexOperationSettings = OperationCallSettings.newBuilder();
            this.deleteIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteIndexOperationSettings = OperationCallSettings.newBuilder();
            this.importDataObjectsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importDataObjectsOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCollectionsSettings, this.getCollectionSettings, this.createCollectionSettings, this.updateCollectionSettings, this.deleteCollectionSettings, this.listIndexesSettings, this.getIndexSettings, this.createIndexSettings, this.deleteIndexSettings, this.importDataObjectsSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(VectorSearchServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listCollectionsSettings = settings.listCollectionsSettings.toBuilder();
            this.getCollectionSettings = settings.getCollectionSettings.toBuilder();
            this.createCollectionSettings = settings.createCollectionSettings.toBuilder();
            this.createCollectionOperationSettings = settings.createCollectionOperationSettings.toBuilder();
            this.updateCollectionSettings = settings.updateCollectionSettings.toBuilder();
            this.updateCollectionOperationSettings = settings.updateCollectionOperationSettings.toBuilder();
            this.deleteCollectionSettings = settings.deleteCollectionSettings.toBuilder();
            this.deleteCollectionOperationSettings = settings.deleteCollectionOperationSettings.toBuilder();
            this.listIndexesSettings = settings.listIndexesSettings.toBuilder();
            this.getIndexSettings = settings.getIndexSettings.toBuilder();
            this.createIndexSettings = settings.createIndexSettings.toBuilder();
            this.createIndexOperationSettings = settings.createIndexOperationSettings.toBuilder();
            this.deleteIndexSettings = settings.deleteIndexSettings.toBuilder();
            this.deleteIndexOperationSettings = settings.deleteIndexOperationSettings.toBuilder();
            this.importDataObjectsSettings = settings.importDataObjectsSettings.toBuilder();
            this.importDataObjectsOperationSettings = settings.importDataObjectsOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCollectionsSettings, this.getCollectionSettings, this.createCollectionSettings, this.updateCollectionSettings, this.deleteCollectionSettings, this.listIndexesSettings, this.getIndexSettings, this.createIndexSettings, this.deleteIndexSettings, this.importDataObjectsSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(VectorSearchServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)VectorSearchServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)VectorSearchServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(VectorSearchServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)VectorSearchServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)VectorSearchServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)VectorSearchServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(VectorSearchServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listCollectionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCollectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCollectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.updateCollectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.deleteCollectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.listIndexesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.deleteIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.importDataObjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createCollectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Collection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateCollectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Collection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteCollectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createIndexOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Index.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteIndexOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.importDataObjectsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportDataObjectsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportDataObjectsMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListCollectionsRequest, ListCollectionsResponse, VectorSearchServiceClient.ListCollectionsPagedResponse> listCollectionsSettings() {
            return this.listCollectionsSettings;
        }

        public UnaryCallSettings.Builder<GetCollectionRequest, Collection> getCollectionSettings() {
            return this.getCollectionSettings;
        }

        public UnaryCallSettings.Builder<CreateCollectionRequest, Operation> createCollectionSettings() {
            return this.createCollectionSettings;
        }

        public OperationCallSettings.Builder<CreateCollectionRequest, Collection, OperationMetadata> createCollectionOperationSettings() {
            return this.createCollectionOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateCollectionRequest, Operation> updateCollectionSettings() {
            return this.updateCollectionSettings;
        }

        public OperationCallSettings.Builder<UpdateCollectionRequest, Collection, OperationMetadata> updateCollectionOperationSettings() {
            return this.updateCollectionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteCollectionRequest, Operation> deleteCollectionSettings() {
            return this.deleteCollectionSettings;
        }

        public OperationCallSettings.Builder<DeleteCollectionRequest, Empty, OperationMetadata> deleteCollectionOperationSettings() {
            return this.deleteCollectionOperationSettings;
        }

        public PagedCallSettings.Builder<ListIndexesRequest, ListIndexesResponse, VectorSearchServiceClient.ListIndexesPagedResponse> listIndexesSettings() {
            return this.listIndexesSettings;
        }

        public UnaryCallSettings.Builder<GetIndexRequest, Index> getIndexSettings() {
            return this.getIndexSettings;
        }

        public UnaryCallSettings.Builder<CreateIndexRequest, Operation> createIndexSettings() {
            return this.createIndexSettings;
        }

        public OperationCallSettings.Builder<CreateIndexRequest, Index, OperationMetadata> createIndexOperationSettings() {
            return this.createIndexOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteIndexRequest, Operation> deleteIndexSettings() {
            return this.deleteIndexSettings;
        }

        public OperationCallSettings.Builder<DeleteIndexRequest, Empty, OperationMetadata> deleteIndexOperationSettings() {
            return this.deleteIndexOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportDataObjectsRequest, Operation> importDataObjectsSettings() {
            return this.importDataObjectsSettings;
        }

        public OperationCallSettings.Builder<ImportDataObjectsRequest, ImportDataObjectsResponse, ImportDataObjectsMetadata> importDataObjectsOperationSettings() {
            return this.importDataObjectsOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, VectorSearchServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public VectorSearchServiceStubSettings build() throws IOException {
            return new VectorSearchServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((java.util.Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((java.util.Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((java.util.Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

