/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vectorsearch.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vectorsearch.v1beta.AggregateDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.AggregateDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.BatchSearchDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.BatchSearchDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.DataObjectSearchServiceClient;
import com.google.cloud.vectorsearch.v1beta.QueryDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.QueryDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.SearchDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.SearchDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.stub.DataObjectSearchServiceStub;
import com.google.cloud.vectorsearch.v1beta.stub.DataObjectSearchServiceStubSettings;
import com.google.cloud.vectorsearch.v1beta.stub.GrpcDataObjectSearchServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDataObjectSearchServiceStub
extends DataObjectSearchServiceStub {
    private static final MethodDescriptor<SearchDataObjectsRequest, SearchDataObjectsResponse> searchDataObjectsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vectorsearch.v1beta.DataObjectSearchService/SearchDataObjects").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchDataObjectsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchDataObjectsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<QueryDataObjectsRequest, QueryDataObjectsResponse> queryDataObjectsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vectorsearch.v1beta.DataObjectSearchService/QueryDataObjects").setRequestMarshaller(ProtoUtils.marshaller((Message)QueryDataObjectsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)QueryDataObjectsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<AggregateDataObjectsRequest, AggregateDataObjectsResponse> aggregateDataObjectsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vectorsearch.v1beta.DataObjectSearchService/AggregateDataObjects").setRequestMarshaller(ProtoUtils.marshaller((Message)AggregateDataObjectsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AggregateDataObjectsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<BatchSearchDataObjectsRequest, BatchSearchDataObjectsResponse> batchSearchDataObjectsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vectorsearch.v1beta.DataObjectSearchService/BatchSearchDataObjects").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchSearchDataObjectsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BatchSearchDataObjectsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<SearchDataObjectsRequest, SearchDataObjectsResponse> searchDataObjectsCallable;
    private final UnaryCallable<SearchDataObjectsRequest, DataObjectSearchServiceClient.SearchDataObjectsPagedResponse> searchDataObjectsPagedCallable;
    private final UnaryCallable<QueryDataObjectsRequest, QueryDataObjectsResponse> queryDataObjectsCallable;
    private final UnaryCallable<QueryDataObjectsRequest, DataObjectSearchServiceClient.QueryDataObjectsPagedResponse> queryDataObjectsPagedCallable;
    private final UnaryCallable<AggregateDataObjectsRequest, AggregateDataObjectsResponse> aggregateDataObjectsCallable;
    private final UnaryCallable<BatchSearchDataObjectsRequest, BatchSearchDataObjectsResponse> batchSearchDataObjectsCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DataObjectSearchServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDataObjectSearchServiceStub create(DataObjectSearchServiceStubSettings settings) throws IOException {
        return new GrpcDataObjectSearchServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDataObjectSearchServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDataObjectSearchServiceStub(DataObjectSearchServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDataObjectSearchServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDataObjectSearchServiceStub(DataObjectSearchServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDataObjectSearchServiceStub(DataObjectSearchServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDataObjectSearchServiceCallableFactory());
    }

    protected GrpcDataObjectSearchServiceStub(DataObjectSearchServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings searchDataObjectsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchDataObjectsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings queryDataObjectsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(queryDataObjectsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings aggregateDataObjectsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(aggregateDataObjectsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings batchSearchDataObjectsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchSearchDataObjectsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.searchDataObjectsCallable = callableFactory.createUnaryCallable(searchDataObjectsTransportSettings, settings.searchDataObjectsSettings(), clientContext);
        this.searchDataObjectsPagedCallable = callableFactory.createPagedCallable(searchDataObjectsTransportSettings, settings.searchDataObjectsSettings(), clientContext);
        this.queryDataObjectsCallable = callableFactory.createUnaryCallable(queryDataObjectsTransportSettings, settings.queryDataObjectsSettings(), clientContext);
        this.queryDataObjectsPagedCallable = callableFactory.createPagedCallable(queryDataObjectsTransportSettings, settings.queryDataObjectsSettings(), clientContext);
        this.aggregateDataObjectsCallable = callableFactory.createUnaryCallable(aggregateDataObjectsTransportSettings, settings.aggregateDataObjectsSettings(), clientContext);
        this.batchSearchDataObjectsCallable = callableFactory.createUnaryCallable(batchSearchDataObjectsTransportSettings, settings.batchSearchDataObjectsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<SearchDataObjectsRequest, SearchDataObjectsResponse> searchDataObjectsCallable() {
        return this.searchDataObjectsCallable;
    }

    @Override
    public UnaryCallable<SearchDataObjectsRequest, DataObjectSearchServiceClient.SearchDataObjectsPagedResponse> searchDataObjectsPagedCallable() {
        return this.searchDataObjectsPagedCallable;
    }

    @Override
    public UnaryCallable<QueryDataObjectsRequest, QueryDataObjectsResponse> queryDataObjectsCallable() {
        return this.queryDataObjectsCallable;
    }

    @Override
    public UnaryCallable<QueryDataObjectsRequest, DataObjectSearchServiceClient.QueryDataObjectsPagedResponse> queryDataObjectsPagedCallable() {
        return this.queryDataObjectsPagedCallable;
    }

    @Override
    public UnaryCallable<AggregateDataObjectsRequest, AggregateDataObjectsResponse> aggregateDataObjectsCallable() {
        return this.aggregateDataObjectsCallable;
    }

    @Override
    public UnaryCallable<BatchSearchDataObjectsRequest, BatchSearchDataObjectsResponse> batchSearchDataObjectsCallable() {
        return this.batchSearchDataObjectsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DataObjectSearchServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

