/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.memorystore.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.memorystore.v1.Backup;
import com.google.cloud.memorystore.v1.BackupCollection;
import com.google.cloud.memorystore.v1.BackupCollectionName;
import com.google.cloud.memorystore.v1.BackupInstanceRequest;
import com.google.cloud.memorystore.v1.BackupName;
import com.google.cloud.memorystore.v1.CertificateAuthority;
import com.google.cloud.memorystore.v1.CreateInstanceRequest;
import com.google.cloud.memorystore.v1.DeleteBackupRequest;
import com.google.cloud.memorystore.v1.DeleteInstanceRequest;
import com.google.cloud.memorystore.v1.ExportBackupRequest;
import com.google.cloud.memorystore.v1.GetBackupCollectionRequest;
import com.google.cloud.memorystore.v1.GetBackupRequest;
import com.google.cloud.memorystore.v1.GetCertificateAuthorityRequest;
import com.google.cloud.memorystore.v1.GetInstanceRequest;
import com.google.cloud.memorystore.v1.Instance;
import com.google.cloud.memorystore.v1.InstanceName;
import com.google.cloud.memorystore.v1.ListBackupCollectionsRequest;
import com.google.cloud.memorystore.v1.ListBackupCollectionsResponse;
import com.google.cloud.memorystore.v1.ListBackupsRequest;
import com.google.cloud.memorystore.v1.ListBackupsResponse;
import com.google.cloud.memorystore.v1.ListInstancesRequest;
import com.google.cloud.memorystore.v1.ListInstancesResponse;
import com.google.cloud.memorystore.v1.LocationName;
import com.google.cloud.memorystore.v1.MemorystoreSettings;
import com.google.cloud.memorystore.v1.OperationMetadata;
import com.google.cloud.memorystore.v1.RescheduleMaintenanceRequest;
import com.google.cloud.memorystore.v1.UpdateInstanceRequest;
import com.google.cloud.memorystore.v1.stub.MemorystoreStub;
import com.google.cloud.memorystore.v1.stub.MemorystoreStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MemorystoreClient
implements BackgroundResource {
    private final MemorystoreSettings settings;
    private final MemorystoreStub stub;
    private final OperationsClient httpJsonOperationsClient;

    public static final MemorystoreClient create() throws IOException {
        return MemorystoreClient.create(MemorystoreSettings.newBuilder().build());
    }

    public static final MemorystoreClient create(MemorystoreSettings settings) throws IOException {
        return new MemorystoreClient(settings);
    }

    public static final MemorystoreClient create(MemorystoreStub stub) {
        return new MemorystoreClient(stub);
    }

    protected MemorystoreClient(MemorystoreSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MemorystoreStubSettings)settings.getStubSettings()).createStub();
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected MemorystoreClient(MemorystoreStub stub) {
        this.settings = null;
        this.stub = stub;
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final MemorystoreSettings getSettings() {
        return this.settings;
    }

    public MemorystoreStub getStub() {
        return this.stub;
    }

    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListInstancesPagedResponse listInstances(LocationName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(LocationName parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(String parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(CreateInstanceRequest request) {
        return this.createInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.stub.createInstanceOperationCallable();
    }

    public final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.stub.createInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(Instance instance, FieldMask updateMask) {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setInstance(instance).setUpdateMask(updateMask).build();
        return this.updateInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(UpdateInstanceRequest request) {
        return this.updateInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.stub.updateInstanceOperationCallable();
    }

    public final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.stub.updateInstanceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(InstanceName name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(String name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(DeleteInstanceRequest request) {
        return this.deleteInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.stub.deleteInstanceOperationCallable();
    }

    public final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    public final CertificateAuthority getCertificateAuthority(InstanceName name) {
        GetCertificateAuthorityRequest request = GetCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCertificateAuthority(request);
    }

    public final CertificateAuthority getCertificateAuthority(String name) {
        GetCertificateAuthorityRequest request = GetCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.getCertificateAuthority(request);
    }

    public final CertificateAuthority getCertificateAuthority(GetCertificateAuthorityRequest request) {
        return (CertificateAuthority)this.getCertificateAuthorityCallable().call((Object)request);
    }

    public final UnaryCallable<GetCertificateAuthorityRequest, CertificateAuthority> getCertificateAuthorityCallable() {
        return this.stub.getCertificateAuthorityCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> rescheduleMaintenanceAsync(InstanceName name, RescheduleMaintenanceRequest.RescheduleType rescheduleType, Timestamp scheduleTime) {
        RescheduleMaintenanceRequest request = RescheduleMaintenanceRequest.newBuilder().setName(name == null ? null : name.toString()).setRescheduleType(rescheduleType).setScheduleTime(scheduleTime).build();
        return this.rescheduleMaintenanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> rescheduleMaintenanceAsync(String name, RescheduleMaintenanceRequest.RescheduleType rescheduleType, Timestamp scheduleTime) {
        RescheduleMaintenanceRequest request = RescheduleMaintenanceRequest.newBuilder().setName(name).setRescheduleType(rescheduleType).setScheduleTime(scheduleTime).build();
        return this.rescheduleMaintenanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> rescheduleMaintenanceAsync(RescheduleMaintenanceRequest request) {
        return this.rescheduleMaintenanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RescheduleMaintenanceRequest, Instance, OperationMetadata> rescheduleMaintenanceOperationCallable() {
        return this.stub.rescheduleMaintenanceOperationCallable();
    }

    public final UnaryCallable<RescheduleMaintenanceRequest, Operation> rescheduleMaintenanceCallable() {
        return this.stub.rescheduleMaintenanceCallable();
    }

    public final ListBackupCollectionsPagedResponse listBackupCollections(LocationName parent) {
        ListBackupCollectionsRequest request = ListBackupCollectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackupCollections(request);
    }

    public final ListBackupCollectionsPagedResponse listBackupCollections(String parent) {
        ListBackupCollectionsRequest request = ListBackupCollectionsRequest.newBuilder().setParent(parent).build();
        return this.listBackupCollections(request);
    }

    public final ListBackupCollectionsPagedResponse listBackupCollections(ListBackupCollectionsRequest request) {
        return (ListBackupCollectionsPagedResponse)((Object)this.listBackupCollectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupCollectionsRequest, ListBackupCollectionsPagedResponse> listBackupCollectionsPagedCallable() {
        return this.stub.listBackupCollectionsPagedCallable();
    }

    public final UnaryCallable<ListBackupCollectionsRequest, ListBackupCollectionsResponse> listBackupCollectionsCallable() {
        return this.stub.listBackupCollectionsCallable();
    }

    public final BackupCollection getBackupCollection(BackupCollectionName name) {
        GetBackupCollectionRequest request = GetBackupCollectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackupCollection(request);
    }

    public final BackupCollection getBackupCollection(String name) {
        GetBackupCollectionRequest request = GetBackupCollectionRequest.newBuilder().setName(name).build();
        return this.getBackupCollection(request);
    }

    public final BackupCollection getBackupCollection(GetBackupCollectionRequest request) {
        return (BackupCollection)this.getBackupCollectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupCollectionRequest, BackupCollection> getBackupCollectionCallable() {
        return this.stub.getBackupCollectionCallable();
    }

    public final ListBackupsPagedResponse listBackups(BackupCollectionName parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(String parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(ListBackupsRequest request) {
        return (ListBackupsPagedResponse)((Object)this.listBackupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsPagedResponse> listBackupsPagedCallable() {
        return this.stub.listBackupsPagedCallable();
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.stub.listBackupsCallable();
    }

    public final Backup getBackup(BackupName name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(String name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(GetBackupRequest request) {
        return (Backup)this.getBackupCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.stub.getBackupCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(BackupName name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBackupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(String name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name).build();
        return this.deleteBackupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(DeleteBackupRequest request) {
        return this.deleteBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationCallable() {
        return this.stub.deleteBackupOperationCallable();
    }

    public final UnaryCallable<DeleteBackupRequest, Operation> deleteBackupCallable() {
        return this.stub.deleteBackupCallable();
    }

    public final OperationFuture<Backup, OperationMetadata> exportBackupAsync(ExportBackupRequest request) {
        return this.exportBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportBackupRequest, Backup, OperationMetadata> exportBackupOperationCallable() {
        return this.stub.exportBackupOperationCallable();
    }

    public final UnaryCallable<ExportBackupRequest, Operation> exportBackupCallable() {
        return this.stub.exportBackupCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> backupInstanceAsync(InstanceName name) {
        BackupInstanceRequest request = BackupInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.backupInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> backupInstanceAsync(String name) {
        BackupInstanceRequest request = BackupInstanceRequest.newBuilder().setName(name).build();
        return this.backupInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> backupInstanceAsync(BackupInstanceRequest request) {
        return this.backupInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BackupInstanceRequest, Instance, OperationMetadata> backupInstanceOperationCallable() {
        return this.stub.backupInstanceOperationCallable();
    }

    public final UnaryCallable<BackupInstanceRequest, Operation> backupInstanceCallable() {
        return this.stub.backupInstanceCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        private ListBackupsFixedSizeCollection(List<ListBackupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupsFixedSizeCollection createEmptyCollection() {
            return new ListBackupsFixedSizeCollection(null, 0);
        }

        protected ListBackupsFixedSizeCollection createCollection(List<ListBackupsPage> pages, int collectionSize) {
            return new ListBackupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupsPage
    extends AbstractPage<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage> {
        private ListBackupsPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupsPage createEmptyPage() {
            return new ListBackupsPage(null, null);
        }

        protected ListBackupsPage createPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            return new ListBackupsPage(context, response);
        }

        public ApiFuture<ListBackupsPage> createPageAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupsPagedResponse
    extends AbstractPagedListResponse<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        public static ApiFuture<ListBackupsPagedResponse> createAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            ApiFuture<ListBackupsPage> futurePage = ListBackupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupsPagedResponse((ListBackupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupsPagedResponse(ListBackupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupCollectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupCollectionsRequest, ListBackupCollectionsResponse, BackupCollection, ListBackupCollectionsPage, ListBackupCollectionsFixedSizeCollection> {
        private ListBackupCollectionsFixedSizeCollection(List<ListBackupCollectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupCollectionsFixedSizeCollection createEmptyCollection() {
            return new ListBackupCollectionsFixedSizeCollection(null, 0);
        }

        protected ListBackupCollectionsFixedSizeCollection createCollection(List<ListBackupCollectionsPage> pages, int collectionSize) {
            return new ListBackupCollectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupCollectionsPage
    extends AbstractPage<ListBackupCollectionsRequest, ListBackupCollectionsResponse, BackupCollection, ListBackupCollectionsPage> {
        private ListBackupCollectionsPage(PageContext<ListBackupCollectionsRequest, ListBackupCollectionsResponse, BackupCollection> context, ListBackupCollectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupCollectionsPage createEmptyPage() {
            return new ListBackupCollectionsPage(null, null);
        }

        protected ListBackupCollectionsPage createPage(PageContext<ListBackupCollectionsRequest, ListBackupCollectionsResponse, BackupCollection> context, ListBackupCollectionsResponse response) {
            return new ListBackupCollectionsPage(context, response);
        }

        public ApiFuture<ListBackupCollectionsPage> createPageAsync(PageContext<ListBackupCollectionsRequest, ListBackupCollectionsResponse, BackupCollection> context, ApiFuture<ListBackupCollectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupCollectionsPagedResponse
    extends AbstractPagedListResponse<ListBackupCollectionsRequest, ListBackupCollectionsResponse, BackupCollection, ListBackupCollectionsPage, ListBackupCollectionsFixedSizeCollection> {
        public static ApiFuture<ListBackupCollectionsPagedResponse> createAsync(PageContext<ListBackupCollectionsRequest, ListBackupCollectionsResponse, BackupCollection> context, ApiFuture<ListBackupCollectionsResponse> futureResponse) {
            ApiFuture<ListBackupCollectionsPage> futurePage = ListBackupCollectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupCollectionsPagedResponse((ListBackupCollectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupCollectionsPagedResponse(ListBackupCollectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupCollectionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }
}

