/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.translate.v3.AdaptiveMtDataset;
import com.google.cloud.translate.v3.AdaptiveMtFile;
import com.google.cloud.translate.v3.AdaptiveMtSentence;
import com.google.cloud.translate.v3.AdaptiveMtTranslateRequest;
import com.google.cloud.translate.v3.AdaptiveMtTranslateResponse;
import com.google.cloud.translate.v3.BatchTranslateDocumentMetadata;
import com.google.cloud.translate.v3.BatchTranslateDocumentRequest;
import com.google.cloud.translate.v3.BatchTranslateDocumentResponse;
import com.google.cloud.translate.v3.BatchTranslateMetadata;
import com.google.cloud.translate.v3.BatchTranslateResponse;
import com.google.cloud.translate.v3.BatchTranslateTextRequest;
import com.google.cloud.translate.v3.CreateAdaptiveMtDatasetRequest;
import com.google.cloud.translate.v3.CreateDatasetMetadata;
import com.google.cloud.translate.v3.CreateDatasetRequest;
import com.google.cloud.translate.v3.CreateGlossaryEntryRequest;
import com.google.cloud.translate.v3.CreateGlossaryMetadata;
import com.google.cloud.translate.v3.CreateGlossaryRequest;
import com.google.cloud.translate.v3.CreateModelMetadata;
import com.google.cloud.translate.v3.CreateModelRequest;
import com.google.cloud.translate.v3.Dataset;
import com.google.cloud.translate.v3.DeleteAdaptiveMtDatasetRequest;
import com.google.cloud.translate.v3.DeleteAdaptiveMtFileRequest;
import com.google.cloud.translate.v3.DeleteDatasetMetadata;
import com.google.cloud.translate.v3.DeleteDatasetRequest;
import com.google.cloud.translate.v3.DeleteGlossaryEntryRequest;
import com.google.cloud.translate.v3.DeleteGlossaryMetadata;
import com.google.cloud.translate.v3.DeleteGlossaryRequest;
import com.google.cloud.translate.v3.DeleteGlossaryResponse;
import com.google.cloud.translate.v3.DeleteModelMetadata;
import com.google.cloud.translate.v3.DeleteModelRequest;
import com.google.cloud.translate.v3.DetectLanguageRequest;
import com.google.cloud.translate.v3.DetectLanguageResponse;
import com.google.cloud.translate.v3.Example;
import com.google.cloud.translate.v3.ExportDataMetadata;
import com.google.cloud.translate.v3.ExportDataRequest;
import com.google.cloud.translate.v3.GetAdaptiveMtDatasetRequest;
import com.google.cloud.translate.v3.GetAdaptiveMtFileRequest;
import com.google.cloud.translate.v3.GetDatasetRequest;
import com.google.cloud.translate.v3.GetGlossaryEntryRequest;
import com.google.cloud.translate.v3.GetGlossaryRequest;
import com.google.cloud.translate.v3.GetModelRequest;
import com.google.cloud.translate.v3.GetSupportedLanguagesRequest;
import com.google.cloud.translate.v3.Glossary;
import com.google.cloud.translate.v3.GlossaryEntry;
import com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest;
import com.google.cloud.translate.v3.ImportAdaptiveMtFileResponse;
import com.google.cloud.translate.v3.ImportDataMetadata;
import com.google.cloud.translate.v3.ImportDataRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtDatasetsRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtDatasetsResponse;
import com.google.cloud.translate.v3.ListAdaptiveMtFilesRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse;
import com.google.cloud.translate.v3.ListAdaptiveMtSentencesRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtSentencesResponse;
import com.google.cloud.translate.v3.ListDatasetsRequest;
import com.google.cloud.translate.v3.ListDatasetsResponse;
import com.google.cloud.translate.v3.ListExamplesRequest;
import com.google.cloud.translate.v3.ListExamplesResponse;
import com.google.cloud.translate.v3.ListGlossariesRequest;
import com.google.cloud.translate.v3.ListGlossariesResponse;
import com.google.cloud.translate.v3.ListGlossaryEntriesRequest;
import com.google.cloud.translate.v3.ListGlossaryEntriesResponse;
import com.google.cloud.translate.v3.ListModelsRequest;
import com.google.cloud.translate.v3.ListModelsResponse;
import com.google.cloud.translate.v3.Model;
import com.google.cloud.translate.v3.RomanizeTextRequest;
import com.google.cloud.translate.v3.RomanizeTextResponse;
import com.google.cloud.translate.v3.SupportedLanguages;
import com.google.cloud.translate.v3.TranslateDocumentRequest;
import com.google.cloud.translate.v3.TranslateDocumentResponse;
import com.google.cloud.translate.v3.TranslateTextRequest;
import com.google.cloud.translate.v3.TranslateTextResponse;
import com.google.cloud.translate.v3.TranslationServiceClient;
import com.google.cloud.translate.v3.UpdateGlossaryEntryRequest;
import com.google.cloud.translate.v3.UpdateGlossaryMetadata;
import com.google.cloud.translate.v3.UpdateGlossaryRequest;
import com.google.cloud.translate.v3.stub.GrpcTranslationServiceStub;
import com.google.cloud.translate.v3.stub.HttpJsonTranslationServiceStub;
import com.google.cloud.translate.v3.stub.TranslationServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TranslationServiceStubSettings
extends StubSettings<TranslationServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-translation").build();
    private final UnaryCallSettings<TranslateTextRequest, TranslateTextResponse> translateTextSettings;
    private final UnaryCallSettings<RomanizeTextRequest, RomanizeTextResponse> romanizeTextSettings;
    private final UnaryCallSettings<DetectLanguageRequest, DetectLanguageResponse> detectLanguageSettings;
    private final UnaryCallSettings<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesSettings;
    private final UnaryCallSettings<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentSettings;
    private final UnaryCallSettings<BatchTranslateTextRequest, Operation> batchTranslateTextSettings;
    private final OperationCallSettings<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationSettings;
    private final UnaryCallSettings<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentSettings;
    private final OperationCallSettings<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationSettings;
    private final UnaryCallSettings<CreateGlossaryRequest, Operation> createGlossarySettings;
    private final OperationCallSettings<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationSettings;
    private final UnaryCallSettings<UpdateGlossaryRequest, Operation> updateGlossarySettings;
    private final OperationCallSettings<UpdateGlossaryRequest, Glossary, UpdateGlossaryMetadata> updateGlossaryOperationSettings;
    private final PagedCallSettings<ListGlossariesRequest, ListGlossariesResponse, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesSettings;
    private final UnaryCallSettings<GetGlossaryRequest, Glossary> getGlossarySettings;
    private final UnaryCallSettings<DeleteGlossaryRequest, Operation> deleteGlossarySettings;
    private final OperationCallSettings<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationSettings;
    private final UnaryCallSettings<GetGlossaryEntryRequest, GlossaryEntry> getGlossaryEntrySettings;
    private final PagedCallSettings<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, TranslationServiceClient.ListGlossaryEntriesPagedResponse> listGlossaryEntriesSettings;
    private final UnaryCallSettings<CreateGlossaryEntryRequest, GlossaryEntry> createGlossaryEntrySettings;
    private final UnaryCallSettings<UpdateGlossaryEntryRequest, GlossaryEntry> updateGlossaryEntrySettings;
    private final UnaryCallSettings<DeleteGlossaryEntryRequest, Empty> deleteGlossaryEntrySettings;
    private final UnaryCallSettings<CreateDatasetRequest, Operation> createDatasetSettings;
    private final OperationCallSettings<CreateDatasetRequest, Dataset, CreateDatasetMetadata> createDatasetOperationSettings;
    private final UnaryCallSettings<GetDatasetRequest, Dataset> getDatasetSettings;
    private final PagedCallSettings<ListDatasetsRequest, ListDatasetsResponse, TranslationServiceClient.ListDatasetsPagedResponse> listDatasetsSettings;
    private final UnaryCallSettings<DeleteDatasetRequest, Operation> deleteDatasetSettings;
    private final OperationCallSettings<DeleteDatasetRequest, Empty, DeleteDatasetMetadata> deleteDatasetOperationSettings;
    private final UnaryCallSettings<CreateAdaptiveMtDatasetRequest, AdaptiveMtDataset> createAdaptiveMtDatasetSettings;
    private final UnaryCallSettings<DeleteAdaptiveMtDatasetRequest, Empty> deleteAdaptiveMtDatasetSettings;
    private final UnaryCallSettings<GetAdaptiveMtDatasetRequest, AdaptiveMtDataset> getAdaptiveMtDatasetSettings;
    private final PagedCallSettings<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, TranslationServiceClient.ListAdaptiveMtDatasetsPagedResponse> listAdaptiveMtDatasetsSettings;
    private final UnaryCallSettings<AdaptiveMtTranslateRequest, AdaptiveMtTranslateResponse> adaptiveMtTranslateSettings;
    private final UnaryCallSettings<GetAdaptiveMtFileRequest, AdaptiveMtFile> getAdaptiveMtFileSettings;
    private final UnaryCallSettings<DeleteAdaptiveMtFileRequest, Empty> deleteAdaptiveMtFileSettings;
    private final UnaryCallSettings<ImportAdaptiveMtFileRequest, ImportAdaptiveMtFileResponse> importAdaptiveMtFileSettings;
    private final PagedCallSettings<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, TranslationServiceClient.ListAdaptiveMtFilesPagedResponse> listAdaptiveMtFilesSettings;
    private final PagedCallSettings<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, TranslationServiceClient.ListAdaptiveMtSentencesPagedResponse> listAdaptiveMtSentencesSettings;
    private final UnaryCallSettings<ImportDataRequest, Operation> importDataSettings;
    private final OperationCallSettings<ImportDataRequest, Empty, ImportDataMetadata> importDataOperationSettings;
    private final UnaryCallSettings<ExportDataRequest, Operation> exportDataSettings;
    private final OperationCallSettings<ExportDataRequest, Empty, ExportDataMetadata> exportDataOperationSettings;
    private final PagedCallSettings<ListExamplesRequest, ListExamplesResponse, TranslationServiceClient.ListExamplesPagedResponse> listExamplesSettings;
    private final UnaryCallSettings<CreateModelRequest, Operation> createModelSettings;
    private final OperationCallSettings<CreateModelRequest, Model, CreateModelMetadata> createModelOperationSettings;
    private final PagedCallSettings<ListModelsRequest, ListModelsResponse, TranslationServiceClient.ListModelsPagedResponse> listModelsSettings;
    private final UnaryCallSettings<GetModelRequest, Model> getModelSettings;
    private final UnaryCallSettings<DeleteModelRequest, Operation> deleteModelSettings;
    private final OperationCallSettings<DeleteModelRequest, Empty, DeleteModelMetadata> deleteModelOperationSettings;
    private static final PagedListDescriptor<ListGlossariesRequest, ListGlossariesResponse, Glossary> LIST_GLOSSARIES_PAGE_STR_DESC = new PagedListDescriptor<ListGlossariesRequest, ListGlossariesResponse, Glossary>(){

        public String emptyToken() {
            return "";
        }

        public ListGlossariesRequest injectToken(ListGlossariesRequest payload, String token) {
            return ListGlossariesRequest.newBuilder((ListGlossariesRequest)payload).setPageToken(token).build();
        }

        public ListGlossariesRequest injectPageSize(ListGlossariesRequest payload, int pageSize) {
            return ListGlossariesRequest.newBuilder((ListGlossariesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGlossariesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGlossariesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Glossary> extractResources(ListGlossariesResponse payload) {
            return payload.getGlossariesList();
        }
    };
    private static final PagedListDescriptor<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, GlossaryEntry> LIST_GLOSSARY_ENTRIES_PAGE_STR_DESC = new PagedListDescriptor<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, GlossaryEntry>(){

        public String emptyToken() {
            return "";
        }

        public ListGlossaryEntriesRequest injectToken(ListGlossaryEntriesRequest payload, String token) {
            return ListGlossaryEntriesRequest.newBuilder((ListGlossaryEntriesRequest)payload).setPageToken(token).build();
        }

        public ListGlossaryEntriesRequest injectPageSize(ListGlossaryEntriesRequest payload, int pageSize) {
            return ListGlossaryEntriesRequest.newBuilder((ListGlossaryEntriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGlossaryEntriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGlossaryEntriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GlossaryEntry> extractResources(ListGlossaryEntriesResponse payload) {
            return payload.getGlossaryEntriesList();
        }
    };
    private static final PagedListDescriptor<ListDatasetsRequest, ListDatasetsResponse, Dataset> LIST_DATASETS_PAGE_STR_DESC = new PagedListDescriptor<ListDatasetsRequest, ListDatasetsResponse, Dataset>(){

        public String emptyToken() {
            return "";
        }

        public ListDatasetsRequest injectToken(ListDatasetsRequest payload, String token) {
            return ListDatasetsRequest.newBuilder((ListDatasetsRequest)payload).setPageToken(token).build();
        }

        public ListDatasetsRequest injectPageSize(ListDatasetsRequest payload, int pageSize) {
            return ListDatasetsRequest.newBuilder((ListDatasetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDatasetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDatasetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Dataset> extractResources(ListDatasetsResponse payload) {
            return payload.getDatasetsList();
        }
    };
    private static final PagedListDescriptor<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, AdaptiveMtDataset> LIST_ADAPTIVE_MT_DATASETS_PAGE_STR_DESC = new PagedListDescriptor<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, AdaptiveMtDataset>(){

        public String emptyToken() {
            return "";
        }

        public ListAdaptiveMtDatasetsRequest injectToken(ListAdaptiveMtDatasetsRequest payload, String token) {
            return ListAdaptiveMtDatasetsRequest.newBuilder((ListAdaptiveMtDatasetsRequest)payload).setPageToken(token).build();
        }

        public ListAdaptiveMtDatasetsRequest injectPageSize(ListAdaptiveMtDatasetsRequest payload, int pageSize) {
            return ListAdaptiveMtDatasetsRequest.newBuilder((ListAdaptiveMtDatasetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAdaptiveMtDatasetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAdaptiveMtDatasetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AdaptiveMtDataset> extractResources(ListAdaptiveMtDatasetsResponse payload) {
            return payload.getAdaptiveMtDatasetsList();
        }
    };
    private static final PagedListDescriptor<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, AdaptiveMtFile> LIST_ADAPTIVE_MT_FILES_PAGE_STR_DESC = new PagedListDescriptor<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, AdaptiveMtFile>(){

        public String emptyToken() {
            return "";
        }

        public ListAdaptiveMtFilesRequest injectToken(ListAdaptiveMtFilesRequest payload, String token) {
            return ListAdaptiveMtFilesRequest.newBuilder((ListAdaptiveMtFilesRequest)payload).setPageToken(token).build();
        }

        public ListAdaptiveMtFilesRequest injectPageSize(ListAdaptiveMtFilesRequest payload, int pageSize) {
            return ListAdaptiveMtFilesRequest.newBuilder((ListAdaptiveMtFilesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAdaptiveMtFilesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAdaptiveMtFilesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AdaptiveMtFile> extractResources(ListAdaptiveMtFilesResponse payload) {
            return payload.getAdaptiveMtFilesList();
        }
    };
    private static final PagedListDescriptor<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, AdaptiveMtSentence> LIST_ADAPTIVE_MT_SENTENCES_PAGE_STR_DESC = new PagedListDescriptor<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, AdaptiveMtSentence>(){

        public String emptyToken() {
            return "";
        }

        public ListAdaptiveMtSentencesRequest injectToken(ListAdaptiveMtSentencesRequest payload, String token) {
            return ListAdaptiveMtSentencesRequest.newBuilder((ListAdaptiveMtSentencesRequest)payload).setPageToken(token).build();
        }

        public ListAdaptiveMtSentencesRequest injectPageSize(ListAdaptiveMtSentencesRequest payload, int pageSize) {
            return ListAdaptiveMtSentencesRequest.newBuilder((ListAdaptiveMtSentencesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAdaptiveMtSentencesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAdaptiveMtSentencesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AdaptiveMtSentence> extractResources(ListAdaptiveMtSentencesResponse payload) {
            return payload.getAdaptiveMtSentencesList();
        }
    };
    private static final PagedListDescriptor<ListExamplesRequest, ListExamplesResponse, Example> LIST_EXAMPLES_PAGE_STR_DESC = new PagedListDescriptor<ListExamplesRequest, ListExamplesResponse, Example>(){

        public String emptyToken() {
            return "";
        }

        public ListExamplesRequest injectToken(ListExamplesRequest payload, String token) {
            return ListExamplesRequest.newBuilder((ListExamplesRequest)payload).setPageToken(token).build();
        }

        public ListExamplesRequest injectPageSize(ListExamplesRequest payload, int pageSize) {
            return ListExamplesRequest.newBuilder((ListExamplesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListExamplesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListExamplesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Example> extractResources(ListExamplesResponse payload) {
            return payload.getExamplesList();
        }
    };
    private static final PagedListDescriptor<ListModelsRequest, ListModelsResponse, Model> LIST_MODELS_PAGE_STR_DESC = new PagedListDescriptor<ListModelsRequest, ListModelsResponse, Model>(){

        public String emptyToken() {
            return "";
        }

        public ListModelsRequest injectToken(ListModelsRequest payload, String token) {
            return ListModelsRequest.newBuilder((ListModelsRequest)payload).setPageToken(token).build();
        }

        public ListModelsRequest injectPageSize(ListModelsRequest payload, int pageSize) {
            return ListModelsRequest.newBuilder((ListModelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListModelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListModelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Model> extractResources(ListModelsResponse payload) {
            return payload.getModelsList();
        }
    };
    private static final PagedListResponseFactory<ListGlossariesRequest, ListGlossariesResponse, TranslationServiceClient.ListGlossariesPagedResponse> LIST_GLOSSARIES_PAGE_STR_FACT = new PagedListResponseFactory<ListGlossariesRequest, ListGlossariesResponse, TranslationServiceClient.ListGlossariesPagedResponse>(){

        public ApiFuture<TranslationServiceClient.ListGlossariesPagedResponse> getFuturePagedResponse(UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> callable, ListGlossariesRequest request, ApiCallContext context, ApiFuture<ListGlossariesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GLOSSARIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TranslationServiceClient.ListGlossariesPagedResponse.createAsync((PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, TranslationServiceClient.ListGlossaryEntriesPagedResponse> LIST_GLOSSARY_ENTRIES_PAGE_STR_FACT = new PagedListResponseFactory<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, TranslationServiceClient.ListGlossaryEntriesPagedResponse>(){

        public ApiFuture<TranslationServiceClient.ListGlossaryEntriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse> callable, ListGlossaryEntriesRequest request, ApiCallContext context, ApiFuture<ListGlossaryEntriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GLOSSARY_ENTRIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TranslationServiceClient.ListGlossaryEntriesPagedResponse.createAsync((PageContext<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, GlossaryEntry>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDatasetsRequest, ListDatasetsResponse, TranslationServiceClient.ListDatasetsPagedResponse> LIST_DATASETS_PAGE_STR_FACT = new PagedListResponseFactory<ListDatasetsRequest, ListDatasetsResponse, TranslationServiceClient.ListDatasetsPagedResponse>(){

        public ApiFuture<TranslationServiceClient.ListDatasetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> callable, ListDatasetsRequest request, ApiCallContext context, ApiFuture<ListDatasetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATASETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TranslationServiceClient.ListDatasetsPagedResponse.createAsync((PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, TranslationServiceClient.ListAdaptiveMtDatasetsPagedResponse> LIST_ADAPTIVE_MT_DATASETS_PAGE_STR_FACT = new PagedListResponseFactory<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, TranslationServiceClient.ListAdaptiveMtDatasetsPagedResponse>(){

        public ApiFuture<TranslationServiceClient.ListAdaptiveMtDatasetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse> callable, ListAdaptiveMtDatasetsRequest request, ApiCallContext context, ApiFuture<ListAdaptiveMtDatasetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ADAPTIVE_MT_DATASETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TranslationServiceClient.ListAdaptiveMtDatasetsPagedResponse.createAsync((PageContext<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, AdaptiveMtDataset>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, TranslationServiceClient.ListAdaptiveMtFilesPagedResponse> LIST_ADAPTIVE_MT_FILES_PAGE_STR_FACT = new PagedListResponseFactory<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, TranslationServiceClient.ListAdaptiveMtFilesPagedResponse>(){

        public ApiFuture<TranslationServiceClient.ListAdaptiveMtFilesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse> callable, ListAdaptiveMtFilesRequest request, ApiCallContext context, ApiFuture<ListAdaptiveMtFilesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ADAPTIVE_MT_FILES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TranslationServiceClient.ListAdaptiveMtFilesPagedResponse.createAsync((PageContext<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, AdaptiveMtFile>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, TranslationServiceClient.ListAdaptiveMtSentencesPagedResponse> LIST_ADAPTIVE_MT_SENTENCES_PAGE_STR_FACT = new PagedListResponseFactory<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, TranslationServiceClient.ListAdaptiveMtSentencesPagedResponse>(){

        public ApiFuture<TranslationServiceClient.ListAdaptiveMtSentencesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse> callable, ListAdaptiveMtSentencesRequest request, ApiCallContext context, ApiFuture<ListAdaptiveMtSentencesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ADAPTIVE_MT_SENTENCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TranslationServiceClient.ListAdaptiveMtSentencesPagedResponse.createAsync((PageContext<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, AdaptiveMtSentence>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListExamplesRequest, ListExamplesResponse, TranslationServiceClient.ListExamplesPagedResponse> LIST_EXAMPLES_PAGE_STR_FACT = new PagedListResponseFactory<ListExamplesRequest, ListExamplesResponse, TranslationServiceClient.ListExamplesPagedResponse>(){

        public ApiFuture<TranslationServiceClient.ListExamplesPagedResponse> getFuturePagedResponse(UnaryCallable<ListExamplesRequest, ListExamplesResponse> callable, ListExamplesRequest request, ApiCallContext context, ApiFuture<ListExamplesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EXAMPLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TranslationServiceClient.ListExamplesPagedResponse.createAsync((PageContext<ListExamplesRequest, ListExamplesResponse, Example>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListModelsRequest, ListModelsResponse, TranslationServiceClient.ListModelsPagedResponse> LIST_MODELS_PAGE_STR_FACT = new PagedListResponseFactory<ListModelsRequest, ListModelsResponse, TranslationServiceClient.ListModelsPagedResponse>(){

        public ApiFuture<TranslationServiceClient.ListModelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListModelsRequest, ListModelsResponse> callable, ListModelsRequest request, ApiCallContext context, ApiFuture<ListModelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MODELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TranslationServiceClient.ListModelsPagedResponse.createAsync((PageContext<ListModelsRequest, ListModelsResponse, Model>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<TranslateTextRequest, TranslateTextResponse> translateTextSettings() {
        return this.translateTextSettings;
    }

    public UnaryCallSettings<RomanizeTextRequest, RomanizeTextResponse> romanizeTextSettings() {
        return this.romanizeTextSettings;
    }

    public UnaryCallSettings<DetectLanguageRequest, DetectLanguageResponse> detectLanguageSettings() {
        return this.detectLanguageSettings;
    }

    public UnaryCallSettings<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesSettings() {
        return this.getSupportedLanguagesSettings;
    }

    public UnaryCallSettings<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentSettings() {
        return this.translateDocumentSettings;
    }

    public UnaryCallSettings<BatchTranslateTextRequest, Operation> batchTranslateTextSettings() {
        return this.batchTranslateTextSettings;
    }

    public OperationCallSettings<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationSettings() {
        return this.batchTranslateTextOperationSettings;
    }

    public UnaryCallSettings<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentSettings() {
        return this.batchTranslateDocumentSettings;
    }

    public OperationCallSettings<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationSettings() {
        return this.batchTranslateDocumentOperationSettings;
    }

    public UnaryCallSettings<CreateGlossaryRequest, Operation> createGlossarySettings() {
        return this.createGlossarySettings;
    }

    public OperationCallSettings<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationSettings() {
        return this.createGlossaryOperationSettings;
    }

    public UnaryCallSettings<UpdateGlossaryRequest, Operation> updateGlossarySettings() {
        return this.updateGlossarySettings;
    }

    public OperationCallSettings<UpdateGlossaryRequest, Glossary, UpdateGlossaryMetadata> updateGlossaryOperationSettings() {
        return this.updateGlossaryOperationSettings;
    }

    public PagedCallSettings<ListGlossariesRequest, ListGlossariesResponse, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesSettings() {
        return this.listGlossariesSettings;
    }

    public UnaryCallSettings<GetGlossaryRequest, Glossary> getGlossarySettings() {
        return this.getGlossarySettings;
    }

    public UnaryCallSettings<DeleteGlossaryRequest, Operation> deleteGlossarySettings() {
        return this.deleteGlossarySettings;
    }

    public OperationCallSettings<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationSettings() {
        return this.deleteGlossaryOperationSettings;
    }

    public UnaryCallSettings<GetGlossaryEntryRequest, GlossaryEntry> getGlossaryEntrySettings() {
        return this.getGlossaryEntrySettings;
    }

    public PagedCallSettings<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, TranslationServiceClient.ListGlossaryEntriesPagedResponse> listGlossaryEntriesSettings() {
        return this.listGlossaryEntriesSettings;
    }

    public UnaryCallSettings<CreateGlossaryEntryRequest, GlossaryEntry> createGlossaryEntrySettings() {
        return this.createGlossaryEntrySettings;
    }

    public UnaryCallSettings<UpdateGlossaryEntryRequest, GlossaryEntry> updateGlossaryEntrySettings() {
        return this.updateGlossaryEntrySettings;
    }

    public UnaryCallSettings<DeleteGlossaryEntryRequest, Empty> deleteGlossaryEntrySettings() {
        return this.deleteGlossaryEntrySettings;
    }

    public UnaryCallSettings<CreateDatasetRequest, Operation> createDatasetSettings() {
        return this.createDatasetSettings;
    }

    public OperationCallSettings<CreateDatasetRequest, Dataset, CreateDatasetMetadata> createDatasetOperationSettings() {
        return this.createDatasetOperationSettings;
    }

    public UnaryCallSettings<GetDatasetRequest, Dataset> getDatasetSettings() {
        return this.getDatasetSettings;
    }

    public PagedCallSettings<ListDatasetsRequest, ListDatasetsResponse, TranslationServiceClient.ListDatasetsPagedResponse> listDatasetsSettings() {
        return this.listDatasetsSettings;
    }

    public UnaryCallSettings<DeleteDatasetRequest, Operation> deleteDatasetSettings() {
        return this.deleteDatasetSettings;
    }

    public OperationCallSettings<DeleteDatasetRequest, Empty, DeleteDatasetMetadata> deleteDatasetOperationSettings() {
        return this.deleteDatasetOperationSettings;
    }

    public UnaryCallSettings<CreateAdaptiveMtDatasetRequest, AdaptiveMtDataset> createAdaptiveMtDatasetSettings() {
        return this.createAdaptiveMtDatasetSettings;
    }

    public UnaryCallSettings<DeleteAdaptiveMtDatasetRequest, Empty> deleteAdaptiveMtDatasetSettings() {
        return this.deleteAdaptiveMtDatasetSettings;
    }

    public UnaryCallSettings<GetAdaptiveMtDatasetRequest, AdaptiveMtDataset> getAdaptiveMtDatasetSettings() {
        return this.getAdaptiveMtDatasetSettings;
    }

    public PagedCallSettings<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, TranslationServiceClient.ListAdaptiveMtDatasetsPagedResponse> listAdaptiveMtDatasetsSettings() {
        return this.listAdaptiveMtDatasetsSettings;
    }

    public UnaryCallSettings<AdaptiveMtTranslateRequest, AdaptiveMtTranslateResponse> adaptiveMtTranslateSettings() {
        return this.adaptiveMtTranslateSettings;
    }

    public UnaryCallSettings<GetAdaptiveMtFileRequest, AdaptiveMtFile> getAdaptiveMtFileSettings() {
        return this.getAdaptiveMtFileSettings;
    }

    public UnaryCallSettings<DeleteAdaptiveMtFileRequest, Empty> deleteAdaptiveMtFileSettings() {
        return this.deleteAdaptiveMtFileSettings;
    }

    public UnaryCallSettings<ImportAdaptiveMtFileRequest, ImportAdaptiveMtFileResponse> importAdaptiveMtFileSettings() {
        return this.importAdaptiveMtFileSettings;
    }

    public PagedCallSettings<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, TranslationServiceClient.ListAdaptiveMtFilesPagedResponse> listAdaptiveMtFilesSettings() {
        return this.listAdaptiveMtFilesSettings;
    }

    public PagedCallSettings<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, TranslationServiceClient.ListAdaptiveMtSentencesPagedResponse> listAdaptiveMtSentencesSettings() {
        return this.listAdaptiveMtSentencesSettings;
    }

    public UnaryCallSettings<ImportDataRequest, Operation> importDataSettings() {
        return this.importDataSettings;
    }

    public OperationCallSettings<ImportDataRequest, Empty, ImportDataMetadata> importDataOperationSettings() {
        return this.importDataOperationSettings;
    }

    public UnaryCallSettings<ExportDataRequest, Operation> exportDataSettings() {
        return this.exportDataSettings;
    }

    public OperationCallSettings<ExportDataRequest, Empty, ExportDataMetadata> exportDataOperationSettings() {
        return this.exportDataOperationSettings;
    }

    public PagedCallSettings<ListExamplesRequest, ListExamplesResponse, TranslationServiceClient.ListExamplesPagedResponse> listExamplesSettings() {
        return this.listExamplesSettings;
    }

    public UnaryCallSettings<CreateModelRequest, Operation> createModelSettings() {
        return this.createModelSettings;
    }

    public OperationCallSettings<CreateModelRequest, Model, CreateModelMetadata> createModelOperationSettings() {
        return this.createModelOperationSettings;
    }

    public PagedCallSettings<ListModelsRequest, ListModelsResponse, TranslationServiceClient.ListModelsPagedResponse> listModelsSettings() {
        return this.listModelsSettings;
    }

    public UnaryCallSettings<GetModelRequest, Model> getModelSettings() {
        return this.getModelSettings;
    }

    public UnaryCallSettings<DeleteModelRequest, Operation> deleteModelSettings() {
        return this.deleteModelSettings;
    }

    public OperationCallSettings<DeleteModelRequest, Empty, DeleteModelMetadata> deleteModelOperationSettings() {
        return this.deleteModelOperationSettings;
    }

    public TranslationServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTranslationServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTranslationServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "translate";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "translate.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "translate.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TranslationServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TranslationServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TranslationServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return TranslationServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TranslationServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.translateTextSettings = settingsBuilder.translateTextSettings().build();
        this.romanizeTextSettings = settingsBuilder.romanizeTextSettings().build();
        this.detectLanguageSettings = settingsBuilder.detectLanguageSettings().build();
        this.getSupportedLanguagesSettings = settingsBuilder.getSupportedLanguagesSettings().build();
        this.translateDocumentSettings = settingsBuilder.translateDocumentSettings().build();
        this.batchTranslateTextSettings = settingsBuilder.batchTranslateTextSettings().build();
        this.batchTranslateTextOperationSettings = settingsBuilder.batchTranslateTextOperationSettings().build();
        this.batchTranslateDocumentSettings = settingsBuilder.batchTranslateDocumentSettings().build();
        this.batchTranslateDocumentOperationSettings = settingsBuilder.batchTranslateDocumentOperationSettings().build();
        this.createGlossarySettings = settingsBuilder.createGlossarySettings().build();
        this.createGlossaryOperationSettings = settingsBuilder.createGlossaryOperationSettings().build();
        this.updateGlossarySettings = settingsBuilder.updateGlossarySettings().build();
        this.updateGlossaryOperationSettings = settingsBuilder.updateGlossaryOperationSettings().build();
        this.listGlossariesSettings = settingsBuilder.listGlossariesSettings().build();
        this.getGlossarySettings = settingsBuilder.getGlossarySettings().build();
        this.deleteGlossarySettings = settingsBuilder.deleteGlossarySettings().build();
        this.deleteGlossaryOperationSettings = settingsBuilder.deleteGlossaryOperationSettings().build();
        this.getGlossaryEntrySettings = settingsBuilder.getGlossaryEntrySettings().build();
        this.listGlossaryEntriesSettings = settingsBuilder.listGlossaryEntriesSettings().build();
        this.createGlossaryEntrySettings = settingsBuilder.createGlossaryEntrySettings().build();
        this.updateGlossaryEntrySettings = settingsBuilder.updateGlossaryEntrySettings().build();
        this.deleteGlossaryEntrySettings = settingsBuilder.deleteGlossaryEntrySettings().build();
        this.createDatasetSettings = settingsBuilder.createDatasetSettings().build();
        this.createDatasetOperationSettings = settingsBuilder.createDatasetOperationSettings().build();
        this.getDatasetSettings = settingsBuilder.getDatasetSettings().build();
        this.listDatasetsSettings = settingsBuilder.listDatasetsSettings().build();
        this.deleteDatasetSettings = settingsBuilder.deleteDatasetSettings().build();
        this.deleteDatasetOperationSettings = settingsBuilder.deleteDatasetOperationSettings().build();
        this.createAdaptiveMtDatasetSettings = settingsBuilder.createAdaptiveMtDatasetSettings().build();
        this.deleteAdaptiveMtDatasetSettings = settingsBuilder.deleteAdaptiveMtDatasetSettings().build();
        this.getAdaptiveMtDatasetSettings = settingsBuilder.getAdaptiveMtDatasetSettings().build();
        this.listAdaptiveMtDatasetsSettings = settingsBuilder.listAdaptiveMtDatasetsSettings().build();
        this.adaptiveMtTranslateSettings = settingsBuilder.adaptiveMtTranslateSettings().build();
        this.getAdaptiveMtFileSettings = settingsBuilder.getAdaptiveMtFileSettings().build();
        this.deleteAdaptiveMtFileSettings = settingsBuilder.deleteAdaptiveMtFileSettings().build();
        this.importAdaptiveMtFileSettings = settingsBuilder.importAdaptiveMtFileSettings().build();
        this.listAdaptiveMtFilesSettings = settingsBuilder.listAdaptiveMtFilesSettings().build();
        this.listAdaptiveMtSentencesSettings = settingsBuilder.listAdaptiveMtSentencesSettings().build();
        this.importDataSettings = settingsBuilder.importDataSettings().build();
        this.importDataOperationSettings = settingsBuilder.importDataOperationSettings().build();
        this.exportDataSettings = settingsBuilder.exportDataSettings().build();
        this.exportDataOperationSettings = settingsBuilder.exportDataOperationSettings().build();
        this.listExamplesSettings = settingsBuilder.listExamplesSettings().build();
        this.createModelSettings = settingsBuilder.createModelSettings().build();
        this.createModelOperationSettings = settingsBuilder.createModelOperationSettings().build();
        this.listModelsSettings = settingsBuilder.listModelsSettings().build();
        this.getModelSettings = settingsBuilder.getModelSettings().build();
        this.deleteModelSettings = settingsBuilder.deleteModelSettings().build();
        this.deleteModelOperationSettings = settingsBuilder.deleteModelOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TranslationServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<TranslateTextRequest, TranslateTextResponse> translateTextSettings;
        private final UnaryCallSettings.Builder<RomanizeTextRequest, RomanizeTextResponse> romanizeTextSettings;
        private final UnaryCallSettings.Builder<DetectLanguageRequest, DetectLanguageResponse> detectLanguageSettings;
        private final UnaryCallSettings.Builder<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesSettings;
        private final UnaryCallSettings.Builder<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentSettings;
        private final UnaryCallSettings.Builder<BatchTranslateTextRequest, Operation> batchTranslateTextSettings;
        private final OperationCallSettings.Builder<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationSettings;
        private final UnaryCallSettings.Builder<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentSettings;
        private final OperationCallSettings.Builder<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationSettings;
        private final UnaryCallSettings.Builder<CreateGlossaryRequest, Operation> createGlossarySettings;
        private final OperationCallSettings.Builder<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationSettings;
        private final UnaryCallSettings.Builder<UpdateGlossaryRequest, Operation> updateGlossarySettings;
        private final OperationCallSettings.Builder<UpdateGlossaryRequest, Glossary, UpdateGlossaryMetadata> updateGlossaryOperationSettings;
        private final PagedCallSettings.Builder<ListGlossariesRequest, ListGlossariesResponse, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesSettings;
        private final UnaryCallSettings.Builder<GetGlossaryRequest, Glossary> getGlossarySettings;
        private final UnaryCallSettings.Builder<DeleteGlossaryRequest, Operation> deleteGlossarySettings;
        private final OperationCallSettings.Builder<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationSettings;
        private final UnaryCallSettings.Builder<GetGlossaryEntryRequest, GlossaryEntry> getGlossaryEntrySettings;
        private final PagedCallSettings.Builder<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, TranslationServiceClient.ListGlossaryEntriesPagedResponse> listGlossaryEntriesSettings;
        private final UnaryCallSettings.Builder<CreateGlossaryEntryRequest, GlossaryEntry> createGlossaryEntrySettings;
        private final UnaryCallSettings.Builder<UpdateGlossaryEntryRequest, GlossaryEntry> updateGlossaryEntrySettings;
        private final UnaryCallSettings.Builder<DeleteGlossaryEntryRequest, Empty> deleteGlossaryEntrySettings;
        private final UnaryCallSettings.Builder<CreateDatasetRequest, Operation> createDatasetSettings;
        private final OperationCallSettings.Builder<CreateDatasetRequest, Dataset, CreateDatasetMetadata> createDatasetOperationSettings;
        private final UnaryCallSettings.Builder<GetDatasetRequest, Dataset> getDatasetSettings;
        private final PagedCallSettings.Builder<ListDatasetsRequest, ListDatasetsResponse, TranslationServiceClient.ListDatasetsPagedResponse> listDatasetsSettings;
        private final UnaryCallSettings.Builder<DeleteDatasetRequest, Operation> deleteDatasetSettings;
        private final OperationCallSettings.Builder<DeleteDatasetRequest, Empty, DeleteDatasetMetadata> deleteDatasetOperationSettings;
        private final UnaryCallSettings.Builder<CreateAdaptiveMtDatasetRequest, AdaptiveMtDataset> createAdaptiveMtDatasetSettings;
        private final UnaryCallSettings.Builder<DeleteAdaptiveMtDatasetRequest, Empty> deleteAdaptiveMtDatasetSettings;
        private final UnaryCallSettings.Builder<GetAdaptiveMtDatasetRequest, AdaptiveMtDataset> getAdaptiveMtDatasetSettings;
        private final PagedCallSettings.Builder<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, TranslationServiceClient.ListAdaptiveMtDatasetsPagedResponse> listAdaptiveMtDatasetsSettings;
        private final UnaryCallSettings.Builder<AdaptiveMtTranslateRequest, AdaptiveMtTranslateResponse> adaptiveMtTranslateSettings;
        private final UnaryCallSettings.Builder<GetAdaptiveMtFileRequest, AdaptiveMtFile> getAdaptiveMtFileSettings;
        private final UnaryCallSettings.Builder<DeleteAdaptiveMtFileRequest, Empty> deleteAdaptiveMtFileSettings;
        private final UnaryCallSettings.Builder<ImportAdaptiveMtFileRequest, ImportAdaptiveMtFileResponse> importAdaptiveMtFileSettings;
        private final PagedCallSettings.Builder<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, TranslationServiceClient.ListAdaptiveMtFilesPagedResponse> listAdaptiveMtFilesSettings;
        private final PagedCallSettings.Builder<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, TranslationServiceClient.ListAdaptiveMtSentencesPagedResponse> listAdaptiveMtSentencesSettings;
        private final UnaryCallSettings.Builder<ImportDataRequest, Operation> importDataSettings;
        private final OperationCallSettings.Builder<ImportDataRequest, Empty, ImportDataMetadata> importDataOperationSettings;
        private final UnaryCallSettings.Builder<ExportDataRequest, Operation> exportDataSettings;
        private final OperationCallSettings.Builder<ExportDataRequest, Empty, ExportDataMetadata> exportDataOperationSettings;
        private final PagedCallSettings.Builder<ListExamplesRequest, ListExamplesResponse, TranslationServiceClient.ListExamplesPagedResponse> listExamplesSettings;
        private final UnaryCallSettings.Builder<CreateModelRequest, Operation> createModelSettings;
        private final OperationCallSettings.Builder<CreateModelRequest, Model, CreateModelMetadata> createModelOperationSettings;
        private final PagedCallSettings.Builder<ListModelsRequest, ListModelsResponse, TranslationServiceClient.ListModelsPagedResponse> listModelsSettings;
        private final UnaryCallSettings.Builder<GetModelRequest, Model> getModelSettings;
        private final UnaryCallSettings.Builder<DeleteModelRequest, Operation> deleteModelSettings;
        private final OperationCallSettings.Builder<DeleteModelRequest, Empty, DeleteModelMetadata> deleteModelOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.translateTextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.romanizeTextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.detectLanguageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSupportedLanguagesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.translateDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchTranslateTextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchTranslateTextOperationSettings = OperationCallSettings.newBuilder();
            this.batchTranslateDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchTranslateDocumentOperationSettings = OperationCallSettings.newBuilder();
            this.createGlossarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGlossaryOperationSettings = OperationCallSettings.newBuilder();
            this.updateGlossarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGlossaryOperationSettings = OperationCallSettings.newBuilder();
            this.listGlossariesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GLOSSARIES_PAGE_STR_FACT);
            this.getGlossarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGlossarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGlossaryOperationSettings = OperationCallSettings.newBuilder();
            this.getGlossaryEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGlossaryEntriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GLOSSARY_ENTRIES_PAGE_STR_FACT);
            this.createGlossaryEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGlossaryEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGlossaryEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDatasetOperationSettings = OperationCallSettings.newBuilder();
            this.getDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDatasetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATASETS_PAGE_STR_FACT);
            this.deleteDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDatasetOperationSettings = OperationCallSettings.newBuilder();
            this.createAdaptiveMtDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAdaptiveMtDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAdaptiveMtDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAdaptiveMtDatasetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ADAPTIVE_MT_DATASETS_PAGE_STR_FACT);
            this.adaptiveMtTranslateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAdaptiveMtFileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAdaptiveMtFileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importAdaptiveMtFileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAdaptiveMtFilesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ADAPTIVE_MT_FILES_PAGE_STR_FACT);
            this.listAdaptiveMtSentencesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ADAPTIVE_MT_SENTENCES_PAGE_STR_FACT);
            this.importDataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importDataOperationSettings = OperationCallSettings.newBuilder();
            this.exportDataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportDataOperationSettings = OperationCallSettings.newBuilder();
            this.listExamplesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EXAMPLES_PAGE_STR_FACT);
            this.createModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createModelOperationSettings = OperationCallSettings.newBuilder();
            this.listModelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MODELS_PAGE_STR_FACT);
            this.getModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteModelOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.translateTextSettings, this.romanizeTextSettings, this.detectLanguageSettings, this.getSupportedLanguagesSettings, this.translateDocumentSettings, this.batchTranslateTextSettings, this.batchTranslateDocumentSettings, this.createGlossarySettings, this.updateGlossarySettings, this.listGlossariesSettings, this.getGlossarySettings, this.deleteGlossarySettings, (Object[])new UnaryCallSettings.Builder[]{this.getGlossaryEntrySettings, this.listGlossaryEntriesSettings, this.createGlossaryEntrySettings, this.updateGlossaryEntrySettings, this.deleteGlossaryEntrySettings, this.createDatasetSettings, this.getDatasetSettings, this.listDatasetsSettings, this.deleteDatasetSettings, this.createAdaptiveMtDatasetSettings, this.deleteAdaptiveMtDatasetSettings, this.getAdaptiveMtDatasetSettings, this.listAdaptiveMtDatasetsSettings, this.adaptiveMtTranslateSettings, this.getAdaptiveMtFileSettings, this.deleteAdaptiveMtFileSettings, this.importAdaptiveMtFileSettings, this.listAdaptiveMtFilesSettings, this.listAdaptiveMtSentencesSettings, this.importDataSettings, this.exportDataSettings, this.listExamplesSettings, this.createModelSettings, this.listModelsSettings, this.getModelSettings, this.deleteModelSettings});
            Builder.initDefaults(this);
        }

        protected Builder(TranslationServiceStubSettings settings) {
            super((StubSettings)settings);
            this.translateTextSettings = settings.translateTextSettings.toBuilder();
            this.romanizeTextSettings = settings.romanizeTextSettings.toBuilder();
            this.detectLanguageSettings = settings.detectLanguageSettings.toBuilder();
            this.getSupportedLanguagesSettings = settings.getSupportedLanguagesSettings.toBuilder();
            this.translateDocumentSettings = settings.translateDocumentSettings.toBuilder();
            this.batchTranslateTextSettings = settings.batchTranslateTextSettings.toBuilder();
            this.batchTranslateTextOperationSettings = settings.batchTranslateTextOperationSettings.toBuilder();
            this.batchTranslateDocumentSettings = settings.batchTranslateDocumentSettings.toBuilder();
            this.batchTranslateDocumentOperationSettings = settings.batchTranslateDocumentOperationSettings.toBuilder();
            this.createGlossarySettings = settings.createGlossarySettings.toBuilder();
            this.createGlossaryOperationSettings = settings.createGlossaryOperationSettings.toBuilder();
            this.updateGlossarySettings = settings.updateGlossarySettings.toBuilder();
            this.updateGlossaryOperationSettings = settings.updateGlossaryOperationSettings.toBuilder();
            this.listGlossariesSettings = settings.listGlossariesSettings.toBuilder();
            this.getGlossarySettings = settings.getGlossarySettings.toBuilder();
            this.deleteGlossarySettings = settings.deleteGlossarySettings.toBuilder();
            this.deleteGlossaryOperationSettings = settings.deleteGlossaryOperationSettings.toBuilder();
            this.getGlossaryEntrySettings = settings.getGlossaryEntrySettings.toBuilder();
            this.listGlossaryEntriesSettings = settings.listGlossaryEntriesSettings.toBuilder();
            this.createGlossaryEntrySettings = settings.createGlossaryEntrySettings.toBuilder();
            this.updateGlossaryEntrySettings = settings.updateGlossaryEntrySettings.toBuilder();
            this.deleteGlossaryEntrySettings = settings.deleteGlossaryEntrySettings.toBuilder();
            this.createDatasetSettings = settings.createDatasetSettings.toBuilder();
            this.createDatasetOperationSettings = settings.createDatasetOperationSettings.toBuilder();
            this.getDatasetSettings = settings.getDatasetSettings.toBuilder();
            this.listDatasetsSettings = settings.listDatasetsSettings.toBuilder();
            this.deleteDatasetSettings = settings.deleteDatasetSettings.toBuilder();
            this.deleteDatasetOperationSettings = settings.deleteDatasetOperationSettings.toBuilder();
            this.createAdaptiveMtDatasetSettings = settings.createAdaptiveMtDatasetSettings.toBuilder();
            this.deleteAdaptiveMtDatasetSettings = settings.deleteAdaptiveMtDatasetSettings.toBuilder();
            this.getAdaptiveMtDatasetSettings = settings.getAdaptiveMtDatasetSettings.toBuilder();
            this.listAdaptiveMtDatasetsSettings = settings.listAdaptiveMtDatasetsSettings.toBuilder();
            this.adaptiveMtTranslateSettings = settings.adaptiveMtTranslateSettings.toBuilder();
            this.getAdaptiveMtFileSettings = settings.getAdaptiveMtFileSettings.toBuilder();
            this.deleteAdaptiveMtFileSettings = settings.deleteAdaptiveMtFileSettings.toBuilder();
            this.importAdaptiveMtFileSettings = settings.importAdaptiveMtFileSettings.toBuilder();
            this.listAdaptiveMtFilesSettings = settings.listAdaptiveMtFilesSettings.toBuilder();
            this.listAdaptiveMtSentencesSettings = settings.listAdaptiveMtSentencesSettings.toBuilder();
            this.importDataSettings = settings.importDataSettings.toBuilder();
            this.importDataOperationSettings = settings.importDataOperationSettings.toBuilder();
            this.exportDataSettings = settings.exportDataSettings.toBuilder();
            this.exportDataOperationSettings = settings.exportDataOperationSettings.toBuilder();
            this.listExamplesSettings = settings.listExamplesSettings.toBuilder();
            this.createModelSettings = settings.createModelSettings.toBuilder();
            this.createModelOperationSettings = settings.createModelOperationSettings.toBuilder();
            this.listModelsSettings = settings.listModelsSettings.toBuilder();
            this.getModelSettings = settings.getModelSettings.toBuilder();
            this.deleteModelSettings = settings.deleteModelSettings.toBuilder();
            this.deleteModelOperationSettings = settings.deleteModelOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.translateTextSettings, this.romanizeTextSettings, this.detectLanguageSettings, this.getSupportedLanguagesSettings, this.translateDocumentSettings, this.batchTranslateTextSettings, this.batchTranslateDocumentSettings, this.createGlossarySettings, this.updateGlossarySettings, this.listGlossariesSettings, this.getGlossarySettings, this.deleteGlossarySettings, (Object[])new UnaryCallSettings.Builder[]{this.getGlossaryEntrySettings, this.listGlossaryEntriesSettings, this.createGlossaryEntrySettings, this.updateGlossaryEntrySettings, this.deleteGlossaryEntrySettings, this.createDatasetSettings, this.getDatasetSettings, this.listDatasetsSettings, this.deleteDatasetSettings, this.createAdaptiveMtDatasetSettings, this.deleteAdaptiveMtDatasetSettings, this.getAdaptiveMtDatasetSettings, this.listAdaptiveMtDatasetsSettings, this.adaptiveMtTranslateSettings, this.getAdaptiveMtFileSettings, this.deleteAdaptiveMtFileSettings, this.importAdaptiveMtFileSettings, this.listAdaptiveMtFilesSettings, this.listAdaptiveMtSentencesSettings, this.importDataSettings, this.exportDataSettings, this.listExamplesSettings, this.createModelSettings, this.listModelsSettings, this.getModelSettings, this.deleteModelSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TranslationServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TranslationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TranslationServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TranslationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)TranslationServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)TranslationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TranslationServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TranslationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.translateTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.romanizeTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.detectLanguageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSupportedLanguagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.translateDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.batchTranslateTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.batchTranslateDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createGlossarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateGlossarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listGlossariesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getGlossarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteGlossarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getGlossaryEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listGlossaryEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createGlossaryEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateGlossaryEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteGlossaryEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDatasetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createAdaptiveMtDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteAdaptiveMtDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getAdaptiveMtDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listAdaptiveMtDatasetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.adaptiveMtTranslateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getAdaptiveMtFileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteAdaptiveMtFileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.importAdaptiveMtFileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listAdaptiveMtFilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listAdaptiveMtSentencesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.importDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.exportDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listExamplesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listModelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchTranslateTextOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchTranslateResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchTranslateMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchTranslateDocumentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchTranslateDocumentResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchTranslateDocumentMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createGlossaryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Glossary.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateGlossaryMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateGlossaryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Glossary.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateGlossaryMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteGlossaryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DeleteGlossaryResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteGlossaryMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createDatasetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Dataset.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateDatasetMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDatasetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteDatasetMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importDataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportDataMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.exportDataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ExportDataMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Model.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateModelMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteModelMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<TranslateTextRequest, TranslateTextResponse> translateTextSettings() {
            return this.translateTextSettings;
        }

        public UnaryCallSettings.Builder<RomanizeTextRequest, RomanizeTextResponse> romanizeTextSettings() {
            return this.romanizeTextSettings;
        }

        public UnaryCallSettings.Builder<DetectLanguageRequest, DetectLanguageResponse> detectLanguageSettings() {
            return this.detectLanguageSettings;
        }

        public UnaryCallSettings.Builder<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesSettings() {
            return this.getSupportedLanguagesSettings;
        }

        public UnaryCallSettings.Builder<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentSettings() {
            return this.translateDocumentSettings;
        }

        public UnaryCallSettings.Builder<BatchTranslateTextRequest, Operation> batchTranslateTextSettings() {
            return this.batchTranslateTextSettings;
        }

        public OperationCallSettings.Builder<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationSettings() {
            return this.batchTranslateTextOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentSettings() {
            return this.batchTranslateDocumentSettings;
        }

        public OperationCallSettings.Builder<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationSettings() {
            return this.batchTranslateDocumentOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateGlossaryRequest, Operation> createGlossarySettings() {
            return this.createGlossarySettings;
        }

        public OperationCallSettings.Builder<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationSettings() {
            return this.createGlossaryOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateGlossaryRequest, Operation> updateGlossarySettings() {
            return this.updateGlossarySettings;
        }

        public OperationCallSettings.Builder<UpdateGlossaryRequest, Glossary, UpdateGlossaryMetadata> updateGlossaryOperationSettings() {
            return this.updateGlossaryOperationSettings;
        }

        public PagedCallSettings.Builder<ListGlossariesRequest, ListGlossariesResponse, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesSettings() {
            return this.listGlossariesSettings;
        }

        public UnaryCallSettings.Builder<GetGlossaryRequest, Glossary> getGlossarySettings() {
            return this.getGlossarySettings;
        }

        public UnaryCallSettings.Builder<DeleteGlossaryRequest, Operation> deleteGlossarySettings() {
            return this.deleteGlossarySettings;
        }

        public OperationCallSettings.Builder<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationSettings() {
            return this.deleteGlossaryOperationSettings;
        }

        public UnaryCallSettings.Builder<GetGlossaryEntryRequest, GlossaryEntry> getGlossaryEntrySettings() {
            return this.getGlossaryEntrySettings;
        }

        public PagedCallSettings.Builder<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, TranslationServiceClient.ListGlossaryEntriesPagedResponse> listGlossaryEntriesSettings() {
            return this.listGlossaryEntriesSettings;
        }

        public UnaryCallSettings.Builder<CreateGlossaryEntryRequest, GlossaryEntry> createGlossaryEntrySettings() {
            return this.createGlossaryEntrySettings;
        }

        public UnaryCallSettings.Builder<UpdateGlossaryEntryRequest, GlossaryEntry> updateGlossaryEntrySettings() {
            return this.updateGlossaryEntrySettings;
        }

        public UnaryCallSettings.Builder<DeleteGlossaryEntryRequest, Empty> deleteGlossaryEntrySettings() {
            return this.deleteGlossaryEntrySettings;
        }

        public UnaryCallSettings.Builder<CreateDatasetRequest, Operation> createDatasetSettings() {
            return this.createDatasetSettings;
        }

        public OperationCallSettings.Builder<CreateDatasetRequest, Dataset, CreateDatasetMetadata> createDatasetOperationSettings() {
            return this.createDatasetOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDatasetRequest, Dataset> getDatasetSettings() {
            return this.getDatasetSettings;
        }

        public PagedCallSettings.Builder<ListDatasetsRequest, ListDatasetsResponse, TranslationServiceClient.ListDatasetsPagedResponse> listDatasetsSettings() {
            return this.listDatasetsSettings;
        }

        public UnaryCallSettings.Builder<DeleteDatasetRequest, Operation> deleteDatasetSettings() {
            return this.deleteDatasetSettings;
        }

        public OperationCallSettings.Builder<DeleteDatasetRequest, Empty, DeleteDatasetMetadata> deleteDatasetOperationSettings() {
            return this.deleteDatasetOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateAdaptiveMtDatasetRequest, AdaptiveMtDataset> createAdaptiveMtDatasetSettings() {
            return this.createAdaptiveMtDatasetSettings;
        }

        public UnaryCallSettings.Builder<DeleteAdaptiveMtDatasetRequest, Empty> deleteAdaptiveMtDatasetSettings() {
            return this.deleteAdaptiveMtDatasetSettings;
        }

        public UnaryCallSettings.Builder<GetAdaptiveMtDatasetRequest, AdaptiveMtDataset> getAdaptiveMtDatasetSettings() {
            return this.getAdaptiveMtDatasetSettings;
        }

        public PagedCallSettings.Builder<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, TranslationServiceClient.ListAdaptiveMtDatasetsPagedResponse> listAdaptiveMtDatasetsSettings() {
            return this.listAdaptiveMtDatasetsSettings;
        }

        public UnaryCallSettings.Builder<AdaptiveMtTranslateRequest, AdaptiveMtTranslateResponse> adaptiveMtTranslateSettings() {
            return this.adaptiveMtTranslateSettings;
        }

        public UnaryCallSettings.Builder<GetAdaptiveMtFileRequest, AdaptiveMtFile> getAdaptiveMtFileSettings() {
            return this.getAdaptiveMtFileSettings;
        }

        public UnaryCallSettings.Builder<DeleteAdaptiveMtFileRequest, Empty> deleteAdaptiveMtFileSettings() {
            return this.deleteAdaptiveMtFileSettings;
        }

        public UnaryCallSettings.Builder<ImportAdaptiveMtFileRequest, ImportAdaptiveMtFileResponse> importAdaptiveMtFileSettings() {
            return this.importAdaptiveMtFileSettings;
        }

        public PagedCallSettings.Builder<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, TranslationServiceClient.ListAdaptiveMtFilesPagedResponse> listAdaptiveMtFilesSettings() {
            return this.listAdaptiveMtFilesSettings;
        }

        public PagedCallSettings.Builder<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, TranslationServiceClient.ListAdaptiveMtSentencesPagedResponse> listAdaptiveMtSentencesSettings() {
            return this.listAdaptiveMtSentencesSettings;
        }

        public UnaryCallSettings.Builder<ImportDataRequest, Operation> importDataSettings() {
            return this.importDataSettings;
        }

        public OperationCallSettings.Builder<ImportDataRequest, Empty, ImportDataMetadata> importDataOperationSettings() {
            return this.importDataOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportDataRequest, Operation> exportDataSettings() {
            return this.exportDataSettings;
        }

        public OperationCallSettings.Builder<ExportDataRequest, Empty, ExportDataMetadata> exportDataOperationSettings() {
            return this.exportDataOperationSettings;
        }

        public PagedCallSettings.Builder<ListExamplesRequest, ListExamplesResponse, TranslationServiceClient.ListExamplesPagedResponse> listExamplesSettings() {
            return this.listExamplesSettings;
        }

        public UnaryCallSettings.Builder<CreateModelRequest, Operation> createModelSettings() {
            return this.createModelSettings;
        }

        public OperationCallSettings.Builder<CreateModelRequest, Model, CreateModelMetadata> createModelOperationSettings() {
            return this.createModelOperationSettings;
        }

        public PagedCallSettings.Builder<ListModelsRequest, ListModelsResponse, TranslationServiceClient.ListModelsPagedResponse> listModelsSettings() {
            return this.listModelsSettings;
        }

        public UnaryCallSettings.Builder<GetModelRequest, Model> getModelSettings() {
            return this.getModelSettings;
        }

        public UnaryCallSettings.Builder<DeleteModelRequest, Operation> deleteModelSettings() {
            return this.deleteModelSettings;
        }

        public OperationCallSettings.Builder<DeleteModelRequest, Empty, DeleteModelMetadata> deleteModelOperationSettings() {
            return this.deleteModelOperationSettings;
        }

        public TranslationServiceStubSettings build() throws IOException {
            return new TranslationServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

