/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.api.services.translate.model.DetectionsResourceItems;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public class Detection
implements Serializable {
    private static final long serialVersionUID = 5767106557994900916L;
    private final String language;
    private final Float confidence;

    private Detection(String language, Float confidence) {
        this.language = language;
        this.confidence = confidence;
    }

    @Deprecated
    public String language() {
        return this.getLanguage();
    }

    public String getLanguage() {
        return this.language;
    }

    @Deprecated
    public float confidence() {
        return this.getConfidence();
    }

    public float getConfidence() {
        return this.confidence.floatValue();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("language", (Object)this.language).add("confidence", (Object)this.confidence).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.language, this.confidence);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Detection.class)) {
            return false;
        }
        Detection other = (Detection)obj;
        return Objects.equals(this.language, other.language) && Objects.equals(this.confidence, other.confidence);
    }

    static Detection fromPb(DetectionsResourceItems detectionPb) {
        return new Detection(detectionPb.getLanguage(), detectionPb.getConfidence());
    }
}

