/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.cloud.HttpServiceOptions;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateFactory;
import com.google.cloud.translate.TranslateImpl;
import com.google.cloud.translate.spi.DefaultTranslateRpc;
import com.google.cloud.translate.spi.TranslateRpc;
import com.google.cloud.translate.spi.TranslateRpcFactory;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class TranslateOptions
extends HttpServiceOptions<Translate, TranslateRpc, TranslateOptions> {
    private static final long serialVersionUID = -572597134540398216L;
    private static final String DEFAULT_HOST = "https://translation.googleapis.com";
    private static final String API_KEY_ENV_NAME = "GOOGLE_API_KEY";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/cloud-platform");
    private final String apiKey;
    private final String targetLanguage;

    private TranslateOptions(Builder builder) {
        super(TranslateFactory.class, TranslateRpcFactory.class, (HttpServiceOptions.Builder)builder);
        this.apiKey = builder.apiKey != null ? builder.apiKey : this.getDefaultApiKey();
        this.targetLanguage = (String)MoreObjects.firstNonNull((Object)builder.targetLanguage, (Object)Locale.ENGLISH.getLanguage());
    }

    protected TranslateFactory getDefaultServiceFactory() {
        return DefaultTranslateFactory.INSTANCE;
    }

    protected TranslateRpcFactory getDefaultRpcFactory() {
        return DefaultTranslateRpcFactory.INSTANCE;
    }

    protected boolean projectIdRequired() {
        return false;
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    @Deprecated
    protected String defaultApiKey() {
        return this.getDefaultApiKey();
    }

    protected String getDefaultApiKey() {
        return System.getProperty(API_KEY_ENV_NAME, System.getenv(API_KEY_ENV_NAME));
    }

    @Deprecated
    public String apiKey() {
        return this.getApiKey();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    @Deprecated
    public String targetLanguage() {
        return this.getTargetLanguage();
    }

    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TranslateOptions)) {
            return false;
        }
        TranslateOptions options = (TranslateOptions)((Object)obj);
        return this.baseEquals(options) && Objects.equals(this.apiKey, options.apiKey) && Objects.equals(this.targetLanguage, options.targetLanguage);
    }

    @Deprecated
    public static TranslateOptions defaultInstance() {
        return TranslateOptions.getDefaultInstance();
    }

    public static TranslateOptions getDefaultInstance() {
        return TranslateOptions.newBuilder().build();
    }

    @Deprecated
    public static Builder builder() {
        return TranslateOptions.newBuilder();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends HttpServiceOptions.Builder<Translate, TranslateRpc, TranslateOptions, Builder> {
        private String apiKey;
        private String targetLanguage;

        private Builder() {
        }

        private Builder(TranslateOptions options) {
            super((HttpServiceOptions)options);
            this.apiKey = options.apiKey;
        }

        @Deprecated
        public Builder projectId(String projectId) {
            return this.setProjectId(projectId);
        }

        public Builder setProjectId(String projectId) {
            super.setProjectId(projectId);
            return (Builder)this.self();
        }

        @Deprecated
        public Builder apiKey(String apiKey) {
            return this.setApiKey(apiKey);
        }

        public Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Deprecated
        public Builder targetLanguage(String targetLanguage) {
            return this.setTargetLanguage(targetLanguage);
        }

        public Builder setTargetLanguage(String targetLanguage) {
            this.targetLanguage = targetLanguage;
            return (Builder)this.self();
        }

        public TranslateOptions build() {
            return new TranslateOptions(this);
        }
    }

    public static class DefaultTranslateRpcFactory
    implements TranslateRpcFactory {
        private static final TranslateRpcFactory INSTANCE = new DefaultTranslateRpcFactory();

        public TranslateRpc create(TranslateOptions options) {
            return new DefaultTranslateRpc(options);
        }
    }

    public static class DefaultTranslateFactory
    implements TranslateFactory {
        private static final TranslateFactory INSTANCE = new DefaultTranslateFactory();

        public Translate create(TranslateOptions options) {
            return new TranslateImpl(options);
        }
    }
}

