/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.api.services.translate.model.DetectionsResourceItems;
import com.google.api.services.translate.model.LanguagesResource;
import com.google.api.services.translate.model.TranslationsResource;
import com.google.cloud.BaseService;
import com.google.cloud.Clock;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.RetryHelper;
import com.google.cloud.RetryParams;
import com.google.cloud.ServiceOptions;
import com.google.cloud.translate.Detection;
import com.google.cloud.translate.Language;
import com.google.cloud.translate.Option;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateException;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import com.google.cloud.translate.spi.TranslateRpc;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

final class TranslateImpl
extends BaseService<TranslateOptions>
implements Translate {
    private final TranslateRpc translateRpc;
    private static final Function<List<DetectionsResourceItems>, Detection> DETECTION_FROM_PB_FUNCTION = new Function<List<DetectionsResourceItems>, Detection>(){

        public Detection apply(List<DetectionsResourceItems> detectionPb) {
            return Detection.fromPb(detectionPb.get(0));
        }
    };

    TranslateImpl(TranslateOptions options) {
        super((ServiceOptions)options);
        this.translateRpc = (TranslateRpc)options.rpc();
    }

    @Override
    public List<Language> listSupportedLanguages(final Translate.LanguageListOption ... options) {
        try {
            return Lists.transform((List)((List)RetryHelper.runWithRetries((Callable)new Callable<List<LanguagesResource>>(){

                @Override
                public List<LanguagesResource> call() {
                    return TranslateImpl.this.translateRpc.listSupportedLanguages(TranslateImpl.this.optionMap(options));
                }
            }, (RetryParams)((TranslateOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((TranslateOptions)this.options()).clock())), Language.FROM_PB_FUNCTION);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw TranslateException.translateAndThrow(e);
        }
    }

    @Override
    public List<Detection> detect(final List<String> texts) {
        try {
            List detectionsPb = (List)RetryHelper.runWithRetries((Callable)new Callable<List<List<DetectionsResourceItems>>>(){

                @Override
                public List<List<DetectionsResourceItems>> call() {
                    return TranslateImpl.this.translateRpc.detect(texts);
                }
            }, (RetryParams)((TranslateOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((TranslateOptions)this.options()).clock());
            Iterator detectionIterator = detectionsPb.iterator();
            Iterator<String> textIterator = texts.iterator();
            while (detectionIterator.hasNext() && textIterator.hasNext()) {
                List detectionPb = (List)detectionIterator.next();
                String text = textIterator.next();
                Preconditions.checkState((detectionPb != null && !detectionPb.isEmpty() ? 1 : 0) != 0, (String)"No detection found for text: %s", (Object[])new Object[]{text});
                Preconditions.checkState((detectionPb.size() == 1 ? 1 : 0) != 0, (String)"Multiple detections found for text: %s", (Object[])new Object[]{text});
            }
            return Lists.transform((List)detectionsPb, DETECTION_FROM_PB_FUNCTION);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw TranslateException.translateAndThrow(e);
        }
    }

    @Override
    public List<Detection> detect(String ... texts) {
        return this.detect(Arrays.asList(texts));
    }

    @Override
    public Detection detect(String text) {
        return this.detect(Collections.singletonList(text)).get(0);
    }

    @Override
    public List<Translation> translate(final List<String> texts, final Translate.TranslateOption ... options) {
        try {
            return Lists.transform((List)((List)RetryHelper.runWithRetries((Callable)new Callable<List<TranslationsResource>>(){

                @Override
                public List<TranslationsResource> call() {
                    return TranslateImpl.this.translateRpc.translate(texts, TranslateImpl.this.optionMap(options));
                }
            }, (RetryParams)((TranslateOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((TranslateOptions)this.options()).clock())), Translation.FROM_PB_FUNCTION);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw TranslateException.translateAndThrow(e);
        }
    }

    @Override
    public Translation translate(String text, Translate.TranslateOption ... options) {
        return this.translate(Collections.singletonList(text), options).get(0);
    }

    private Map<TranslateRpc.Option, ?> optionMap(Option ... options) {
        EnumMap optionMap = Maps.newEnumMap(TranslateRpc.Option.class);
        for (Option option : options) {
            Object prev = optionMap.put(option.rpcOption(), option.value());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object[])new Object[]{option});
        }
        return optionMap;
    }
}

