/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.trace.v1.TraceServiceClient;
import com.google.cloud.trace.v1.stub.HttpJsonTraceServiceCallableFactory;
import com.google.cloud.trace.v1.stub.TraceServiceStub;
import com.google.cloud.trace.v1.stub.TraceServiceStubSettings;
import com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.devtools.cloudtrace.v1.Trace;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonTraceServiceStub
extends TraceServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListTracesRequest, ListTracesResponse> listTracesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudtrace.v1.TraceService/ListTraces").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/traces", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "endTime", (Object)request.getEndTime());
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "startTime", (Object)request.getStartTime());
        serializer.putQueryParam(fields, "view", (Object)request.getView());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTracesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetTraceRequest, Trace> getTraceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudtrace.v1.TraceService/GetTrace").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/traces/{traceId}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "traceId", (Object)request.getTraceId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Trace.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PatchTracesRequest, Empty> patchTracesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudtrace.v1.TraceService/PatchTraces").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/traces", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("traces", (Message)request.getTraces(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListTracesRequest, ListTracesResponse> listTracesCallable;
    private final UnaryCallable<ListTracesRequest, TraceServiceClient.ListTracesPagedResponse> listTracesPagedCallable;
    private final UnaryCallable<GetTraceRequest, Trace> getTraceCallable;
    private final UnaryCallable<PatchTracesRequest, Empty> patchTracesCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTraceServiceStub create(TraceServiceStubSettings settings) throws IOException {
        return new HttpJsonTraceServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTraceServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTraceServiceStub(TraceServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonTraceServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTraceServiceStub(TraceServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTraceServiceStub(TraceServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTraceServiceCallableFactory());
    }

    protected HttpJsonTraceServiceStub(TraceServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listTracesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTracesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getTraceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTraceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings patchTracesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchTracesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listTracesCallable = callableFactory.createUnaryCallable(listTracesTransportSettings, settings.listTracesSettings(), clientContext);
        this.listTracesPagedCallable = callableFactory.createPagedCallable(listTracesTransportSettings, settings.listTracesSettings(), clientContext);
        this.getTraceCallable = callableFactory.createUnaryCallable(getTraceTransportSettings, settings.getTraceSettings(), clientContext);
        this.patchTracesCallable = callableFactory.createUnaryCallable(patchTracesTransportSettings, settings.patchTracesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listTracesMethodDescriptor);
        methodDescriptors.add(getTraceMethodDescriptor);
        methodDescriptors.add(patchTracesMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListTracesRequest, ListTracesResponse> listTracesCallable() {
        return this.listTracesCallable;
    }

    @Override
    public UnaryCallable<ListTracesRequest, TraceServiceClient.ListTracesPagedResponse> listTracesPagedCallable() {
        return this.listTracesPagedCallable;
    }

    @Override
    public UnaryCallable<GetTraceRequest, Trace> getTraceCallable() {
        return this.getTraceCallable;
    }

    @Override
    public UnaryCallable<PatchTracesRequest, Empty> patchTracesCallable() {
        return this.patchTracesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

