/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.v2;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.trace.v2.TraceServiceSettings;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.cloud.trace.v2.stub.TraceServiceStubSettings;
import com.google.devtools.cloudtrace.v2.BatchWriteSpansRequest;
import com.google.devtools.cloudtrace.v2.ProjectName;
import com.google.devtools.cloudtrace.v2.Span;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TraceServiceClient
implements BackgroundResource {
    private final TraceServiceSettings settings;
    private final TraceServiceStub stub;

    public static final TraceServiceClient create() throws IOException {
        return TraceServiceClient.create(TraceServiceSettings.newBuilder().build());
    }

    public static final TraceServiceClient create(TraceServiceSettings settings) throws IOException {
        return new TraceServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TraceServiceClient create(TraceServiceStub stub) {
        return new TraceServiceClient(stub);
    }

    protected TraceServiceClient(TraceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TraceServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TraceServiceClient(TraceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TraceServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TraceServiceStub getStub() {
        return this.stub;
    }

    public final Span createSpan(Span request) {
        return (Span)this.createSpanCallable().call((Object)request);
    }

    public final UnaryCallable<Span, Span> createSpanCallable() {
        return this.stub.createSpanCallable();
    }

    public final void batchWriteSpans(ProjectName name, List<Span> spans) {
        BatchWriteSpansRequest request = BatchWriteSpansRequest.newBuilder().setName(name == null ? null : name.toString()).addAllSpans(spans).build();
        this.batchWriteSpans(request);
    }

    public final void batchWriteSpans(String name, List<Span> spans) {
        BatchWriteSpansRequest request = BatchWriteSpansRequest.newBuilder().setName(name).addAllSpans(spans).build();
        this.batchWriteSpans(request);
    }

    public final void batchWriteSpans(BatchWriteSpansRequest request) {
        this.batchWriteSpansCallable().call((Object)request);
    }

    public final UnaryCallable<BatchWriteSpansRequest, Empty> batchWriteSpansCallable() {
        return this.stub.batchWriteSpansCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

