/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.spi.v1;

import com.google.api.gax.core.PageAccessor;
import com.google.api.gax.grpc.ApiCallable;
import com.google.cloud.trace.spi.v1.TraceServiceSettings;
import com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.devtools.cloudtrace.v1.Trace;
import com.google.devtools.cloudtrace.v1.Traces;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class TraceServiceApi
implements AutoCloseable {
    private final TraceServiceSettings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final ApiCallable<PatchTracesRequest, Empty> patchTracesCallable;
    private final ApiCallable<GetTraceRequest, Trace> getTraceCallable;
    private final ApiCallable<ListTracesRequest, ListTracesResponse> listTracesCallable;
    private final ApiCallable<ListTracesRequest, PageAccessor<Trace>> listTracesPagedCallable;

    public final TraceServiceSettings getSettings() {
        return this.settings;
    }

    public static final TraceServiceApi create() throws IOException {
        return TraceServiceApi.create(TraceServiceSettings.defaultBuilder().build());
    }

    public static final TraceServiceApi create(TraceServiceSettings settings) throws IOException {
        return new TraceServiceApi(settings);
    }

    protected TraceServiceApi(TraceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.patchTracesCallable = ApiCallable.create(settings.patchTracesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.getTraceCallable = ApiCallable.create(settings.getTraceSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listTracesCallable = ApiCallable.create(settings.listTracesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listTracesPagedCallable = ApiCallable.createPagedVariant(settings.listTracesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    TraceServiceApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    TraceServiceApi.this.executor.shutdown();
                }
            });
        }
    }

    public final void patchTraces(String projectId, Traces traces) {
        PatchTracesRequest request = PatchTracesRequest.newBuilder().setProjectId(projectId).setTraces(traces).build();
        this.patchTraces(request);
    }

    public final void patchTraces(PatchTracesRequest request) {
        this.patchTracesCallable().call((Object)request);
    }

    public final ApiCallable<PatchTracesRequest, Empty> patchTracesCallable() {
        return this.patchTracesCallable;
    }

    public final Trace getTrace(String projectId, String traceId) {
        GetTraceRequest request = GetTraceRequest.newBuilder().setProjectId(projectId).setTraceId(traceId).build();
        return this.getTrace(request);
    }

    private final Trace getTrace(GetTraceRequest request) {
        return (Trace)this.getTraceCallable().call((Object)request);
    }

    public final ApiCallable<GetTraceRequest, Trace> getTraceCallable() {
        return this.getTraceCallable;
    }

    public final PageAccessor<Trace> listTraces(String projectId) {
        ListTracesRequest request = ListTracesRequest.newBuilder().setProjectId(projectId).build();
        return this.listTraces(request);
    }

    public final PageAccessor<Trace> listTraces(ListTracesRequest request) {
        return (PageAccessor)this.listTracesPagedCallable().call((Object)request);
    }

    public final ApiCallable<ListTracesRequest, PageAccessor<Trace>> listTracesPagedCallable() {
        return this.listTracesPagedCallable;
    }

    public final ApiCallable<ListTracesRequest, ListTracesResponse> listTracesCallable() {
        return this.listTracesCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

