/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.tpu.v1.AcceleratorType;
import com.google.cloud.tpu.v1.CreateNodeRequest;
import com.google.cloud.tpu.v1.DeleteNodeRequest;
import com.google.cloud.tpu.v1.GetAcceleratorTypeRequest;
import com.google.cloud.tpu.v1.GetNodeRequest;
import com.google.cloud.tpu.v1.GetTensorFlowVersionRequest;
import com.google.cloud.tpu.v1.ListAcceleratorTypesRequest;
import com.google.cloud.tpu.v1.ListAcceleratorTypesResponse;
import com.google.cloud.tpu.v1.ListNodesRequest;
import com.google.cloud.tpu.v1.ListNodesResponse;
import com.google.cloud.tpu.v1.ListTensorFlowVersionsRequest;
import com.google.cloud.tpu.v1.ListTensorFlowVersionsResponse;
import com.google.cloud.tpu.v1.Node;
import com.google.cloud.tpu.v1.OperationMetadata;
import com.google.cloud.tpu.v1.ReimageNodeRequest;
import com.google.cloud.tpu.v1.StartNodeRequest;
import com.google.cloud.tpu.v1.StopNodeRequest;
import com.google.cloud.tpu.v1.TensorFlowVersion;
import com.google.cloud.tpu.v1.TpuClient;
import com.google.cloud.tpu.v1.stub.GrpcTpuStub;
import com.google.cloud.tpu.v1.stub.TpuStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TpuStubSettings
extends StubSettings<TpuStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListNodesRequest, ListNodesResponse, TpuClient.ListNodesPagedResponse> listNodesSettings;
    private final UnaryCallSettings<GetNodeRequest, Node> getNodeSettings;
    private final UnaryCallSettings<CreateNodeRequest, Operation> createNodeSettings;
    private final OperationCallSettings<CreateNodeRequest, Node, OperationMetadata> createNodeOperationSettings;
    private final UnaryCallSettings<DeleteNodeRequest, Operation> deleteNodeSettings;
    private final OperationCallSettings<DeleteNodeRequest, Node, OperationMetadata> deleteNodeOperationSettings;
    private final UnaryCallSettings<ReimageNodeRequest, Operation> reimageNodeSettings;
    private final OperationCallSettings<ReimageNodeRequest, Node, OperationMetadata> reimageNodeOperationSettings;
    private final UnaryCallSettings<StopNodeRequest, Operation> stopNodeSettings;
    private final OperationCallSettings<StopNodeRequest, Node, OperationMetadata> stopNodeOperationSettings;
    private final UnaryCallSettings<StartNodeRequest, Operation> startNodeSettings;
    private final OperationCallSettings<StartNodeRequest, Node, OperationMetadata> startNodeOperationSettings;
    private final PagedCallSettings<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TpuClient.ListTensorFlowVersionsPagedResponse> listTensorFlowVersionsSettings;
    private final UnaryCallSettings<GetTensorFlowVersionRequest, TensorFlowVersion> getTensorFlowVersionSettings;
    private final PagedCallSettings<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesSettings;
    private final UnaryCallSettings<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeSettings;
    private static final PagedListDescriptor<ListNodesRequest, ListNodesResponse, Node> LIST_NODES_PAGE_STR_DESC = new PagedListDescriptor<ListNodesRequest, ListNodesResponse, Node>(){

        public String emptyToken() {
            return "";
        }

        public ListNodesRequest injectToken(ListNodesRequest payload, String token) {
            return ListNodesRequest.newBuilder((ListNodesRequest)payload).setPageToken(token).build();
        }

        public ListNodesRequest injectPageSize(ListNodesRequest payload, int pageSize) {
            return ListNodesRequest.newBuilder((ListNodesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNodesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNodesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Node> extractResources(ListNodesResponse payload) {
            return payload.getNodesList() == null ? ImmutableList.of() : payload.getNodesList();
        }
    };
    private static final PagedListDescriptor<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TensorFlowVersion> LIST_TENSOR_FLOW_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TensorFlowVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListTensorFlowVersionsRequest injectToken(ListTensorFlowVersionsRequest payload, String token) {
            return ListTensorFlowVersionsRequest.newBuilder((ListTensorFlowVersionsRequest)payload).setPageToken(token).build();
        }

        public ListTensorFlowVersionsRequest injectPageSize(ListTensorFlowVersionsRequest payload, int pageSize) {
            return ListTensorFlowVersionsRequest.newBuilder((ListTensorFlowVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTensorFlowVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTensorFlowVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TensorFlowVersion> extractResources(ListTensorFlowVersionsResponse payload) {
            return payload.getTensorflowVersionsList() == null ? ImmutableList.of() : payload.getTensorflowVersionsList();
        }
    };
    private static final PagedListDescriptor<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType> LIST_ACCELERATOR_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType>(){

        public String emptyToken() {
            return "";
        }

        public ListAcceleratorTypesRequest injectToken(ListAcceleratorTypesRequest payload, String token) {
            return ListAcceleratorTypesRequest.newBuilder((ListAcceleratorTypesRequest)payload).setPageToken(token).build();
        }

        public ListAcceleratorTypesRequest injectPageSize(ListAcceleratorTypesRequest payload, int pageSize) {
            return ListAcceleratorTypesRequest.newBuilder((ListAcceleratorTypesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAcceleratorTypesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAcceleratorTypesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AcceleratorType> extractResources(ListAcceleratorTypesResponse payload) {
            return payload.getAcceleratorTypesList() == null ? ImmutableList.of() : payload.getAcceleratorTypesList();
        }
    };
    private static final PagedListResponseFactory<ListNodesRequest, ListNodesResponse, TpuClient.ListNodesPagedResponse> LIST_NODES_PAGE_STR_FACT = new PagedListResponseFactory<ListNodesRequest, ListNodesResponse, TpuClient.ListNodesPagedResponse>(){

        public ApiFuture<TpuClient.ListNodesPagedResponse> getFuturePagedResponse(UnaryCallable<ListNodesRequest, ListNodesResponse> callable, ListNodesRequest request, ApiCallContext context, ApiFuture<ListNodesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NODES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TpuClient.ListNodesPagedResponse.createAsync((PageContext<ListNodesRequest, ListNodesResponse, Node>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TpuClient.ListTensorFlowVersionsPagedResponse> LIST_TENSOR_FLOW_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TpuClient.ListTensorFlowVersionsPagedResponse>(){

        public ApiFuture<TpuClient.ListTensorFlowVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse> callable, ListTensorFlowVersionsRequest request, ApiCallContext context, ApiFuture<ListTensorFlowVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TENSOR_FLOW_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TpuClient.ListTensorFlowVersionsPagedResponse.createAsync((PageContext<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TensorFlowVersion>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, TpuClient.ListAcceleratorTypesPagedResponse> LIST_ACCELERATOR_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, TpuClient.ListAcceleratorTypesPagedResponse>(){

        public ApiFuture<TpuClient.ListAcceleratorTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> callable, ListAcceleratorTypesRequest request, ApiCallContext context, ApiFuture<ListAcceleratorTypesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ACCELERATOR_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TpuClient.ListAcceleratorTypesPagedResponse.createAsync((PageContext<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListNodesRequest, ListNodesResponse, TpuClient.ListNodesPagedResponse> listNodesSettings() {
        return this.listNodesSettings;
    }

    public UnaryCallSettings<GetNodeRequest, Node> getNodeSettings() {
        return this.getNodeSettings;
    }

    public UnaryCallSettings<CreateNodeRequest, Operation> createNodeSettings() {
        return this.createNodeSettings;
    }

    public OperationCallSettings<CreateNodeRequest, Node, OperationMetadata> createNodeOperationSettings() {
        return this.createNodeOperationSettings;
    }

    public UnaryCallSettings<DeleteNodeRequest, Operation> deleteNodeSettings() {
        return this.deleteNodeSettings;
    }

    public OperationCallSettings<DeleteNodeRequest, Node, OperationMetadata> deleteNodeOperationSettings() {
        return this.deleteNodeOperationSettings;
    }

    public UnaryCallSettings<ReimageNodeRequest, Operation> reimageNodeSettings() {
        return this.reimageNodeSettings;
    }

    public OperationCallSettings<ReimageNodeRequest, Node, OperationMetadata> reimageNodeOperationSettings() {
        return this.reimageNodeOperationSettings;
    }

    public UnaryCallSettings<StopNodeRequest, Operation> stopNodeSettings() {
        return this.stopNodeSettings;
    }

    public OperationCallSettings<StopNodeRequest, Node, OperationMetadata> stopNodeOperationSettings() {
        return this.stopNodeOperationSettings;
    }

    public UnaryCallSettings<StartNodeRequest, Operation> startNodeSettings() {
        return this.startNodeSettings;
    }

    public OperationCallSettings<StartNodeRequest, Node, OperationMetadata> startNodeOperationSettings() {
        return this.startNodeOperationSettings;
    }

    public PagedCallSettings<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TpuClient.ListTensorFlowVersionsPagedResponse> listTensorFlowVersionsSettings() {
        return this.listTensorFlowVersionsSettings;
    }

    public UnaryCallSettings<GetTensorFlowVersionRequest, TensorFlowVersion> getTensorFlowVersionSettings() {
        return this.getTensorFlowVersionSettings;
    }

    public PagedCallSettings<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesSettings() {
        return this.listAcceleratorTypesSettings;
    }

    public UnaryCallSettings<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeSettings() {
        return this.getAcceleratorTypeSettings;
    }

    public TpuStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTpuStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "tpu.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "tpu.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TpuStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TpuStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TpuStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listNodesSettings = settingsBuilder.listNodesSettings().build();
        this.getNodeSettings = settingsBuilder.getNodeSettings().build();
        this.createNodeSettings = settingsBuilder.createNodeSettings().build();
        this.createNodeOperationSettings = settingsBuilder.createNodeOperationSettings().build();
        this.deleteNodeSettings = settingsBuilder.deleteNodeSettings().build();
        this.deleteNodeOperationSettings = settingsBuilder.deleteNodeOperationSettings().build();
        this.reimageNodeSettings = settingsBuilder.reimageNodeSettings().build();
        this.reimageNodeOperationSettings = settingsBuilder.reimageNodeOperationSettings().build();
        this.stopNodeSettings = settingsBuilder.stopNodeSettings().build();
        this.stopNodeOperationSettings = settingsBuilder.stopNodeOperationSettings().build();
        this.startNodeSettings = settingsBuilder.startNodeSettings().build();
        this.startNodeOperationSettings = settingsBuilder.startNodeOperationSettings().build();
        this.listTensorFlowVersionsSettings = settingsBuilder.listTensorFlowVersionsSettings().build();
        this.getTensorFlowVersionSettings = settingsBuilder.getTensorFlowVersionSettings().build();
        this.listAcceleratorTypesSettings = settingsBuilder.listAcceleratorTypesSettings().build();
        this.getAcceleratorTypeSettings = settingsBuilder.getAcceleratorTypeSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TpuStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListNodesRequest, ListNodesResponse, TpuClient.ListNodesPagedResponse> listNodesSettings;
        private final UnaryCallSettings.Builder<GetNodeRequest, Node> getNodeSettings;
        private final UnaryCallSettings.Builder<CreateNodeRequest, Operation> createNodeSettings;
        private final OperationCallSettings.Builder<CreateNodeRequest, Node, OperationMetadata> createNodeOperationSettings;
        private final UnaryCallSettings.Builder<DeleteNodeRequest, Operation> deleteNodeSettings;
        private final OperationCallSettings.Builder<DeleteNodeRequest, Node, OperationMetadata> deleteNodeOperationSettings;
        private final UnaryCallSettings.Builder<ReimageNodeRequest, Operation> reimageNodeSettings;
        private final OperationCallSettings.Builder<ReimageNodeRequest, Node, OperationMetadata> reimageNodeOperationSettings;
        private final UnaryCallSettings.Builder<StopNodeRequest, Operation> stopNodeSettings;
        private final OperationCallSettings.Builder<StopNodeRequest, Node, OperationMetadata> stopNodeOperationSettings;
        private final UnaryCallSettings.Builder<StartNodeRequest, Operation> startNodeSettings;
        private final OperationCallSettings.Builder<StartNodeRequest, Node, OperationMetadata> startNodeOperationSettings;
        private final PagedCallSettings.Builder<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TpuClient.ListTensorFlowVersionsPagedResponse> listTensorFlowVersionsSettings;
        private final UnaryCallSettings.Builder<GetTensorFlowVersionRequest, TensorFlowVersion> getTensorFlowVersionSettings;
        private final PagedCallSettings.Builder<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesSettings;
        private final UnaryCallSettings.Builder<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listNodesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NODES_PAGE_STR_FACT);
            this.getNodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createNodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createNodeOperationSettings = OperationCallSettings.newBuilder();
            this.deleteNodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNodeOperationSettings = OperationCallSettings.newBuilder();
            this.reimageNodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reimageNodeOperationSettings = OperationCallSettings.newBuilder();
            this.stopNodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopNodeOperationSettings = OperationCallSettings.newBuilder();
            this.startNodeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startNodeOperationSettings = OperationCallSettings.newBuilder();
            this.listTensorFlowVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TENSOR_FLOW_VERSIONS_PAGE_STR_FACT);
            this.getTensorFlowVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAcceleratorTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ACCELERATOR_TYPES_PAGE_STR_FACT);
            this.getAcceleratorTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listNodesSettings, this.getNodeSettings, this.createNodeSettings, this.deleteNodeSettings, this.reimageNodeSettings, this.stopNodeSettings, this.startNodeSettings, this.listTensorFlowVersionsSettings, this.getTensorFlowVersionSettings, this.listAcceleratorTypesSettings, this.getAcceleratorTypeSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TpuStubSettings settings) {
            super((StubSettings)settings);
            this.listNodesSettings = settings.listNodesSettings.toBuilder();
            this.getNodeSettings = settings.getNodeSettings.toBuilder();
            this.createNodeSettings = settings.createNodeSettings.toBuilder();
            this.createNodeOperationSettings = settings.createNodeOperationSettings.toBuilder();
            this.deleteNodeSettings = settings.deleteNodeSettings.toBuilder();
            this.deleteNodeOperationSettings = settings.deleteNodeOperationSettings.toBuilder();
            this.reimageNodeSettings = settings.reimageNodeSettings.toBuilder();
            this.reimageNodeOperationSettings = settings.reimageNodeOperationSettings.toBuilder();
            this.stopNodeSettings = settings.stopNodeSettings.toBuilder();
            this.stopNodeOperationSettings = settings.stopNodeOperationSettings.toBuilder();
            this.startNodeSettings = settings.startNodeSettings.toBuilder();
            this.startNodeOperationSettings = settings.startNodeOperationSettings.toBuilder();
            this.listTensorFlowVersionsSettings = settings.listTensorFlowVersionsSettings.toBuilder();
            this.getTensorFlowVersionSettings = settings.getTensorFlowVersionSettings.toBuilder();
            this.listAcceleratorTypesSettings = settings.listAcceleratorTypesSettings.toBuilder();
            this.getAcceleratorTypeSettings = settings.getAcceleratorTypeSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listNodesSettings, this.getNodeSettings, this.createNodeSettings, this.deleteNodeSettings, this.reimageNodeSettings, this.stopNodeSettings, this.startNodeSettings, this.listTensorFlowVersionsSettings, this.getTensorFlowVersionSettings, this.listAcceleratorTypesSettings, this.getAcceleratorTypeSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TpuStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TpuStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TpuStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TpuStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TpuStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listNodesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getNodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createNodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteNodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.reimageNodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.stopNodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.startNodeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listTensorFlowVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getTensorFlowVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listAcceleratorTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getAcceleratorTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createNodeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Node.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteNodeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Node.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.reimageNodeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Node.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.stopNodeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Node.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.startNodeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Node.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListNodesRequest, ListNodesResponse, TpuClient.ListNodesPagedResponse> listNodesSettings() {
            return this.listNodesSettings;
        }

        public UnaryCallSettings.Builder<GetNodeRequest, Node> getNodeSettings() {
            return this.getNodeSettings;
        }

        public UnaryCallSettings.Builder<CreateNodeRequest, Operation> createNodeSettings() {
            return this.createNodeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateNodeRequest, Node, OperationMetadata> createNodeOperationSettings() {
            return this.createNodeOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteNodeRequest, Operation> deleteNodeSettings() {
            return this.deleteNodeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteNodeRequest, Node, OperationMetadata> deleteNodeOperationSettings() {
            return this.deleteNodeOperationSettings;
        }

        public UnaryCallSettings.Builder<ReimageNodeRequest, Operation> reimageNodeSettings() {
            return this.reimageNodeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ReimageNodeRequest, Node, OperationMetadata> reimageNodeOperationSettings() {
            return this.reimageNodeOperationSettings;
        }

        public UnaryCallSettings.Builder<StopNodeRequest, Operation> stopNodeSettings() {
            return this.stopNodeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StopNodeRequest, Node, OperationMetadata> stopNodeOperationSettings() {
            return this.stopNodeOperationSettings;
        }

        public UnaryCallSettings.Builder<StartNodeRequest, Operation> startNodeSettings() {
            return this.startNodeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StartNodeRequest, Node, OperationMetadata> startNodeOperationSettings() {
            return this.startNodeOperationSettings;
        }

        public PagedCallSettings.Builder<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TpuClient.ListTensorFlowVersionsPagedResponse> listTensorFlowVersionsSettings() {
            return this.listTensorFlowVersionsSettings;
        }

        public UnaryCallSettings.Builder<GetTensorFlowVersionRequest, TensorFlowVersion> getTensorFlowVersionSettings() {
            return this.getTensorFlowVersionSettings;
        }

        public PagedCallSettings.Builder<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesSettings() {
            return this.listAcceleratorTypesSettings;
        }

        public UnaryCallSettings.Builder<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeSettings() {
            return this.getAcceleratorTypeSettings;
        }

        public TpuStubSettings build() throws IOException {
            return new TpuStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

