/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.texttospeech.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.texttospeech.v1beta1.AudioConfig;
import com.google.cloud.texttospeech.v1beta1.ListVoicesRequest;
import com.google.cloud.texttospeech.v1beta1.ListVoicesResponse;
import com.google.cloud.texttospeech.v1beta1.SynthesisInput;
import com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest;
import com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse;
import com.google.cloud.texttospeech.v1beta1.TextToSpeechSettings;
import com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams;
import com.google.cloud.texttospeech.v1beta1.stub.TextToSpeechStub;
import com.google.cloud.texttospeech.v1beta1.stub.TextToSpeechStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TextToSpeechClient
implements BackgroundResource {
    private final TextToSpeechSettings settings;
    private final TextToSpeechStub stub;

    public static final TextToSpeechClient create() throws IOException {
        return TextToSpeechClient.create(TextToSpeechSettings.newBuilder().build());
    }

    public static final TextToSpeechClient create(TextToSpeechSettings settings) throws IOException {
        return new TextToSpeechClient(settings);
    }

    public static final TextToSpeechClient create(TextToSpeechStub stub) {
        return new TextToSpeechClient(stub);
    }

    protected TextToSpeechClient(TextToSpeechSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TextToSpeechStubSettings)settings.getStubSettings()).createStub();
    }

    protected TextToSpeechClient(TextToSpeechStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TextToSpeechSettings getSettings() {
        return this.settings;
    }

    public TextToSpeechStub getStub() {
        return this.stub;
    }

    public final ListVoicesResponse listVoices(String languageCode) {
        ListVoicesRequest request = ListVoicesRequest.newBuilder().setLanguageCode(languageCode).build();
        return this.listVoices(request);
    }

    public final ListVoicesResponse listVoices(ListVoicesRequest request) {
        return (ListVoicesResponse)this.listVoicesCallable().call((Object)request);
    }

    public final UnaryCallable<ListVoicesRequest, ListVoicesResponse> listVoicesCallable() {
        return this.stub.listVoicesCallable();
    }

    public final SynthesizeSpeechResponse synthesizeSpeech(SynthesisInput input, VoiceSelectionParams voice, AudioConfig audioConfig) {
        SynthesizeSpeechRequest request = SynthesizeSpeechRequest.newBuilder().setInput(input).setVoice(voice).setAudioConfig(audioConfig).build();
        return this.synthesizeSpeech(request);
    }

    public final SynthesizeSpeechResponse synthesizeSpeech(SynthesizeSpeechRequest request) {
        return (SynthesizeSpeechResponse)this.synthesizeSpeechCallable().call((Object)request);
    }

    public final UnaryCallable<SynthesizeSpeechRequest, SynthesizeSpeechResponse> synthesizeSpeechCallable() {
        return this.stub.synthesizeSpeechCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

