/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4.CompleteQueryRequest;
import com.google.cloud.talent.v4.CompleteQueryResponse;
import com.google.cloud.talent.v4.stub.CompletionStub;
import com.google.cloud.talent.v4.stub.CompletionStubSettings;
import com.google.cloud.talent.v4.stub.GrpcCompletionCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCompletionStub
extends CompletionStub {
    private static final MethodDescriptor<CompleteQueryRequest, CompleteQueryResponse> completeQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.Completion/CompleteQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)CompleteQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CompleteQueryResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCompletionStub create(CompletionStubSettings settings) throws IOException {
        return new GrpcCompletionStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCompletionStub create(ClientContext clientContext) throws IOException {
        return new GrpcCompletionStub(CompletionStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCompletionStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCompletionStub(CompletionStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCompletionStub(CompletionStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCompletionCallableFactory());
    }

    protected GrpcCompletionStub(CompletionStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings completeQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(completeQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("tenant", String.valueOf(request.getTenant()));
            return builder.build();
        }).build();
        this.completeQueryCallable = callableFactory.createUnaryCallable(completeQueryTransportSettings, settings.completeQuerySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable() {
        return this.completeQueryCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

