/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.BatchCreateJobsRequest;
import com.google.cloud.talent.v4beta1.BatchDeleteJobsRequest;
import com.google.cloud.talent.v4beta1.BatchOperationMetadata;
import com.google.cloud.talent.v4beta1.BatchUpdateJobsRequest;
import com.google.cloud.talent.v4beta1.CreateJobRequest;
import com.google.cloud.talent.v4beta1.DeleteJobRequest;
import com.google.cloud.talent.v4beta1.GetJobRequest;
import com.google.cloud.talent.v4beta1.Job;
import com.google.cloud.talent.v4beta1.JobOperationResult;
import com.google.cloud.talent.v4beta1.JobServiceClient;
import com.google.cloud.talent.v4beta1.ListJobsRequest;
import com.google.cloud.talent.v4beta1.ListJobsResponse;
import com.google.cloud.talent.v4beta1.SearchJobsRequest;
import com.google.cloud.talent.v4beta1.SearchJobsResponse;
import com.google.cloud.talent.v4beta1.UpdateJobRequest;
import com.google.cloud.talent.v4beta1.stub.HttpJsonJobServiceCallableFactory;
import com.google.cloud.talent.v4beta1.stub.JobServiceStub;
import com.google.cloud.talent.v4beta1.stub.JobServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonJobServiceStub
extends JobServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(JobOperationResult.getDescriptor()).add(BatchOperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateJobRequest, Job> createJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.JobService/CreateJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{parent=projects/*/tenants/*}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{parent=projects/*}/jobs"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchCreateJobsRequest, Operation> batchCreateJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.JobService/BatchCreateJobs").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{parent=projects/*/tenants/*}/jobs:batchCreate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{parent=projects/*}/jobs:batchCreate"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.JobService/GetJob").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{name=projects/*/tenants/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{name=projects/*/jobs/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateJobRequest, Job> updateJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.JobService/UpdateJob").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{job.name=projects/*/tenants/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "job.name", (Object)request.getJob().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{job.name=projects/*/jobs/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchUpdateJobsRequest, Operation> batchUpdateJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.JobService/BatchUpdateJobs").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{parent=projects/*/tenants/*}/jobs:batchUpdate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{parent=projects/*}/jobs:batchUpdate"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteJobRequest, Empty> deleteJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.JobService/DeleteJob").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{name=projects/*/tenants/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{name=projects/*/jobs/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchDeleteJobsRequest, Empty> batchDeleteJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.JobService/BatchDeleteJobs").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{parent=projects/*/tenants/*}/jobs:batchDelete", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{parent=projects/*}/jobs:batchDelete"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.JobService/ListJobs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{parent=projects/*/tenants/*}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{parent=projects/*}/jobs"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "jobView", (Object)request.getJobViewValue());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListJobsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchJobsRequest, SearchJobsResponse> searchJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.JobService/SearchJobs").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{parent=projects/*/tenants/*}/jobs:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{parent=projects/*}/jobs:search"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchJobsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.JobService/SearchJobsForAlert").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{parent=projects/*/tenants/*}/jobs:searchForAlert", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{parent=projects/*}/jobs:searchForAlert"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchJobsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateJobRequest, Job> createJobCallable;
    private final UnaryCallable<BatchCreateJobsRequest, Operation> batchCreateJobsCallable;
    private final OperationCallable<BatchCreateJobsRequest, JobOperationResult, BatchOperationMetadata> batchCreateJobsOperationCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<UpdateJobRequest, Job> updateJobCallable;
    private final UnaryCallable<BatchUpdateJobsRequest, Operation> batchUpdateJobsCallable;
    private final OperationCallable<BatchUpdateJobsRequest, JobOperationResult, BatchOperationMetadata> batchUpdateJobsOperationCallable;
    private final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable;
    private final UnaryCallable<BatchDeleteJobsRequest, Empty> batchDeleteJobsCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, JobServiceClient.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsCallable;
    private final UnaryCallable<SearchJobsRequest, JobServiceClient.SearchJobsPagedResponse> searchJobsPagedCallable;
    private final UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertCallable;
    private final UnaryCallable<SearchJobsRequest, JobServiceClient.SearchJobsForAlertPagedResponse> searchJobsForAlertPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonJobServiceStub create(JobServiceStubSettings settings) throws IOException {
        return new HttpJsonJobServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonJobServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonJobServiceStub(JobServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonJobServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonJobServiceStub(JobServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonJobServiceStub(JobServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonJobServiceCallableFactory());
    }

    protected HttpJsonJobServiceStub(JobServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v4beta1/{name=projects/*/operations/*}").build()).build());
        HttpJsonCallSettings createJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createJobMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings batchCreateJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchCreateJobsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateJobMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("job.name", String.valueOf(request.getJob().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings batchUpdateJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchUpdateJobsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteJobMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings batchDeleteJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchDeleteJobsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings searchJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchJobsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings searchJobsForAlertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchJobsForAlertMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createJobCallable = callableFactory.createUnaryCallable(createJobTransportSettings, settings.createJobSettings(), clientContext);
        this.batchCreateJobsCallable = callableFactory.createUnaryCallable(batchCreateJobsTransportSettings, settings.batchCreateJobsSettings(), clientContext);
        this.batchCreateJobsOperationCallable = callableFactory.createOperationCallable(batchCreateJobsTransportSettings, settings.batchCreateJobsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.updateJobCallable = callableFactory.createUnaryCallable(updateJobTransportSettings, settings.updateJobSettings(), clientContext);
        this.batchUpdateJobsCallable = callableFactory.createUnaryCallable(batchUpdateJobsTransportSettings, settings.batchUpdateJobsSettings(), clientContext);
        this.batchUpdateJobsOperationCallable = callableFactory.createOperationCallable(batchUpdateJobsTransportSettings, settings.batchUpdateJobsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteJobCallable = callableFactory.createUnaryCallable(deleteJobTransportSettings, settings.deleteJobSettings(), clientContext);
        this.batchDeleteJobsCallable = callableFactory.createUnaryCallable(batchDeleteJobsTransportSettings, settings.batchDeleteJobsSettings(), clientContext);
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.searchJobsCallable = callableFactory.createUnaryCallable(searchJobsTransportSettings, settings.searchJobsSettings(), clientContext);
        this.searchJobsPagedCallable = callableFactory.createPagedCallable(searchJobsTransportSettings, settings.searchJobsSettings(), clientContext);
        this.searchJobsForAlertCallable = callableFactory.createUnaryCallable(searchJobsForAlertTransportSettings, settings.searchJobsForAlertSettings(), clientContext);
        this.searchJobsForAlertPagedCallable = callableFactory.createPagedCallable(searchJobsForAlertTransportSettings, settings.searchJobsForAlertSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createJobMethodDescriptor);
        methodDescriptors.add(batchCreateJobsMethodDescriptor);
        methodDescriptors.add(getJobMethodDescriptor);
        methodDescriptors.add(updateJobMethodDescriptor);
        methodDescriptors.add(batchUpdateJobsMethodDescriptor);
        methodDescriptors.add(deleteJobMethodDescriptor);
        methodDescriptors.add(batchDeleteJobsMethodDescriptor);
        methodDescriptors.add(listJobsMethodDescriptor);
        methodDescriptors.add(searchJobsMethodDescriptor);
        methodDescriptors.add(searchJobsForAlertMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.createJobCallable;
    }

    @Override
    public UnaryCallable<BatchCreateJobsRequest, Operation> batchCreateJobsCallable() {
        return this.batchCreateJobsCallable;
    }

    @Override
    public OperationCallable<BatchCreateJobsRequest, JobOperationResult, BatchOperationMetadata> batchCreateJobsOperationCallable() {
        return this.batchCreateJobsOperationCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.updateJobCallable;
    }

    @Override
    public UnaryCallable<BatchUpdateJobsRequest, Operation> batchUpdateJobsCallable() {
        return this.batchUpdateJobsCallable;
    }

    @Override
    public OperationCallable<BatchUpdateJobsRequest, JobOperationResult, BatchOperationMetadata> batchUpdateJobsOperationCallable() {
        return this.batchUpdateJobsOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.deleteJobCallable;
    }

    @Override
    public UnaryCallable<BatchDeleteJobsRequest, Empty> batchDeleteJobsCallable() {
        return this.batchDeleteJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, JobServiceClient.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsCallable() {
        return this.searchJobsCallable;
    }

    @Override
    public UnaryCallable<SearchJobsRequest, JobServiceClient.SearchJobsPagedResponse> searchJobsPagedCallable() {
        return this.searchJobsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertCallable() {
        return this.searchJobsForAlertCallable;
    }

    @Override
    public UnaryCallable<SearchJobsRequest, JobServiceClient.SearchJobsForAlertPagedResponse> searchJobsForAlertPagedCallable() {
        return this.searchJobsForAlertPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

