/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4.CreateTenantRequest;
import com.google.cloud.talent.v4.DeleteTenantRequest;
import com.google.cloud.talent.v4.GetTenantRequest;
import com.google.cloud.talent.v4.ListTenantsRequest;
import com.google.cloud.talent.v4.ListTenantsResponse;
import com.google.cloud.talent.v4.Tenant;
import com.google.cloud.talent.v4.TenantServiceClient;
import com.google.cloud.talent.v4.UpdateTenantRequest;
import com.google.cloud.talent.v4.stub.HttpJsonTenantServiceCallableFactory;
import com.google.cloud.talent.v4.stub.TenantServiceStub;
import com.google.cloud.talent.v4.stub.TenantServiceStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonTenantServiceStub
extends TenantServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateTenantRequest, Tenant> createTenantMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4.TenantService/CreateTenant").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4/{parent=projects/*}/tenants", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("tenant", (Message)request.getTenant(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Tenant.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetTenantRequest, Tenant> getTenantMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4.TenantService/GetTenant").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4/{name=projects/*/tenants/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Tenant.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateTenantRequest, Tenant> updateTenantMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4.TenantService/UpdateTenant").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4/{tenant.name=projects/*/tenants/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "tenant.name", (Object)request.getTenant().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("tenant", (Message)request.getTenant(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Tenant.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteTenantRequest, Empty> deleteTenantMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4.TenantService/DeleteTenant").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4/{name=projects/*/tenants/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListTenantsRequest, ListTenantsResponse> listTenantsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4.TenantService/ListTenants").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4/{parent=projects/*}/tenants", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTenantsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateTenantRequest, Tenant> createTenantCallable;
    private final UnaryCallable<GetTenantRequest, Tenant> getTenantCallable;
    private final UnaryCallable<UpdateTenantRequest, Tenant> updateTenantCallable;
    private final UnaryCallable<DeleteTenantRequest, Empty> deleteTenantCallable;
    private final UnaryCallable<ListTenantsRequest, ListTenantsResponse> listTenantsCallable;
    private final UnaryCallable<ListTenantsRequest, TenantServiceClient.ListTenantsPagedResponse> listTenantsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTenantServiceStub create(TenantServiceStubSettings settings) throws IOException {
        return new HttpJsonTenantServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTenantServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTenantServiceStub(TenantServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonTenantServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTenantServiceStub(TenantServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTenantServiceStub(TenantServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTenantServiceCallableFactory());
    }

    protected HttpJsonTenantServiceStub(TenantServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createTenantTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createTenantMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getTenantTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTenantMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateTenantTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateTenantMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteTenantTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteTenantMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listTenantsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTenantsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createTenantCallable = callableFactory.createUnaryCallable(createTenantTransportSettings, settings.createTenantSettings(), clientContext);
        this.getTenantCallable = callableFactory.createUnaryCallable(getTenantTransportSettings, settings.getTenantSettings(), clientContext);
        this.updateTenantCallable = callableFactory.createUnaryCallable(updateTenantTransportSettings, settings.updateTenantSettings(), clientContext);
        this.deleteTenantCallable = callableFactory.createUnaryCallable(deleteTenantTransportSettings, settings.deleteTenantSettings(), clientContext);
        this.listTenantsCallable = callableFactory.createUnaryCallable(listTenantsTransportSettings, settings.listTenantsSettings(), clientContext);
        this.listTenantsPagedCallable = callableFactory.createPagedCallable(listTenantsTransportSettings, settings.listTenantsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createTenantMethodDescriptor);
        methodDescriptors.add(getTenantMethodDescriptor);
        methodDescriptors.add(updateTenantMethodDescriptor);
        methodDescriptors.add(deleteTenantMethodDescriptor);
        methodDescriptors.add(listTenantsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateTenantRequest, Tenant> createTenantCallable() {
        return this.createTenantCallable;
    }

    @Override
    public UnaryCallable<GetTenantRequest, Tenant> getTenantCallable() {
        return this.getTenantCallable;
    }

    @Override
    public UnaryCallable<UpdateTenantRequest, Tenant> updateTenantCallable() {
        return this.updateTenantCallable;
    }

    @Override
    public UnaryCallable<DeleteTenantRequest, Empty> deleteTenantCallable() {
        return this.deleteTenantCallable;
    }

    @Override
    public UnaryCallable<ListTenantsRequest, ListTenantsResponse> listTenantsCallable() {
        return this.listTenantsCallable;
    }

    @Override
    public UnaryCallable<ListTenantsRequest, TenantServiceClient.ListTenantsPagedResponse> listTenantsPagedCallable() {
        return this.listTenantsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

