/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.Utils;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;

final class JsonResumableWrite
implements Serializable {
    private static final long serialVersionUID = 7934407897802252292L;
    private static final Gson gson = new Gson();
    private transient @MonotonicNonNull StorageObject object;
    private transient @MonotonicNonNull Hasher hasher;
    private transient @MonotonicNonNull Crc32cValue<?> cumulativeCrc32c;
    private final @MonotonicNonNull Map<StorageRpc.Option, ?> options;
    private final @MonotonicNonNull String signedUrl;
    private final @NonNull String uploadId;
    private final long beginOffset;
    private volatile String objectJson;
    private @GuardedBy(value={"objectJson"}) String base64CumulativeCrc32c;

    private JsonResumableWrite(StorageObject object, @MonotonicNonNull Hasher hasher, @MonotonicNonNull Crc32cValue<?> cumulativeCrc32c, Map<StorageRpc.Option, ?> options, String signedUrl, @NonNull String uploadId, long beginOffset) {
        this.object = object;
        this.hasher = hasher;
        this.cumulativeCrc32c = cumulativeCrc32c;
        this.options = options;
        this.signedUrl = signedUrl;
        this.uploadId = uploadId;
        this.beginOffset = beginOffset;
    }

    ImmutableMap<String, String> getExtraHeaders() {
        Object tmp;
        if (this.options != null && (tmp = this.options.get((Object)StorageRpc.Option.EXTRA_HEADERS)) != null) {
            return (ImmutableMap)tmp;
        }
        return ImmutableMap.of();
    }

    public @NonNull String getUploadId() {
        return this.uploadId;
    }

    public long getBeginOffset() {
        return this.beginOffset;
    }

    public JsonResumableWrite withBeginOffset(long newBeginOffset) {
        Preconditions.checkArgument((newBeginOffset >= this.beginOffset ? 1 : 0) != 0, (String)"New beginOffset must be >= existing beginOffset (%s >= %s)", (long)newBeginOffset, (long)this.beginOffset);
        return new JsonResumableWrite(this.object, this.hasher, this.cumulativeCrc32c, this.options, this.signedUrl, this.uploadId, newBeginOffset);
    }

    public @MonotonicNonNull Hasher getHasher() {
        return this.hasher;
    }

    public @MonotonicNonNull Crc32cValue<?> getCumulativeCrc32c() {
        return this.cumulativeCrc32c;
    }

    public void setCumulativeCrc32c(Crc32cValue<?> cumulativeCrc32c) {
        this.cumulativeCrc32c = cumulativeCrc32c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonResumableWrite)) {
            return false;
        }
        JsonResumableWrite that = (JsonResumableWrite)o;
        return this.beginOffset == that.beginOffset && Objects.equals(this.object, that.object) && Objects.equals(this.hasher, that.hasher) && this.cumulativeCrc32c.eqValue(that.cumulativeCrc32c) && Objects.equals(this.options, that.options) && Objects.equals(this.signedUrl, that.signedUrl) && Objects.equals(this.uploadId, that.uploadId);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.hasher, this.cumulativeCrc32c.getValue(), this.options, this.signedUrl, this.uploadId, this.beginOffset);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("object", (Object)this.object).add("hasher", (Object)this.hasher).add("cumulativeCrc32c", this.cumulativeCrc32c).add("options", this.options).add("signedUrl", (Object)this.signedUrl).add("uploadId", (Object)this.uploadId).add("beginOffset", this.beginOffset).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getObjectJson() {
        if (this.objectJson == null) {
            JsonResumableWrite jsonResumableWrite = this;
            synchronized (jsonResumableWrite) {
                if (this.objectJson == null) {
                    this.objectJson = gson.toJson((Object)this.object);
                    this.base64CumulativeCrc32c = (String)Utils.crc32cCodec.encode(this.cumulativeCrc32c.getValue());
                }
            }
        }
        return this.objectJson;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        String ignore = this.getObjectJson();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        JsonReader jsonReader = gson.newJsonReader((Reader)new StringReader(this.objectJson));
        this.object = (StorageObject)gson.fromJson(jsonReader, StorageObject.class);
        if (this.base64CumulativeCrc32c != null) {
            Integer decode = (Integer)Utils.crc32cCodec.decode(this.base64CumulativeCrc32c);
            this.cumulativeCrc32c = decode == 0 ? Crc32cValue.zero() : Crc32cValue.of(decode);
            this.hasher = Hasher.enabled();
        }
    }

    static JsonResumableWrite of(StorageObject req, Map<StorageRpc.Option, ?> options, String uploadId, long beginOffset) {
        return JsonResumableWrite.of(req, options, uploadId, beginOffset, Hasher.noop(), null);
    }

    static JsonResumableWrite of(StorageObject req, Map<StorageRpc.Option, ?> options, String uploadId, long beginOffset, Hasher hasher, Crc32cValue<?> initialValue) {
        return new JsonResumableWrite(req, hasher, initialValue, options, null, uploadId, beginOffset);
    }

    static JsonResumableWrite of(String signedUrl, String uploadId, long beginOffset) {
        Hasher hasher = Hasher.noop();
        if (beginOffset == 0L) {
            hasher = Hasher.defaultHasher();
        }
        return new JsonResumableWrite(null, hasher, hasher.initialValue(), null, signedUrl, uploadId, beginOffset);
    }
}

