/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageV2ProtoUtils;
import com.google.cloud.storage.UploadFailureScenario;
import com.google.cloud.storage.Utils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.storage.v2.AppendObjectSpec;
import com.google.storage.v2.BidiWriteHandle;
import com.google.storage.v2.BidiWriteObjectRedirectedError;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.WriteObjectSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

abstract class BidiUploadState {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidiUploadState.class);
    private static final Marker TRACE_ENTER = MarkerFactory.getMarker((String)"enter");
    private static final Marker TRACE_EXIT = MarkerFactory.getMarker((String)"exit");
    static final Descriptors.OneofDescriptor FIRST_MESSAGE_DESCRIPTOR = BidiWriteObjectRequest.getDescriptor().getOneofs().stream().filter(d -> "first_message".equalsIgnoreCase(d.getName())).findFirst().orElseThrow(() -> new IllegalStateException("BidiWriteObject.first_message oneof not found"));

    private BidiUploadState() {
    }

    @VisibleForTesting
    BidiUploadState(String testName) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        boolean isJunitTest = Arrays.stream(stackTrace).anyMatch(ste -> ste.getClassName().startsWith("org.junit"));
        Preconditions.checkState((boolean)isJunitTest, (String)"not a junit test", (Object)testName);
    }

    protected final StorageException err(UploadFailureScenario scenario, BidiWriteObjectResponse response) {
        BidiWriteObjectRequest t = this.peekLast();
        GrpcCallContext ctx = this.enqueueFirstMessageAndGetGrpcCallContext();
        return scenario.toStorageException(Utils.nullSafeList(t), (Message)response, ctx, (Throwable)null);
    }

    @Nullable Crc32cValue.Crc32cLengthKnown getCumulativeCrc32c() {
        return (Crc32cValue.Crc32cLengthKnown)BidiUploadState.unimplemented();
    }

    long getTotalSentBytes() {
        return (Long)BidiUploadState.unimplemented();
    }

    long getConfirmedBytes() {
        return (Long)BidiUploadState.unimplemented();
    }

    long availableCapacity() {
        return (Long)BidiUploadState.unimplemented();
    }

    boolean offer(@NonNull ChunkSegmenter.ChunkSegment data) {
        return (Boolean)BidiUploadState.unimplemented();
    }

    boolean finalFlush(long totalLength) {
        return (Boolean)BidiUploadState.unimplemented();
    }

    boolean offer(@NonNull BidiWriteObjectRequest e) {
        return (Boolean)BidiUploadState.unimplemented();
    }

    void updateStateFromResponse(BidiWriteObjectResponse response) {
        BidiUploadState.unimplemented();
    }

    @NonNull GrpcCallContext enqueueFirstMessageAndGetGrpcCallContext() {
        return (GrpcCallContext)BidiUploadState.unimplemented();
    }

    void sendVia(Consumer<BidiWriteObjectRequest> consumer) {
        BidiUploadState.unimplemented();
    }

    void updateFromRedirect(@NonNull BidiWriteObjectRedirectedError redirect) {
        BidiUploadState.unimplemented();
    }

    void terminalError() {
        BidiUploadState.unimplemented();
    }

    void pendingRetry() {
        BidiUploadState.unimplemented();
    }

    void retrying() {
        BidiUploadState.unimplemented();
    }

    @Nullable BidiWriteObjectRequest peekLast() {
        return (BidiWriteObjectRequest)BidiUploadState.unimplemented();
    }

    boolean isFinalizing() {
        return (Boolean)BidiUploadState.unimplemented();
    }

    ApiFuture<Void> beginReconciliation() {
        return (ApiFuture)BidiUploadState.unimplemented();
    }

    static AppendableUploadState appendableNew(BidiWriteObjectRequest initial, Supplier<GrpcCallContext> baseCallContext, long maxBytes, SettableApiFuture<BidiWriteObjectResponse> resultFuture, @Nullable Crc32cValue.Crc32cLengthKnown initialCrc32c) {
        Preconditions.checkArgument((boolean)initial.hasWriteObjectSpec(), (Object)"provided initial request did not contain a WriteObjectSpec");
        WriteObjectSpec spec = initial.getWriteObjectSpec();
        return new NewAppendableUploadState(initial, spec, baseCallContext, maxBytes, resultFuture, initialCrc32c);
    }

    static AppendableUploadState appendableTakeover(BidiWriteObjectRequest initial, Supplier<GrpcCallContext> baseCallContext, long maxBytes, SettableApiFuture<BidiWriteObjectResponse> resultFuture, @Nullable Crc32cValue.Crc32cLengthKnown initialCrc32c) {
        Preconditions.checkArgument((boolean)initial.hasAppendObjectSpec(), (Object)"provided initial request did not contain a AppendableObjectSpec");
        AppendObjectSpec spec = initial.getAppendObjectSpec();
        return new TakeoverAppendableUploadState(initial, spec, baseCallContext, maxBytes, resultFuture, initialCrc32c);
    }

    private static ImmutableMap<String, List<String>> makeHeadersMap(Stream<String> xGoogRequestParamsEntries) {
        return ImmutableMap.of((Object)"x-goog-request-params", (Object)ImmutableList.of((Object)xGoogRequestParamsEntries.filter(Objects::nonNull).collect(Collectors.joining("&"))));
    }

    static BidiWriteObjectRequest concatenate(BidiWriteObjectRequest first, BidiWriteObjectRequest second) {
        Preconditions.checkArgument((!first.hasChecksummedData() || !second.hasChecksummedData() ? 1 : 0) != 0, (Object)"attempting to merge two requests that both specify checksummed_data");
        BidiWriteObjectRequest.Builder b = first.toBuilder().mergeFrom(second);
        long lwo = first.getWriteOffset();
        long rwo = second.getWriteOffset();
        if (first.hasChecksummedData()) {
            int size = first.getChecksummedData().getContent().size();
            Preconditions.checkArgument((lwo + (long)size == rwo ? 1 : 0) != 0, (String)"(leftWriteOffset + size == rightWriteOffset) (%s + %s == %s)", (Object)lwo, (Object)size, (Object)rwo);
            b.setWriteOffset(lwo);
        } else {
            b.setWriteOffset(rwo);
        }
        if (second.getFinishWrite() && (first.getFlush() || first.getStateLookup())) {
            b.clearFlush().clearStateLookup();
        }
        return b.build();
    }

    @Nullable StorageException onResponse(BidiWriteObjectResponse response) {
        return (StorageException)((Object)BidiUploadState.unimplemented());
    }

    State getState() {
        return (State)((Object)BidiUploadState.unimplemented());
    }

    @VisibleForTesting
    @Nullable BidiWriteObjectRequest peekFirst() {
        return (BidiWriteObjectRequest)BidiUploadState.unimplemented();
    }

    SettableApiFuture<BidiWriteObjectResponse> getResultFuture() {
        return (SettableApiFuture)BidiUploadState.unimplemented();
    }

    void awaitState(State ... state) throws InterruptedException {
        BidiUploadState.unimplemented();
    }

    public void awaitTakeoverStateReconciliation(Runnable restart) {
        BidiUploadState.unimplemented();
    }

    public void awaitAck(long writeOffset) throws InterruptedException {
        BidiUploadState.unimplemented();
    }

    private static <T> T unimplemented() {
        throw new IllegalStateException("not implemented");
    }

    static final class NewAppendableUploadState
    extends AppendableUploadState {
        private final WriteObjectSpec spec;

        private NewAppendableUploadState(BidiWriteObjectRequest initial, WriteObjectSpec spec, Supplier<GrpcCallContext> baseCallContext, long maxBytes, SettableApiFuture<BidiWriteObjectResponse> resultFuture, @Nullable Crc32cValue.Crc32cLengthKnown initialCrc32c) {
            super(initial, baseCallContext, maxBytes, resultFuture, initialCrc32c, State.INITIALIZING);
            this.spec = spec;
        }

        @Override
        protected String getBucket() {
            return this.spec.getResource().getBucket();
        }

        @Override
        protected BidiWriteObjectRequest.Builder getBuilder() {
            BidiWriteObjectRequest.Builder b = BidiWriteObjectRequest.newBuilder();
            if (this.confirmedBytes >= 0L) {
                Preconditions.checkState((this.generation > 0L ? 1 : 0) != 0, (Object)"generation > 0");
                AppendObjectSpec.Builder aosb = AppendObjectSpec.newBuilder().setBucket(this.spec.getResource().getBucket()).setObject(this.spec.getResource().getName()).setGeneration(this.generation);
                if (this.spec.hasIfMetagenerationMatch()) {
                    aosb.setIfMetagenerationMatch(this.spec.getIfMetagenerationMatch());
                }
                if (this.spec.hasIfMetagenerationNotMatch()) {
                    aosb.setIfMetagenerationNotMatch(this.spec.getIfMetagenerationMatch());
                }
                Utils.ifNonNull(this.routingToken, arg_0 -> ((AppendObjectSpec.Builder)aosb).setRoutingToken(arg_0));
                Utils.ifNonNull(this.writeHandle, arg_0 -> ((AppendObjectSpec.Builder)aosb).setWriteHandle(arg_0));
                b.setAppendObjectSpec(aosb);
            } else {
                b.setWriteObjectSpec(this.spec);
            }
            return b;
        }
    }

    static final class TakeoverAppendableUploadState
    extends AppendableUploadState {
        private final AppendObjectSpec spec;

        private TakeoverAppendableUploadState(BidiWriteObjectRequest initial, AppendObjectSpec spec, Supplier<GrpcCallContext> baseCallContext, long maxBytes, SettableApiFuture<BidiWriteObjectResponse> resultFuture, @Nullable Crc32cValue.Crc32cLengthKnown initialCrc32c) {
            super(initial, baseCallContext, maxBytes, resultFuture, initialCrc32c, State.TAKEOVER);
            this.spec = spec;
        }

        @Override
        protected String getBucket() {
            return this.spec.getBucket();
        }

        @Override
        protected BidiWriteObjectRequest.Builder getBuilder() {
            AppendObjectSpec.Builder aosb = this.spec.toBuilder();
            Utils.ifNonNull(this.routingToken, arg_0 -> ((AppendObjectSpec.Builder)aosb).setRoutingToken(arg_0));
            Utils.ifNonNull(this.writeHandle, arg_0 -> ((AppendObjectSpec.Builder)aosb).setWriteHandle(arg_0));
            return BidiWriteObjectRequest.newBuilder().setAppendObjectSpec(aosb);
        }
    }

    static enum State {
        INITIALIZING,
        TAKEOVER,
        RUNNING,
        PENDING_RETRY,
        RETRYING,
        TERMINAL_SUCCESS,
        TERMINAL_ERROR;

        private static final State[] allNonTerminal;

        boolean in(State ... states) {
            for (State state : states) {
                if (state != this) continue;
                return true;
            }
            return false;
        }

        static {
            allNonTerminal = new State[]{INITIALIZING, TAKEOVER, RUNNING, PENDING_RETRY, RETRYING};
        }
    }

    static final class OpenArguments {
        private final BidiWriteObjectRequest req;
        private final GrpcCallContext ctx;

        private OpenArguments(BidiWriteObjectRequest req, GrpcCallContext ctx) {
            this.req = req;
            this.ctx = ctx;
        }

        public BidiWriteObjectRequest getReq() {
            return this.req;
        }

        public GrpcCallContext getCtx() {
            return this.ctx;
        }
    }

    static abstract class AppendableUploadState
    extends BaseUploadState {
        private AppendableUploadState(BidiWriteObjectRequest initial, Supplier<GrpcCallContext> baseCallContext, long maxBytes, SettableApiFuture<BidiWriteObjectResponse> resultFuture, @Nullable Crc32cValue.Crc32cLengthKnown initialCrc32c, State startingState) {
            super(initial, baseCallContext, maxBytes, resultFuture, initialCrc32c, startingState);
        }

        protected abstract String getBucket();

        protected abstract BidiWriteObjectRequest.Builder getBuilder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @NonNull GrpcCallContext enqueueFirstMessageAndGetGrpcCallContext() {
            this.lock.lock();
            try {
                if (!this.state.in(State.INITIALIZING, State.RETRYING, State.TAKEOVER)) {
                    GrpcCallContext grpcCallContext = this.lastOpenArguments.getCtx();
                    return grpcCallContext;
                }
                ImmutableMap xGoogRequestParams = BidiUploadState.makeHeadersMap(Stream.of("bucket=" + this.getBucket(), "appendable=true", this.routingToken != null ? "routing_token=" + this.routingToken : null));
                GrpcCallContext context = ((GrpcCallContext)this.baseCallContext.get()).withExtraHeaders((Map)xGoogRequestParams);
                BidiWriteObjectRequest.Builder b = this.getBuilder();
                if (this.state == State.RETRYING) {
                    b.setStateLookup(true);
                }
                BidiWriteObjectRequest req = b.build();
                OpenArguments openArguments = new OpenArguments(req, context);
                this.internalOffer(req);
                this.lastOpenArguments = openArguments;
                GrpcCallContext grpcCallContext = openArguments.getCtx();
                return grpcCallContext;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @Nullable StorageException onResponse(BidiWriteObjectResponse response) {
            this.lock.lock();
            try {
                block34: {
                    boolean finalizing;
                    long minWriteOffset;
                    long totalSentBytes;
                    long persistedSize;
                    block36: {
                        boolean incremental;
                        block35: {
                            this.validateCurrentStateIsOneOf(State.allNonTerminal);
                            if (response.hasWriteHandle()) {
                                this.writeHandle = response.getWriteHandle();
                            }
                            incremental = !response.hasResource();
                            persistedSize = -1L;
                            if (response.hasPersistedSize()) {
                                persistedSize = response.getPersistedSize();
                            } else if (response.hasResource()) {
                                persistedSize = response.getResource().getSize();
                            }
                            Preconditions.checkState((persistedSize > -1L ? 1 : 0) != 0, (String)"persistedSize > -1 (%s > -1)", (long)persistedSize);
                            if (this.state == State.TAKEOVER || this.stateToReturnToAfterRetry == State.TAKEOVER) {
                                this.totalSentBytes = persistedSize;
                                this.setConfirmedBytes(persistedSize);
                                if (response.hasResource() && response.getResource().hasChecksums() && response.getResource().getChecksums().hasCrc32C()) {
                                    this.cumulativeCrc32c = Crc32cValue.of(response.getResource().getChecksums().getCrc32C(), persistedSize);
                                }
                                this.updateStateFromResponse(response);
                                this.transitionTo(State.RUNNING);
                                StorageException storageException = null;
                                return storageException;
                            }
                            totalSentBytes = this.getTotalSentBytes();
                            minWriteOffset = this.minByteOffset;
                            finalizing = this.isFinalizing();
                            if (finalizing || !incremental) break block35;
                            if (persistedSize == totalSentBytes) {
                                this.updateStateFromResponse(response);
                                break block34;
                            } else {
                                if (persistedSize >= totalSentBytes) {
                                    StorageException storageException = this.err(UploadFailureScenario.SCENARIO_7, response);
                                    return storageException;
                                }
                                this.updateStateFromResponse(response);
                            }
                            break block34;
                        }
                        if (!finalizing || incremental) break block36;
                        if (persistedSize == totalSentBytes) {
                            this.updateStateFromResponse(response);
                            break block34;
                        } else {
                            if (persistedSize >= totalSentBytes) {
                                StorageException storageException = this.err(UploadFailureScenario.SCENARIO_4_2, response);
                                return storageException;
                            }
                            if (persistedSize > minWriteOffset) {
                                this.updateStateFromResponse(response);
                                break block34;
                            } else if (this.lastResponseWithResource != null) {
                                StorageException storageException = this.err(UploadFailureScenario.SCENARIO_4_1, response);
                                return storageException;
                            }
                        }
                        break block34;
                    }
                    if (!finalizing) {
                        if (persistedSize > totalSentBytes) {
                            StorageException storageException = this.err(UploadFailureScenario.SCENARIO_7, response);
                            return storageException;
                        }
                        this.updateStateFromResponse(response);
                    } else if (persistedSize == totalSentBytes) {
                        this.updateStateFromResponse(response);
                    } else {
                        if (persistedSize >= totalSentBytes) {
                            StorageException storageException = this.err(UploadFailureScenario.SCENARIO_2, response);
                            return storageException;
                        }
                        if (persistedSize > minWriteOffset) {
                            this.updateStateFromResponse(response);
                        } else if (this.lastResponseWithResource != null) {
                            StorageException storageException = this.err(UploadFailureScenario.SCENARIO_3, response);
                            return storageException;
                        }
                    }
                }
                StorageException storageException = null;
                return storageException;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    static abstract class BaseUploadState
    extends BidiUploadState {
        protected final BidiWriteObjectRequest initial;
        protected final Supplier<GrpcCallContext> baseCallContext;
        protected final ReentrantLock lock;
        protected final Condition stateUpdated;
        protected final Condition confirmedBytesUpdated;
        protected final long maxBytes;
        protected final ArrayList<BidiWriteObjectRequest> queue;
        protected final SettableApiFuture<BidiWriteObjectResponse> resultFuture;
        private long enqueuedBytes;
        @VisibleForTesting
        int lastSentRequestIndex;
        protected long minByteOffset;
        protected long totalSentBytes;
        protected @Nullable Crc32cValue.Crc32cLengthKnown cumulativeCrc32c;
        protected long confirmedBytes;
        protected long generation;
        protected @Nullable BidiWriteHandle writeHandle;
        protected @Nullable String routingToken;
        protected @NonNull State state;
        protected @MonotonicNonNull BidiWriteObjectResponse lastResponseWithResource;
        protected @Nullable State stateToReturnToAfterRetry;
        protected long finalFlushOffset;
        protected boolean finalFlushSent;
        protected long finishWriteOffset;
        protected boolean finishWriteSent;
        protected @MonotonicNonNull OpenArguments lastOpenArguments;
        protected @Nullable SettableApiFuture<Void> pendingReconciliation;

        private BaseUploadState(BidiWriteObjectRequest initial, Supplier<GrpcCallContext> baseCallContext, long maxBytes, SettableApiFuture<BidiWriteObjectResponse> resultFuture, @Nullable Crc32cValue.Crc32cLengthKnown initialCrc32c, State startingState) {
            this.initial = initial;
            this.baseCallContext = baseCallContext;
            this.resultFuture = resultFuture;
            this.cumulativeCrc32c = initialCrc32c;
            this.maxBytes = maxBytes;
            this.queue = new ArrayList();
            this.enqueuedBytes = 0L;
            this.lock = new ReentrantLock();
            this.stateUpdated = this.lock.newCondition();
            this.confirmedBytesUpdated = this.lock.newCondition();
            this.lastSentRequestIndex = -1;
            this.minByteOffset = 0L;
            this.totalSentBytes = 0L;
            this.confirmedBytes = -1L;
            this.state = startingState;
            this.finalFlushOffset = -1L;
            this.finishWriteOffset = -1L;
        }

        @Override
        final State getState() {
            this.lock.lock();
            try {
                State state = this.state;
                return state;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        final @Nullable Crc32cValue.Crc32cLengthKnown getCumulativeCrc32c() {
            this.lock.lock();
            try {
                Crc32cValue.Crc32cLengthKnown crc32cLengthKnown = this.cumulativeCrc32c;
                return crc32cLengthKnown;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        final long getTotalSentBytes() {
            this.lock.lock();
            try {
                long l = this.totalSentBytes;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        final long getConfirmedBytes() {
            this.lock.lock();
            try {
                long l = this.confirmedBytes;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        final long availableCapacity() {
            this.lock.lock();
            try {
                long l = this.maxBytes - this.enqueuedBytes;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean offer(@NonNull ChunkSegmenter.ChunkSegment datum) {
            this.lock.lock();
            try {
                Objects.requireNonNull(datum, "data must be non null");
                this.validateCurrentStateIsOneOf(State.allNonTerminal);
                this.checkNotFinalizing();
                ByteString b = datum.getB();
                long availableCapacity = this.availableCapacity();
                int size = b.size();
                if ((long)size <= availableCapacity) {
                    Crc32cValue.Crc32cLengthKnown crc32c = datum.getCrc32c();
                    ChecksummedData.Builder checksummedData = ChecksummedData.newBuilder().setContent(b);
                    if (crc32c != null) {
                        checksummedData.setCrc32C(crc32c.getValue());
                    }
                    ChecksummedData built = checksummedData.build();
                    boolean offered = this.internalOffer(BidiWriteObjectRequest.newBuilder().setWriteOffset(this.totalSentBytes).setChecksummedData(built).build());
                    if (offered) {
                        this.cumulativeCrc32c = this.crc32cConcat(crc32c);
                    }
                    boolean bl = offered;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean finalFlush(long totalLength) {
            this.lock.lock();
            try {
                this.validateCurrentStateIsOneOf(State.allNonTerminal);
                this.checkNotFinalizing();
                Preconditions.checkArgument((totalLength == this.totalSentBytes ? 1 : 0) != 0, (String)"(totalLength == totalSentBytes) (%s == %s)", (long)totalLength, (long)this.totalSentBytes);
                BidiWriteObjectRequest flush = BidiWriteObjectRequest.newBuilder().setWriteOffset(totalLength).setFlush(true).setStateLookup(true).build();
                BidiWriteObjectRequest currentLast = this.peekLast();
                boolean equals = flush.equals((Object)currentLast);
                if (equals && this.finalFlushOffset == totalLength) {
                    boolean bl = true;
                    return bl;
                }
                if (equals && this.lastSentRequestIndex == this.queue.size() - 1) {
                    this.finalFlushOffset = totalLength;
                    this.finalFlushSent = true;
                    boolean bl = true;
                    return bl;
                }
                boolean offered = this.internalOffer(flush);
                if (offered) {
                    this.finalFlushOffset = totalLength;
                }
                boolean bl = offered;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean offer(@NonNull BidiWriteObjectRequest e) {
            this.lock.lock();
            try {
                long availableCapacity;
                int size;
                Objects.requireNonNull(e, "e must be non null");
                this.validateCurrentStateIsOneOf(State.allNonTerminal);
                if (e.hasChecksummedData()) {
                    this.checkNotFinalizing();
                }
                if ((long)(size = e.getChecksummedData().getContent().size()) > (availableCapacity = this.availableCapacity())) {
                    boolean bl = false;
                    return bl;
                }
                Preconditions.checkArgument((e.hasOneof(FIRST_MESSAGE_DESCRIPTOR) || e.getWriteOffset() == this.totalSentBytes ? 1 : 0) != 0, (String)"(write_offset == totalSentBytes) (%s == %s)", (long)e.getWriteOffset(), (long)this.totalSentBytes);
                boolean bl = this.internalOffer(e);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        protected void setConfirmedBytes(long newConfirmedBytes) {
            this.confirmedBytes = newConfirmedBytes;
            this.confirmedBytesUpdated.signalAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void updateStateFromResponse(BidiWriteObjectResponse response) {
            this.lock.lock();
            try {
                BidiWriteObjectRequest peek;
                long persistedSize = -1L;
                if (response.hasPersistedSize()) {
                    persistedSize = response.getPersistedSize();
                } else if (response.hasResource()) {
                    persistedSize = response.getResource().getSize();
                    this.lastResponseWithResource = response;
                    this.generation = this.lastResponseWithResource.getResource().getGeneration();
                }
                Preconditions.checkState((persistedSize > -1L ? 1 : 0) != 0, (String)"persistedSize > -1 (%s > -1)", (long)persistedSize);
                Preconditions.checkArgument((persistedSize >= this.confirmedBytes ? 1 : 0) != 0, (String)"(persistedSize >= confirmedBytes) (%s >= %s)", (Object)response, (long)this.confirmedBytes);
                this.validateCurrentStateIsOneOf(State.INITIALIZING, State.TAKEOVER, State.RUNNING, State.RETRYING);
                this.routingToken = null;
                if (this.state == State.INITIALIZING) {
                    this.setConfirmedBytes(persistedSize);
                    this.totalSentBytes = Math.max(this.totalSentBytes, persistedSize);
                }
                if (this.state == State.INITIALIZING || this.state == State.RETRYING) {
                    this.transitionTo(this.stateToReturnToAfterRetry != null ? this.stateToReturnToAfterRetry : State.RUNNING);
                }
                boolean signalTerminalSuccess = false;
                while ((peek = this.peekFirst()) != null) {
                    if (peek.hasChecksummedData()) {
                        int size = peek.getChecksummedData().getContent().size();
                        long endOffset = peek.getWriteOffset() + (long)size;
                        if (endOffset > persistedSize) break;
                        this.poll();
                        this.setConfirmedBytes(endOffset);
                        this.enqueuedBytes -= (long)size;
                        this.minByteOffset = peek.getWriteOffset();
                        continue;
                    }
                    if (peek.hasOneof(FIRST_MESSAGE_DESCRIPTOR)) {
                        this.poll();
                        continue;
                    }
                    if (peek.getFlush()) {
                        if (this.finalFlushSent && persistedSize == this.totalSentBytes && persistedSize == this.finalFlushOffset) {
                            this.setConfirmedBytes(persistedSize);
                            signalTerminalSuccess = true;
                            this.poll();
                            continue;
                        }
                        if (persistedSize < peek.getWriteOffset()) break;
                        this.setConfirmedBytes(persistedSize);
                        this.poll();
                        continue;
                    }
                    if (peek.getFinishWrite()) {
                        Preconditions.checkState((this.enqueuedBytes == 0L ? 1 : 0) != 0, (Object)"attempting to evict finish_write: true while bytes are still enqueued");
                        if (!response.hasResource() || persistedSize != this.totalSentBytes || persistedSize != this.finishWriteOffset) break;
                        this.setConfirmedBytes(persistedSize);
                        if (!response.getResource().hasFinalizeTime()) break;
                        signalTerminalSuccess = true;
                        this.poll();
                        continue;
                    }
                    Preconditions.checkState((boolean)false, (String)"peek = {%s}, response = {%s}", (Object)StorageV2ProtoUtils.fmtProto(peek), (Object)StorageV2ProtoUtils.fmtProto(response));
                }
                if (this.pendingReconciliation != null) {
                    this.pendingReconciliation.set(null);
                    this.pendingReconciliation = null;
                }
                if (signalTerminalSuccess && this.lastResponseWithResource != null) {
                    BidiWriteObjectResponse.Builder b = this.lastResponseWithResource.toBuilder();
                    b.getResourceBuilder().setSize(this.confirmedBytes);
                    b.getResourceBuilder().getChecksumsBuilder().clearMd5Hash().clearCrc32C();
                    if (this.cumulativeCrc32c != null) {
                        b.getResourceBuilder().getChecksumsBuilder().setCrc32C(this.cumulativeCrc32c.getValue());
                    }
                    BidiWriteObjectResponse updated = b.build();
                    this.resultFuture.set((Object)updated);
                    this.terminalSuccess();
                } else if (signalTerminalSuccess) {
                    Preconditions.checkState((boolean)false, (Object)"signalTerminalSuccess without prior resource response");
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        final void updateFromRedirect(@NonNull BidiWriteObjectRedirectedError redirect) {
            this.lock.lock();
            try {
                this.validateCurrentStateIsOneOf(State.INITIALIZING, State.RUNNING, State.PENDING_RETRY, State.RETRYING);
                if (redirect.hasWriteHandle()) {
                    this.writeHandle = redirect.getWriteHandle();
                }
                if (redirect.hasRoutingToken()) {
                    this.routingToken = redirect.getRoutingToken();
                }
                if (redirect.hasGeneration()) {
                    if (this.generation > 0L) {
                        Preconditions.checkState((this.generation == redirect.getGeneration() ? 1 : 0) != 0, (String)"Generation changed: (generation == redirect.getGeneration()) (%s == %s)", (long)this.generation, (long)redirect.getGeneration());
                    }
                    this.generation = redirect.getGeneration();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        final void terminalError() {
            this.lock.lock();
            try {
                this.validateCurrentStateIsOneOf(State.allNonTerminal);
                this.transitionTo(State.TERMINAL_ERROR);
                if (this.pendingReconciliation != null) {
                    this.pendingReconciliation.cancel(true);
                }
                this.stateUpdated.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        private void terminalSuccess() {
            this.lock.lock();
            try {
                this.validateCurrentStateIsOneOf(State.allNonTerminal);
                this.transitionTo(State.TERMINAL_SUCCESS);
                this.stateUpdated.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        final void pendingRetry() {
            this.lock.lock();
            try {
                this.validateCurrentStateIsOneOf(State.allNonTerminal);
                this.stateToReturnToAfterRetry = this.state;
                this.transitionTo(State.PENDING_RETRY);
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        final void retrying() {
            this.lock.lock();
            try {
                this.validateCurrentStateIsOneOf(State.PENDING_RETRY, State.INITIALIZING, State.TAKEOVER);
                this.transitionTo(State.RETRYING);
                this.lastSentRequestIndex = -1;
                this.finishWriteSent = false;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        final boolean isFinalizing() {
            this.lock.lock();
            try {
                boolean bl = this.finishWriteOffset >= 0L && this.finishWriteSent;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        ApiFuture<Void> beginReconciliation() {
            this.lock.lock();
            try {
                if (this.pendingReconciliation == null) {
                    this.pendingReconciliation = SettableApiFuture.create();
                }
                SettableApiFuture<Void> settableApiFuture = this.pendingReconciliation;
                return settableApiFuture;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void sendVia(Consumer<BidiWriteObjectRequest> consumer) {
            this.lock.lock();
            try {
                this.validateCurrentStateIsOneOf(State.INITIALIZING, State.RUNNING, State.RETRYING, State.TAKEOVER);
                BidiWriteObjectRequest prev = null;
                for (int i = this.lastSentRequestIndex + 1; i < this.queue.size(); ++i) {
                    BidiWriteObjectRequest m = this.queue.get(i);
                    this.lastSentRequestIndex = i;
                    if (this.state == State.RETRYING) {
                        prev = m;
                        break;
                    }
                    if (prev != null) {
                        if (prev.hasChecksummedData() && m.hasChecksummedData()) {
                            consumer.accept(prev);
                            prev = m;
                            continue;
                        }
                        prev = BaseUploadState.concatenate(prev, m);
                        continue;
                    }
                    prev = m;
                }
                if (prev != null) {
                    if (prev.getFinishWrite()) {
                        this.finishWriteSent = true;
                    } else if (prev.getFlush() && prev.getStateLookup() && this.finalFlushOffset > -1L) {
                        this.finalFlushSent = true;
                    }
                    consumer.accept(prev);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private void prepend(BidiWriteObjectRequest e) {
            this.queue.add(0, e);
            this.enqueuedBytes += (long)e.getChecksummedData().getContent().size();
        }

        private void append(BidiWriteObjectRequest e) {
            this.queue.add(e);
            this.enqueuedBytes += (long)e.getChecksummedData().getContent().size();
        }

        @Override
        final @Nullable BidiWriteObjectRequest peekLast() {
            this.lock.lock();
            try {
                int index = this.queue.size() - 1;
                if (index < 0) {
                    BidiWriteObjectRequest bidiWriteObjectRequest = null;
                    return bidiWriteObjectRequest;
                }
                BidiWriteObjectRequest bidiWriteObjectRequest = this.queue.get(index);
                return bidiWriteObjectRequest;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        @VisibleForTesting
        final @Nullable BidiWriteObjectRequest peekFirst() {
            this.lock.lock();
            try {
                if (this.queue.isEmpty()) {
                    BidiWriteObjectRequest bidiWriteObjectRequest = null;
                    return bidiWriteObjectRequest;
                }
                BidiWriteObjectRequest bidiWriteObjectRequest = this.queue.get(0);
                return bidiWriteObjectRequest;
            }
            finally {
                this.lock.unlock();
            }
        }

        private void poll() {
            BidiWriteObjectRequest remove = this.queue.remove(0);
            if (remove != null) {
                this.lastSentRequestIndex = Math.max(this.lastSentRequestIndex - 1, -1);
            }
        }

        protected final void transitionTo(State state) {
            this.state = state;
            this.stateUpdated.signalAll();
        }

        protected final void validateCurrentStateIsOneOf(State ... allowed) {
            Preconditions.checkState((boolean)this.state.in(allowed), (String)"state mismatch. expected one of %s but is %s", (Object)Arrays.toString((Object[])allowed), (Object)((Object)this.state));
        }

        private void checkNotFinalizing() {
            Preconditions.checkState((this.finishWriteOffset == -1L ? 1 : 0) != 0, (Object)"Attempting to append bytes even though finalization has previously been signaled.");
        }

        protected final boolean internalOffer(BidiWriteObjectRequest e) {
            Consumer<BidiWriteObjectRequest> add = this::append;
            if (e.hasOneof(FIRST_MESSAGE_DESCRIPTOR)) {
                if (!this.queue.isEmpty() && this.queue.get(0).hasOneof(FIRST_MESSAGE_DESCRIPTOR)) {
                    this.poll();
                }
                add = this::prepend;
            }
            boolean appended = false;
            if (e.hasChecksummedData() && this.finishWriteOffset == -1L) {
                ChecksummedData checksummedData = e.getChecksummedData();
                int size = checksummedData.getContent().size();
                if ((long)size <= this.availableCapacity()) {
                    this.totalSentBytes += (long)size;
                    add.accept(e);
                    appended = true;
                }
            } else {
                add.accept(e);
                appended = true;
            }
            if (e.getFinishWrite()) {
                this.finishWriteOffset = this.totalSentBytes;
            }
            return appended;
        }

        private @Nullable Crc32cValue.Crc32cLengthKnown crc32cConcat(@Nullable Crc32cValue.Crc32cLengthKnown rhs) {
            if (this.cumulativeCrc32c == null) {
                return null;
            }
            Objects.requireNonNull(rhs, "rhs must be non null");
            return this.cumulativeCrc32c.concat(rhs);
        }

        @Override
        public SettableApiFuture<BidiWriteObjectResponse> getResultFuture() {
            return this.resultFuture;
        }

        @Override
        void awaitState(State ... anyOf) throws InterruptedException {
            this.lock.lock();
            try {
                ImmutableSet states = ImmutableSet.copyOf((Object[])anyOf);
                while (!states.contains((Object)this.state) && !this.stateUpdated.await(5L, TimeUnit.MILLISECONDS)) {
                    if (!this.resultFuture.isDone()) continue;
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void awaitTakeoverStateReconciliation(Runnable restart) {
            try {
                this.pendingRetry();
                restart.run();
                this.awaitState(State.RUNNING);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw StorageException.coalesce(e);
            }
        }

        @Override
        public void awaitAck(long writeOffset) throws InterruptedException {
            this.lock.lock();
            try {
                while (this.confirmedBytes < writeOffset && !this.confirmedBytesUpdated.await(5L, TimeUnit.MILLISECONDS)) {
                    if (!this.resultFuture.isDone()) continue;
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

