/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.paging.Page;
import com.google.cloud.Policy;
import com.google.cloud.ReadChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.HmacKey;
import com.google.cloud.storage.Notification;
import com.google.cloud.storage.NotificationInfo;
import com.google.cloud.storage.PostPolicyV4;
import com.google.cloud.storage.ServiceAccount;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.TransportCompatibility;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class OtelStorageDecorator
implements Storage {
    private static final String OTEL_SCOPE_NAME = "cloud.google.com/java/storage";
    private final Storage delegate;
    private final OpenTelemetry otel;
    private final Attributes baseAttributes;
    private final Tracer tracer;

    private OtelStorageDecorator(Storage delegate, OpenTelemetry otel, Attributes baseAttributes) {
        this.delegate = delegate;
        this.otel = otel;
        this.baseAttributes = baseAttributes;
        this.tracer = TracerDecorator.decorate(null, otel, baseAttributes, Storage.class.getName() + "/");
    }

    @Override
    public Bucket create(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        Span span = this.tracer.spanBuilder("create").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucketInfo.getName())).startSpan();
        try {
            Bucket bucket;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bucket = this.delegate.create(bucketInfo, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bucket;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob create(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        Span span = this.tracer.spanBuilder("create").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob = this.delegate.create(blobInfo, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, Storage.BlobTargetOption ... options) {
        Span span = this.tracer.spanBuilder("create").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob = this.delegate.create(blobInfo, content, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, int offset, int length, Storage.BlobTargetOption ... options) {
        Span span = this.tracer.spanBuilder("create").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob = this.delegate.create(blobInfo, content, offset, length, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob;
        }
        finally {
            span.end();
        }
    }

    @Override
    @Deprecated
    public Blob create(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) {
        Span span = this.tracer.spanBuilder("create").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob = this.delegate.create(blobInfo, content, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, Storage.BlobWriteOption ... options) throws IOException {
        Span span = this.tracer.spanBuilder("createFrom").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob = this.delegate.createFrom(blobInfo, path, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        Span span = this.tracer.spanBuilder("createFrom").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob = this.delegate.createFrom(blobInfo, path, bufferSize, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) throws IOException {
        Span span = this.tracer.spanBuilder("createFrom").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob = this.delegate.createFrom(blobInfo, content, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        Span span = this.tracer.spanBuilder("createFrom").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob = this.delegate.createFrom(blobInfo, content, bufferSize, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Bucket get(String bucket, Storage.BucketGetOption ... options) {
        Span span = this.tracer.spanBuilder("get").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Bucket bucket2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bucket2 = this.delegate.get(bucket, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bucket2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Bucket lockRetentionPolicy(BucketInfo bucket, Storage.BucketTargetOption ... options) {
        Span span = this.tracer.spanBuilder("lockRetentionPolicy").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket.getName())).startSpan();
        try {
            Bucket bucket2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bucket2 = this.delegate.lockRetentionPolicy(bucket, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bucket2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob get(String bucket, String blob, Storage.BlobGetOption ... options) {
        Span span = this.tracer.spanBuilder("get").setAttribute("gsutil.uri", String.format("gs://%s/%s", bucket, blob)).startSpan();
        try {
            Blob blob2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob2 = this.delegate.get(bucket, blob, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob get(BlobId blob, Storage.BlobGetOption ... options) {
        Span span = this.tracer.spanBuilder("get").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob2 = this.delegate.get(blob, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob get(BlobId blob) {
        Span span = this.tracer.spanBuilder("get").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob2 = this.delegate.get(blob);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob restore(BlobId blob, Storage.BlobRestoreOption ... options) {
        Span span = this.tracer.spanBuilder("restore").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob2 = this.delegate.restore(blob, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Page<Bucket> list(Storage.BucketListOption ... options) {
        Span span = this.tracer.spanBuilder("list").setAttribute("gsutil.uri", "gs://").startSpan();
        try {
            Page<Bucket> page;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    page = this.delegate.list(options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return page;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Page<Blob> list(String bucket, Storage.BlobListOption ... options) {
        Span span = this.tracer.spanBuilder("list").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Page<Blob> page;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    page = this.delegate.list(bucket, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return page;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Bucket update(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        Span span = this.tracer.spanBuilder("update").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucketInfo.getName())).startSpan();
        try {
            Bucket bucket;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bucket = this.delegate.update(bucketInfo, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bucket;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        Span span = this.tracer.spanBuilder("update").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob = this.delegate.update(blobInfo, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob update(BlobInfo blobInfo) {
        Span span = this.tracer.spanBuilder("update").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Blob blob;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob = this.delegate.update(blobInfo);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob;
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean delete(String bucket, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("delete").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            boolean bl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bl = this.delegate.delete(bucket, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("delete").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            boolean bl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bl = this.delegate.delete(bucket, blob, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean delete(BlobId blob, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("delete").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            boolean bl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bl = this.delegate.delete(blob, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean delete(BlobId blob) {
        Span span = this.tracer.spanBuilder("delete").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            boolean bl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bl = this.delegate.delete(blob);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob compose(Storage.ComposeRequest composeRequest) {
        Span span = this.tracer.spanBuilder("compose").setAttribute("gsutil.uri", composeRequest.getTarget().getBlobId().toGsUtilUri()).startSpan();
        try {
            Blob blob;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    blob = this.delegate.compose(composeRequest);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return blob;
        }
        finally {
            span.end();
        }
    }

    @Override
    public CopyWriter copy(Storage.CopyRequest copyRequest) {
        OtelDecoratedCopyWriter otelDecoratedCopyWriter;
        block8: {
            Span span = this.tracer.spanBuilder("copy").setAttribute("gsutil.uri", copyRequest.getTarget().getBlobId().toGsUtilUri()).startSpan();
            Scope ignore = span.makeCurrent();
            try {
                CopyWriter copyWriter = this.delegate.copy(copyRequest);
                otelDecoratedCopyWriter = new OtelDecoratedCopyWriter(copyWriter, span);
                if (ignore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    span.recordException(t);
                    span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                    span.end();
                    throw t;
                }
            }
            ignore.close();
        }
        return otelDecoratedCopyWriter;
    }

    @Override
    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("readAllBytes").setAttribute("gsutil.uri", BlobId.of(bucket, blob).toGsUtilUri()).startSpan();
        try {
            byte[] byArray;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    byArray = this.delegate.readAllBytes(bucket, blob, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return byArray;
        }
        finally {
            span.end();
        }
    }

    @Override
    public byte[] readAllBytes(BlobId blob, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("readAllBytes").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            byte[] byArray;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    byArray = this.delegate.readAllBytes(blob, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return byArray;
        }
        finally {
            span.end();
        }
    }

    @Override
    public StorageBatch batch() {
        return this.delegate.batch();
    }

    @Override
    public ReadChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        OtelDecoratedReadChannel otelDecoratedReadChannel;
        block8: {
            Span span = this.tracer.spanBuilder("reader").setAttribute("gsutil.uri", BlobId.of(bucket, blob).toGsUtilUriWithGeneration()).startSpan();
            Scope ignore = span.makeCurrent();
            try {
                ReadChannel reader = this.delegate.reader(bucket, blob, options);
                otelDecoratedReadChannel = new OtelDecoratedReadChannel(reader, span);
                if (ignore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    span.recordException(t);
                    span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                    span.end();
                    throw t;
                }
            }
            ignore.close();
        }
        return otelDecoratedReadChannel;
    }

    @Override
    public ReadChannel reader(BlobId blob, Storage.BlobSourceOption ... options) {
        OtelDecoratedReadChannel otelDecoratedReadChannel;
        block8: {
            Span span = this.tracer.spanBuilder("reader").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
            Scope ignore = span.makeCurrent();
            try {
                ReadChannel reader = this.delegate.reader(blob, options);
                otelDecoratedReadChannel = new OtelDecoratedReadChannel(reader, span);
                if (ignore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    span.recordException(t);
                    span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                    span.end();
                    throw t;
                }
            }
            ignore.close();
        }
        return otelDecoratedReadChannel;
    }

    @Override
    public void downloadTo(BlobId blob, Path path, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("downloadTo").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try (Scope ignore = span.makeCurrent();){
            this.delegate.downloadTo(blob, path, options);
        }
        catch (Throwable t) {
            span.recordException(t);
            span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
            throw t;
        }
        finally {
            span.end();
        }
    }

    @Override
    public void downloadTo(BlobId blob, OutputStream outputStream, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("downloadTo").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try (Scope ignore = span.makeCurrent();){
            this.delegate.downloadTo(blob, outputStream, options);
        }
        catch (Throwable t) {
            span.recordException(t);
            span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
            throw t;
        }
        finally {
            span.end();
        }
    }

    @Override
    public WriteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        OtelDecoratedWriteChannel otelDecoratedWriteChannel;
        block8: {
            Span sessionSpan = this.tracer.spanBuilder("writer").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
            Scope ignore = sessionSpan.makeCurrent();
            try {
                WriteChannel writer = this.delegate.writer(blobInfo, options);
                otelDecoratedWriteChannel = new OtelDecoratedWriteChannel(writer, sessionSpan);
                if (ignore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    sessionSpan.recordException(t);
                    sessionSpan.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                    sessionSpan.end();
                    throw t;
                }
            }
            ignore.close();
        }
        return otelDecoratedWriteChannel;
    }

    @Override
    public WriteChannel writer(URL signedURL) {
        OtelDecoratedWriteChannel otelDecoratedWriteChannel;
        block8: {
            Span sessionSpan = this.tracer.spanBuilder("writer").startSpan();
            Scope ignore = sessionSpan.makeCurrent();
            try {
                WriteChannel writer = this.delegate.writer(signedURL);
                otelDecoratedWriteChannel = new OtelDecoratedWriteChannel(writer, sessionSpan);
                if (ignore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    sessionSpan.recordException(t);
                    sessionSpan.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                    sessionSpan.end();
                    throw t;
                }
            }
            ignore.close();
        }
        return otelDecoratedWriteChannel;
    }

    @Override
    public URL signUrl(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        Span span = this.tracer.spanBuilder("signUrl").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            URL uRL;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    uRL = this.delegate.signUrl(blobInfo, duration, unit, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return uRL;
        }
        finally {
            span.end();
        }
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        Span span = this.tracer.spanBuilder("generateSignedPostPolicyV4").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            PostPolicyV4 postPolicyV4;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    postPolicyV4 = this.delegate.generateSignedPostPolicyV4(blobInfo, duration, unit, fields, conditions, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return postPolicyV4;
        }
        finally {
            span.end();
        }
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, Storage.PostPolicyV4Option ... options) {
        Span span = this.tracer.spanBuilder("generateSignedPostPolicyV4").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            PostPolicyV4 postPolicyV4;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    postPolicyV4 = this.delegate.generateSignedPostPolicyV4(blobInfo, duration, unit, fields, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return postPolicyV4;
        }
        finally {
            span.end();
        }
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        Span span = this.tracer.spanBuilder("generateSignedPostPolicyV4").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            PostPolicyV4 postPolicyV4;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    postPolicyV4 = this.delegate.generateSignedPostPolicyV4(blobInfo, duration, unit, conditions, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return postPolicyV4;
        }
        finally {
            span.end();
        }
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.PostPolicyV4Option ... options) {
        Span span = this.tracer.spanBuilder("generateSignedPostPolicyV4").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            PostPolicyV4 postPolicyV4;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    postPolicyV4 = this.delegate.generateSignedPostPolicyV4(blobInfo, duration, unit, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return postPolicyV4;
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Blob> get(BlobId ... blobIds) {
        Span span = this.tracer.spanBuilder("get").startSpan();
        try {
            List<Blob> list;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    list = this.delegate.get(blobIds);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return list;
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Blob> get(Iterable<BlobId> blobIds) {
        Span span = this.tracer.spanBuilder("get").startSpan();
        try {
            List<Blob> list;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    list = this.delegate.get(blobIds);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return list;
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Blob> update(BlobInfo ... blobInfos) {
        Span span = this.tracer.spanBuilder("update").startSpan();
        try {
            List<Blob> list;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    list = this.delegate.update(blobInfos);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return list;
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Blob> update(Iterable<BlobInfo> blobInfos) {
        Span span = this.tracer.spanBuilder("update").startSpan();
        try {
            List<Blob> list;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    list = this.delegate.update(blobInfos);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return list;
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Boolean> delete(BlobId ... blobIds) {
        Span span = this.tracer.spanBuilder("delete").startSpan();
        try {
            List<Boolean> list;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    list = this.delegate.delete(blobIds);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return list;
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Boolean> delete(Iterable<BlobId> blobIds) {
        Span span = this.tracer.spanBuilder("delete").startSpan();
        try {
            List<Boolean> list;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    list = this.delegate.delete(blobIds);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return list;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("getAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Acl acl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    acl = this.delegate.getAcl(bucket, entity, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return acl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity) {
        Span span = this.tracer.spanBuilder("getAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Acl acl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    acl = this.delegate.getAcl(bucket, entity);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return acl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("deleteAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            boolean bl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bl = this.delegate.deleteAcl(bucket, entity, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity) {
        Span span = this.tracer.spanBuilder("deleteAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            boolean bl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bl = this.delegate.deleteAcl(bucket, entity);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl createAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("createAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Acl acl2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    acl2 = this.delegate.createAcl(bucket, acl, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return acl2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl createAcl(String bucket, Acl acl) {
        Span span = this.tracer.spanBuilder("createAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Acl acl2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    acl2 = this.delegate.createAcl(bucket, acl);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return acl2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("updateAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Acl acl2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    acl2 = this.delegate.updateAcl(bucket, acl, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return acl2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl) {
        Span span = this.tracer.spanBuilder("updateAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Acl acl2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    acl2 = this.delegate.updateAcl(bucket, acl);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return acl2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Acl> listAcls(String bucket, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("listAcls").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            List<Acl> list;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    list = this.delegate.listAcls(bucket, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return list;
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Acl> listAcls(String bucket) {
        Span span = this.tracer.spanBuilder("listAcls").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            List<Acl> list;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    list = this.delegate.listAcls(bucket);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return list;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl getDefaultAcl(String bucket, Acl.Entity entity) {
        Span span = this.tracer.spanBuilder("getDefaultAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Acl acl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    acl = this.delegate.getDefaultAcl(bucket, entity);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return acl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean deleteDefaultAcl(String bucket, Acl.Entity entity) {
        Span span = this.tracer.spanBuilder("deleteDefaultAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            boolean bl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bl = this.delegate.deleteDefaultAcl(bucket, entity);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl createDefaultAcl(String bucket, Acl acl) {
        Span span = this.tracer.spanBuilder("createDefaultAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Acl acl2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    acl2 = this.delegate.createDefaultAcl(bucket, acl);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return acl2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl updateDefaultAcl(String bucket, Acl acl) {
        Span span = this.tracer.spanBuilder("updateDefaultAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Acl acl2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    acl2 = this.delegate.updateDefaultAcl(bucket, acl);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return acl2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Acl> listDefaultAcls(String bucket) {
        Span span = this.tracer.spanBuilder("listDefaultAcls").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            List<Acl> list;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    list = this.delegate.listDefaultAcls(bucket);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return list;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl getAcl(BlobId blob, Acl.Entity entity) {
        Span span = this.tracer.spanBuilder("getAcl").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Acl acl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    acl = this.delegate.getAcl(blob, entity);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return acl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean deleteAcl(BlobId blob, Acl.Entity entity) {
        Span span = this.tracer.spanBuilder("deleteAcl").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            boolean bl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bl = this.delegate.deleteAcl(blob, entity);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl createAcl(BlobId blob, Acl acl) {
        Span span = this.tracer.spanBuilder("createAcl").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Acl acl2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    acl2 = this.delegate.createAcl(blob, acl);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return acl2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl updateAcl(BlobId blob, Acl acl) {
        Span span = this.tracer.spanBuilder("updateAcl").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Acl acl2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    acl2 = this.delegate.updateAcl(blob, acl);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return acl2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Acl> listAcls(BlobId blob) {
        Span span = this.tracer.spanBuilder("listAcls").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            List<Acl> list;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    list = this.delegate.listAcls(blob);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return list;
        }
        finally {
            span.end();
        }
    }

    @Override
    public HmacKey createHmacKey(ServiceAccount serviceAccount, Storage.CreateHmacKeyOption ... options) {
        Span span = this.tracer.spanBuilder("createHmacKey").startSpan();
        try {
            HmacKey hmacKey;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    hmacKey = this.delegate.createHmacKey(serviceAccount, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return hmacKey;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Page<HmacKey.HmacKeyMetadata> listHmacKeys(Storage.ListHmacKeysOption ... options) {
        Span span = this.tracer.spanBuilder("listHmacKeys").startSpan();
        try {
            Page<HmacKey.HmacKeyMetadata> page;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    page = this.delegate.listHmacKeys(options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return page;
        }
        finally {
            span.end();
        }
    }

    @Override
    public HmacKey.HmacKeyMetadata getHmacKey(String accessId, Storage.GetHmacKeyOption ... options) {
        Span span = this.tracer.spanBuilder("getHmacKey").startSpan();
        try {
            HmacKey.HmacKeyMetadata hmacKeyMetadata;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    hmacKeyMetadata = this.delegate.getHmacKey(accessId, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return hmacKeyMetadata;
        }
        finally {
            span.end();
        }
    }

    @Override
    public void deleteHmacKey(HmacKey.HmacKeyMetadata hmacKeyMetadata, Storage.DeleteHmacKeyOption ... options) {
        Span span = this.tracer.spanBuilder("deleteHmacKey").startSpan();
        try (Scope ignore = span.makeCurrent();){
            this.delegate.deleteHmacKey(hmacKeyMetadata, options);
        }
        catch (Throwable t) {
            span.recordException(t);
            span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
            throw t;
        }
        finally {
            span.end();
        }
    }

    @Override
    public HmacKey.HmacKeyMetadata updateHmacKeyState(HmacKey.HmacKeyMetadata hmacKeyMetadata, HmacKey.HmacKeyState state, Storage.UpdateHmacKeyOption ... options) {
        Span span = this.tracer.spanBuilder("updateHmacKeyState").startSpan();
        try {
            HmacKey.HmacKeyMetadata hmacKeyMetadata2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    hmacKeyMetadata2 = this.delegate.updateHmacKeyState(hmacKeyMetadata, state, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return hmacKeyMetadata2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Policy getIamPolicy(String bucket, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("getIamPolicy").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Policy policy;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    policy = this.delegate.getIamPolicy(bucket, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return policy;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Policy setIamPolicy(String bucket, Policy policy, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("setIamPolicy").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Policy policy2;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    policy2 = this.delegate.setIamPolicy(bucket, policy, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return policy2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Boolean> testIamPermissions(String bucket, List<String> permissions, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("testIamPermissions").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            List<Boolean> list;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    list = this.delegate.testIamPermissions(bucket, permissions, options);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return list;
        }
        finally {
            span.end();
        }
    }

    @Override
    public ServiceAccount getServiceAccount(String projectId) {
        Span span = this.tracer.spanBuilder("getServiceAccount").startSpan();
        try {
            ServiceAccount serviceAccount;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    serviceAccount = this.delegate.getServiceAccount(projectId);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return serviceAccount;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Notification createNotification(String bucket, NotificationInfo notificationInfo) {
        Span span = this.tracer.spanBuilder("createNotification").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Notification notification;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    notification = this.delegate.createNotification(bucket, notificationInfo);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return notification;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Notification getNotification(String bucket, String notificationId) {
        Span span = this.tracer.spanBuilder("getNotification").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Notification notification;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    notification = this.delegate.getNotification(bucket, notificationId);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return notification;
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Notification> listNotifications(String bucket) {
        Span span = this.tracer.spanBuilder("listNotifications").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            List<Notification> list;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    list = this.delegate.listNotifications(bucket);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return list;
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean deleteNotification(String bucket, String notificationId) {
        Span span = this.tracer.spanBuilder("deleteNotification").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            boolean bl;
            block11: {
                Scope ignore = span.makeCurrent();
                try {
                    bl = this.delegate.deleteNotification(bucket, notificationId);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return bl;
        }
        finally {
            span.end();
        }
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    @Override
    @BetaApi
    public BlobWriteSession blobWriteSession(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        Span sessionSpan = this.tracer.spanBuilder("blobWriteSession").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            OtelDecoratedBlobWriteSession otelDecoratedBlobWriteSession;
            block11: {
                Scope ignore = sessionSpan.makeCurrent();
                try {
                    BlobWriteSession session = this.delegate.blobWriteSession(blobInfo, options);
                    otelDecoratedBlobWriteSession = new OtelDecoratedBlobWriteSession(session);
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        sessionSpan.recordException(t);
                        sessionSpan.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return otelDecoratedBlobWriteSession;
        }
        finally {
            sessionSpan.end();
        }
    }

    public StorageOptions getOptions() {
        return (StorageOptions)this.delegate.getOptions();
    }

    static Storage decorate(Storage delegate, OpenTelemetry otel, TransportCompatibility.Transport transport) {
        Objects.requireNonNull(delegate, "delegate must be non null");
        Objects.requireNonNull(otel, "otel must be non null");
        if (otel == OpenTelemetry.noop()) {
            return delegate;
        }
        Attributes baseAttributes = Attributes.builder().put("gcp.client.service", "Storage").put("gcp.client.version", StorageOptions.getDefaultInstance().getLibraryVersion()).put("gcp.client.repo", "googleapis/java-storage").put("gcp.client.artifact", "com.google.cloud:google-cloud-storage").put("rpc.system", transport.toString().toLowerCase(Locale.ROOT)).put("service.name", "storage.googleapis.com").build();
        return new OtelStorageDecorator(delegate, otel, baseAttributes);
    }

    private static @NonNull String fmtBucket(String bucket) {
        return String.format("gs://%s/", bucket);
    }

    private static final class TracerDecorator
    implements Tracer {
        private final @Nullable Context parentContextOverride;
        private final Tracer delegate;
        private final Attributes baseAttributes;
        private final String spanNamePrefix;

        private TracerDecorator(@Nullable Context parentContextOverride, Tracer delegate, Attributes baseAttributes, String spanNamePrefix) {
            this.parentContextOverride = parentContextOverride;
            this.delegate = delegate;
            this.baseAttributes = baseAttributes;
            this.spanNamePrefix = spanNamePrefix;
        }

        private static TracerDecorator decorate(@Nullable Context parentContextOverride, OpenTelemetry otel, Attributes baseAttributes, String spanNamePrefix) {
            Objects.requireNonNull(otel, "otel must be non null");
            Objects.requireNonNull(baseAttributes, "baseAttributes must be non null");
            Objects.requireNonNull(spanNamePrefix, "spanNamePrefix must be non null");
            Tracer tracer = otel.getTracer(OtelStorageDecorator.OTEL_SCOPE_NAME, StorageOptions.getDefaultInstance().getLibraryVersion());
            return new TracerDecorator(parentContextOverride, tracer, baseAttributes, spanNamePrefix);
        }

        public SpanBuilder spanBuilder(String spanName) {
            SpanBuilder spanBuilder = this.delegate.spanBuilder(this.spanNamePrefix + spanName).setAllAttributes(this.baseAttributes);
            if (this.parentContextOverride != null) {
                spanBuilder.setParent(this.parentContextOverride);
            }
            return spanBuilder;
        }
    }

    private final class OtelDecoratedCopyWriter
    extends CopyWriter {
        private final CopyWriter copyWriter;
        private final Span span;
        private final Context parentContext;
        private final Tracer tracer;

        public OtelDecoratedCopyWriter(CopyWriter copyWriter, Span span) {
            this.copyWriter = copyWriter;
            this.span = span;
            this.parentContext = Context.current();
            this.tracer = TracerDecorator.decorate(Context.current(), OtelStorageDecorator.this.otel, OtelStorageDecorator.this.baseAttributes, CopyWriter.class.getName() + "/");
        }

        @Override
        public Blob getResult() {
            try {
                Blob blob = this.copyWriter.getResult();
                return blob;
            }
            catch (Throwable t) {
                this.span.recordException(t);
                this.span.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                throw t;
            }
            finally {
                this.span.end();
            }
        }

        @Override
        public long getBlobSize() {
            return this.copyWriter.getBlobSize();
        }

        @Override
        public boolean isDone() {
            boolean done = this.copyWriter.isDone();
            if (done) {
                this.span.end();
            }
            return done;
        }

        @Override
        public long getTotalBytesCopied() {
            return this.copyWriter.getTotalBytesCopied();
        }

        @Override
        public RestorableState<CopyWriter> capture() {
            return this.copyWriter.capture();
        }

        @Override
        public void copyChunk() {
            Span copyChunkSpan = this.tracer.spanBuilder("copyChunk").setParent(this.parentContext).startSpan();
            try (Scope ignore = copyChunkSpan.makeCurrent();){
                this.copyWriter.copyChunk();
            }
            catch (Throwable t) {
                copyChunkSpan.recordException(t);
                copyChunkSpan.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                this.span.end();
                throw t;
            }
            finally {
                copyChunkSpan.end();
            }
        }
    }

    private static final class OtelDecoratedReadChannel
    implements ReadChannel {
        private final ReadChannel reader;
        private final Span span;

        private OtelDecoratedReadChannel(ReadChannel reader, Span span) {
            this.reader = reader;
            this.span = span;
        }

        public void seek(long position) throws IOException {
            this.reader.seek(position);
        }

        public void setChunkSize(int chunkSize) {
            this.reader.setChunkSize(chunkSize);
        }

        public RestorableState<ReadChannel> capture() {
            return this.reader.capture();
        }

        public ReadChannel limit(long limit) {
            return this.reader.limit(limit);
        }

        public long limit() {
            return this.reader.limit();
        }

        public int read(ByteBuffer dst) throws IOException {
            return this.reader.read(dst);
        }

        public boolean isOpen() {
            return this.reader.isOpen();
        }

        public void close() {
            try {
                this.reader.close();
            }
            finally {
                this.span.end();
            }
        }
    }

    private static final class OtelDecoratedWriteChannel
    implements WriteChannel {
        private final WriteChannel delegate;
        private final Span openSpan;

        private OtelDecoratedWriteChannel(WriteChannel delegate, Span openSpan) {
            this.delegate = delegate;
            this.openSpan = openSpan;
        }

        public void setChunkSize(int chunkSize) {
            this.delegate.setChunkSize(chunkSize);
        }

        public RestorableState<WriteChannel> capture() {
            return this.delegate.capture();
        }

        public int write(ByteBuffer src) throws IOException {
            return this.delegate.write(src);
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            catch (IOException | RuntimeException e) {
                this.openSpan.recordException((Throwable)e);
                this.openSpan.setStatus(StatusCode.ERROR, e.getClass().getSimpleName());
                throw e;
            }
            finally {
                this.openSpan.end();
            }
        }
    }

    private final class OtelDecoratedBlobWriteSession
    implements BlobWriteSession {
        private final BlobWriteSession delegate;
        private final Tracer tracer;

        public OtelDecoratedBlobWriteSession(BlobWriteSession delegate) {
            this.delegate = delegate;
            this.tracer = TracerDecorator.decorate(Context.current(), OtelStorageDecorator.this.otel, OtelStorageDecorator.this.baseAttributes, BlobWriteSession.class.getName() + "/");
        }

        @Override
        public WritableByteChannel open() throws IOException {
            OtelDecoratingWritableByteChannel otelDecoratingWritableByteChannel;
            block8: {
                Span openSpan = this.tracer.spanBuilder("open").startSpan();
                Scope ignore = openSpan.makeCurrent();
                try {
                    WritableByteChannel delegate = this.delegate.open();
                    otelDecoratingWritableByteChannel = new OtelDecoratingWritableByteChannel(delegate, openSpan);
                    if (ignore == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        openSpan.recordException(t);
                        openSpan.setStatus(StatusCode.ERROR, t.getClass().getSimpleName());
                        throw t;
                    }
                }
                ignore.close();
            }
            return otelDecoratingWritableByteChannel;
        }

        @Override
        public ApiFuture<BlobInfo> getResult() {
            return this.delegate.getResult();
        }

        private class OtelDecoratingWritableByteChannel
        implements WritableByteChannel {
            private final WritableByteChannel delegate;
            private final Span openSpan;

            private OtelDecoratingWritableByteChannel(WritableByteChannel delegate, Span openSpan) {
                this.delegate = delegate;
                this.openSpan = openSpan;
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return this.delegate.write(src);
            }

            @Override
            public boolean isOpen() {
                return this.delegate.isOpen();
            }

            @Override
            public void close() throws IOException {
                try {
                    this.delegate.close();
                }
                catch (IOException | RuntimeException e) {
                    this.openSpan.recordException((Throwable)e);
                    this.openSpan.setStatus(StatusCode.ERROR, e.getClass().getSimpleName());
                    throw e;
                }
                finally {
                    this.openSpan.end();
                }
            }
        }
    }
}

