/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.storage.Buffers;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.ReadCursor;
import com.google.cloud.storage.ResponseContentLifecycleHandle;
import com.google.cloud.storage.ResponseContentLifecycleManager;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import com.google.protobuf.ByteString;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ScatteringByteChannel;
import java.util.Iterator;

final class GapicUnbufferedReadableByteChannel
implements UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel,
ScatteringByteChannel {
    private final SettableApiFuture<com.google.storage.v2.Object> result;
    private final ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read;
    private final ReadObjectRequest req;
    private final Hasher hasher;
    private final LazyServerStreamIterator iter;
    private final ResponseContentLifecycleManager rclm;
    private boolean open = true;
    private boolean complete = false;
    private long blobOffset;
    private com.google.storage.v2.Object metadata;
    private ResponseContentLifecycleHandle leftovers;

    GapicUnbufferedReadableByteChannel(SettableApiFuture<com.google.storage.v2.Object> result, ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read, ReadObjectRequest req, Hasher hasher, ResponseContentLifecycleManager rclm) {
        this.result = result;
        this.read = read;
        this.req = req;
        this.hasher = hasher;
        this.blobOffset = req.getReadOffset();
        this.rclm = rclm;
        this.iter = new LazyServerStreamIterator();
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (this.complete && this.open) {
            this.close();
            return -1L;
        }
        if (!this.open) {
            throw new ClosedChannelException();
        }
        long totalBufferCapacity = Buffers.totalRemaining(dsts, offset, length);
        ReadCursor c = new ReadCursor(this.blobOffset, this.blobOffset + totalBufferCapacity);
        while (c.hasRemaining()) {
            if (this.leftovers != null) {
                this.leftovers.copy(c, dsts, offset, length);
                if (this.leftovers.hasRemaining()) continue;
                this.leftovers.close();
                this.leftovers = null;
                continue;
            }
            if (this.iter.hasNext()) {
                ReadObjectResponse resp = this.iter.next();
                ResponseContentLifecycleHandle handle = this.rclm.get(resp);
                if (resp.hasMetadata()) {
                    com.google.storage.v2.Object respMetadata = resp.getMetadata();
                    if (this.metadata == null) {
                        this.metadata = respMetadata;
                    } else if (this.metadata.getGeneration() != respMetadata.getGeneration()) {
                        throw this.closeWithError(String.format("Mismatch Generation between subsequent reads. Expected %d but received %d", this.metadata.getGeneration(), respMetadata.getGeneration()));
                    }
                    if (!this.result.isDone()) {
                        this.result.set((Object)this.metadata);
                    }
                }
                ChecksummedData checksummedData = resp.getChecksummedData();
                ByteString content = checksummedData.getContent();
                int contentSize = content.size();
                if (checksummedData.hasCrc32C()) {
                    Crc32cValue.Crc32cLengthKnown expected = Crc32cValue.of(checksummedData.getCrc32C(), contentSize);
                    try {
                        this.hasher.validate(expected, content.asReadOnlyByteBufferList());
                    }
                    catch (IOException e) {
                        this.close();
                        throw e;
                    }
                }
                handle.copy(c, dsts, offset, length);
                if (handle.hasRemaining()) {
                    this.leftovers = handle;
                    continue;
                }
                handle.close();
                continue;
            }
            this.complete = true;
            break;
        }
        long read = c.read();
        this.blobOffset += read;
        return read;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        try {
            if (this.leftovers != null) {
                this.leftovers.close();
            }
        }
        finally {
            this.iter.close();
        }
    }

    ApiFuture<com.google.storage.v2.Object> getResult() {
        return this.result;
    }

    private IOException closeWithError(String message) throws IOException {
        this.close();
        StorageException cause = new StorageException(412, message);
        throw new IOException(message, (Throwable)((Object)cause));
    }

    private final class LazyServerStreamIterator
    implements Iterator<ReadObjectResponse>,
    Closeable {
        private ServerStream<ReadObjectResponse> serverStream;
        private Iterator<ReadObjectResponse> responseIterator;
        private volatile boolean streamInitialized = false;

        private LazyServerStreamIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                return this.ensureResponseIteratorOpen().hasNext();
            }
            catch (RuntimeException e) {
                if (!GapicUnbufferedReadableByteChannel.this.result.isDone()) {
                    GapicUnbufferedReadableByteChannel.this.result.setException((Throwable)StorageException.coalesce(e));
                }
                this.reset();
                throw e;
            }
        }

        @Override
        public ReadObjectResponse next() {
            try {
                return this.ensureResponseIteratorOpen().next();
            }
            catch (RuntimeException e) {
                if (!GapicUnbufferedReadableByteChannel.this.result.isDone()) {
                    GapicUnbufferedReadableByteChannel.this.result.setException((Throwable)StorageException.coalesce(e));
                }
                this.reset();
                throw e;
            }
        }

        @Override
        public void close() {
            if (this.serverStream != null) {
                this.serverStream.cancel();
                if (this.responseIterator != null) {
                    IOException ioException = null;
                    while (this.responseIterator.hasNext()) {
                        try {
                            ReadObjectResponse next = this.responseIterator.next();
                            ResponseContentLifecycleHandle handle = GapicUnbufferedReadableByteChannel.this.rclm.get(next);
                            handle.close();
                        }
                        catch (IOException e) {
                            if (ioException == null) {
                                ioException = e;
                                continue;
                            }
                            if (ioException == e) continue;
                            ioException.addSuppressed(e);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterator<ReadObjectResponse> ensureResponseIteratorOpen() {
            boolean initialized = this.streamInitialized;
            if (initialized) {
                return this.responseIterator;
            }
            LazyServerStreamIterator lazyServerStreamIterator = this;
            synchronized (lazyServerStreamIterator) {
                if (!this.streamInitialized) {
                    if (this.serverStream == null) {
                        this.serverStream = GapicUnbufferedReadableByteChannel.this.read.call((Object)GapicUnbufferedReadableByteChannel.this.req);
                    }
                    this.responseIterator = this.serverStream.iterator();
                    this.streamInitialized = true;
                }
                return this.responseIterator;
            }
        }

        private void reset() {
            this.serverStream = null;
            this.responseIterator = null;
            this.streamInitialized = false;
        }
    }
}

