/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedReadableByteChannelSession;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.LazyReadChannel;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageReadChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class BaseStorageReadChannel<T>
implements StorageReadChannel {
    private boolean open = true;
    private ByteRangeSpec byteRangeSpec = ByteRangeSpec.nullRange();
    private int chunkSize = 0x200000;
    private BufferHandle bufferHandle;
    private LazyReadChannel<T> lazyReadChannel;
    private @Nullable T resolvedObject;

    protected BaseStorageReadChannel() {
    }

    public final synchronized void setChunkSize(int chunkSize) {
        StorageException.wrapIOException(() -> this.maybeResetChannel(true));
        this.chunkSize = chunkSize;
    }

    public final synchronized boolean isOpen() {
        return this.open;
    }

    public final synchronized void close() {
        this.open = false;
        if (this.internalGetLazyChannel().isOpen()) {
            StorageException.wrapIOException(this.internalGetLazyChannel().getChannel()::close);
        }
    }

    @Override
    public final synchronized StorageReadChannel setByteRangeSpec(ByteRangeSpec byteRangeSpec) {
        Objects.requireNonNull(byteRangeSpec, "byteRangeSpec must be non null");
        StorageException.wrapIOException(() -> this.maybeResetChannel(false));
        this.byteRangeSpec = byteRangeSpec;
        return this;
    }

    @Override
    public final ByteRangeSpec getByteRangeSpec() {
        return this.byteRangeSpec;
    }

    public final synchronized int read(ByteBuffer dst) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        long diff = this.byteRangeSpec.length();
        if (diff <= 0L) {
            return -1;
        }
        try {
            BufferedReadableByteChannelSession.BufferedReadableByteChannel tmp = this.internalGetLazyChannel().getChannel();
            if (!tmp.isOpen()) {
                return -1;
            }
            int read = tmp.read(dst);
            if (read != -1) {
                this.byteRangeSpec = this.byteRangeSpec.withShiftBeginOffset(read);
            }
            return read;
        }
        catch (StorageException e) {
            if (e.getCode() == 416) {
                return -1;
            }
            throw new IOException((Throwable)((Object)e));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException((Throwable)StorageException.coalesce(e));
        }
    }

    protected final BufferHandle getBufferHandle() {
        if (this.bufferHandle == null) {
            this.bufferHandle = BufferHandle.allocate(this.chunkSize);
        }
        return this.bufferHandle;
    }

    protected final int getChunkSize() {
        return this.chunkSize;
    }

    protected @Nullable T getResolvedObject() {
        return this.resolvedObject;
    }

    protected void setResolvedObject(@Nullable T resolvedObject) {
        this.resolvedObject = resolvedObject;
    }

    protected abstract LazyReadChannel<T> newLazyReadChannel();

    private void maybeResetChannel(boolean freeBuffer) throws IOException {
        if (this.lazyReadChannel != null) {
            if (this.lazyReadChannel.isOpen()) {
                this.lazyReadChannel.getChannel().close();
            }
            if (this.bufferHandle != null && !freeBuffer) {
                ((ByteBuffer)this.bufferHandle.get()).clear();
            } else if (freeBuffer) {
                this.bufferHandle = null;
            }
            this.lazyReadChannel = null;
        }
    }

    private LazyReadChannel<T> internalGetLazyChannel() {
        if (this.lazyReadChannel == null) {
            this.lazyReadChannel = this.newLazyReadChannel();
        }
        return this.lazyReadChannel;
    }
}

