/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.StorageByteChannels;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import com.google.cloud.storage.Utils;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

class ApiaryUnbufferedReadableByteChannel
implements UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel {
    private final ApiaryReadRequest apiaryReadRequest;
    private final Storage storage;
    private final SettableApiFuture<StorageObject> result;
    private final HttpStorageOptions options;
    private final ResultRetryAlgorithm<?> resultRetryAlgorithm;
    private final Consumer<StorageObject> resolvedObjectCallback;
    private long position;
    private ScatteringByteChannel sbc;
    private boolean open;
    private Long xGoogGeneration;

    ApiaryUnbufferedReadableByteChannel(ApiaryReadRequest apiaryReadRequest, Storage storage, SettableApiFuture<StorageObject> result, HttpStorageOptions options, ResultRetryAlgorithm<?> resultRetryAlgorithm, Consumer<StorageObject> resolvedObjectCallback) {
        this.apiaryReadRequest = apiaryReadRequest;
        this.storage = storage;
        this.result = result;
        this.options = options;
        this.resultRetryAlgorithm = resultRetryAlgorithm;
        this.resolvedObjectCallback = resolvedObjectCallback;
        this.open = true;
        this.position = apiaryReadRequest.getByteRangeSpec() != null ? apiaryReadRequest.getByteRangeSpec().beginOffset() : 0L;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        while (true) {
            if (this.sbc == null) {
                this.sbc = (ScatteringByteChannel)Retrying.run(this.options, this.resultRetryAlgorithm, this::open, Function.identity());
            }
            try {
                long read = this.sbc.read(dsts, offset, length);
                if (read == -1L) {
                    this.open = false;
                } else {
                    this.position += read;
                }
                return read;
            }
            catch (Exception t) {
                if (this.resultRetryAlgorithm.shouldRetry((Throwable)t, null)) {
                    this.sbc = null;
                    continue;
                }
                if (t instanceof IOException) {
                    IOException ioE = (IOException)t;
                    if (this.resultRetryAlgorithm.shouldRetry((Throwable)((Object)StorageException.translate(ioE)), null)) {
                        this.sbc = null;
                        continue;
                    }
                    throw ioE;
                }
                throw new IOException((Throwable)StorageException.coalesce(t));
            }
            break;
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        if (this.sbc != null) {
            this.sbc.close();
        }
    }

    private ScatteringByteChannel open() {
        try {
            HttpHeaders responseHeaders;
            List xGoogGenHeader;
            Boolean b = (Boolean)this.apiaryReadRequest.options.get((Object)StorageRpc.Option.RETURN_RAW_INPUT_STREAM);
            boolean returnRawInputStream = b != null ? b : true;
            ApiaryReadRequest request = this.apiaryReadRequest.withNewBeginOffset(this.position);
            Storage.Objects.Get get = ApiaryUnbufferedReadableByteChannel.createGetRequest(request, this.storage.objects(), this.xGoogGeneration, returnRawInputStream);
            HttpResponse media = get.executeMedia();
            InputStream content = media.getContent();
            if (this.xGoogGeneration == null && (xGoogGenHeader = (List)(responseHeaders = media.getHeaders()).get((Object)"x-goog-generation")) != null && !xGoogGenHeader.isEmpty()) {
                Long generation;
                String s = (String)xGoogGenHeader.get(0);
                this.xGoogGeneration = generation = Long.valueOf(s);
                this.resolvedObjectCallback.accept(this.apiaryReadRequest.getObject().clone().setGeneration(generation));
            }
            ReadableByteChannel rbc = Channels.newChannel(content);
            return StorageByteChannels.readable().asScatteringByteChannel(rbc);
        }
        catch (HttpResponseException e) {
            int statusCode;
            if (this.xGoogGeneration != null && (statusCode = e.getStatusCode()) == 404) {
                throw new StorageException(404, "Failure while trying to resume download", e);
            }
            throw StorageException.translate((IOException)((Object)e));
        }
        catch (IOException e) {
            throw StorageException.translate(e);
        }
        catch (Throwable t) {
            throw StorageException.coalesce(t);
        }
    }

    @VisibleForTesting
    static Storage.Objects.Get createGetRequest(ApiaryReadRequest apiaryReadRequest, Storage.Objects objects, Long xGoogGeneration, boolean returnRawInputStream) throws IOException {
        StorageObject from = apiaryReadRequest.getObject();
        Map<StorageRpc.Option, ?> options = apiaryReadRequest.getOptions();
        Storage.Objects.Get get = objects.get(from.getBucket(), from.getName());
        if (from.getGeneration() != null) {
            get.setGeneration(from.getGeneration());
        } else if (xGoogGeneration != null) {
            get.setGeneration(xGoogGeneration);
        }
        Utils.ifNonNull(options.get((Object)StorageRpc.Option.IF_GENERATION_MATCH), ApiaryUnbufferedReadableByteChannel::cast, arg_0 -> ((Storage.Objects.Get)get).setIfGenerationMatch(arg_0));
        Utils.ifNonNull(options.get((Object)StorageRpc.Option.IF_GENERATION_NOT_MATCH), ApiaryUnbufferedReadableByteChannel::cast, arg_0 -> ((Storage.Objects.Get)get).setIfGenerationNotMatch(arg_0));
        Utils.ifNonNull(options.get((Object)StorageRpc.Option.IF_METAGENERATION_MATCH), ApiaryUnbufferedReadableByteChannel::cast, arg_0 -> ((Storage.Objects.Get)get).setIfMetagenerationMatch(arg_0));
        Utils.ifNonNull(options.get((Object)StorageRpc.Option.IF_METAGENERATION_NOT_MATCH), ApiaryUnbufferedReadableByteChannel::cast, arg_0 -> ((Storage.Objects.Get)get).setIfMetagenerationNotMatch(arg_0));
        Utils.ifNonNull(options.get((Object)StorageRpc.Option.USER_PROJECT), ApiaryUnbufferedReadableByteChannel::cast, arg_0 -> ((Storage.Objects.Get)get).setUserProject(arg_0));
        HttpHeaders headers = get.getRequestHeaders();
        Utils.ifNonNull(options.get((Object)StorageRpc.Option.CUSTOMER_SUPPLIED_KEY), ApiaryUnbufferedReadableByteChannel::cast, key -> {
            BaseEncoding base64 = BaseEncoding.base64();
            HashFunction hashFunction = Hashing.sha256();
            headers.set("x-goog-encryption-algorithm", (Object)"AES256");
            headers.set("x-goog-encryption-key", key);
            headers.set("x-goog-encryption-key-sha256", (Object)base64.encode(hashFunction.hashBytes(base64.decode((CharSequence)key)).asBytes()));
        });
        get.setReturnRawInputStream(returnRawInputStream);
        String range = apiaryReadRequest.getByteRangeSpec().getHttpRangeHeader();
        if (range != null) {
            get.getRequestHeaders().setRange(range);
        }
        get.getMediaHttpDownloader().setDirectDownloadEnabled(true);
        return get;
    }

    private static <T> T cast(Object o) {
        return (T)o;
    }

    @Immutable
    static final class ApiaryReadRequest
    implements Serializable {
        private static final long serialVersionUID = -4059435314115374448L;
        private static final Gson gson = new Gson();
        private transient StorageObject object;
        private final Map<StorageRpc.Option, ?> options;
        private final ByteRangeSpec byteRangeSpec;
        private volatile String objectJson;

        ApiaryReadRequest(StorageObject object, Map<StorageRpc.Option, ?> options, ByteRangeSpec byteRangeSpec) {
            this.object = object;
            this.options = options;
            this.byteRangeSpec = byteRangeSpec;
        }

        StorageObject getObject() {
            return this.object;
        }

        Map<StorageRpc.Option, ?> getOptions() {
            return this.options;
        }

        ByteRangeSpec getByteRangeSpec() {
            return this.byteRangeSpec;
        }

        ApiaryReadRequest withNewBeginOffset(long beginOffset) {
            if (beginOffset > 0L && beginOffset != this.byteRangeSpec.beginOffset()) {
                return new ApiaryReadRequest(this.object, this.options, this.byteRangeSpec.withNewBeginOffset(beginOffset));
            }
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ApiaryReadRequest)) {
                return false;
            }
            ApiaryReadRequest that = (ApiaryReadRequest)o;
            return Objects.equals(this.object, that.object) && Objects.equals(this.options, that.options) && Objects.equals(this.byteRangeSpec, that.byteRangeSpec);
        }

        public int hashCode() {
            return Objects.hash(this.object, this.options, this.byteRangeSpec);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("byteRangeSpec", (Object)this.byteRangeSpec).add("options", this.options).add("object", (Object)this.getObjectJson()).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getObjectJson() {
            if (this.objectJson == null) {
                ApiaryReadRequest apiaryReadRequest = this;
                synchronized (apiaryReadRequest) {
                    if (this.objectJson == null) {
                        this.objectJson = gson.toJson((Object)this.object);
                    }
                }
            }
            return this.objectJson;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            String ignore = this.getObjectJson();
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            JsonReader jsonReader = gson.newJsonReader((Reader)new StringReader(this.objectJson));
            this.object = (StorageObject)gson.fromJson(jsonReader, StorageObject.class);
        }
    }
}

