/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpResponseException;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.HmacKeyMetadata;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.Policy;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.BaseServiceException;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.storage.RetryAlgorithmManager;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class NewRetryAlgorithmManager
implements RetryAlgorithmManager {
    private static final ExceptionHandler.Interceptor INTERCEPTOR_IDEMPOTENT = new InterceptorImpl(true, ImmutableSet.builder().add((Object)408).add((Object)429).add((Object)500).add((Object)502).add((Object)503).add((Object)504).build());
    private static final ExceptionHandler.Interceptor INTERCEPTOR_IDEMPOTENT_RESUMABLE = new InterceptorImpl(true, ImmutableSet.builder().add((Object)408).add((Object)500).add((Object)502).add((Object)503).add((Object)504).build());
    private static final ExceptionHandler.Interceptor INTERCEPTOR_NON_IDEMPOTENT = new InterceptorImpl(false, ImmutableSet.builder().build());
    private static final ExceptionHandler IDEMPOTENT_HANDLER = ExceptionHandler.newBuilder().retryOn(new Class[]{RuntimeException.class}).addInterceptors(new ExceptionHandler.Interceptor[]{INTERCEPTOR_IDEMPOTENT}).build();
    private static final ExceptionHandler IDEMPOTENT_RESUMABLE_UPLOAD_HANDLER = ExceptionHandler.newBuilder().retryOn(new Class[]{RuntimeException.class}).addInterceptors(new ExceptionHandler.Interceptor[]{INTERCEPTOR_IDEMPOTENT_RESUMABLE}).build();
    private static final ExceptionHandler NON_IDEMPOTENT_HANDLER = ExceptionHandler.newBuilder().retryOn(new Class[]{RuntimeException.class}).addInterceptors(new ExceptionHandler.Interceptor[]{INTERCEPTOR_NON_IDEMPOTENT}).build();

    NewRetryAlgorithmManager() {
    }

    @Override
    public ExceptionHandler getForBucketAclCreate(BucketAccessControl pb, Map<StorageRpc.Option, ?> optionsMap) {
        return NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketAclDelete(String pb, Map<StorageRpc.Option, ?> optionsMap) {
        return NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketAclGet(String pb, Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketAclUpdate(BucketAccessControl pb, Map<StorageRpc.Option, ?> optionsMap) {
        return NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketAclList(String pb, Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketsCreate(Bucket pb, Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketsDelete(Bucket pb, Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketsGet(Bucket pb, Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketsUpdate(Bucket pb, Map<StorageRpc.Option, ?> optionsMap) {
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_METAGENERATION_MATCH) ? IDEMPOTENT_HANDLER : NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketsList(Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketsLockRetentionPolicy(Bucket pb, Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketsGetIamPolicy(String bucket, Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketsSetIamPolicy(String bucket, Policy pb, Map<StorageRpc.Option, ?> optionsMap) {
        return pb.getEtag() != null ? IDEMPOTENT_HANDLER : NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForBucketsTestIamPermissions(String bucket, List<String> permissions, Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForDefaultObjectAclCreate(ObjectAccessControl pb) {
        return NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForDefaultObjectAclDelete(String pb) {
        return NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForDefaultObjectAclGet(String pb) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForDefaultObjectAclUpdate(ObjectAccessControl pb) {
        return NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForDefaultObjectAclList(String pb) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForHmacKeyCreate(String pb, Map<StorageRpc.Option, ?> optionsMap) {
        return NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForHmacKeyDelete(HmacKeyMetadata pb, Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForHmacKeyGet(String accessId, Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForHmacKeyUpdate(HmacKeyMetadata pb, Map<StorageRpc.Option, ?> optionsMap) {
        return NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForHmacKeyList(Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForObjectAclCreate(ObjectAccessControl aclPb) {
        return NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForObjectAclDelete(String bucket, String name, Long generation, String pb) {
        return NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForObjectAclList(String bucket, String name, Long generation) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForObjectAclGet(String bucket, String name, Long generation, String pb) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForObjectAclUpdate(ObjectAccessControl aclPb) {
        return NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForObjectsCreate(StorageObject pb, Map<StorageRpc.Option, ?> optionsMap) {
        if (pb.getGeneration() != null && pb.getGeneration() == 0L) {
            return IDEMPOTENT_HANDLER;
        }
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_GENERATION_MATCH) ? IDEMPOTENT_HANDLER : NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForObjectsDelete(StorageObject pb, Map<StorageRpc.Option, ?> optionsMap) {
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_GENERATION_MATCH) ? IDEMPOTENT_HANDLER : NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForObjectsGet(StorageObject pb, Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForObjectsUpdate(StorageObject pb, Map<StorageRpc.Option, ?> optionsMap) {
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_METAGENERATION_MATCH) ? IDEMPOTENT_HANDLER : NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForObjectsList(String bucket, Map<StorageRpc.Option, ?> optionsMap) {
        return IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForObjectsRewrite(StorageRpc.RewriteRequest pb) {
        return pb.targetOptions.containsKey((Object)StorageRpc.Option.IF_GENERATION_MATCH) ? IDEMPOTENT_HANDLER : NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForObjectsCompose(List<StorageObject> sources, StorageObject target, Map<StorageRpc.Option, ?> optionsMap) {
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_GENERATION_MATCH) ? IDEMPOTENT_HANDLER : NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForResumableUploadSessionCreate(Map<StorageRpc.Option, ?> optionsMap) {
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_GENERATION_MATCH) ? IDEMPOTENT_HANDLER : NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForResumableUploadSessionWrite(Map<StorageRpc.Option, ?> optionsMap) {
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_GENERATION_MATCH) ? IDEMPOTENT_RESUMABLE_UPLOAD_HANDLER : NON_IDEMPOTENT_HANDLER;
    }

    @Override
    public ExceptionHandler getForServiceAccountGet(String pb) {
        return IDEMPOTENT_HANDLER;
    }

    private static class InterceptorImpl
    implements ExceptionHandler.Interceptor {
        private final boolean idempotent;
        private final ImmutableSet<Integer> retryableCodes;

        private InterceptorImpl(boolean idempotent, ImmutableSet<Integer> retryableCodes) {
            this.idempotent = idempotent;
            this.retryableCodes = retryableCodes;
        }

        public ExceptionHandler.Interceptor.RetryResult afterEval(Exception exception, ExceptionHandler.Interceptor.RetryResult retryResult) {
            return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
        }

        public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
            StorageException storageException;
            Throwable cause;
            if (exception instanceof StorageException && !((cause = (storageException = (StorageException)((Object)exception)).getCause()) instanceof GoogleJsonResponseException)) {
                if (cause instanceof HttpResponseException) {
                    int code = ((HttpResponseException)cause).getStatusCode();
                    return this.shouldRetryCode(code);
                }
                if (cause instanceof IOException) {
                    IOException ioException = (IOException)cause;
                    return BaseServiceException.isRetryable((boolean)this.idempotent, (IOException)ioException) ? ExceptionHandler.Interceptor.RetryResult.RETRY : ExceptionHandler.Interceptor.RetryResult.NO_RETRY;
                }
            }
            if (exception instanceof BaseServiceException) {
                int code = ((BaseServiceException)exception).getCode();
                return this.shouldRetryCode(code);
            }
            return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
        }

        private ExceptionHandler.Interceptor.RetryResult shouldRetryCode(int code) {
            if (this.retryableCodes.contains((Object)code)) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            return ExceptionHandler.Interceptor.RetryResult.NO_RETRY;
        }
    }
}

