/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.ObjectAccessControl;
import java.io.Serializable;
import java.util.Objects;

public final class Acl
implements Serializable {
    private static final long serialVersionUID = 6435575339887912222L;
    private final Entity entity;
    private final Role role;

    private Acl(Entity entity, Role role) {
        this.entity = entity;
        this.role = role;
    }

    public Entity entity() {
        return this.entity;
    }

    public Role role() {
        return this.role;
    }

    public static Acl of(Entity entity, Role role) {
        return new Acl(entity, role);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entity, this.role});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Acl other = (Acl)obj;
        return Objects.equals(this.entity, other.entity) && Objects.equals((Object)this.role, (Object)other.role);
    }

    BucketAccessControl toBucketPb() {
        BucketAccessControl bucketPb = new BucketAccessControl();
        bucketPb.setRole(this.role().toString());
        bucketPb.setEntity(this.entity().toString());
        return bucketPb;
    }

    ObjectAccessControl toObjectPb() {
        ObjectAccessControl objectPb = new ObjectAccessControl();
        objectPb.setRole(this.role().name());
        objectPb.setEntity(this.entity().toPb());
        return objectPb;
    }

    static Acl fromPb(ObjectAccessControl objectAccessControl) {
        Role role = Role.valueOf(objectAccessControl.getRole());
        return Acl.of(Entity.fromPb(objectAccessControl.getEntity()), role);
    }

    static Acl fromPb(BucketAccessControl bucketAccessControl) {
        Role role = Role.valueOf(bucketAccessControl.getRole());
        return Acl.of(Entity.fromPb(bucketAccessControl.getEntity()), role);
    }

    public static final class RawEntity
    extends Entity {
        private static final long serialVersionUID = 3966205614223053950L;

        RawEntity(String entity) {
            super(Entity.Type.UNKNOWN, entity);
        }

        @Override
        String toPb() {
            return this.value();
        }
    }

    public static final class Project
    extends Entity {
        private static final long serialVersionUID = 7933776866530023027L;
        private final ProjectRole projectRole;
        private final String projectId;

        public Project(ProjectRole projectRole, String projectId) {
            super(Entity.Type.PROJECT, projectRole.name().toLowerCase() + "-" + projectId);
            this.projectRole = projectRole;
            this.projectId = projectId;
        }

        public ProjectRole projectRole() {
            return this.projectRole;
        }

        public String projectId() {
            return this.projectId;
        }

        public static enum ProjectRole {
            OWNERS,
            EDITORS,
            VIEWERS;

        }
    }

    public static final class User
    extends Entity {
        private static final long serialVersionUID = 3076518036392737008L;
        private static final String ALL_USERS = "allUsers";
        private static final String ALL_AUTHENTICATED_USERS = "allAuthenticatedUsers";

        public User(String email) {
            super(Entity.Type.USER, email);
        }

        public String email() {
            return this.value();
        }

        @Override
        String toPb() {
            switch (this.value()) {
                case "allAuthenticatedUsers": {
                    return ALL_AUTHENTICATED_USERS;
                }
                case "allUsers": {
                    return ALL_USERS;
                }
            }
            return super.toPb();
        }

        public static User ofAllUsers() {
            return new User(ALL_USERS);
        }

        public static User ofAllAuthenticatedUsers() {
            return new User(ALL_AUTHENTICATED_USERS);
        }
    }

    public static final class Group
    extends Entity {
        private static final long serialVersionUID = -1660987136294408826L;

        public Group(String email) {
            super(Entity.Type.GROUP, email);
        }

        public String email() {
            return this.value();
        }
    }

    public static final class Domain
    extends Entity {
        private static final long serialVersionUID = -3033025857280447253L;

        public Domain(String domain) {
            super(Entity.Type.DOMAIN, domain);
        }

        public String domain() {
            return this.value();
        }
    }

    public static abstract class Entity
    implements Serializable {
        private static final long serialVersionUID = -2707407252771255840L;
        private final Type type;
        private final String value;

        Entity(Type type, String value) {
            this.type = type;
            this.value = value;
        }

        public Type type() {
            return this.type;
        }

        protected String value() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Entity entity = (Entity)obj;
            return Objects.equals((Object)this.type, (Object)entity.type) && Objects.equals(this.value, entity.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.value});
        }

        public String toString() {
            return this.toPb();
        }

        String toPb() {
            return this.type.name().toLowerCase() + "-" + this.value();
        }

        static Entity fromPb(String entity) {
            if (entity.startsWith("user-")) {
                return new User(entity.substring(5));
            }
            if (entity.equals("allUsers")) {
                return User.ofAllUsers();
            }
            if (entity.equals("allAuthenticatedUsers")) {
                return User.ofAllAuthenticatedUsers();
            }
            if (entity.startsWith("group-")) {
                return new Group(entity.substring(6));
            }
            if (entity.startsWith("domain-")) {
                return new Domain(entity.substring(7));
            }
            if (entity.startsWith("project-")) {
                int idx = entity.indexOf(45, 8);
                String team = entity.substring(8, idx);
                String projectId = entity.substring(idx + 1);
                return new Project(Project.ProjectRole.valueOf(team.toUpperCase()), projectId);
            }
            return new RawEntity(entity);
        }

        public static enum Type {
            DOMAIN,
            GROUP,
            USER,
            PROJECT,
            UNKNOWN;

        }
    }

    public static enum Role {
        OWNER,
        READER,
        WRITER;

    }
}

