/*
 * Decompiled with CFR 0.152.
 */
package com.google.storagetransfer.v1.proto;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.storagetransfer.v1.proto.StorageTransferServiceSettings;
import com.google.storagetransfer.v1.proto.TransferProto;
import com.google.storagetransfer.v1.proto.TransferTypes;
import com.google.storagetransfer.v1.proto.stub.StorageTransferServiceStub;
import com.google.storagetransfer.v1.proto.stub.StorageTransferServiceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class StorageTransferServiceClient
implements BackgroundResource {
    private final StorageTransferServiceSettings settings;
    private final StorageTransferServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final StorageTransferServiceClient create() throws IOException {
        return StorageTransferServiceClient.create(StorageTransferServiceSettings.newBuilder().build());
    }

    public static final StorageTransferServiceClient create(StorageTransferServiceSettings settings) throws IOException {
        return new StorageTransferServiceClient(settings);
    }

    public static final StorageTransferServiceClient create(StorageTransferServiceStub stub) {
        return new StorageTransferServiceClient(stub);
    }

    protected StorageTransferServiceClient(StorageTransferServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((StorageTransferServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected StorageTransferServiceClient(StorageTransferServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final StorageTransferServiceSettings getSettings() {
        return this.settings;
    }

    public StorageTransferServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final TransferTypes.GoogleServiceAccount getGoogleServiceAccount(TransferProto.GetGoogleServiceAccountRequest request) {
        return (TransferTypes.GoogleServiceAccount)this.getGoogleServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.GetGoogleServiceAccountRequest, TransferTypes.GoogleServiceAccount> getGoogleServiceAccountCallable() {
        return this.stub.getGoogleServiceAccountCallable();
    }

    public final TransferTypes.TransferJob createTransferJob(TransferProto.CreateTransferJobRequest request) {
        return (TransferTypes.TransferJob)this.createTransferJobCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.CreateTransferJobRequest, TransferTypes.TransferJob> createTransferJobCallable() {
        return this.stub.createTransferJobCallable();
    }

    public final TransferTypes.TransferJob updateTransferJob(TransferProto.UpdateTransferJobRequest request) {
        return (TransferTypes.TransferJob)this.updateTransferJobCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.UpdateTransferJobRequest, TransferTypes.TransferJob> updateTransferJobCallable() {
        return this.stub.updateTransferJobCallable();
    }

    public final TransferTypes.TransferJob getTransferJob(TransferProto.GetTransferJobRequest request) {
        return (TransferTypes.TransferJob)this.getTransferJobCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.GetTransferJobRequest, TransferTypes.TransferJob> getTransferJobCallable() {
        return this.stub.getTransferJobCallable();
    }

    public final ListTransferJobsPagedResponse listTransferJobs(TransferProto.ListTransferJobsRequest request) {
        return (ListTransferJobsPagedResponse)((Object)this.listTransferJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<TransferProto.ListTransferJobsRequest, ListTransferJobsPagedResponse> listTransferJobsPagedCallable() {
        return this.stub.listTransferJobsPagedCallable();
    }

    public final UnaryCallable<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse> listTransferJobsCallable() {
        return this.stub.listTransferJobsCallable();
    }

    public final void pauseTransferOperation(TransferProto.PauseTransferOperationRequest request) {
        this.pauseTransferOperationCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.PauseTransferOperationRequest, Empty> pauseTransferOperationCallable() {
        return this.stub.pauseTransferOperationCallable();
    }

    public final void resumeTransferOperation(TransferProto.ResumeTransferOperationRequest request) {
        this.resumeTransferOperationCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.ResumeTransferOperationRequest, Empty> resumeTransferOperationCallable() {
        return this.stub.resumeTransferOperationCallable();
    }

    public final OperationFuture<Empty, TransferTypes.TransferOperation> runTransferJobAsync(TransferProto.RunTransferJobRequest request) {
        return this.runTransferJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TransferProto.RunTransferJobRequest, Empty, TransferTypes.TransferOperation> runTransferJobOperationCallable() {
        return this.stub.runTransferJobOperationCallable();
    }

    public final UnaryCallable<TransferProto.RunTransferJobRequest, Operation> runTransferJobCallable() {
        return this.stub.runTransferJobCallable();
    }

    public final void deleteTransferJob(TransferProto.DeleteTransferJobRequest request) {
        this.deleteTransferJobCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.DeleteTransferJobRequest, Empty> deleteTransferJobCallable() {
        return this.stub.deleteTransferJobCallable();
    }

    public final TransferTypes.AgentPool createAgentPool(String projectId, TransferTypes.AgentPool agentPool, String agentPoolId) {
        TransferProto.CreateAgentPoolRequest request = TransferProto.CreateAgentPoolRequest.newBuilder().setProjectId(projectId).setAgentPool(agentPool).setAgentPoolId(agentPoolId).build();
        return this.createAgentPool(request);
    }

    public final TransferTypes.AgentPool createAgentPool(TransferProto.CreateAgentPoolRequest request) {
        return (TransferTypes.AgentPool)this.createAgentPoolCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.CreateAgentPoolRequest, TransferTypes.AgentPool> createAgentPoolCallable() {
        return this.stub.createAgentPoolCallable();
    }

    public final TransferTypes.AgentPool updateAgentPool(TransferTypes.AgentPool agentPool, FieldMask updateMask) {
        TransferProto.UpdateAgentPoolRequest request = TransferProto.UpdateAgentPoolRequest.newBuilder().setAgentPool(agentPool).setUpdateMask(updateMask).build();
        return this.updateAgentPool(request);
    }

    public final TransferTypes.AgentPool updateAgentPool(TransferProto.UpdateAgentPoolRequest request) {
        return (TransferTypes.AgentPool)this.updateAgentPoolCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.UpdateAgentPoolRequest, TransferTypes.AgentPool> updateAgentPoolCallable() {
        return this.stub.updateAgentPoolCallable();
    }

    public final TransferTypes.AgentPool getAgentPool(String name) {
        TransferProto.GetAgentPoolRequest request = TransferProto.GetAgentPoolRequest.newBuilder().setName(name).build();
        return this.getAgentPool(request);
    }

    public final TransferTypes.AgentPool getAgentPool(TransferProto.GetAgentPoolRequest request) {
        return (TransferTypes.AgentPool)this.getAgentPoolCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.GetAgentPoolRequest, TransferTypes.AgentPool> getAgentPoolCallable() {
        return this.stub.getAgentPoolCallable();
    }

    public final ListAgentPoolsPagedResponse listAgentPools(String projectId) {
        TransferProto.ListAgentPoolsRequest request = TransferProto.ListAgentPoolsRequest.newBuilder().setProjectId(projectId).build();
        return this.listAgentPools(request);
    }

    public final ListAgentPoolsPagedResponse listAgentPools(TransferProto.ListAgentPoolsRequest request) {
        return (ListAgentPoolsPagedResponse)((Object)this.listAgentPoolsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<TransferProto.ListAgentPoolsRequest, ListAgentPoolsPagedResponse> listAgentPoolsPagedCallable() {
        return this.stub.listAgentPoolsPagedCallable();
    }

    public final UnaryCallable<TransferProto.ListAgentPoolsRequest, TransferProto.ListAgentPoolsResponse> listAgentPoolsCallable() {
        return this.stub.listAgentPoolsCallable();
    }

    public final void deleteAgentPool(String name) {
        TransferProto.DeleteAgentPoolRequest request = TransferProto.DeleteAgentPoolRequest.newBuilder().setName(name).build();
        this.deleteAgentPool(request);
    }

    public final void deleteAgentPool(TransferProto.DeleteAgentPoolRequest request) {
        this.deleteAgentPoolCallable().call((Object)request);
    }

    public final UnaryCallable<TransferProto.DeleteAgentPoolRequest, Empty> deleteAgentPoolCallable() {
        return this.stub.deleteAgentPoolCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAgentPoolsFixedSizeCollection
    extends AbstractFixedSizeCollection<TransferProto.ListAgentPoolsRequest, TransferProto.ListAgentPoolsResponse, TransferTypes.AgentPool, ListAgentPoolsPage, ListAgentPoolsFixedSizeCollection> {
        private ListAgentPoolsFixedSizeCollection(List<ListAgentPoolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAgentPoolsFixedSizeCollection createEmptyCollection() {
            return new ListAgentPoolsFixedSizeCollection(null, 0);
        }

        protected ListAgentPoolsFixedSizeCollection createCollection(List<ListAgentPoolsPage> pages, int collectionSize) {
            return new ListAgentPoolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAgentPoolsPage
    extends AbstractPage<TransferProto.ListAgentPoolsRequest, TransferProto.ListAgentPoolsResponse, TransferTypes.AgentPool, ListAgentPoolsPage> {
        private ListAgentPoolsPage(PageContext<TransferProto.ListAgentPoolsRequest, TransferProto.ListAgentPoolsResponse, TransferTypes.AgentPool> context, TransferProto.ListAgentPoolsResponse response) {
            super(context, (Object)response);
        }

        private static ListAgentPoolsPage createEmptyPage() {
            return new ListAgentPoolsPage(null, null);
        }

        protected ListAgentPoolsPage createPage(PageContext<TransferProto.ListAgentPoolsRequest, TransferProto.ListAgentPoolsResponse, TransferTypes.AgentPool> context, TransferProto.ListAgentPoolsResponse response) {
            return new ListAgentPoolsPage(context, response);
        }

        public ApiFuture<ListAgentPoolsPage> createPageAsync(PageContext<TransferProto.ListAgentPoolsRequest, TransferProto.ListAgentPoolsResponse, TransferTypes.AgentPool> context, ApiFuture<TransferProto.ListAgentPoolsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAgentPoolsPagedResponse
    extends AbstractPagedListResponse<TransferProto.ListAgentPoolsRequest, TransferProto.ListAgentPoolsResponse, TransferTypes.AgentPool, ListAgentPoolsPage, ListAgentPoolsFixedSizeCollection> {
        public static ApiFuture<ListAgentPoolsPagedResponse> createAsync(PageContext<TransferProto.ListAgentPoolsRequest, TransferProto.ListAgentPoolsResponse, TransferTypes.AgentPool> context, ApiFuture<TransferProto.ListAgentPoolsResponse> futureResponse) {
            ApiFuture<ListAgentPoolsPage> futurePage = ListAgentPoolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAgentPoolsPagedResponse((ListAgentPoolsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAgentPoolsPagedResponse(ListAgentPoolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAgentPoolsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTransferJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob, ListTransferJobsPage, ListTransferJobsFixedSizeCollection> {
        private ListTransferJobsFixedSizeCollection(List<ListTransferJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTransferJobsFixedSizeCollection createEmptyCollection() {
            return new ListTransferJobsFixedSizeCollection(null, 0);
        }

        protected ListTransferJobsFixedSizeCollection createCollection(List<ListTransferJobsPage> pages, int collectionSize) {
            return new ListTransferJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTransferJobsPage
    extends AbstractPage<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob, ListTransferJobsPage> {
        private ListTransferJobsPage(PageContext<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob> context, TransferProto.ListTransferJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListTransferJobsPage createEmptyPage() {
            return new ListTransferJobsPage(null, null);
        }

        protected ListTransferJobsPage createPage(PageContext<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob> context, TransferProto.ListTransferJobsResponse response) {
            return new ListTransferJobsPage(context, response);
        }

        public ApiFuture<ListTransferJobsPage> createPageAsync(PageContext<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob> context, ApiFuture<TransferProto.ListTransferJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTransferJobsPagedResponse
    extends AbstractPagedListResponse<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob, ListTransferJobsPage, ListTransferJobsFixedSizeCollection> {
        public static ApiFuture<ListTransferJobsPagedResponse> createAsync(PageContext<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob> context, ApiFuture<TransferProto.ListTransferJobsResponse> futureResponse) {
            ApiFuture<ListTransferJobsPage> futurePage = ListTransferJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTransferJobsPagedResponse((ListTransferJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTransferJobsPagedResponse(ListTransferJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTransferJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

